﻿using Newtonsoft.Json;
using Sonic.Web.Models;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Sonic.Web.Model
{
    public class TransactionBase
    {
        #region [public Properties]

        public int OrganizationId { get; set; }
        public int CustomerOrganizationId { get; set; }
        public string TransactionId { set; get; }
        public int EmployeeId { set; get; }
        public int DivisionId { set; get; }
        public int WarehouseId { set; get; }
        public int RefWarehouseId { set; get; }
        public string EmployeeName { get; set; }
        public string EmployeeCodeName { get; set; }
        public string RouteCodeName { get; set; }
        public string DivisionName { get; set; }
        public string DivisionCodeName { get; set; }
        public string WarehouseName { get; set; }
        public string warehouseCodeName { get; set; }
        public bool Posted { set; get; }
        public int RouteHistoryId { set; get; }
        public TransactionMainTypes MainType { set; get; }
        public DocumentTypes DocumentType { set; get; }
        public DateTime CreatedDate { get; set; }
        public DateTime UpdatedDate { get; set; }
        public DateTime DueDate { get; set; }
        public int UpdatedBy { get; set; }
        public string SourceTransactionId { get; set; }
        public int RouteId { set; get; }
        public int SupervisorId { get; set; }
        public int HelperId { get; set; }
        public int DriverId { get; set; }
        public int SalesRepId { get; set; }
        public int SalesManagerId { get; set; }
        public bool IsUpdatedInFO { get; set; }
        public int VisitNo { get; set; }
        public bool AllowBatchesInItems { get; set; }
        public string ProducationTransactionID { set; get; }

        #endregion

        public TransactionBase()
        {
            AllowBatchesInItems = false;
            WarehouseId = -1;
            EmployeeId = -1;
            DivisionId = -1;
            RouteId = -1;
        }

    }
}
