﻿using Sonic.Web.Models;
using System;
using System.Collections.Generic;
using System.Text;

namespace Sonic.Web.Model
{
    public class TransactionHistory
    {
        public int DivisionId { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public string OrderId { get; set; }
        public DateTime? OrderDate { get; set; }
        public string OrderBy { get; set; }
        public decimal OrderValue { get; set; }
        public string TransactionId { get; set; }
        public string TransactionIdInUI { get; set; }
        public DateTime? InvoiceDate { get; set; }
        public string DeliveredBy { get; set; }
        public decimal? InvoiceValue { get; set; }
        public OrderStatus OrderStatusId { get; set; }
        public string Status { get; set; }
        public string RejectNote { get; set; }
        public string OrderType { get; set; }
        public string CustomerPaymentId { get; set; }
        public PaymentStatusTypes PaymentStatusId { get; set; }
        public PaymentTypes PaymentTypeId { get; set; }
        public bool IsTransaction { get; set; }
        public bool IsTopUp { get; set; }
        public bool IsOrder { get; set; }
        public string CustomerName { get; set; }
        public string CustomerCode { get; set; }
        public string OutletCode { get; set; }
        public string OutletName { get; set; }
        public string EmployeeName { get; set; }
        public DateTime? DueDate { get; set; }
        public string TaxNumber { get; set; }
        public int CustomerTypeId { get; set; }
        public string PaymentTerm { get; set; }
        public DateTime? DesiredDeliveryDate { get; set; }
        public string OrderSource { get; set; }
        public int AccountId { get; set; }
        public int DCFID { get; set; }
        public int DisplayUnitId { get; set; }
        public int RouteHistoryID { get; set; }
        public int StockCountingHistoryID { get; set; }
        public string StockCountingName { get; set; }

        public int WarehouseID { get; set; }
        public int CustomerOrganizationId { get; set; }
        public int? DeliveryChargesId { get; set; }
        public double? DeliveryValue { get; set; }
        public double? DeliveryTax { get; set; }
        public ReportMode reportMode { get; set; }
        public bool IsReprintReport { get; set; }
        public int OrganizationId { get; set; }
        private DateTime? _roiDate;
        public DateTime? RoiDate
        {
            get { return _roiDate; }
            set
            {
                _roiDate = value;
                if (_roiDate != null)
                    RoiDateModel = new DateModel(_roiDate.Value);
            }
        }
        public DateModel RoiDateModel { get; set; }
        //public DateModel RoiDateModel { get; set; }
        //public DateTime RoiDate { get; set; }
        public string OrganizationCodeName { get; set; }

        public string CustomerEmail { set; get; }
        public string OutletEmail { set; get; }
        public DateTime TransactionDate { set; get; }
        public decimal NetTotal { set; get; }
        public decimal AppliedAmount { set; get; }
        public decimal RemainingAmount { set; get; }
        public string CurrencyCode { set; get; }
        public bool Voided { get; set; }
        public int LanguageID { get; set; }
        public int TransactionTypeID { get; set; }
        public int CreationReason { get; set; }
        public int CurrencyId { get; set; }

        public string SourceTransactionID { get; set; }
        public string CustomerCodeName { get; set; }
        public string OutletCodeName { get; set; }
        public string BackColor { get; set; }

        public TransactionHistory()
        {
            //RoiDateModel = new DateModel();
            DivisionId = -1;
            NetTotal = 0.0m;
            RemainingAmount = 0;
            CustomerEmail = string.Empty;
            OutletEmail = string.Empty;
            Voided = false;
            LanguageID = 1;
            SourceTransactionID = string.Empty;
            CurrencyId = -1;
            CustomerCodeName = string.Empty;
            OutletCodeName = string.Empty;
        }
    }
}
