﻿using Newtonsoft.Json;
using Sonic.Web.Models;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Reflection;
using InCube.Security;
using Sonic.Web.ZATCAXML;

namespace Sonic.Web.Model
{
    public class TransactionModel : TransactionBase
    {

        #region[private members]

        private string _signature;
        private DateTime _transactionDate;
        #endregion

        #region[Properties]

        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public int DivisionId { get; set; }
        public int MainOutletId { get; set; }
        public int FirstOutletId { get; set; }
        public int CreatedBy { get; set; }
        public int AccountId { get; set; }
        public string Signature
        {
            get
            {
                return EncryptionManager.Instance.EncryptData(
                   TransactionId + EncryptionManager.Instance.SignatureSeparator
                   + CustomerId + EncryptionManager.Instance.SignatureSeparator
                   + OutletId + EncryptionManager.Instance.SignatureSeparator
                   + EmployeeId + EncryptionManager.Instance.SignatureSeparator
                   + DivisionId + EncryptionManager.Instance.SignatureSeparator
                   + CustomerPaymentId );
            }
            set
            {
                _signature = value;
                if (!string.IsNullOrEmpty(_signature))
                {
                    string[] IDs = EncryptionManager.Instance.DecryptData(_signature).Split(EncryptionManager.Instance.SignatureSeparator.ToCharArray());
                    TransactionId = IDs[0];
                    CustomerId = int.Parse(IDs[1]);
                    OutletId = int.Parse(IDs[2]);
                    EmployeeId = int.Parse(IDs[3]);
                    DivisionId = int.Parse(IDs[4]);
                    CustomerPaymentId = IDs[5];
                }
            }
        }
        public DateTime TransactionDate
        {
            get { return _transactionDate; }
            set
            {
                _transactionDate = value;
                if (_transactionDate != null)
                {
                    TransactionDateModel = new DateModel(_transactionDate);
                }
            }
        }        
        public DateModel TransactionDateModel { get; set; }
        public decimal RemainingAmount { get; set; }
        public decimal ValuesUsed { get; set; }
        public bool DisableValuesUsed { get; set; }
        public decimal AppliedAmount { get; set; }
        public decimal NetTotal { get; set; }
        public bool ExportCustomer { get; set; }
        public decimal RoundingDifference { get; set; }
        public decimal IncludedTaxAmount { get; set; }
        public decimal GrossTotal { get; set; }
        public decimal Tax { get; set; }
        public string OrganizationName { get; set; }
        public decimal Discount { get; set; }

        public decimal CalculatedRetailTax { get; set; }
        public decimal ReturnNetTotal { get; set; }
        public decimal ReturnGrossTotal { get; set; }
        public decimal ReturnTax { get; set; }
        public decimal ReturnDiscount { get; set; }

        public decimal ReturnCalculatedRetailTax { get; set; }
        public decimal PromotedDiscount { get; set; }
        public decimal CollectionDiscount { get; set; }
        public TransactionType TransactionType { set; get; }
        public int TransactionTypeId { get; set; }
        public int ReportTypeID { get; set; }
        public int CurrencyId { get; set; }
        public int CustomerTypeId { get; set; }
        public int SelectedCurrencyId { get; set; }
        public string CustomerName { get; set; }
        public string OutletName { get; set; }
        public string OutletCode { get; set; }
        public string CustomerCodeName { get; set; }
        public string OutletCodeName { get; set; }
        public string ReturnWarehouseCodeName { get; set; }
        public bool Voided { get; set; }
        public string VoidedString { get; set; }
        public string CustomerOutletHeader { get; set; }
        public float GPSLatitude { get; set; }
        public float GPSLongitude { get; set; }
        public string Notes { set; get; }
        public decimal ExchangeRate { set; get; }
        public string LPONumber { set; get; }
        public string RefOrderId { set; get; }
        public string SoldBy { set; get; }
        public bool IsPromotionTaken { set; get; }
        public bool IsChecked { set; get; }
        public bool Synchronized { set; get; }

        public bool IsTopUp { set; get; }
        public bool IsPayment { set; get; }
        public bool IsReversal { set; get; }
        public int TransactionStatusId { set; get; }
        public CustomerOutletModel Outlet { get; set; }
        public SalesModes SalesMode { get; set; }
        public string CustomerPaymentId { set; get; }
        public CustomerValidationsModel CustomerValidations { get; set; }
        public List<ItemPackModel> AllItems { get; set; }
        public List<ItemPackModel> SoldItems { get; set; }
        public List<ItemPackModel> PromotedItems { get; set; }
        public List<ItemPackModel> FOCItems { get; set; }
        public List<ItemPackModel> ReturnItems { get; set; }
        public TransactionCreationReason CreationReason { get; set; }
        public bool IsTaxeableOutlet { get; set; }
        public string linkedSSCCBarcodes { get; set; }
        public List<Promotion> CustomerPromotions { get; set; }
        public bool DeliverFromVehicle { get; set; }
        public decimal ICashAmount { get; set; }
        public decimal ICashBalanceBefore { get; set; }
        public decimal ICashBalanceAfter { get; set; }
        public decimal ICashCurrentBalance { get; set; }
        public string ICashTransactionType { get; set; }
        public string ICashTransactionID { get; set; }
        public string Status { get; set; }
        public string DeliveryNotesTransactionIds { get; set; }
        public string DisplayTransactionID { get; set; }
        public bool ShowVoidBtn { get; set; }
        public bool ShowViewBtn { get; set; }
        public int DocumentReasonID { get; set; }
        public string TransPaymentType { get; set; }
        public int PaymentTypeId { get; set; }
        public bool IsCustomerTransactions { get; set; }
        public string SourceTransactionId { get; set; }
        public string ShipTo { get; set; }
        public decimal CreditLimit { get; set; }
        public decimal Balance { get; set; }
        public bool IsReturn { get; set; }
        public bool IsReturnExchange { get; set; }
        public string ReturnId { get; set; }
        public int RouteId { get; set; }
        public decimal FinalDiscount { get; set; }
        public decimal Tempreture { get; set; }
        public int SDCId { get; set; }
        public string TransactionTypeName { get; set; }
        public string Icon { get; set; }
        public string IconColor { get; set; }
        public int PackStatusId { get; set; }
        public bool IsReturnSerials { get; set; }
        public string InvoiceNumber { set; get; }

        #endregion


        #region[ZATCA properties]
        private PaymentTypes _zatcaPaymentType = PaymentTypes.Cash;
        private AccountingCustomerParty _accountingCustomerParty;

        public string ReturnReason { get; set; }
        public bool IsBusinessCustomer { get; set; }
        public string SalesTransactionIds { get; set; }
        public PaymentTypes ZatcaPaymentType { get => _zatcaPaymentType; set => _zatcaPaymentType = value; }
        public AccountingCustomerParty AccountingCustomerParty { get => _accountingCustomerParty; set => _accountingCustomerParty = value; }

        #endregion

        #region [METHODS]

        public TransactionModel()
        {
            MainType = TransactionMainTypes.CustomerTransaction;
            Outlet = new CustomerOutletModel();
            CustomerValidations = new CustomerValidationsModel();
            TransactionDateModel = new DateModel();
            AllItems = new List<ItemPackModel>();
            SoldItems = new List<ItemPackModel>();
            PromotedItems = new List<ItemPackModel>();
            FOCItems = new List<ItemPackModel>();
            IsChecked = false;
            CustomerId = -1;
            OutletId = -1;
            MainOutletId = -1;
            AccountId = -1;
            OrganizationId = -1;
            CreatedBy = -1;
            CustomerPromotions = new List<Promotion>();
            Status = string.Empty;
            TransactionStatusId = -1;
            DeliveryNotesTransactionIds = string.Empty;
            ShowVoidBtn = false;
            DocumentReasonID = -1;
            RouteId = -1;
            IsReturn = false;
            ReturnId = string.Empty;
            Notes = string.Empty;
            IsReturnExchange = false;
            Tempreture = 0;
            FinalDiscount = 0;
            SDCId = -1;
            DivisionId = -1;
            TransactionTypeName = string.Empty;
            Icon = string.Empty;
            IconColor = string.Empty;
            RoundingDifference = 0;
            PackStatusId = -1;
            InvoiceNumber = string.Empty;
            OrganizationName = string.Empty;
        }

        #endregion
    }

    public class ExternalOnlineTransactionModel
    {
        #region[Properties]

        public int CustomerID { get; set; }
        public int DivisionID { set; get; }
        public string TransactionID { set; get; }
        public int OutletID { get; set; }
        public int MainOutletID { get; set; }
        public int AccountID { get; set; }
        public int OrganizationID { get; set; }
        public int EmployeeID { set; get; }

        public decimal RemainingAmount { get; set; }
        public decimal AppliedAmount { get; set; }
        public decimal NetTotal { get; set; }
        public decimal GrossTotal { get; set; }

        public int CurrencyID { get; set; }
        public List<ExternalItemPackOnlineModel> TransactionDetails { get; set; }
         public string Notes { get; set; }
        #endregion

        #region [METHODS]

        public ExternalOnlineTransactionModel()
        {
            CustomerID = -1;
            OutletID = -1;
            MainOutletID = -1;
            AccountID = -1;
            Notes = "";
        }

        #endregion
    }

    public class EmailFilter
    {
        [Required]
        public int CustomerId { get; set; }
        [Required]
        public int EmployeeID { get; set; }
        [Required]
        public int OutletId { get; set; }
        public int DivisionId { get; set; }
        [Required]
        public string TransactionId { get; set; }
        [Required]
        public int TransactionTypeId { get; set; }
        public int ReportTypeID { get; set; }
        public int RouteHistoryID { get; set; }

        public EmailFilter()
        {
            DivisionId = -1;
        }
    }
    public class TransactionEmailHistory
    {
        public string TransactionId { get; set; }
        public string CustomerDescription { get; set; }
        public string OutletDescription { get; set; }
        public int DivisionId { get; set; }
        public int CustomerId { get; set; }
        public int OutletId { get; set; }
        public int Status { get; set; }
        public int TemplateID { get; set; }
        public string StatusDescription { get; set; }
        public int EmailID { get; set; }
        public DateTime? SendDate { get; set; }
        public DateTime? TransactionDate { get; set; }
        public int TransactionTypeId { get; set; }
        public int Voided { get; set; }
        public string VoidedDescription { get; set; }
        public string EmailSubject { get; set; }
        public string EmailBody { get; set; }
        public string SenderEmail { get; set; }
        public bool AllowView { get; set; }
        public string EmailPassword { get; set; }
        public int ServerPort { get; set; }
        public string ServerAddress { get; set; }
        public bool EnableSSL { get; set; }
        public bool HasAttachment { get; set; }
        public int ReportID { get; set; }
        public int ReportTypeID { get; set; }

    }
    public class DocumentTransaction
    {
        public string SalesID { get; set; }
        public string ReturnID { get; set; }
        public string CreditNoteID { get; set; }
        public string DebitNoteID { get; set; }

        public DocumentTransaction()
        {
            SalesID = string.Empty;
            ReturnID = string.Empty;
            CreditNoteID = string.Empty;
            DebitNoteID = string.Empty;
        }
    }

    public class MovedTransactions
    {
        public List<TransactionModel> Transaction { get; set; }
        public int FromEmployeeId { get; set; }
        public int ToEmployeeId { get; set; }
    }
}