﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Text.Json.Serialization;

namespace Sonic.Web.Model
{
    public class WebFormModel
    {
        public WebFormModel()
        {
            WebFormId = -1;
            EntryFormId = -1;
            SliderWidth = 50;
            WebMenuId = string.Empty;
            Columns = new List<WebFormColumnModel>();
            Filters = new List<WebFormFilterModel>();
            Controls = new List<WebFormControlModel>();
            FormTables = new List<WebFormTable>();
            ActionProcedures = new List<WebFormActionProcedure>();
            SharedTableDataSource = null;
            WebMenuURL = string.Empty;
            AttachmentFolder = string.Empty;
            AttachedFiles = new List<string>();
            FileName = string.Empty;
            IsFromExport = false;
        }
        public int WebFormId { set; get; }
        public WebFormType WebFormTypeId { set; get; }
        public string WebFormName { set; get; }
        public string MenuName { set; get; }
        public string WebFormDescription { set; get; }
        public string WebMenuId { set; get; }
        public string ParentFormWebMenuId { set; get; }
        [JsonIgnore]
        public string Query { set; get; }
        public string DefaultSortingPattern { set; get; }
        public int EntryFormId { set; get; }
        public int CreatedBy { set; get; }
        public DateTime CreatedDate { set; get; }
        public int UpdatedBy { set; get; }
        public DateTime UpdatedDate { set; get; }
        public decimal SliderWidth { set; get; }
        public bool ShowFilterButton { set; get; }
        public bool IsAddMode { set; get; }
        public bool IsEditMode { set; get; }
        public string FilledPrimaryKeyCondition { set; get; }
        public SharedTableResult<dynamic> SharedTableDataSource { set; get; }
        public List<WebFormColumnModel> Columns { set; get; }
        public List<WebFormFilterModel> Filters { set; get; }
        public List<WebFormControlModel> Controls { set; get; }
        public List<WebFormTable> FormTables { set; get; }
        public List<WebFormActionProcedure> ActionProcedures { set; get; }
        public DateTime ExpirationDate { get; set; }
        public bool HasAttachments { get; set; }
        public bool ShowImportButton { get; set; }
        public string WebMenuURL { set; get; }
        public string AttachmentFolder { set; get; }
        public List<string> AttachedFiles { get; set; }
        public bool IsAttachmentsMandatory { get; set; }
        public bool IsFromExport { get; set; }
        public string FileName { set; get; }
        public List<PrimaryKeyModel> PrimaryKeyColumnList { set; get; }
        public List<dynamic> ReportData { get; set; }
        public bool IsPrintingQuery { set; get; }
    }
    public class WebFormColumnModel
    {
        public int WebFormId { set; get; }
        public int ColumnIndex { set; get; }
        public string ColumnName { set; get; }
        public string ColumnDescription { set; get; }
        public WebFormColumnType ColumnTypeId { set; get; }
        public decimal Width { set; get; }
        public bool Sortable { set; get; }
        public bool IsVisible { set; get; }
        public bool IsPrimary { set; get; }
        public string Title { set; get; }
        public string Key { set; get; }
        public bool IsSortable { set; get; }
        public bool IsDate { set; get; }
        public bool IsExpiryDate { set; get; }
        public bool NumberOfStockDigits { set; get; }
        public bool NumberOfDigits { set; get; }
        public string EntryColumnName { set; get; }
    }
    public class PrimaryKeyModel
    {
        public string ColumnName { set; get; }
        public WebFormColumnType ColumnTypeId { set; get; }
        public string Value { set; get; }
        //public DateTime DateValue { set; get; }
        public PrimaryKeyModel()
        {
            //DateValue = DateTime.Now;
        }
    }
    public class PerformActionProcedureModel
    {
        public string ProcedureName { set; get; }
        public List<PrimaryKeyModel> PrimaryKeyColumnList { set; get; }
        public DateTime ExpirationDate { get; set; }
        public string WebMenuId { set; get; }
        public WebMenuActions ActionId { set; get; }

        public PerformActionProcedureModel()
        {
        }
    }

    public class WebFormFilterModel
    {
        public WebFormFilterModel()
        {
            DefaultValue = string.Empty;
            SelectedDateModelValue = new List<DateModel>();
            DataSourceList = new List<ControlDataSourceModel>();
        }
        public int WebFormId { set; get; }
        public int Sequence { set; get; }
        public string FormControlName { set; get; }
        public int WebFormFilterId { set; get; }
        public WebFormControlType FilterTypeId { set; get; }
        public string Description { set; get; }
        public string ColumnName { set; get; }

        [JsonIgnore]
        public string Query { set; get; }
        //public string ValueId { get; set; }
        //public string DisplayText { get; set; }
        public bool BuiltIn { set; get; }
        public WebBuiltInFilters BuiltInFilterId { set; get; }
        public bool IsVisible { set; get; }
        public int CreatedBy { set; get; }
        public DateTime CreatedDate { set; get; }
        public int UpdatedBy { set; get; }
        public DateTime UpdatedDate { set; get; }
        public string DefaultValue { set; get; }
        public string SelectedValue { set; get; }
        public List<DateModel> SelectedDateModelValue { set; get; } 
        public List<ControlDataSourceModel> DataSourceList { set; get; }
    }
    public class WebFormControlModel
    {
        public WebFormControlModel()
        {
            WebFormId = -1;
            DescriptionLanguages = new List<TextLanguage>();
            DataSourceList = new List<ControlDataSourceModel>();
            SelectedValuesList = new List<string>();
            DependsOnColumnIndex = -1;
            ParentFilterControlIndex = -1;
        }
        private DateTime? _selectedDateValue;
        public int WebFormId { set; get; }
        public int ControlIndex { set; get; }
        public string FormControlName { set; get; }
        public string Description { set; get; }
        public string TipDescription { set; get; }
        public WebFormControlType ControlTypeId { set; get; }
        public string ColumnName { set; get; }
        public string DBColumnName { set; get; }
        public string TableName { set; get; }
        [JsonIgnore]
        public string Query { set; get; }
        public bool BuiltIn { set; get; }
        public WebBuiltInFilters BuiltInFilterId { set; get; }
        public WebFormValidation ValidationId { set; get; }
        public int DependsOnColumnIndex { set; get; } // this for show/hide fields according to another field value
        public string DependsOnValue { set; get; } // this for show/hide fields according to another field value
        public int ParentFilterControlIndex { set; get; } // this for refill data source for combos based on parent combo seletion 
        public string ParentFilterControlParameter { set; get; } // this for refill data source for combos based on parent combo seletion
        public string ParentFilterControlValue { set; get; } // this for refill data source for combos based on parent combo seletion
        public bool FilterBySpecificControl { set; get; } // this for refill data source for combos based on parent combo seletion
        public int Width { set; get; }
        public bool AllowEdit { set; get; }
        public bool IsPrimary { set; get; }
        public bool IsVisible { set; get; }

        public DateTime? SelectedDateValue
        {
            get { return _selectedDateValue; }
            set
            {
                _selectedDateValue = value;
                if (_selectedDateValue != null)
                    SelectedDateModelValue = new DateModel(_selectedDateValue.Value);
            }
        }
        public DateModel SelectedDateModelValue { get; set; }
        public string SelectedValue { get; set; }
        public List<string> SelectedValuesList { get; set; } // For Multi Select Combo
        public string DefaultValue { get; set; }
        public string DefaultDescription { get; set; }
        public List<ControlDataSourceModel> DataSourceList { set; get; }
        public List<TextLanguage> DescriptionLanguages { set; get; }
    }
    public class WebFormTable
    {
        public WebFormTable()
        {
            WebFormId = -1;
        }
        public int WebFormId { set; get; }
        public string TableName { set; get; }
        public int Sequence { set; get; }
        public string PrimaryKeys { set; get; }
        public bool HasAuditColumns { set; get; }
        public bool IsAssignmentTable { set; get; } // For Multi Select Controls
        public bool HasAttachmentColumn { set; get; }
    }
    public class ControlDataSourceModel
    {
        public ControlDataSourceModel()
        {

        }
        public string ValueId { set; get; }
        public string DisplayText { set; get; }
        public string UniqueValue { set; get; } // Stores the unique column value (for import app data functionality).

    }
    public class InitializeWebFormList
    {
        public InitializeWebFormList()
        {
            URL = string.Empty;
        }
        public string URL { set; get; }
        public WebFormModel Form { set; get; }
        public CustomListFilters SharedTableFilter { set; get; }
    }
    public class InitializeWebFormEntry
    {
        public InitializeWebFormEntry()
        {
            WebFormId = -1;
            WebMenuURL = string.Empty;
            PrimaryKey = string.Empty;
        }
        public int WebFormId { set; get; }
        //public string PrimaryKeyCondition { set; get; }
        public List<PrimaryKeyModel> PrimaryKeyColumnList { set; get; }
        public bool GetSavedDetails { set; get; } // if edit || view mode -> true
        public string WebMenuURL { get; set; }
        public string PrimaryKey{ get; set; }
    }
    public class WebFormActionProcedure
    {
        public WebFormActionProcedure()
        {
            ActionId = -1;
            WebFormId = -1;
        }
        public int WebFormId { set; get; }
        public int ActionId { set; get; }
        public string ProcedureName { set; get; }
    }
}