﻿using DinkToPdf.Contracts;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;
using Sonic.Web.DAL;
using Sonic.Web.Licensing.Licensing;
using Sonic.Web.PL.Controllers;
using Sonic.Web.Service;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Threading;
using System.Threading.Tasks;
using Sonic.Web.Model;
using Sonic.Web.PL.SystemModels;
using Sonic.Web.Resources;
using System.IO;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.DependencyInjection;
using DinkToPdf;
using Sonic.Web.Service.SendEmail;
using Sonic.Web.Models;
using Sonic.Web.Model.AutoService;
using Sonic.Web.Service.AutoService;
using Sonic.Web.Core.AutoService;

namespace Sonic.Web.PL
{
    //public class BackgroundService : IHostedService, IDisposable
    //{
    //    private int executionCount = 0;
    //    private readonly ILogger<BackgroundService> _logger;
    //    private Timer _timerSendingEmails;
    //    private Timer _timerInsertImages;
    //    private readonly IServiceScopeFactory _scopeFactory;
    //    private readonly IConverter _converter;
    //    private readonly Microsoft.AspNetCore.Hosting.IHostingEnvironment _hostingEnvironment;
    //    private ProofService _proofService;
    //    private ServicesService _servicesService;
    //    private EmailService _emailService;
    //    private TemplateGenerator _templateGenerator;
    //    private WindowsServiceData _windowsServiceData;
    //    private bool _runInsertingImages = true;
    //    public BackgroundService(ILogger<BackgroundService> logger, IServiceScopeFactory scopeFactory, IConverter converter, Microsoft.AspNetCore.Hosting.IHostingEnvironment hostingEnvironment)
    //    {
    //        _logger = logger;
    //        _scopeFactory = scopeFactory;
    //        _converter = converter;
    //        _hostingEnvironment = hostingEnvironment;
    //    }

    //    public void Dispose()
    //    {
    //        _timerInsertImages?.Dispose();
    //        _timerSendingEmails?.Dispose();
    //    }

    //    public Task StartAsync(CancellationToken cancellationToken)
    //    {
    //        _proofService = new ProofService(null);
    //        _emailService = new EmailService(null);
    //        _servicesService = new ServicesService(null);
    //        _templateGenerator = new TemplateGenerator(null, _hostingEnvironment, _converter);
    //        _logger.LogInformation("Timed Hosted Service running.");
    //        //ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Started ", null, "", 0);

    //        _windowsServiceData = _servicesService.GetWindowsServiceData();
    //        if (_windowsServiceData != null && _windowsServiceData.ServiceID > 0)
    //        {
    //            if (!_windowsServiceData.IsCertainTimeRuning)
    //            {
    //                _timerSendingEmails = new Timer(DoWorkWindowsServiceData, null, TimeSpan.Zero,
    //                TimeSpan.FromMilliseconds(GetSleepTime()));
    //            }
    //            else
    //            {
    //                _timerSendingEmails = new Timer(DoWorkWindowsServiceData, null, TimeSpan.Zero,
    //                                    TimeSpan.FromMilliseconds(GetSleepTime()));
    //            }

    //        }

    //        if (_runInsertingImages)
    //        {
    //            _timerInsertImages = new Timer(DoWorkImageInserting, null, TimeSpan.Zero,
    //                                    TimeSpan.FromMinutes(10));
    //        }
    //        return Task.CompletedTask;
    //    }

    //    private void DoWorkWindowsServiceData(object state)
    //    {
    //        var count = Interlocked.Increment(ref executionCount);
    //        //ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Running " + count, null, "", 0);
    //        if (!_windowsServiceData.IsCertainTimeRuning || _windowsServiceData.TimeToRun <= DateTime.Now)
    //        {
    //            SendEmail();
    //        }
    //    }

    //    private void DoWorkImageInserting(object state)
    //    {
    //        if (_runInsertingImages)
    //        {
    //            if (_servicesService.FillSystemImages() != GlobalErrors.Success)
    //            {
    //                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Running Images Background Service Failed", null, "", 0);
    //            }
    //            else
    //            {
    //                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Images Background Service Finished Successfully", null, "", 0);
    //            }
    //            _runInsertingImages = false;
    //            _timerInsertImages.Dispose();
    //        }
    //    }

    //    public Task StopAsync(CancellationToken cancellationToken)
    //    {
    //        _logger.LogInformation("Timed Hosted Service is stopping.");
    //        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Stopped ", null, "", 0);

    //        _timerInsertImages?.Change(Timeout.Infinite, 0);
    //        _timerSendingEmails?.Change(Timeout.Infinite, 0);

    //        return Task.CompletedTask;
    //    }

    //    public void SendEmail()
    //    {
    //        GlobalErrors result = GlobalErrors.NotInitialized;
    //        try
    //        {
    //            List<string> AllUnsentProofsList = _proofService.GetAllUnsentProofs();
    //            if (AllUnsentProofsList != null && AllUnsentProofsList.Count > 0)
    //            {
    //                foreach (string DocumentId in AllUnsentProofsList)
    //                {
    //                    if (string.IsNullOrEmpty(DocumentId))
    //                    {
    //                        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "DocumentID Not Available ", null, "", 0);
    //                    }

    //                    ProofDataForEmail proofDataForEmail = _proofService.GetProofDataForEmail(DocumentId);
    //                    if (proofDataForEmail == null)
    //                    {
    //                        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Error Getting Email Template Data ", null, "", 0);
    //                    }
    //                    if (proofDataForEmail.EmailTempID <= 0)
    //                    {
    //                        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "No Email Template Available ", null, "", 0);
    //                    }
    //                    if (proofDataForEmail.Email == null || proofDataForEmail.Email.Count <= 0)
    //                    {
    //                        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "No Emails Available ", null, "", 0);
    //                    }

    //                    ICollection<IFormFile> file = null;
    //                    Dictionary<int, List<ProofDataForPDF>> proofTypeData = _proofService.GetProofDataForPDF(DocumentId);
    //                    ProofHeaderForPDF proofHeader = _proofService.GetProofHeaderForPDF(DocumentId);
    //                    HtmlToPdfDocument pdf = _templateGenerator.HtmlToPDF(proofTypeData, proofHeader);
    //                    string printoutPath = _templateGenerator.GetPrintoutPath(DocumentId);
    //                    EmailModel emailObj = new EmailModel();
    //                    emailObj.EmailTempId = proofDataForEmail.EmailTempID;
    //                    foreach (string email in proofDataForEmail.Email)
    //                    {
    //                        MemoryStream fff = _templateGenerator.CreateProofsPDF(DocumentId, pdf, proofTypeData);
    //                        emailObj.ToEmail = email;

    //                        //file.Add(fff);
    //                        if (emailObj != null)
    //                        {
    //                            result = _emailService.SendEmail(file, emailObj, fff, "Proofs.pdf", printoutPath, proofDataForEmail.CustomerName, DocumentId);
    //                        }

    //                        if (result != GlobalErrors.Success)
    //                        {
    //                            ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Error While Sending Email ", null, "", 0);
    //                            break;
    //                        }
    //                    }

    //                    if (result == GlobalErrors.Success)
    //                    {
    //                        result = _proofService.UpdateProofStatusToSent(DocumentId);
    //                    }

    //                    if (result != GlobalErrors.Success)
    //                    {
    //                        ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, "Error While Updating DocumentProofHeader Table Status ", null, "", 0);
    //                    }
    //                }
    //            }
    //        }
    //        catch (Exception ex)
    //        {
    //            ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
    //        }
    //    }

    //    private int GetSleepTime()
    //    {
    //        int SleepTime = 0;
    //        try
    //        {
    //            if (!_windowsServiceData.IsCertainTimeRuning)
    //            {
    //                SleepTime = _windowsServiceData.NumberOfMinutesToSleep * 60000;
    //            }
    //            else
    //            {
    //                DateTime currentTime = DateTime.Now;
    //                int hour = currentTime.Hour;
    //                int minute = currentTime.Minute;

    //                if(currentTime.Date >= _windowsServiceData.TimeToRun.Date)
    //                {
    //                    if ((hour < _windowsServiceData.TimeToRun.Hour))
    //                    {
    //                        if (minute <= _windowsServiceData.TimeToRun.Minute)
    //                        {
    //                            SleepTime = (_windowsServiceData.TimeToRun.Minute - minute);
    //                            SleepTime = SleepTime + ((_windowsServiceData.TimeToRun.Hour - hour) * 60);
    //                        }
    //                        else
    //                        {
    //                            SleepTime = 60 - minute;
    //                            SleepTime = SleepTime + ((_windowsServiceData.TimeToRun.Hour - hour - 1) * 60);
    //                        }
    //                    }
    //                    else if ((hour == _windowsServiceData.TimeToRun.Hour))
    //                    {
    //                        if (minute <= _windowsServiceData.TimeToRun.Minute)
    //                        {
    //                            SleepTime = (_windowsServiceData.TimeToRun.Minute - minute);
    //                        }
    //                        else
    //                        {
    //                            SleepTime = 60 - minute;
    //                            SleepTime = SleepTime + (23 * 60);
    //                        }
    //                    }
    //                    else if (hour > _windowsServiceData.TimeToRun.Hour)
    //                    {
    //                        if (minute <= _windowsServiceData.TimeToRun.Minute)
    //                        {
    //                            SleepTime = (_windowsServiceData.TimeToRun.Minute - minute);
    //                            SleepTime = (24 * 60) - (SleepTime + ((hour - _windowsServiceData.TimeToRun.Hour) * 60));
    //                        }
    //                        else
    //                        {
    //                            SleepTime = 60 - minute;
    //                            SleepTime = (24 * 60) - (SleepTime + ((hour - _windowsServiceData.TimeToRun.Hour - 1) * 60));
    //                        }
    //                    }
    //                    // Sleep Time in Millisecond
    //                    if (SleepTime == 0)
    //                    {
    //                        SleepTime = (24 * 60 * 60000) - 1000;
    //                    }
    //                    else
    //                    {
    //                        SleepTime = (SleepTime * 60000) - 1000;
    //                    }
    //                }
    //                else
    //                {
    //                    SleepTime = 86400000;
    //                }
    //            }
    //        }
    //        catch (Exception ex)
    //        {
    //            SleepTime = 0;
    //            ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
    //        }
    //        return SleepTime;
    //    }


    //}

    public class ServiceWorker : IHostedService, IDisposable
    {
        private readonly ILogger<ServiceWorker> _logger;
        private int _numberOfTrails = 0;
        private List<Thread> _threads;
        private List<AutoServiceComponent> _components;
        private CancellationToken _cancellationToken;
        private readonly IConverter _converter;
        public ServiceWorker(ILogger<ServiceWorker> logger, IConverter converter)
        {
            _numberOfTrails = 0;
            _threads = new List<Thread>();
            _components = new List<AutoServiceComponent>();
            _logger = logger;
            _converter = converter;
        }
        public async Task StartAsync(CancellationToken cancellationToken)
        {
            try
            {
                _numberOfTrails++;
                _cancellationToken = cancellationToken;
                AutoServiceManager serviceManager = new AutoServiceManager(null);
                
                // Always run fill Images on startup for one time only 
                AppendImagesService();

                var webServiceList = new List<AutoServiceModel>();
                GlobalErrors result = serviceManager.GetAutoServiceWebList(ref webServiceList);
                if (result == GlobalErrors.Success)
                {
                    if (webServiceList != null && webServiceList.Count > 0)
                    {
                        foreach (var webService in webServiceList)
                        {
                            AppendService(webService);
                        }
                    }
                }
                else
                {
                    await Task.Delay(500);
                    if (_numberOfTrails < 3)
                    {
                        await StartAsync(cancellationToken);
                    }
                }
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
                await Task.Delay(500);
                if (_numberOfTrails < 3)
                {
                    await StartAsync(cancellationToken);
                }
            }
        }


        public Task StopAsync(CancellationToken cancellationToken)
        {
            StopServices();
            return Task.CompletedTask;
        }

        private void StopServices()
        {
            for (int index = 0; index < _threads.Count; index++)
            {
                _threads[index].Interrupt();
            }
        }
        public void Dispose()
        {
            StopServices();
        }

        private void AppendService(AutoServiceModel serviceModel)
        {
            try
            {
                var component = new AutoServiceComponent(_cancellationToken, serviceModel, _converter);
                _components.Add(component);
                Thread workerThread = new Thread(new ThreadStart(component.RunService));
                workerThread.Name = serviceModel.ServiceName;
                workerThread.Start();
                _threads.Add(workerThread);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }
        private void AppendImagesService()
        {
            try
            {
                var component = new AutoServiceComponent(_cancellationToken, null, _converter);
                _components.Add(component);
                Thread workerThread = new Thread(new ThreadStart(component.RunImagesService));
                workerThread.Start();
                _threads.Add(workerThread);
            }
            catch (Exception ex)
            {
                ErrorLogger.Logger(MethodBase.GetCurrentMethod().DeclaringType.FullName, MethodBase.GetCurrentMethod().Name, ex.Message, ex.InnerException, ex.StackTrace, 0);
            }
        }



    }
}
