import { Component, OnInit, ViewChild} from '@angular/core';
import { CoreSession } from '../../../core/core.session';
import { SettingsService } from '../settings.service';
import { TranslateService } from '@ngx-translate/core';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import * as cloneDeep from 'lodash/cloneDeep';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { HttpErrorResponse } from '@angular/common/http';
import { DialogMode } from '../../../shared/models/enums/dialog-mode.enum';
import { DialogResult } from '../../../shared/models/enums/dialog-result.enum';
import { NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { SharedTableResult } from '../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../shared/models/shared-table/table-properties.interface';
@Component({
  selector: 'app-add-language',
  templateUrl: './add-language.component.html',
  styleUrls: ['./add-language.component.css']
})
export class AddLanguageComponent implements OnInit {
  @ViewChild('addLanguageDialog') addLanguageDialog: any;
  tableData: ITableProperties = {
    pageSize: 10,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: true,
    showOptionPerLine: false,
    showEditButton: false,
    specificActionWhenCheckAll: true,
    showOptionOnKey: 'enabled',
    rowOperations: [],
    multiSelectionOperations: [
    ],
    columns: []
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  OkResult: DialogResult = DialogResult.Ok;
  Languages: any[] = [];
  currentLanguageId = -1;
  constructor(
    private coreSession: CoreSession,
    private settingsService: SettingsService,
    private translateService: TranslateService,
    private sessionDataProvider: SessionDataProvider,
    private modalService: NgbModal
  ) { }
  ngOnInit() {
    this.setTableColumns();
    this.Languages = cloneDeep(this.sessionDataProvider.getSessionLanguages());
    this.Languages.forEach((element) => {
      element.oldStatus = element.active;
    });
    this.currentLanguageId = this.coreSession.selectedLanguageId;
    this.dataSource.data = this.Languages;
    this.dataSource.totalItems = this.Languages.length;
  }
  manageLanguages() {
    this.coreSession.ModalLoading.Show();
    this.settingsService.manageLanguages(this.dataSource.data).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly), '');
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.dataSource.data = cloneDeep(this.sessionDataProvider.getSessionLanguages());
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );

  }
  public showDialog() {
    return this.modalService.open(this.addLanguageDialog,  { centered: true}).result.then(
      (result) => {
        if (result === DialogResult.Ok) {
          this.manageLanguages();
          this.sessionDataProvider.loadSessionLanguges();
        } else {
          this.dataSource.data = cloneDeep(this.sessionDataProvider.getSessionLanguages());
          return -1;
        }
      });
  }
  onSelectAll(event: any) {
    this.dataSource.data.forEach((element) => {
      if (element.languageId !== 1 && element.languageId !== 2) {
      element.isChecked = event;
      }
    });
  }
  setTableColumns() {
    this.tableData.columns = [
      {
        title: 'Language',
        key: 'description',
        isSortable: true,
        width: '75%',
        useTranslate: true,
      },
      {
        title: 'Code',
        key: 'code',
        isSortable: true,
        width: '25%'
      }
    ];
  }
}
