import { RestoreDefaultCaptionsComponent } from '../restore-default-captions/restore-default-captions.component';
import { Component, OnInit, OnChanges, Input, ViewChild } from '@angular/core';
import { CoreSession } from '../../../core/core.session';
import { SettingsService } from '../settings.service';
import { Subject, Observable, Subscription } from 'rxjs';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { ConstantURLs } from '../../../shared/models/constants/constant-URL';
import { Router, ActivatedRoute, Params } from '@angular/router';
import { MenuModel } from '../../../shared/models/menu/menu.model';
import { NavBarService } from '../../../core/sidebar/sidebar.service';
import { TranslateService } from '@ngx-translate/core';
import { SetupService } from '../setup/setup.service';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { FormMode } from '../../../shared/models/enums/form-mode.enum';
import { LicenseResult } from '../../../shared/models/enums/globalErrors';
import { AuthService } from '../../../core/auth/auth.service';
import { ConstantStorage } from '../../../shared/models/constants/constant-stroage';
import { ChangeLanguageComponent } from '../change-language/change-language.component';
import { ConstantConfigurations } from '../../../shared/models/constants/constant-configuration';
import { DialogMode } from '../../../shared/models/enums/dialog-mode.enum';
import { DialogResult } from '../../../shared/models/enums/dialog-result.enum';
import { IncubeSupportDialogComponent } from '../incube-support-dialog/incube-support-dialog.component';
import { HttpErrorResponse } from '@angular/common/http';
import { ShepherdService } from 'angular-shepherd';
import { TourService } from '../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../shared/shepherd-config/trackTour.service';
import { SharedDialogComponent } from '../../../shared/components/shared-dialog/shared-dialog.component';
@Component({
  selector: 'app-admin-settings-main',
  templateUrl: './admin-settings-main.component.html',
  styleUrls: ['./admin-settings-main.component.css']
})
export class AdminSettingsMainComponent implements OnInit, OnChanges {
  sliderDescription: String = '';
  @ViewChild('restoreDefaultsDialog', { static: true }) restoreDefaultsDialog: any;
  @ViewChild('changeLanguageDialog', { static: true }) changeLanguageDialog: any;
  @ViewChild('addLanguageDialog') addLanguageDialog: any;
  @ViewChild("IncubeSupportNoteDialog", { static: true }) IncubeSupportNoteDialog: IncubeSupportDialogComponent;
  @ViewChild('ItemEntryDialog', { static: true }) ItemEntryDialog: SharedDialogComponent;

  supportNote = {
    NoteDescription: ""
  };
  showSlider = false;
  showDialog = false;
  notificationManagementComponent = false;
  changeLanguageComponent = false;
  changeDescriptionsComponent = false;
  customerAppPropertiesComponent = false;
  customerAppBannersComponent = false;
  changeSecurityGroupPrivileges = false;
  changeConfigurationValues = false;
  restoreDefaultCaptionsComponent = false;
  moduleId: number;
  isCustomizationVisible: boolean = true;
  saveSubject: Subject<void> = new Subject<void>();
  isSecurityGroupPrivilegesMenuVisible: boolean = true;
  isChangeLanguageMenuVisible: boolean = true;
  isEmailMenuVisible: boolean = true;
  isDynamicTemplateMenuVisible: boolean = true;
  isEmployeeGroupEmailMenuVisible: boolean = true;
  isConfigurationMenuVisible: boolean = true;
  isUpdateLicenseMenuVisible: boolean = true;
  isSonicServicesMenuVisible: boolean = true;
  isApprovalCycleLevelsMenuVisible: boolean = true;
  isNotificationTemplatesMenuVisible: boolean = true;
  isExcelSheetDynamicTemplatesMenuVisible: boolean = true;
  isOperatorLoginFailuresMenuVisible: boolean = true;
  isCustomerVisitStepsMenuVisible: boolean = true;
  isCustomerBILinksMenuVisible: boolean = true;
  addNewLanguageComponent = false;
  showStockReservationsSlider = false;
  AllowCustomerAppLogin: boolean = false;
  isCustAppPropertiesMenuVisible: boolean = true;
  isFQAsMenuVisible: boolean = true; //
  customerAppItemsComponent = false;
  isFQAsComponent = false;
  companyDetailsComponent = false;
  organizationDetailsComponent = false;
  isCustAppBannersMenuVisible: boolean = true;
  isCompanyDetailsMenuVisible: boolean = true;
  isOrganizationDetailsMenuVisible: boolean = true;
  isItemDefenitionMenuVisible: boolean = true
  isPriceListMenuVisible: boolean = true;
  isCustomerDefinitionMenuVisible: boolean = true
  customerAppFirstOrderItemsComponent: boolean = false;
  customerAppSettingsComponent: boolean = false;

  navLinks: any[];
  constructor(
    public coreSession: CoreSession,
    private settingService: SettingsService,
    private sessionDataProvider: SessionDataProvider,
    private navService: NavBarService,
    private router: Router,
    private route: ActivatedRoute,
    private translateService: TranslateService,
    private setupService: SetupService,
    private authService: AuthService,
    private sessionData: SessionDataProvider,
    private readonly shepherdService: ShepherdService,
    private tourService: TourService,
    private componentVisitService: ComponentVisitService
  ) { }

  private tourStartTimeout: any;

  startTour(forceTour?) {
    this.tourStartTimeout = setTimeout(() => {
      debugger

      if(!forceTour)
      if (this.tourService.isTourCompletedForComponent('admin-setting-entry')) {
        return;
      }

      if(this.tourService.isFirstTour() || forceTour){

        var titles = ['Desc_General_Setting'];
        var texts = ['Desc_General_Setting'];
        const elementSelectors = ['#general-def'];

        if (this.isChangeLanguageMenuVisible) {
          elementSelectors.push('#language-change-def');
          titles.push('Desc_Change_Language');
          texts.push('Desc_Language_Settings');
        }

        if (this.isConfigurationMenuVisible) {
        elementSelectors.push('#config-def');
        titles.push('Desc_Configurations');
        texts.push('Desc_Configure_System_Settings');
      }

      elementSelectors.push('#Incube_Support-def');
      titles.push('Desc_Incube_Support');
      texts.push('Desc_Access_Incube_Support');

      if (this.isSecurityGroupPrivilegesMenuVisible) {
          elementSelectors.push('#SecurityGroup-def');
          titles.push('Desc_SecurityGroup_Management');
          texts.push('Desc_Manage_Security_Group_Privileges');
        }


      if (this.isApprovalCycleLevelsMenuVisible) {
        elementSelectors.push('#ApprovalCycle-def');
        titles.push('Desc_Approval_Cycle_Levels');
        texts.push('Desc_Define_Approval_Cycle_Levels');
      }

      if (this.isNotificationTemplatesMenuVisible) {
        elementSelectors.push('#notification-def');
        titles.push('Desc_Notification_Template');
        texts.push('Desc_Manage_Notification_Templates');
      }

      if (this.isExcelSheetDynamicTemplatesMenuVisible) {
        elementSelectors.push('#excel-def');
        titles.push('Excel Sheet Dynamic Templates');
        texts.push('Here you can manage dynamic templates for Excel sheets.');
      }

      if (this.isOperatorLoginFailuresMenuVisible) {
        elementSelectors.push('#OperatorLogin-def');
        titles.push('Desc_Operator_Login_Failures');
        texts.push('Desc_View_Operator_Login_Failures');
      }


      elementSelectors.push('#Email-def');
      titles.push('Desc_Email');
      texts.push('Desc_Manage_Email_Settings');

      if (this.isEmailMenuVisible) {
        elementSelectors.push('#email-template-def');
        titles.push('Desc_Email_Templates');
        texts.push('Desc_Manage_Email_Templates');
      }

      if (this.isDynamicTemplateMenuVisible) {
        elementSelectors.push('#Dynamic_Template-def');
        titles.push('Desc_Dynamic_Templates');
        texts.push('Desc_Manage_Dynamic_Templates');
      }

      if (this.isEmployeeGroupEmailMenuVisible) {
        elementSelectors.push('#Employee-roup-def');
        titles.push('Desc_Employee_Group_Emails');
        texts.push('Desc_Manage_Employee_Group_Emails');
      }

      if (this.isCustomizationVisible) {
        elementSelectors.push('#Customization-def');
        titles.push('Customization');
        texts.push('Here you can customize settings.');

        elementSelectors.push('#New_Language-def');
        titles.push('New Language');
        texts.push('Here you can add new languages.');

        elementSelectors.push('#Master_Data-def');
        titles.push('Master Data');
        texts.push('Here you can manage master data.');

        elementSelectors.push('#Order-def');
        titles.push('Order');
        texts.push('Here you can manage orders.');

        elementSelectors.push('#Mobile_App-def');
        titles.push('Mobile App');
        texts.push('Here you can manage mobile app settings.');

        elementSelectors.push('#Restore_Defaults');
        titles.push('Restore Defaults');
        texts.push('Here you can restore default settings.');
      }

      if (this.AllowCustomerAppLogin) {
        elementSelectors.push('#Customer-App-def');
        titles.push('Customer App Login');
        texts.push('Here you can manage customer app login.');
      }

      if (this.isCustAppPropertiesMenuVisible) {
        elementSelectors.push('#Desc_About-Policy');
        titles.push('About Policy');
        texts.push('Here you can view the policy details.');
      }

      if (this.isOrganizationDetailsMenuVisible) {
        elementSelectors.push('#Organization-Details-def');
        titles.push('Organization Details');
        texts.push('Here you can view organization details.');
      }

      if (this.isFQAsMenuVisible) {
        elementSelectors.push('#FQAs-def');
        titles.push('FQAs');
        texts.push('Here you can view frequently asked questions.');
      }


      const steps = this.tourService.generateSteps(elementSelectors, titles, texts);
      this.tourService.defaultStepOptions.scrollTo = true
      this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
      this.shepherdService.modal = true;
      this.shepherdService.addSteps(steps);
      this.shepherdService.start();
    }
    }, 1000);
  }
  ngAfterViewInit() {
    this.startTour()
  }
  ngOnDestroy() {
    if (this.tourStartTimeout) {

      this.tourService.defaultStepOptions.scrollTo = false

      clearTimeout(this.tourStartTimeout);
    }
    if (this.shepherdService.tourObject)
      this.shepherdService.cancel()

    this.componentVisitService.markComponentVisited('admin-setting-entry');

    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }
    // this.navService.setNavigation([]);
  }
  tourSubscription :Subscription
  ngOnInit() {
    this.coreSession.SetTitle('Admin Settings');
    this.AllowCustomerAppLogin = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowCustomerAppLogin).toLowerCase() === "true";
    this.checkExistedMenus();

    this.tourSubscription = this.tourService.startTourMain$.subscribe(() => {
      this.startTour(true);
    });
    // if(this.coreSession.showLanguageSlider){
    //   this.changeLanguage();
    // }
  }

  ngOnChanges() {
    // if(this.coreSession.showLanguageSlider){
    //   this.changeLanguage();
    // }
    this.sessionDataProvider.loadSessionLanguges();
  }
  changeLanguage() {
    this.showDialog = true;
    this.changeLanguageComponent = true;
    this.OpenchangeLanguageDialog();
  }

  getQueryParams() {
    let queryParams: any = {};
    return queryParams;
  }

  checkIfSecurityGroupPrivilegesMenuVisible(menu: MenuModel[]) {
    if (this.coreSession.CurrentOperator.employeeId !== 0 &&
      menu.filter(x => x.menuId === '900-001-02').length < 1) {
      this.isSecurityGroupPrivilegesMenuVisible = false;
    } else {
      this.isSecurityGroupPrivilegesMenuVisible = true;
    }
  }

  checkIfChangeLanguageMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '900-001-01').length < 1) {
      this.isChangeLanguageMenuVisible = false;
    } else {
      this.isChangeLanguageMenuVisible = true;
    }
  }

  checkIfEmailMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '900-003-01').length < 1) {
      this.isEmailMenuVisible = false;
    } else {
      this.isEmailMenuVisible = true;
    }
  }
  checkIfEmployeeGroupEmailsMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '900-003-03').length < 1) {
      this.isEmployeeGroupEmailMenuVisible = false;
    } else {
      this.isEmployeeGroupEmailMenuVisible = true;
    }
  }
  checkIfDynamicTemplateMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '900-003-02').length < 1) {
      this.isDynamicTemplateMenuVisible = false;
    } else {
      this.isDynamicTemplateMenuVisible = true;
    }
  }

  checkIfConfigurationMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '900-001-04').length < 1) {
      this.isConfigurationMenuVisible = false;
    } else {
      this.isConfigurationMenuVisible = true;
    }
  }

  checkIfLicenseMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '900-001-05').length < 1) {
      this.isUpdateLicenseMenuVisible = false;
    } else {
      this.isUpdateLicenseMenuVisible = true;
    }
  }
  checkIfSonicServicesMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '900-001-06').length < 1) {
      this.isSonicServicesMenuVisible = false;
    } else {
      this.isSonicServicesMenuVisible = true;
    }
  }
  checkIfCustomizationsMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '900-002').length < 1) {
      this.isCustomizationVisible = false;
    } else {
      this.isCustomizationVisible = true;
    }
  }
  checkIfCustAppPropertiesMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '900-004-01-01').length < 1) {
      this.isCustAppPropertiesMenuVisible = false;
    }
  }

  isCustItemsMenuVisible = true
  checkIfItemsMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '900-004-01-03').length < 1) {
      this.isCustItemsMenuVisible = false;
    }
  }
  checkIfOrganizationDetailsMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '900-004-01-02').length < 1) {
      this.isOrganizationDetailsMenuVisible = false;
    }
  }

  openCustomerAppPropertiesMenu(moduleId) {
    this.moduleId = moduleId;
    this.customerAppPropertiesComponent = true;
    this.showSlider = true;
    if (moduleId == 1)
      this.sliderDescription = this.translateService.instant('Desc_About_Us');
    else if (moduleId == 2)
      this.sliderDescription = this.translateService.instant('Desc_Privacy_Policy');

    this.openItemEntryDialog()

  }



  openCustomerAppBannersMenu() {
    this.customerAppBannersComponent = true;
    this.showSlider = true;
    this.sliderDescription = this.translateService.instant('Desc_Banners');
    this.openItemEntryDialog()
  }

  openSendNotificationMenu() {
    this.coreSession.SetTitle("Notification Management");
    this.showSlider = true;
    this.notificationManagementComponent = true;
    this.sliderDescription = this.translateService.instant('Desc_Send_Notification');
    this.openItemEntryDialog()
  }

  checkIfApprovalCycleLevelsMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '900-001-10').length < 1) {
      this.isApprovalCycleLevelsMenuVisible = false;
    }
  }
  checkIfNotificationTemplatesMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '900-001-11').length < 1) {
      this.isNotificationTemplatesMenuVisible = false;
    }
  }
  checkIfExcelSheetDynamicTemplatesMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '900-001-12').length < 1) {
      this.isExcelSheetDynamicTemplatesMenuVisible = false;
    }
  }
  checkIfOperatorLoginFailuresMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '900-001-14').length < 1) {
      this.isOperatorLoginFailuresMenuVisible = false;
    }
  }
  openEmailComponent() {

    this.router.navigate([ConstantURLs.emailTemplatesURL], {
      relativeTo: this.route.parent
    });

  }
  openDynamicTemplateComponent() {

    this.router.navigate([ConstantURLs.dynamicTemplatesURL], {
      relativeTo: this.route.parent
    });

  }
  openEmployeeGroupEmailsComponent() {
    this.router.navigate([ConstantURLs.EmployeeGroupEmailsURL], {
      relativeTo: this.route.parent
    });

  }
  openConfigurationMenu() {
    this.router.navigate([ConstantURLs.configurationURL], {
      relativeTo: this.route.parent
    });
  }
  openSonicServicesMenu() {
    this.router.navigate([ConstantURLs.sonicServicesURL], {
      relativeTo: this.route.parent
    });
  }
  openApprovalCycleLevelsMenu() {
    this.router.navigate([ConstantURLs.approvalCycleLevelsURL], {
      relativeTo: this.route.parent
    });
  }
  openNotificationTemplatesComponent() {
    this.router.navigate([ConstantURLs.notificationTemplatesURL], {
      relativeTo: this.route.parent
    });
  }
  openExcelSheetDynamicTemplatesComponent() {
    this.router.navigate([ConstantURLs.excelSheetDynamicTemplatesURL], {
      relativeTo: this.route.parent
    });
  }
  openOperatorLoginFailuresComponent() {
    this.router.navigate([ConstantURLs.operatorLoginFailuresURL], {
      relativeTo: this.route.parent
    });
  }

  openCustomerVisitSteps() {
    this.router.navigate([ConstantURLs.customerVisitPatterns], {
      relativeTo: this.route.parent
    });
  }

  openBILinks() {
    this.router.navigate([ConstantURLs.BILinks], {
      relativeTo: this.route.parent
    });
  }

  openSessionHandling() {
    this.router.navigate([ConstantURLs.SessionHandling], {
      relativeTo: this.route.parent
    });

  }
  changeSecurityGroupPrivilegesValue() {
    this.router.navigate([ConstantURLs.securityGroupsURL], {
      relativeTo: this.route.parent
    });
    // this.changeSecurityGroupPrivileges = true;
    // this.showSlider = true;
    // this.sliderDescription = this.translateService.instant("Desc_SecurityGroup_Management")
  }
  openStockReservationsSlider() {
    this.showStockReservationsSlider = true;
    this.sliderDescription = this.translateService.instant('Desc_Stock_Reservations');
  }
  changeDescriptions(moduleId) {
    this.moduleId = moduleId;
    this.changeDescriptionsComponent = true;
    this.showSlider = true;
    this.sliderDescription = this.translateService.instant('Desc_Change_Descriptions');
    this.openItemEntryDialog()
  }
  restoreDefaults() {
    this.restoreDefaultCaptionsComponent = true;
    this.showDialog = true;
  }
  openItemEntryDialog() {
    this.ItemEntryDialog.Show(true).then((res) => { });
  }
  updateLicense() {
    this.coreSession.ModalLoading.Show();
    let languageId = +localStorage.getItem(ConstantStorage.LanguageId);
    this.setupService.UpdateLicense(languageId).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status >= 0 && response.data) {
        switch (response.data) {
          case LicenseResult.Licensed.valueOf():
            this.coreSession.showSuccess('', response.message);
            break;

          case LicenseResult.Unauthorized.valueOf():
            this.authService.logout();
            this.coreSession.showError('', response.message);
            break;

          case LicenseResult.NearToExpired.valueOf():
            this.coreSession.showError('', response.message);
            break;

          default:
            this.coreSession.showError('', response.message);
            break;
        }
      }
      else {
        this.coreSession.showError('', response.message);
      }
    },
      error => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError('', this.translateService.instant(ConstantMessages.ErrorCaption));
      });
  }
  show() {

  }

  close() {
    this.coreSession.SetTitle('Admin Settings');
    this.showSlider = false;
    this.changeDescriptionsComponent = false;
    this.changeLanguageComponent = false;
    this.changeSecurityGroupPrivileges = false;
    this.addNewLanguageComponent = false;
    this.customerAppPropertiesComponent = false;
    this.customerAppBannersComponent = false;
    this.notificationManagementComponent = false;
    this.customerAppItemsComponent = false;
    this.isFQAsComponent = false;
    this.customerAppFirstOrderItemsComponent = false;
    this.customerAppSettingsComponent = false;
    this.ItemEntryDialog.Close()
  }

  onCustomerPropertiesSaved() {
    this.customerAppPropertiesComponent = false;
    this.showSlider = false;
    this.ItemEntryDialog.Close()
  }

  onSaveDescriptions() {
    this.saveSubject.next();
  }

  onPacksCustomerAppSaved() {
    this.customerAppItemsComponent = false;
    this.showSlider = false;
    this.ItemEntryDialog.Close()
  }

  onFQAsSaved() {
    this.isFQAsComponent = false;
    this.showSlider = false;
    this.ItemEntryDialog.Close()
  }

  onFirstOrderPacksCustomerAppSaved() {
    this.customerAppFirstOrderItemsComponent = false;
    this.showSlider = false;
    this.ItemEntryDialog.Close()
  }
  onCustomerAppSettingsSaved() {
    this.customerAppSettingsComponent = false;
    this.showSlider = false;
    this.ItemEntryDialog.Close()
  }

  openFeedbackMenu() {
    this.router.navigate([ConstantURLs.custAppPropertiesURL], {
      relativeTo: this.route.parent
    });
    // this.prepareNavigation();
    var index = this.navLinks.findIndex(x => x.link == this.navService.searchMenuURL);
    if (index == -1) index = 0;
    this.navLinks[index].isActive = true;
    // this.setNavigation(this.navLinks[index]);
  }
  openCompanyDetailsMenu() {
    this.router.navigate([ConstantURLs.companyDetailsURL], {
      relativeTo: this.route.parent
    });
    // this.prepareNavigation();
    // this.setNavigation(this.navLinks[1]);
  }

  openOrganizationDetailsMenu() {
    this.router.navigate([ConstantURLs.organizationDetailsURL], {
      relativeTo: this.route.parent
    });

    // this.prepareNavigation();
    // this.setNavigation(this.navLinks[1]);
  }

  openCustomerAppItemsMenu() {
    this.customerAppItemsComponent = true;
    this.showSlider = true;
    this.sliderDescription = this.translateService.instant('Desc_Items');
    this.openItemEntryDialog()
  }
  openFQAsItemsMenu() {
    this.isFQAsComponent = true;
    this.showSlider = true;
    this.sliderDescription = this.translateService.instant('Desc_FQAs');
    this.openItemEntryDialog()
  }

  openCustomerAppFirstOrderItemsMenu() {
    this.customerAppFirstOrderItemsComponent = true;
    this.showSlider = true;
    this.sliderDescription = this.translateService.instant('Desc_First_Order_Free_Items');
    this.openItemEntryDialog()
  }
  openCustomerSettingsMenu() {
    this.customerAppSettingsComponent = true;
    this.showSlider = true;
    this.sliderDescription = this.translateService.instant('Desc_Customer_App_Settings');
    this.ItemEntryDialog.Close()
  }

  closeStockReservations() {
    this.showStockReservationsSlider = false;
  }

  onSaveStockReservations() {
    this.saveSubject.next();
  }
  afterSavedStockReservationsCompleted() {
    this.showStockReservationsSlider = false;
  }
  checkExistedMenus() {
    this.checkIfChangeLanguageMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfSecurityGroupPrivilegesMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfEmailMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfDynamicTemplateMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfEmployeeGroupEmailsMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfConfigurationMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfSonicServicesMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfLicenseMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfCustomizationsMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfNotificationTemplatesMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfApprovalCycleLevelsMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfCustAppPropertiesMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfOrganizationDetailsMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfItemsMenuVisible(this.sessionDataProvider.allMenusAvailable);

  }
  onSaveCompleted(menu: MenuModel[]) {
    this.close();
    this.settingService.getMenusList(-1, FormMode.None).subscribe(result => {
      this.sessionDataProvider.allMenusAvailable = result.menusList;
      this.sessionDataProvider.addedMenus = result.addedList;
      this.navService.setReloadSidebar();
      this.checkExistedMenus();
      if (this.sessionDataProvider.allMenusAvailable.length < 1) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant(ConstantMessages.NoMenusAvailable));
        this.router.navigate(['/' + ConstantURLs.noMenusURL]);
      }
    });
  }

  OpenRestoreToDefaultDialog() {
    this.restoreDefaultsDialog.showDialog();
  }
  OpenchangeLanguageDialog() {
    this.changeLanguageDialog.showDialog();
  }
  OpenAddLanguageDialog() {
    this.addLanguageDialog.showDialog();
  }
  OpenAddNewLanguage() {
    this.addNewLanguageComponent = true;
    this.OpenAddLanguageDialog();
  }
  onChangeAddNewLanguageCompleted(event) {
    window.location.reload();
    this.close();
  }
  onLanguageChanged(event) {
    this.coreSession.SetTitle('Admin Settings');
    this.showSlider = false;
    this.changeLanguageComponent = false;
    this.ItemEntryDialog.Close()
    if (event && event.languageId != this.coreSession.selectedLanguageId) {
      this.switchLanguage(event);
    }
  }
  switchLanguage(language: any) {
    this.coreSession.selectedLanguageStr = language.value;
    this.translateService.use(language.value);
    // this.settingService.getMenusList(-1).subscribe(result => {
    //   (result);
    //   this.sessionDataProvider.allMenusAvailable = result.menusList;
    //   this.sessionDataProvider.addedMenus = result.addedList;

    //   this.navService.setReloadSidebar();
    // });
    window.location.reload();
  }
  getSessionLanguages() {
    return this.sessionDataProvider.getSessionLanguages();
  }

  onSendCompleted() {
    this.close();
  }
  openIncubeSupportNote() {
    this.IncubeSupportNoteDialog.showDialog().then(
      (result) => {
        if (result != -1) {
          this.supportNote.NoteDescription = result;
          this.coreSession.ModalLoading.Show();
          this.settingService.InsertSupportNote(this.supportNote).subscribe(
            response => {
              if (response.data != null && response.status >= 0) {
                this.coreSession.ModalLoading.Hide();
                this.coreSession.showSuccess(
                  this.translateService.instant(ConstantMessages.SuccessCaption),
                  this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly)
                );
              } else {
                this.coreSession.ModalLoading.Hide();
                this.coreSession.showError(
                  this.translateService.instant(ConstantMessages.ErrorCaption),
                  this.translateService.instant(ConstantMessages.ErrorHappened)
                );
              }
            },
            (error: HttpErrorResponse) => {
              this.coreSession.ModalLoading.Hide();
              this.coreSession.showError(
                this.translateService.instant(ConstantMessages.ErrorCaption),
                this.translateService.instant(ConstantMessages.ErrorHappened)
              );
            }
          );
          // this.cancelSelectedOrder(order);
        }
      });
    // this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgCancelConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then((result: DialogResult) => {
    //   if (result === DialogResult.Yes) {

    //   }
    // });
  }
}
