import { Router } from "@angular/router";
import { ShepherdService } from "angular-shepherd";

export const STEPS_BUTTONS = {
  back: {
    classes: 'back-button',
    secondary: true,
    text: 'wwww',
    type: 'back',
  },
  cancel: {
    classes: 'cancel-button',
    secondary: true,
    text: 'Exit',
    type: 'cancel',
  },
  next: {
    classes: 'next-button',
    text: 'wwww',
    type: 'next',
  },
  defenition: {

    classes: 'next-button',
    text: 'Go to defintion',
  },
};

export const defaultStepOptions = {
  classes: 'shepherd-theme-arrows custom-default-class',
  scrollTo: true,
  cancelIcon: {
    enabled: true,
  },
  highlightClass: 'highlight',
};

export const generateSteps = (elementSelectors: string[],shepherdService:ShepherdService,router:Router) => {
  const steps = [];

  elementSelectors.forEach((selector, index) => {
    let title = '';
    let text = '';

    // Customize title and text based on the index using a switch statement
    switch(index) {
      case 0:
        title = "Let's go to define your item";
        text = 'Here you can define your items.';
        break;
      case 1:
        title = "Let's go to define your customer";
        text = "Here you can define your customer";
        break;
      case 2:
        title = "Step 3 Title";
        text = "Step 3 Content";
        break;
      case 3:
        title = "Step 4 Title";
        text = "Step 4 Content";
        break;
      case 4:
        title = "Step 5 Title";
        text = "Step 5 Content";
        break;
      case 5:
        title = "Step 6 Title";
        text = "Step 6 Content";
        break;
      default:
        title = `Step ${index + 1}`;
        text = `Content in ${selector} at bottom.`;
    }

    steps.push({

      attachTo: {
        element: `${selector}`, // Target the img element inside each .col-md-3 div
        on: 'bottom',
      },
      buttons: [STEPS_BUTTONS.back,
   STEPS_BUTTONS.next ],
      classes: 'custom-class-name-1 custom-class-name-2',
      id: `step-${index + 1}`,
      title: title,
      text: text,
    });
  });

  return steps;
};

