import { Routes, RouterModule } from "@angular/router";
import { EmailTemplateListComponent } from "./email/email-temp/list/email-list.component";
import { AuthGuard } from "../../core/auth/auth.gurad";
import { AdminSettingsMainComponent } from "./admin-settings-main/admin-settings-main.component";
import { ConstantURLs } from "../../shared/models/constants/constant-URL";
import { NgModule } from "@angular/core";
import { ConfigurationComponent } from "./configuration-management/configuration/configuration.component";
import { SecurityGroupsPrivilegeListComponent } from './security-groups-privilege/security-groups-privilege-list/security-groups-privilege-list.component';
import { ApprovalCycleLevelsComponent } from './approval-cycle-levels/approval-cycle-levels.component';
import { NotificationTemplateListComponent } from './notification-templates/notification-template-list/notification-template-list.component';
import { DynamicTemplatesListComponent } from "./dynamic-templates/dynamic-templates-list/dynamic-templates-list.component";
import { EmployeeGroupEmailsComponent } from "./employee-group-emails/employee-group-emails.component";
import { ExcelSheetDynamicTemplatesListComponent } from "./excel-sheet-templates/excel-sheet-templates-list/excel-sheet-templates-list.component";
import { OperatorLoginFailuresListComponent } from "./operator-login-failures/operator-login-failures-list/operator-login-failures-list.component";


const AdminSettingsRouting: Routes = [
  {
    path: "",
    canActivate: [AuthGuard],
    component: AdminSettingsMainComponent
  }, {
    path: ConstantURLs.settingsURL + '/:changeLanguage',
    canActivate: [AuthGuard],
    component: AdminSettingsMainComponent
  },
  {
    path: ConstantURLs.emailTemplatesURL,
    canActivate: [AuthGuard],
    component: EmailTemplateListComponent
  },
  {
    path: ConstantURLs.dynamicTemplatesURL,
    canActivate: [AuthGuard],
    component: DynamicTemplatesListComponent
  },
  {
    path: ConstantURLs.securityGroupsURL,
    canActivate: [AuthGuard],
    component: SecurityGroupsPrivilegeListComponent
  },
  {
    path: ConstantURLs.configurationURL,
    canActivate: [AuthGuard],
    component: ConfigurationComponent
  }
  , {
    path: ConstantURLs.approvalCycleLevelsURL,
    canActivate: [AuthGuard],
    component: ApprovalCycleLevelsComponent
  },
  {
    path: ConstantURLs.notificationTemplatesURL,
    canActivate: [AuthGuard],
    component: NotificationTemplateListComponent
  },
  {
    path: ConstantURLs.excelSheetDynamicTemplatesURL,
    canActivate: [AuthGuard],
    component: ExcelSheetDynamicTemplatesListComponent
  },
  {
    path: ConstantURLs.EmployeeGroupEmailsURL,
    canActivate: [AuthGuard],
    component: EmployeeGroupEmailsComponent
  },
  {
    path: ConstantURLs.operatorLoginFailuresURL,
    canActivate: [AuthGuard],
    component: OperatorLoginFailuresListComponent
  },
];
@NgModule({
  imports: [RouterModule.forChild(AdminSettingsRouting)],
  exports: [RouterModule]
})
export class AdminSettingsRoutingModule { }
