import { OperatorLoginFailuresEntryComponent } from './operator-login-failures/operator-login-failures-entry/operator-login-failures-entry.component';
import { NgModule } from "@angular/core";
import { CommonModule, DatePipe } from "@angular/common";
import { ReactiveFormsModule, FormsModule } from "@angular/forms";
import { SharedModule } from "../../shared/shared.module";
import { TranslateModule } from "@ngx-translate/core";
import { NgbModule } from "@ng-bootstrap/ng-bootstrap";
import { NgSelectModule } from "@ng-select/ng-select";
import { EmailModule } from "./email/email.module";
import { AdminSettingsRoutingModule } from "./admin-settings-routing.module";
import { AdminSettingsMainComponent } from "./admin-settings-main/admin-settings-main.component";
import { ChangeDescriptionsComponent } from "./change-descriptions/change-descriptions.component";
import { ConfigurationComponent } from "./configuration-management/configuration/configuration.component";
import { ConfigurationsOnLevelsComponent } from "./configuration-management/configurations-on-levels/configurations-on-levels.component";
import { MatExpansionModule } from '@angular/material/expansion';
import { NgMultiSelectDropDownModule } from 'ng-multiselect-dropdown';
import { SecurityGroupsPrivilegeComponent } from './security-groups-privilege/security-groups-entry/security-groups-privilege.component';
import { SecurityGroupsPrivilegeListComponent } from './security-groups-privilege/security-groups-privilege-list/security-groups-privilege-list.component';
import { RestoreDefaultCaptionsComponent } from './restore-default-captions/restore-default-captions.component';
import { AddLanguageComponent } from './add-language/add-language.component';
import { QuillModule } from 'ngx-quill';
import { ApprovalCycleLevelsComponent } from './approval-cycle-levels/approval-cycle-levels.component';
import { NotificationTemplateListComponent } from './notification-templates/notification-template-list/notification-template-list.component';
import { NotificationTemplateEntryComponent } from './notification-templates/notification-template-entry/notification-template-entry.component';
import { NgOptionHighlightModule } from '@ng-select/ng-option-highlight';
import { DynamicTemplatesModule } from "./dynamic-templates/dynamic-templates.module";
import { EmployeeGroupEmailsModule } from "./employee-group-emails/employee-group-emails.module";
import { ExcelSheetDynamicTemplatesListComponent } from "./excel-sheet-templates/excel-sheet-templates-list/excel-sheet-templates-list.component";
import { ExcelSheetDynamicTemplatesEntryComponent } from "./excel-sheet-templates/excel-sheet-templates-entry/excel-sheet-templates-entry.component";
import { OperatorLoginFailuresListComponent } from './operator-login-failures/operator-login-failures-list/operator-login-failures-list.component';
import { MatChipsModule } from '@angular/material/chips';
import { DragDropModule } from "@angular/cdk/drag-drop";
import { MatIconModule } from '@angular/material/icon';
import { IncubeSupportDialogComponent } from './incube-support-dialog/incube-support-dialog.component';
import { CustomerAppPropertiesModule } from '../customer-app-properties/customer-app-properties.module';


@NgModule({
    declarations: [
        AdminSettingsMainComponent,
        ChangeDescriptionsComponent,
        SecurityGroupsPrivilegeComponent,
        ConfigurationComponent,
        ConfigurationsOnLevelsComponent,
        SecurityGroupsPrivilegeListComponent,
        RestoreDefaultCaptionsComponent,
        AddLanguageComponent,
        ApprovalCycleLevelsComponent,
        NotificationTemplateListComponent,
        NotificationTemplateEntryComponent,
        ExcelSheetDynamicTemplatesListComponent,
        ExcelSheetDynamicTemplatesEntryComponent,
        OperatorLoginFailuresListComponent,
        OperatorLoginFailuresEntryComponent,
        IncubeSupportDialogComponent,
    ],
    imports: [
        CommonModule,
        ReactiveFormsModule,
        FormsModule,
        SharedModule,
        TranslateModule.forChild(),
        NgbModule,
        NgSelectModule,
        NgOptionHighlightModule,
        EmailModule,
        DynamicTemplatesModule,
        AdminSettingsRoutingModule,
        NgMultiSelectDropDownModule,
        EmployeeGroupEmailsModule,
        MatExpansionModule,
        MatChipsModule,
        DragDropModule,
        MatIconModule,
        CustomerAppPropertiesModule,
        QuillModule.forRoot(),
    ],
    exports: [

    ],
    providers: [
        DatePipe,
    ]
})
export class AdminSettingsModule {
}
