import { Component, OnDestroy, OnInit } from '@angular/core';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { SharedTableResult } from '../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../shared/models/shared-table/table-properties.interface';
import { RowOperation } from '../../../shared/models/enums/shared-table-operation.enum';
import { CoreSession } from '../../../core/core.session';
import { SettingsService } from '../settings.service';
import { ResponseModel } from '../../../shared/models/api-models/api-models';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { DialogMode } from '../../../shared/models/enums/dialog-mode.enum';
import { TranslateService } from '@ngx-translate/core';
import { MenuActions } from '../../../shared/models/enums/menu-actions-enum';
import { ConstantURLs } from '../../../shared/models/constants/constant-URL';
import { ApprovalCycleOperations } from '../../../shared/models/enums/approval-cycle-operations-enum';
import { MasterDataService } from '../../master-data-definition/master-data.service';
import { NavigationData } from '../../../shared/models/navigation-data/navigation-data.model';
import { NavBarService } from '../../../core/sidebar/sidebar.service';
import { ApprovalCycleLevelService } from '../../../shared/services/settings/approval-cycle-level.service';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../shared/models/constants/constant-configuration';
import { ApprovalCycleValidations } from '../../../shared/models/enums/approval-cycle-validations-enum';
import { debug } from 'console';
import { ShepherdService } from 'angular-shepherd';
import { TourService } from '../../../shared/shepherd-config/shepherd-config';
import { Router } from '@angular/router';
import { ComponentVisitService } from '../../../shared/shepherd-config/trackTour.service';

@Component({
  selector: 'app-approval-cycle-levels',
  templateUrl: './approval-cycle-levels.component.html',
  styleUrls: ['./approval-cycle-levels.component.css']
})
export class ApprovalCycleLevelsComponent implements OnInit, OnDestroy {
  selectedOperationIndex: number = 1;
  showAddButton: boolean = false;

  //#region [Promotion approval cycle on organization level]
  form: FormGroup;
  organizationSecurityGroupList: any[] = [];
  selectedOrganizationId: number = -1;
  restrictApprovalCycleToOrganizationLevelString: string = '';
  //#endregion

  constructor(public approvalCycleLevelService: ApprovalCycleLevelService,
    public coreSession: CoreSession,
    public translateService: TranslateService, private masterDataService: MasterDataService,
    private navService: NavBarService,
    private sessionData: SessionDataProvider,
    private shepherdService: ShepherdService,
    private router: Router,
    private tourService: TourService,
    private componentVisitService: ComponentVisitService

  ) { }

  approvalOperationsList: any[] = [
    {
      isCollapsed: false,
      operationName: 'Desc_Promotion',
      operationId: ApprovalCycleOperations.Promotions.valueOf(),
    },
    {
      isCollapsed: true,
      operationName: 'Desc_Discount',
      operationId: ApprovalCycleOperations.Discounts.valueOf()
    },
    {
      isCollapsed: true,
      operationName: 'Desc_Order',
      operationId: ApprovalCycleOperations.Orders.valueOf()
    }
  ];
  // ApprovalFormGroup: FormGroup;
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  promotionDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  discountDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  creditReleaseDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  priceDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  contractedFocDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  }
  orderDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  operationData: any;
  navLinks: any[];
  selectedPromotionSecGroupId: any = -1;
  selectedPromotionSecGroupCaption: any;
  selectedDiscountSecGroupId: any = -1;
  selectedDiscountSecGroupCaption: any;
  selectedCreditReleaseSecGroupId: any = -1;
  selectedCreditReleaseSecGroupCaption: any;
  selectedPriceSecGroupId: any = -1;
  selectedPriceSecGroupCaption: any;
  selectedContractedFocSecGroupId: any = -1;
  selectedContractedFocSecGroupCaption: any;
  selectedOrderSecGroupId: any = -1;
  selectedOrderSecGroupCaption: any;
  securityGroupList: any[];
  isSecurityGroupLoading = false;
  isTouched = false;
  isFromApprovalCyclePromotion: boolean = false;
  ForceOrganizationSelectionOnLogin: any;
  newLevelObject = new Object();
  promotionsDataList: any = {
    operationId: -1,
    securityGroupId: -1,
    levelId: -1,
    securityGroupIdName: "",
    organizationId: -1
  };
  discountsDataList: any = {
    operationId: -1,
    securityGroupId: -1,
    levelId: -1,
    securityGroupIdName: ""
  };
  creditReleasesDataList: any = {
    operationId: -1,
    securityGroupId: -1,
    levelId: -1,
    securityGroupIdName: ""
  };
  operationDataList: any = {
    operationId: -1,
    securityGroupId: -1,
    levelId: -1,
    securityGroupIdName: ""
  };

  priceDataList: any = {
    operationId: -1,
    securityGroupId: -1,
    levelId: -1,
    securityGroupIdName: ""
  };

  contractedFocDataList: any = {
    operationId: -1,
    securityGroupId: -1,
    levelId: -1,
    securityGroupIdName: ""
  }

  orderDataList: any = {
    operationId: -1,
    securityGroupId: -1,
    levelId: -1,
    securityGroupIdName: "",
    organizationId: -1,
    validations: []
  };

  tabelProperties: ITableProperties = {
    pageSize: 100,
    showPaginator: false,
    showSearch: false,
    showNewBtn: false,
    isOnline: false,
    showEditButton: false,
    isMultiSelection: false,
    isAllowDragDrop: true,
    rowOperations: [
    ],
    multiSelectionOperations: [

    ],
    columns: [
      {
        title: 'Desc_Level',
        key: 'levelId',
        isSortable: true,
        width: '30%'
      },
      {
        title: 'Desc_Security_Group',
        key: 'securityGroupIdName',
        isSortable: true,
        width: '50%'
      },
    ]
  };

  approvalCycleLevelValidations: any[] = [];
  validationDropDownSettings = {
    singleSelection: false,
    idField: 'validationId',
    textField: 'description',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 1,
  };
  ngOnInit() {
    this.ForceOrganizationSelectionOnLogin = this.sessionData.getConfigurationValue(ConstantConfigurations.ForceOrganizationSelectionOnLogin)
    this.restrictApprovalCycleToOrganizationLevelString = this.sessionData.getConfigurationValue(ConstantConfigurations.RestrictApprovalCycleToOrganizationLevel);
    this.initForm();
    // this.initApprovalForm();
    this.prepareNavigation();
    this.navLinks[0].isActive = true;
    this.setNavigation();
    this.populateSecurityGroupsList();
    this.getOperationsData();
    this.addDeleteAction();
    this.fillApprovalCycleLevelValidations();
    this.validationDropDownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.validationDropDownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.validationDropDownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
  }
  tourStartTimeout: any
  endTour = false
  startTour() {
    this.tourStartTimeout = setTimeout(() => {

      if (!this.tourService.isFirstTour()) {
        this.sharedTablePromotionData = true
      } else {
        if (this.tourService.isTourCompletedForComponent('approval-cycle-entry')) {
          this.sharedTablePromotionData = true
          return;
        }
        const elementSelectors = this.navLinks.map((_, i) => `#column-${i}`);
        const titles = [];
        const texts = [];

        this.navLinks.forEach(item => {
          let title = '';
          let text = '';
          switch (item.label) {
            case 'Desc_Order':
              title = 'Desc_title_Pending';
              text = 'Desc_content_Pending';
              break;
            case 'Desc_Price':
            case 'Desc_Credit_Release':
              title = 'Desc_title_Approved';
              text = 'Desc_content_Approved';
              break;
            case 'Desc_Discount':
              title = 'Desc_title_Rejected';
              text = 'Desc_content_Rejected';
              break;
            case 'Desc_Promotion':
              title = 'Desc_title_Cancelled';
              text = 'Desc_content_Cancelled';
              break;
            default:
              break;
          }
          titles.push(title);
          texts.push(text);
        });

        elementSelectors.push('#levels');
        titles.push('desc_leve');
        texts.push('desc_leve');

        const steps = this.tourService.generateSteps(
          elementSelectors,
          titles,
          texts
        );
        this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
        this.shepherdService.modal = true;
        this.shepherdService.addSteps(steps);
        this.shepherdService.start();
        this.shepherdService.tourObject.on('cancel', () => {
          this.sharedTablePromotionData = true
        })
        this.shepherdService.tourObject.on('complete', () => {
          this.sharedTablePromotionData = true
        })
      }

    }, 1000);
  }
  ngAfterViewInit() {
    this.startTour()
  }
  initForm() {
    this.form = new FormGroup({
      securityGroupId: new FormControl(null),
      organizationId: new FormControl(null, this.restrictApprovalCycleToOrganizationLevel(ApprovalCycleOperations.Promotions.valueOf()) ? Validators.required : Validators.nullValidator),
      validations: new FormControl([]),
    });
  }

  sharedTablePromotionData = false;
  sharedTableDiscountData = false;
  sharedTableCreditReleaseData = false;
  sharedTablePriceData = false;
  sharedTableOrderData = false


  showEntrySection(selectedIndex: number) {


    this.selectedOperationIndex = selectedIndex + 1;
    this.prepareTableColumns();
    this.navLinks.forEach(a => a.isActive = false);
    this.navLinks[selectedIndex].isActive = true;
    this.populateSecurityGroupsList();
    this.resetTabData();
    const dataProperties = [
      'sharedTablePromotionData',
      'sharedTableDiscountData',
      'sharedTableCreditReleaseData',
      'sharedTablePriceData',
      'sharedTableOrderData'
    ];

    // Reset all data properties to false
    dataProperties.forEach(property => {
      this[property] = false;
    });

    // Set the selected data property to true based on selectedOperationIndex
    if (this.selectedOperationIndex >= 1 && this.selectedOperationIndex <= dataProperties.length) {
      this[dataProperties[this.selectedOperationIndex - 1]] = true;
    }
  }
  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_Promotion',
        index: 0,
        isActive: false,
      },
      {
        label: 'Desc_Discount',
        index: 1,
        isActive: false,
      },
      {
        label: 'Desc_Price',
        index: 2,
        isActive: false,
      },
      {
        label: 'Desc_Order',
        index: 3,
        isActive: false,
      }
    ];
  }
  onAddLevel(levelId: number, operationId: number) {
    switch (operationId) {
      case ApprovalCycleOperations.Promotions.valueOf():
        if (this.selectedPromotionSecGroupId == -1 || (this.restrictApprovalCycleToOrganizationLevel(ApprovalCycleOperations.Promotions.valueOf()) && this.selectedOrganizationId === -1)) {
          this.coreSession.markFormGroupTouched(this.form);
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
          this.isTouched = true;
          return;
        } else this.isTouched = false;
        if (this.promotionsDataList.filter(x => x.securityGroupId === this.selectedPromotionSecGroupId).length > 0) {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgAlreadyAdded));
          return;
        } else {
          this.newLevelObject = {
            operationId: operationId,
            securityGroupId: this.selectedPromotionSecGroupId,
            levelId: levelId,
            securityGroupIdName: this.selectedPromotionSecGroupCaption,
            organizationId: this.selectedOrganizationId
          }
          this.promotionsDataList.push(this.newLevelObject);
          this.form.get("securityGroupId").setValue(null);
          this.selectedPromotionSecGroupId = -1;
          this.selectedPromotionSecGroupCaption = '';
        }
        break;
      case ApprovalCycleOperations.Discounts.valueOf():
        if (this.selectedDiscountSecGroupId == -1) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
          this.isTouched = true;
          return;
        }
        else this.isTouched = false;
        if (this.discountsDataList.filter(x => x.securityGroupId === this.selectedDiscountSecGroupId).length > 0) {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgAlreadyAdded));
        } else {
          this.newLevelObject = {
            operationId: operationId,
            securityGroupId: this.selectedDiscountSecGroupId,
            levelId: levelId,
            securityGroupIdName: this.selectedDiscountSecGroupCaption
          }
          this.discountsDataList.push(this.newLevelObject);
          this.form.get("securityGroupId").setValue(null);
          this.selectedDiscountSecGroupId = -1;
          this.selectedDiscountSecGroupCaption = '';
        }
        break;
      case ApprovalCycleOperations.CreditRelease.valueOf():
        if (this.selectedCreditReleaseSecGroupId == -1) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
          this.isTouched = true;
          return;
        }
        else this.isTouched = false;
        if (this.creditReleasesDataList.filter(x => x.securityGroupId === this.selectedCreditReleaseSecGroupId).length > 0) {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgAlreadyAdded));
        } else {
          this.newLevelObject = {
            operationId: operationId,
            securityGroupId: this.selectedCreditReleaseSecGroupId,
            levelId: levelId,
            securityGroupIdName: this.selectedCreditReleaseSecGroupCaption
          }
          this.creditReleasesDataList.push(this.newLevelObject);
          this.discountsDataList.push(this.newLevelObject);
          this.form.get("securityGroupId").setValue(null);
          this.selectedCreditReleaseSecGroupId = -1;
          this.selectedCreditReleaseSecGroupCaption = '';
        }
        break;
      case ApprovalCycleOperations.Price.valueOf():
        if (this.selectedPriceSecGroupId == -1) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
          this.isTouched = true;
          return;
        }
        else this.isTouched = false;
        if (this.priceDataList.filter(x => x.securityGroupId === this.selectedPriceSecGroupId).length > 0) {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgAlreadyAdded));
        } else {
          this.newLevelObject = {
            operationId: operationId,
            securityGroupId: this.selectedPriceSecGroupId,
            levelId: levelId,
            securityGroupIdName: this.selectedPriceSecGroupCaption
          }
          this.priceDataList.push(this.newLevelObject);
          this.form.get("securityGroupId").setValue(null);
          this.selectedPriceSecGroupId = -1;
          this.selectedPriceSecGroupCaption = '';
        }
        break;
      case ApprovalCycleOperations.ContractedFOC.valueOf():
        if (this.selectedContractedFocSecGroupId == -1) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
          this.isTouched = true;
          return;
        }
        else this.isTouched = false;
        if (this.contractedFocDataList.filter(x => x.securityGroupId === this.selectedContractedFocSecGroupId).length > 0) {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgAlreadyAdded));
        } else {
          this.newLevelObject = {
            operationId: operationId,
            securityGroupId: this.selectedContractedFocSecGroupId,
            levelId: levelId,
            securityGroupIdName: this.selectedContractedFocSecGroupCaption
          }
          this.contractedFocDataList.push(this.newLevelObject);
          this.form.get("securityGroupId").setValue(null);
          this.selectedContractedFocSecGroupId = -1;
          this.selectedContractedFocSecGroupCaption = '';
        }
        break;
      case ApprovalCycleOperations.Orders.valueOf():
        if (this.selectedOrderSecGroupId == -1 || (this.restrictApprovalCycleToOrganizationLevel(ApprovalCycleOperations.Orders.valueOf()) && this.selectedOrganizationId === -1)) {
          this.coreSession.markFormGroupTouched(this.form);
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
          this.isTouched = true;
          return;
        } else this.isTouched = false;
        if (this.orderDataList.filter(x => x.securityGroupId === this.selectedOrderSecGroupId).length > 0) {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgAlreadyAdded));
          return;
        } else {
          this.newLevelObject = {
            operationId: operationId,
            securityGroupId: this.selectedOrderSecGroupId,
            levelId: levelId,
            securityGroupIdName: this.selectedOrderSecGroupCaption,
            organizationId: this.selectedOrganizationId,
            validations: this.form.get('validations').value ? this.form.get('validations').value.map(val => val.validationId) : [],
            validationsString: this.form.get('validations').value && this.form.get('validations').value.length > 0 ? this.prepareValidationsString(this.form.get('validations').value) : ''
          }
          this.orderDataList.push(this.newLevelObject);
          this.form.get("securityGroupId").setValue(null);
          this.selectedOrderSecGroupId = -1;
          this.selectedOrderSecGroupCaption = '';
        }
        break;
    }
    this.form.get('validations').setValue([]);
    this.fillSharedTables();
    this.startTours = true;

  }
  populateSecurityGroupsList(organizationId: number = -1) {
    this.isFromApprovalCyclePromotion = this.selectedOperationIndex === ApprovalCycleOperations.Promotions.valueOf() && this.restrictApprovalCycleToOrganizationLevel(ApprovalCycleOperations.Promotions.valueOf()) ? true : false;
    this.organizationSecurityGroupList = [];
    this.isSecurityGroupLoading = true;
    let filter = {
      organizationId: organizationId,
      employeeId: -1,
      isFromApprovalCyclePromotion: this.isFromApprovalCyclePromotion,
    }
    this.masterDataService.getSecurityGroupsList(filter).subscribe(result => {
      if (organizationId == -1) {
        this.securityGroupList = result;
      } else {
        this.organizationSecurityGroupList = result;
      }
      this.isSecurityGroupLoading = false;
    });
  }
  public markFormGroupTouched(formGroup: FormGroup) {
    (<any>Object).values(formGroup.controls).forEach(control => {
      control.markAsTouched();

      if (control.controls) {
        this.markFormGroupTouched(control);
      }
    });
  }
  onSaveClicked() {
    this.coreSession.ModalLoading.Show();
    this.operationDataList = this.promotionsDataList.concat(this.discountsDataList).concat(this.creditReleasesDataList).concat(this.priceDataList).concat(this.contractedFocDataList).concat(this.orderDataList);
    this.approvalCycleLevelService.saveOperationLevels(this.operationDataList).subscribe(
      result => {
        this.coreSession.ModalLoading.Hide();
        if (result.status != null && result.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
          this.getOperationsData();
          this.selectedOrganizationId = -1;
          this.form.get("securityGroupId").setValue(null);
          if (this.restrictApprovalCycleToOrganizationLevel(this.selectedOperationIndex)) { // here
            this.form.get("organizationId").setValue(null);
            if (this.restrictApprovalCycleToOrganizationLevel(ApprovalCycleOperations.Promotions.valueOf())) this.fillPromotionsDataSource();
            if (this.restrictApprovalCycleToOrganizationLevel(ApprovalCycleOperations.Orders.valueOf())) this.fillOrdersDataSource();
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), result.message);
        }
      },
      error => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  onRowOperation(event: any, operationId: number) {
    switch (event.operation) {
      case RowOperation.rowClick:
        // if(this.coreSession.checkActivitiesAvailability(this.menuURL ,MenuActions.Edit))
        //   {
        //     this.getItemListData(event.object, this.itemListType);
        //   }
        break;
      case RowOperation.delete:
        this.onDeleteClicked(event, operationId);
        break;
    }
  }

  onDragDrop(event: any, operationId: number) {
    let draggedItem;
    switch (operationId) {
      case ApprovalCycleOperations.Promotions.valueOf():
        this.promotionsDataList.sort((a, b) => a.levelId - b.levelId);
        var currentOrganizationLevels = this.promotionsDataList.filter(d => d.organizationId === this.selectedOrganizationId);
        draggedItem = currentOrganizationLevels[event.previousIndex];
        currentOrganizationLevels.splice(event.previousIndex, 1);
        currentOrganizationLevels.splice(event.currentIndex, 0, draggedItem);
        currentOrganizationLevels.forEach(element => {
          element.levelId = currentOrganizationLevels.indexOf(element) + 1;
        });
        this.fillSharedTables();
        break;
      case ApprovalCycleOperations.Discounts.valueOf():
        this.rearrangeLevels(operationId);
        break;
      case ApprovalCycleOperations.CreditRelease.valueOf():
        this.rearrangeLevels(operationId);
        break;

      case ApprovalCycleOperations.Price.valueOf():
        this.rearrangeLevels(operationId);
        break;

      case ApprovalCycleOperations.ContractedFOC.valueOf():
        this.rearrangeLevels(operationId);
        break;

      case ApprovalCycleOperations.Orders.valueOf():
        this.orderDataList.sort((a, b) => a.levelId - b.levelId);
        var currentOrganizationLevels = this.orderDataList.filter(d => d.organizationId === this.selectedOrganizationId);
        draggedItem = currentOrganizationLevels[event.previousIndex];
        currentOrganizationLevels.splice(event.previousIndex, 1);
        currentOrganizationLevels.splice(event.currentIndex, 0, draggedItem);
        currentOrganizationLevels.forEach(element => {
          element.levelId = currentOrganizationLevels.indexOf(element) + 1;
        });
        this.fillSharedTables();
        break;
    }
  }

  addDeleteAction() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.approvalCycleLevelsURL, MenuActions.Delete)) {
      this.tabelProperties.rowOperations.push(
        {
          operation: RowOperation.delete,
          title: 'Desc_Delete',
          icon: 'fa-solid fa-trash',
          color: '#f1685e'
        });
    }
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.approvalCycleLevelsURL, MenuActions.Add)) {
      this.showAddButton = true;
    }
    else
      this.showAddButton = false;
  }
  onDeleteClicked(event: any, operationId: number) {
    switch (operationId) {
      case ApprovalCycleOperations.Promotions.valueOf():
        {
          this.promotionsDataList.sort((a, b) => a.levelId - b.levelId);
          this.promotionsDataList.splice(this.promotionsDataList.indexOf(event.object), 1);
          this.rearrangeLevels(operationId);
        }
        break;
      case ApprovalCycleOperations.Discounts.valueOf():
        {
          this.discountsDataList.splice(this.discountsDataList.indexOf(event.object), 1);
          this.rearrangeLevels(operationId);
        }
        break;
      case ApprovalCycleOperations.CreditRelease.valueOf():
        {
          this.creditReleasesDataList.splice(this.creditReleasesDataList.indexOf(event.object), 1);
          this.rearrangeLevels(operationId);
        }
        break;
      case ApprovalCycleOperations.Price.valueOf():
        {
          this.priceDataList.splice(this.priceDataList.indexOf(event.object), 1);
          this.rearrangeLevels(operationId);
        }
        break;
      case ApprovalCycleOperations.ContractedFOC.valueOf():
        {
          this.contractedFocDataList.splice(this.contractedFocDataList.indexOf(event.object), 1);
          this.rearrangeLevels(operationId);
        }
        break;
      case ApprovalCycleOperations.Orders.valueOf():
        {
          this.orderDataList.sort((a, b) => a.levelId - b.levelId);
          this.orderDataList.splice(this.orderDataList.indexOf(event.object), 1);
          this.rearrangeLevels(operationId);
        }
        break;
    }
    this.fillSharedTables();
  }
  rearrangeLevels(operationId) {
    switch (operationId) {
      case ApprovalCycleOperations.Promotions.valueOf():
        var currentOrganizationLevels = this.promotionsDataList.filter(d => d.organizationId === this.selectedOrganizationId);
        currentOrganizationLevels.forEach(element => {
          element.levelId = currentOrganizationLevels.indexOf(element) + 1;
        });
        this.fillSharedTables
        break;
      case ApprovalCycleOperations.Discounts.valueOf():
        this.discountsDataList.forEach(element => {
          element.levelId = this.discountsDataList.indexOf(element) + 1;
        });
        this.fillSharedTables();
        break;
      case ApprovalCycleOperations.CreditRelease.valueOf():

        this.creditReleasesDataList.forEach(element => {
          element.levelId = this.creditReleasesDataList.indexOf(element) + 1;
        });
        this.fillSharedTables();
        break;

      case ApprovalCycleOperations.Price.valueOf():

        this.priceDataList.forEach(element => {
          element.levelId = this.priceDataList.indexOf(element) + 1;
        });
        this.fillSharedTables();
        break;

      case ApprovalCycleOperations.ContractedFOC.valueOf():

        this.contractedFocDataList.forEach(element => {
          element.levelId = this.contractedFocDataList.indexOf(element) + 1;
        });
        this.fillSharedTables();
        break;

      case ApprovalCycleOperations.Orders.valueOf():
        var currentOrganizationLevels = this.orderDataList.filter(d => d.organizationId === this.selectedOrganizationId);
        currentOrganizationLevels.forEach(element => {
          element.levelId = currentOrganizationLevels.indexOf(element) + 1;
        });
        break;
    }
  }
  getOperationsData() {
    this.coreSession.ModalLoading.Show();
    this.approvalCycleLevelService.getOperationLevelsData()
      .subscribe(
        (response: ResponseModel) => {
          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            this.dataSource = {
              data: response.data,
              totalItems: response.data.length
            }

            this.promotionsDataList = this.dataSource.data.filter((x => x.operationId === ApprovalCycleOperations.Promotions.valueOf()));
            this.discountsDataList = this.dataSource.data.filter((x => x.operationId === ApprovalCycleOperations.Discounts.valueOf()));
            this.creditReleasesDataList = this.dataSource.data.filter((x => x.operationId === ApprovalCycleOperations.CreditRelease.valueOf()));
            this.priceDataList = this.dataSource.data.filter((x => x.operationId === ApprovalCycleOperations.Price.valueOf()));
            this.contractedFocDataList = this.dataSource.data.filter((x => x.operationId === ApprovalCycleOperations.ContractedFOC.valueOf()));
            this.orderDataList = this.dataSource.data.filter((x => x.operationId === ApprovalCycleOperations.Orders.valueOf()));
            this.fillSharedTables();
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);

          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );
  }

  fillDataSource(operation: ApprovalCycleOperations, originalDataList: any[]): any[] {
    var restrictToOrgLevel: boolean = this.restrictApprovalCycleToOrganizationLevel(operation.valueOf());
    if (restrictToOrgLevel) {
      if (this.selectedOperationIndex === operation.valueOf() && this.selectedOrganizationId > -1) {
        return originalDataList.filter(d => d.organizationId === this.selectedOrganizationId)
      }
    } else {
      return originalDataList.filter(d => d.organizationId === -1)
    }
    return [];
  }

  fillSharedTables() {
    var promotionLevels = this.fillDataSource(ApprovalCycleOperations.Promotions, this.promotionsDataList);
    promotionLevels.sort((a, b) => a.levelId - b.levelId);
    this.promotionDataSource = {
      data: promotionLevels,
      totalItems: promotionLevels.length
    }
    this.discountDataSource = {
      data: this.discountsDataList,
      totalItems: this.discountsDataList.length
    }
    this.creditReleaseDataSource = {
      data: this.creditReleasesDataList,
      totalItems: this.creditReleasesDataList.length
    }
    this.priceDataSource = {
      data: this.priceDataList,
      totalItems: this.priceDataList.length
    }
    this.contractedFocDataSource = {
      data: this.contractedFocDataList,
      totalItems: this.contractedFocDataList.length
    }
    var orderLevels = this.fillDataSource(ApprovalCycleOperations.Orders, this.orderDataList);
    orderLevels.sort((a, b) => a.levelId - b.levelId);
    this.orderDataSource = {
      data: orderLevels,
      totalItems: orderLevels.length
    };

  }
  startTours = false

  onSecurityGroupIDSelected(selectedSecGroup: any, operationId: number) {
    this.selectedPromotionSecGroupId = -1;
    this.selectedPromotionSecGroupCaption = '';
    this.selectedOrderSecGroupId = -1;
    this.selectedOrderSecGroupCaption = '';
    if (selectedSecGroup) {
      switch (operationId) {
        case ApprovalCycleOperations.Promotions.valueOf():
          this.selectedPromotionSecGroupId = selectedSecGroup.securityGroupId;
          this.selectedPromotionSecGroupCaption = selectedSecGroup.securityGroupIdName;
          break;
        case ApprovalCycleOperations.Discounts.valueOf():
          this.selectedDiscountSecGroupId = selectedSecGroup.securityGroupId;
          this.selectedDiscountSecGroupCaption = selectedSecGroup.securityGroupIdName;
          break;
        case ApprovalCycleOperations.CreditRelease.valueOf():
          this.selectedCreditReleaseSecGroupId = selectedSecGroup.securityGroupId;
          this.selectedCreditReleaseSecGroupCaption = selectedSecGroup.securityGroupIdName;
          break;
        case ApprovalCycleOperations.Price.valueOf():
          this.selectedPriceSecGroupId = selectedSecGroup.securityGroupId;
          this.selectedPriceSecGroupCaption = selectedSecGroup.securityGroupIdName;
          break;
        case ApprovalCycleOperations.ContractedFOC.valueOf():
          this.selectedContractedFocSecGroupId = selectedSecGroup.securityGroupId;
          this.selectedContractedFocSecGroupCaption = selectedSecGroup.securityGroupIdName;
          break;
        case ApprovalCycleOperations.Orders.valueOf():
          this.selectedOrderSecGroupId = selectedSecGroup.securityGroupId;
          this.selectedOrderSecGroupCaption = selectedSecGroup.securityGroupIdName;
          break;
      }
    }

  }
  getNewLevelID(operationId: number) {
    switch (operationId) {
      case ApprovalCycleOperations.Promotions.valueOf():
        return this.promotionDataSource.totalItems + 1;
        break;
      case ApprovalCycleOperations.Discounts.valueOf():

        return this.discountDataSource.totalItems + 1;
        break;
      case ApprovalCycleOperations.CreditRelease.valueOf():
        return this.creditReleaseDataSource.totalItems + 1;
        break;
      case ApprovalCycleOperations.Price.valueOf():
        return this.priceDataSource.totalItems + 1;
        break;
      case ApprovalCycleOperations.ContractedFOC.valueOf():
        return this.contractedFocDataSource.totalItems + 1;
        break;
      case ApprovalCycleOperations.Orders.valueOf():
        return this.orderDataSource.totalItems + 1;
        break;
    }
  }
  ngOnDestroy() {
    this.navService.setNavigation([]);
    if (this.tourStartTimeout) {
      clearTimeout(this.tourStartTimeout);
    }
    this.navService.tourStatus = false
    this.componentVisitService.markComponentVisited('approval-cycle-entry');


  }
  setNavigation() {
    let navigationList: NavigationData[] = [];
    navigationList.push(
      {
        Name: 'Desc_Settings',
        URL: ConstantURLs.settingsURL
      },
      {
        Name: 'Desc_Approval_Cycle_Levels',
        URL: undefined
      }
    );
    this.navService.setNavigation(navigationList);
  }

  onChangeOrganizationId(organization) {
    this.selectedOrganizationId = -1;
    this.organizationSecurityGroupList = [];
    this.form.get("securityGroupId").setValue(null);
    this.form.get("validations").setValue([]);
    if (this.selectedOperationIndex === ApprovalCycleOperations.Promotions.valueOf()) this.resetPromotionsDataSource();
    if (this.selectedOperationIndex === ApprovalCycleOperations.Orders.valueOf()) this.resetOrderDataSource();
    if (organization) {
      this.selectedOrganizationId = organization.organizationId;
      this.populateSecurityGroupsList(organization.organizationId);
      if (this.selectedOperationIndex === ApprovalCycleOperations.Promotions.valueOf() && this.restrictApprovalCycleToOrganizationLevel(ApprovalCycleOperations.Promotions.valueOf())) this.fillPromotionsDataSource();
      if (this.selectedOperationIndex === ApprovalCycleOperations.Orders.valueOf() && this.restrictApprovalCycleToOrganizationLevel(ApprovalCycleOperations.Orders.valueOf())) this.fillOrdersDataSource();
    }
  }

  resetPromotionsDataSource() {
    this.promotionDataSource = {
      data: [],
      totalItems: 0
    };
  }

  resetOrderDataSource() {
    this.orderDataSource = {
      data: [],
      totalItems: 0
    };
  }

  fillPromotionsDataSource() {
    var promotionLevels = this.promotionsDataList.filter(d => d.organizationId === this.selectedOrganizationId);
    promotionLevels.sort((a, b) => a.levelId - b.levelId);
    this.promotionDataSource = {
      data: promotionLevels,
      totalItems: promotionLevels.length
    }
  }

  fillOrdersDataSource() {
    var orderLevels = this.orderDataList.filter(d => d.organizationId === this.selectedOrganizationId);
    orderLevels.sort((a, b) => a.levelId - b.levelId);
    this.orderDataSource = {
      data: orderLevels,
      totalItems: orderLevels.length
    }
  }
  resetTabData() {
    this.form.get("organizationId").reset();
    this.isTouched = false;
    if ((this.selectedOperationIndex === ApprovalCycleOperations.Promotions.valueOf() || this.selectedOperationIndex === ApprovalCycleOperations.Orders.valueOf()) && this.restrictApprovalCycleToOrganizationLevel(this.selectedOperationIndex)) {
      if (this.selectedOperationIndex === ApprovalCycleOperations.Promotions.valueOf()) this.resetPromotionsDataSource();
      if (this.selectedOperationIndex === ApprovalCycleOperations.Orders.valueOf()) this.resetOrderDataSource();
      this.form.get("organizationId").setValidators(Validators.required);
    } else {
      this.form.get("organizationId").setValidators(Validators.nullValidator);
    }
    this.form.get("organizationId").updateValueAndValidity();
  }

  prepareTableColumns() {
    if (this.selectedOperationIndex === ApprovalCycleOperations.Orders.valueOf()) {
      this.tabelProperties.columns = [
        {
          title: 'Desc_Level',
          key: 'levelId',
          isSortable: true,
          width: '10%'
        },
        {
          title: 'Desc_Security_Group',
          key: 'securityGroupIdName',
          isSortable: true,
          width: '40%'
        },
        {
          title: 'Desc_Level_Validations',
          key: 'validationsString',
          isSortable: true,
          width: '60%'
        },
      ]
    } else {
      this.tabelProperties.columns = [
        {
          title: 'Desc_Level',
          key: 'levelId',
          isSortable: true,
          width: '30%'
        },
        {
          title: 'Desc_Security_Group',
          key: 'securityGroupIdName',
          isSortable: true,
          width: '50%'
        },
      ]
    }
  }

  fillApprovalCycleLevelValidations() {
    this.approvalCycleLevelValidations.push({
      validationId: ApprovalCycleValidations.PaymentTerm.valueOf(),
      description: this.translateService.instant('Desc_Payment_Term')
    });
    this.approvalCycleLevelValidations.push({
      validationId: ApprovalCycleValidations.CreditLimit.valueOf(),
      description: this.translateService.instant('Desc_Credit_Limit')
    });
    this.approvalCycleLevelValidations.push({
      validationId: ApprovalCycleValidations.OnHoldStatus.valueOf(),
      description: this.translateService.instant('Desc_On_Hold_Status')
    });
    this.approvalCycleLevelValidations.push({
      validationId: ApprovalCycleValidations.WarehouseStock.valueOf(),
      description: this.translateService.instant('Desc_Warehouse_Stock')
    });
  }

  restrictApprovalCycleToOrganizationLevel(operationId: number): boolean {
    return this.restrictApprovalCycleToOrganizationLevelString.includes(operationId.toString());
  }

  prepareValidationsString(validations: any[]) {
    return validations.map(v => v.description).join(' ,');
  }
}
