import { Component, OnInit, Input, OnDestroy} from '@angular/core';
import { CoreSession } from '../../../core/core.session';
import { SettingsService } from '../settings.service';
import { DialogMode } from '../../../shared/models/enums/dialog-mode.enum';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { TranslateService } from '@ngx-translate/core';
import { SharedTableResult } from '../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../shared/models/shared-table/table-properties.interface';
import { Observable } from 'rxjs/Observable';


@Component({
  selector: 'app-change-descriptions',
  templateUrl: './change-descriptions.component.html',
  styleUrls: ['./change-descriptions.component.css']
})
export class ChangeDescriptionsComponent implements OnInit , OnDestroy {
  @Input() moduleId: number;
  @Input() events: Observable<void>;
  editedDescreptions: any[] = [];
  descriptionsTable: any;
  saveBtnSubscription: any;
  query = '';
  descriptionsReady = false;
  cloneDataSourceItems: any = [];
  sharedTableCloumns: [] = [];
  sharedTableData: ITableProperties = {
    pageSize: 50,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: false,
    showEditButton: false,
    showOptionPerLine: false,
    showOptionOnKey: 'enabled',
    rowOperations: [],
    multiSelectionOperations: [
    ],
    columns: []
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  constructor(
    private coreSession: CoreSession,
    private settingsService: SettingsService,
    private translateService: TranslateService
  ) {
    this.descriptionsTable = {
      tableHeader: [],
      tableData: []
    };
   }
  ngOnInit() {
    this.populateDescriptionsList();
    this.subscribeToSaveTrigger();
  }
  ngOnDestroy() {
     this.saveBtnSubscription.unsubscribe();
  }
  populateDescriptionsList() {
    this.settingsService.getModuleDiscription(this.moduleId).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.descriptionsTable = response.data;
          this.cloneDataSourceItems  = Object.assign([], this.descriptionsTable.tableData);
          this.dataSource.data = this.descriptionsTable.tableData;
          this.dataSource.totalItems = this.descriptionsTable.tableData.lenth;
          this.setTableColumns();
          this.descriptionsReady = true;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.WarningCaption), response.message);

        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  subscribeToSaveTrigger() {
    this.saveBtnSubscription = this.events.subscribe(
      res => {
           this.saveEditedDescriptions();
      }
    );
  }
  saveEditedDescriptions() {
    this.GetModifiedDescriptions();
    if ( this.editedDescreptions.length ) {
      this.settingsService.updateDescriptions(this.editedDescreptions,this.moduleId).subscribe(
        response => {
          if (response.status != null && response.status >= 0) {
            this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption),
             this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly));
             window.location.reload();
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));

        }
      );
    } else {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.WarningCaption),
       this.translateService.instant(ConstantMessages.Desc_No_Changes_Were_Made));
    }

  }
  setTableColumns() {
    for (const language of this.descriptionsTable.tableHeader) {
      this.sharedTableData.columns.push({
        title: language.description,
        key: 'DescriptionValue' + language.languageId,
        isSortable: false,
        isEditableWithRollback: true,
        width: (100 / this.descriptionsTable.tableHeader.length) + '%'
      });
    }
    this.dataSource.totalItems = this.dataSource.data.length;
  }
  GetModifiedDescriptions() {
    for (let i = 0; i < this.descriptionsTable.tableHeader.length ; i++) {
      for (const descriptionObject of this.dataSource.data) {
        if (descriptionObject['DescriptionValue' + (i + 1)] !== descriptionObject['DescriptionBeforeEdit' + (i + 1)]) {
          this.editedDescreptions.push(descriptionObject);
        }
      }
    }
  }
}
