import { Component, OnDestroy, OnInit } from '@angular/core';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { RowOperation } from '../../../../shared/models/enums/shared-table-operation.enum';
import { SettingsService } from '../../settings.service';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { ConfigurationLevels } from '../../../../shared/models/enums/configuration-levels.enum';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { DialogMode } from '../../../../shared/models/enums/dialog-mode.enum';
import { HttpErrorResponse } from '@angular/common/http';
import { TranslateService } from '@ngx-translate/core';
import { Router, ActivatedRoute } from '@angular/router';
import { CoreSession } from '../../../../core/core.session';
import { Subject } from 'rxjs/Rx';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { DialogResult } from '../../../../shared/models/enums/dialog-result.enum';
import { MenuActions } from '../../../../shared/models/enums/menu-actions-enum';
import { NavBarService } from '../../../../core/sidebar/sidebar.service';
import { NavigationData } from '../../../../shared/models/navigation-data/navigation-data.model';
import { ConfigurationService } from '../../../../shared/services/settings/configuration.service';
import { debug } from 'console';

@Component({
  selector: 'app-configuration',
  templateUrl: './configuration.component.html',
  styleUrls: ['./configuration.component.css']
})
export class ConfigurationComponent implements OnInit, OnDestroy {
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  tableData: ITableProperties = {
    pageSize: 50,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: false,
    showOptionPerLine: true,
    //showAllButtons : false,
    showEditButton: false,
    showOptionOnKey: 'enabled',
    isConfigurationScreen: true,
    rowOperations: [
      {
        operation: RowOperation.EmployeeLevel,
        title: "Desc_Employee_Level",
        icon: "fa fa-user",
        color: "#2b3643",
        highlightBasedOnKeyName:"hasEmployeeLevel"
      },
      {
        operation: RowOperation.SecurityGroupLevel,
        title: "Desc_Security_Group_Level",
        icon: "fa fa-shield",
        color: "#2b3643",
        highlightBasedOnKeyName:"hasSecurityGroupLevel"
      },
      {
        operation: RowOperation.OrganizationLevel,
        title: "Desc_Organization_Level",
        icon: "fa fa-sitemap",
        color: "#2b3643",
        highlightBasedOnKeyName:"hasOrganizationLevel"
      },
      {
        operation: RowOperation.DivisionLevel,
        title: "Desc_Division_Level",
        icon: "fa fa-building",
        color: "#2b3643",
        highlightBasedOnKeyName:"hasDivisionLevel"
      },
      {
        operation: RowOperation.CustomerLevel,
        title: "Desc_Customer_Level",
        icon: "fa fa-address-card-o",
        color: "#2b3643",
        highlightBasedOnKeyName:"hasCustOutLevel"
      },
      {
        operation: RowOperation.ChannelLevel,
        title: "Desc_Channel_Level",
        icon: "fa fa-user-circle-o",
        color: "#2b3643",
        highlightBasedOnKeyName:"hasChannelLevel"
      },
      {
        operation: RowOperation.CustomerGroupLevel,
        title: "Desc_Customer_Group_Level",
        icon: "fa fa-users",
        color: "#2b3643",
        highlightBasedOnKeyName:"hasCustomerGroupLevel"
      }
    ],
    multiSelectionOperations: [
    ],
    columns: []
  };

  changedList: any[];
  showSlider = false;
  sliderHeaderCaption = '';
  selectedLevel: ConfigurationLevels;
  selectedConfiguration: any;
  navLinks: any[];
  saveSubject: Subject<void> = new Subject<void>();
  constructor(private settingService: SettingsService,
    private translateService: TranslateService,
    private router: Router,
    private route: ActivatedRoute,
    private coreSession: CoreSession,
    private sessionDataProvider: SessionDataProvider,
    private navService: NavBarService,
    private configurationService: ConfigurationService) { }

  ngOnInit() {
    this.coreSession.SetTitle('Configuration');
    this.prepareNavigation();
    var index = this.navLinks.findIndex(x => x.link == this.navService.searchMenuURL);
    if (index == -1) index = 0;
    this.navLinks[index].isActive = true;
    this.setNavigation(this.navLinks[index]);
    this.setTableColumns();
    this.getAllConfigurations();
  }
  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_Configurations',
        index: 0,
        isActive: false,
        hidden: false,
        disable: false
      }
    ];
  }
  setTableColumns() {
    this.tableData.columns = [
      {
        title: 'Desc_Category',
        key: 'configCategoryName',
        isSortable: true,
        width: '10%'
      },
      {
        title: 'Desc_Configuration_Key',
        key: 'keyName',
        isSortable: true,
        width: '10%'
      },
      {
        title: 'Desc_Configuration_Value',
        key: 'keyValue',
        isSortable: false,
        width: '10%',
        isEditablePerRow: this.coreSession.checkActivitiesAvailability(ConstantURLs.configurationURL, MenuActions.Edit),
      }
      ,
      {
        title: 'Desc_Description',
        key: 'description',
        isSortable: false,
        width: '80%'

      }
    ];
  }
  onRowOperation(event: any) {
    this.selectedConfiguration = event.object;
    this.selectedConfiguration.configurationId = +event.object.configurationId;
    switch (event.operation) {
      case RowOperation.EmployeeLevel:
        this.selectedLevel = ConfigurationLevels.EmployeeLevel;
        this.sliderHeaderCaption = 'Desc_Employee_Level';
        this.showSlider = true;
        break;
      case RowOperation.SecurityGroupLevel:
        this.selectedLevel = ConfigurationLevels.SecurityGroupLevel;
        this.sliderHeaderCaption = 'Desc_Security_Group_Level';
        this.showSlider = true;
        break;
      case RowOperation.OrganizationLevel:
        this.selectedLevel = ConfigurationLevels.Organization;
        this.sliderHeaderCaption = 'Desc_Organization_Level';
        this.showSlider = true;
        break;
      case RowOperation.DivisionLevel:
        this.selectedLevel = ConfigurationLevels.DivisionLevel;
        this.sliderHeaderCaption = 'Desc_Division_Level';
        this.showSlider = true;
        break;
      case RowOperation.CustomerLevel:
        this.selectedLevel = ConfigurationLevels.CustomerLevel;
        this.sliderHeaderCaption = 'Desc_Customer_Level';
        this.showSlider = true;
        break;
      case RowOperation.ChannelLevel:
        this.selectedLevel = ConfigurationLevels.ChannelLevel;
        this.sliderHeaderCaption = 'Desc_Channel_Level';
        this.showSlider = true;
        break;
      case RowOperation.CustomerGroupLevel:
        this.selectedLevel = ConfigurationLevels.CustomerGroupLevel;
        this.sliderHeaderCaption = 'Desc_Customer_Group_Level';
        this.showSlider = true;
        break;

    }
    //this.sliderHeaderCaption +=' : '+this.selectedConfiguration.keyName
  }
  onCloseSlider() {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgCancelConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          this.showSlider = false;
        }
      });

  }
  onSaveLevelClick() {
    this.saveSubject.next();

  }
  afterSavedCompleted() {
    this.sessionDataProvider.loadSessionConfigurationsAfterUpdateConfig();
    this.showSlider = false;
    this.getAllConfigurations();
  }
  onConfigurationValueChanged(event: any) {
    let changedConfig = event.object;
    ('onConfigurationValueChanged');
    (changedConfig);
    changedConfig.keyValue = event.object.keyValue + '';
    if (!this.changedList) this.changedList = [];
    let index = this.changedList.findIndex(a => a.keyName === changedConfig.keyName);
    if (index > -1) {
      this.changedList[index] = changedConfig;
    } else {
      this.changedList.push(changedConfig);
    }

    (this.changedList);
  }
  getAllConfigurations() {
    this.coreSession.ModalLoading.Show();
    this.configurationService.getAllConfigurations(ConfigurationLevels.SystemLevel.valueOf(), '').subscribe(result => {
      (result);
      this.dataSource = {
        data: result,
        totalItems: result.length
      }
      // this.dataSource.data=result;
      this.coreSession.ModalLoading.Hide();
    });
  }

  onCancel() {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgCancelConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          this.router.navigate(['/' + ConstantURLs.settingsURL], {
            relativeTo: this.route.parent
          });
        }
      });

    //  this.router.navigate([ConstantURLs.customerListURL], { relativeTo: this.route.parent });
  }
  saveConfigurationChanges() {
    if (this.changedList && this.changedList.length > 0) {
      this.coreSession.ModalLoading.Show();
      this.configurationService.updateConfigurations(this.changedList).subscribe(
        response => {
          this.coreSession.ModalLoading.Hide();
          (response.status);
          if (response.status != null && response.status >= 0) {
            this.sessionDataProvider.loadSessionConfigurationsAfterUpdateConfig();
            this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly));
            this.router.navigate(['/' + ConstantURLs.settingsURL], {
              relativeTo: this.route.parent
            });
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        }
      );
    }
  }
  ngOnDestroy() {
    this.navService.setNavigation([]);
  }
  onChangeSeletedTab(tab) {
    this.setNavigation(tab);
  }
  setNavigation(tab) {
    let navigationList: NavigationData[] = [];
    navigationList.push(
      {
        Name: 'Desc_Settings',
        URL: ConstantURLs.settingsURL
      },
      {
        Name: tab.label,
        URL: undefined
      }
    );
    this.navService.setNavigation(navigationList);
  }

}
