import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import { ConfigurationLevels } from '../../../../shared/models/enums/configuration-levels.enum';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { SettingsService } from '../../settings.service';
import * as cloneDeep from 'lodash/cloneDeep';
import { DataActions } from '../../../../shared/models/enums/data-actions.enum';
import { RowOperation } from '../../../../shared/models/enums/shared-table-operation.enum';
import { DataTypes } from '../../../../shared/models/enums/data-types.enum';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { CoreSession } from '../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { Observable } from 'rxjs/Rx';
import { HttpErrorResponse } from '@angular/common/http';
import { DialogResult } from '../../../../shared/models/enums/dialog-result.enum';
import { DialogMode } from '../../../../shared/models/enums/dialog-mode.enum';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { MenuActions } from '../../../../shared/models/enums/menu-actions-enum';
import { ConfigurationService } from '../../../../shared/services/settings/configuration.service';
@Component({
  selector: 'app-configurations-on-levels',
  templateUrl: './configurations-on-levels.component.html',
  styleUrls: ['./configurations-on-levels.component.css']
})
export class ConfigurationsOnLevelsComponent implements OnInit {
  @Input() selectedLevel: ConfigurationLevels;
  @Input() selectedConfiguration: any;
  @Output() onSaveCompleted = new EventEmitter();
  @Input() events: Observable<void>;
  @Input() headerString: string = '';
  saveBtnSubscription: any;
  isAddAvailable = true;
  changedList: any[] = [];
  selectedIdLevel1 = -1;
  selectedIdLevel2 = -1;
  selectedCaptionLevel1 = '';
  selectedCaptionLevel2 = '';
  changedBooleanValue = false;
  changedTextValue = '';
  configurationFormGroup: FormGroup;
  changedConfig: any;

  tableData: ITableProperties = {
    pageSize: 15,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: false,
    isConfigurationScreen: true,
    rowOperations: [{
      operation: RowOperation.delete,
      title: 'Desc_Delete',
      icon: 'fa-solid fa-trash',
      color: '#f1685e'
    }],
    multiSelectionOperations: [
    ],
    columns: [

      {
        title: 'Desc_Configuration_Value',
        key: 'keyValue',
        isSortable: false,
        width: '10%',
        isEditablePerRow: true,
      }

    ]
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  constructor(private settingService: SettingsService,
    public coreSession: CoreSession,
    private translateService: TranslateService,
    private configurationService: ConfigurationService) { }

  ngOnInit() {
    this.isAddAvailable = this.coreSession.checkActivitiesAvailability(ConstantURLs.configurationURL, MenuActions.Add);
    if (!this.coreSession.checkActivitiesAvailability(ConstantURLs.configurationURL, MenuActions.Delete)) {
      this.tableData.rowOperations = [];
    }
    this.headerString = this.translateService.instant(this.headerString).toUpperCase() + ' : ' + this.selectedConfiguration.keyName;
    this.changedConfig = cloneDeep(this.selectedConfiguration);
    this.subscribeSaveClick();
    this.initForm();
    this.initTableColumns();
    this.populateConfigurationData();

  }
  initForm() {
    this.configurationFormGroup = new FormGroup({
      employeeId: new FormControl(
        { value: null, disabled: false },
        (this.isEmployeeLevel() ? Validators.required : Validators.nullValidator)
      ),
      customerId: new FormControl(
        { value: null, disabled: false },
        (this.isCustomerLevel() ? Validators.required : Validators.nullValidator)
      ),
      outletId: new FormControl(
        { value: null, disabled: false },
        (this.isCustomerLevel() ? Validators.required : Validators.nullValidator)
      ),
      divisionId: new FormControl(
        { value: null, disabled: false },
        (this.isDivisionLevel() ? Validators.required : Validators.nullValidator)
      ),
      customerGroupId: new FormControl(
        { value: null, disabled: false },
        (this.isCustomerGroupLevel() ? Validators.required : Validators.nullValidator)
      ),
      channelId: new FormControl(
        { value: null, disabled: false },
        (this.isChannelLevel() ? Validators.required : Validators.nullValidator)
      ),
      subChannelId: new FormControl(
        { value: null, disabled: false },
        (Validators.nullValidator)
      ),
      organizationId: new FormControl(
        { value: null, disabled: false },
        (this.isOrganizationLevel() ? Validators.required : Validators.nullValidator)
      ),
      securityGroupId: new FormControl(
        { value: null, disabled: false },
        (this.isSecurityGroupLevel() ? Validators.required : Validators.nullValidator)
      )

    });

  }
  initTableColumns() {
    this.tableData.columns = []
    switch (this.selectedLevel) {
      case ConfigurationLevels.EmployeeLevel:
        this.tableData.columns.push({
          title: 'Desc_Employee',
          key: 'employeeCodeName',
          isSortable: true,
          width: '50%'
        });
        break;
      case ConfigurationLevels.CustomerLevel:
        this.tableData.columns.push({
          title: 'Desc_Customer',
          key: 'customerCodeName',
          isSortable: true,
          width: '25%'
        }, {
          title: 'Desc_Outlet',
          key: 'outletCodeName',
          isSortable: true,
          width: '25%'
        });

        break;
      case ConfigurationLevels.DivisionLevel:
        this.tableData.columns.push({
          title: 'Desc_Division',
          key: 'divisionCodeName',
          isSortable: true,
          width: '50%'
        });
        break;
      case ConfigurationLevels.CustomerGroupLevel:
        this.tableData.columns.push({
          title: 'Desc_Customer_Group',
          key: 'customerGroupCodeName',
          isSortable: true,
          width: '50%'
        });
        break;
      case ConfigurationLevels.ChannelLevel:
        this.tableData.columns.push({
          title: 'Desc_Channel',
          key: 'channelCodeName',
          isSortable: true,
          width: '25%'
        }, {
          title: 'Desc_SubChannel',
          key: 'subChannelCodeName',
          isSortable: true,
          width: '25%'
        });

        break;
      case ConfigurationLevels.SecurityGroupLevel:
        this.tableData.columns.push({
          title: 'Desc_Security_Group',
          key: 'securityGroupIdName',
          isSortable: true,
          width: '50%'
        });
        break;
      case ConfigurationLevels.Organization:
        this.tableData.columns.push({
          title: 'Desc_Vendor',
          key: 'organizationCodeName',
          isSortable: true,
          width: '50%'
        });
        break;
    }
    this.tableData.columns.push(

      {
        title: 'Desc_Configuration_Value',
        key: 'keyValue',
        isSortable: false,
        width: '50%',
        isEditablePerRow: this.coreSession.checkActivitiesAvailability(ConstantURLs.configurationURL, MenuActions.Edit),
      });
  }
  populateConfigurationData() {
    let configFilter = ' and KeyName =\'' + this.selectedConfiguration.keyName + '\'';
    this.configurationService.getAllConfigurations(this.selectedLevel.valueOf(), configFilter).subscribe(result => {
      this.changedList = result;
      this.dataSource = {
        data: result,
        totalItems: result.length
      }
    });
  }
  onLevelIDSelected(selectedLevel: any) {
    this.selectedIdLevel1 = selectedLevel.id;
    this.selectedCaptionLevel1 = selectedLevel.caption;
  }
  onLevelID2Selected(selectedLevel: any) {
    this.selectedIdLevel2 = selectedLevel.id;
    this.selectedCaptionLevel2 = selectedLevel.caption;

  }
  getConfigurationIndex(configItem: any): number {
    let index = -1;
    switch (this.selectedLevel) {
      case ConfigurationLevels.EmployeeLevel:
        index = this.changedList.findIndex(a => a.employeeId === configItem.employeeId);

        break;
      case ConfigurationLevels.CustomerLevel:
        index = this.changedList.findIndex(a => a.customerId === configItem.customerId && a.outletId === configItem.outletId);

        break;
      case ConfigurationLevels.DivisionLevel:
        index = this.changedList.findIndex(a => a.divisionId === configItem.divisionId);
        break;
      case ConfigurationLevels.CustomerGroupLevel:
        index = this.changedList.findIndex(a => a.customerGroupId === configItem.customerGroupId);
        break;
      case ConfigurationLevels.ChannelLevel:
        index = this.changedList.findIndex(a => a.channelId === configItem.channelId && a.subChannelId === configItem.subChannelId);
        break;
      case ConfigurationLevels.SecurityGroupLevel:
        index = this.changedList.findIndex(a => a.securityGroupId === configItem.securityGroupId);
        break;
      case ConfigurationLevels.Organization:
        index = this.changedList.findIndex(a => a.organizationId === configItem.organizationId);
        break;
    }
    return index;
  }
  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        if (this.coreSession.checkActivitiesAvailability(ConstantURLs.configurationURL, MenuActions.Delete)) {
          this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption))
            .then(
              (result: DialogResult) => {
                if (result === DialogResult.Yes) {
                  this.onDeleteLevelConfiguration(this.getConfigurationIndex(event.object));
                }
              }

            );
        }


        break;

    }
  }
  onDeleteLevelConfiguration(index: number) {
    if (this.changedList[index].dataAction === DataActions.Add)
      this.changedList.splice(index, 1);
    else
      this.changedList[index].dataAction = DataActions.Delete;

    this.resetDataSource();
  }
  onConfigurationValueChanged(event: any) {
    let changedConfig = event.object;
    let index = this.getConfigurationIndex(changedConfig);
    if (this.changedList[index].dataAction !== DataActions.Add)
      changedConfig.dataAction = DataActions.Edit;

    this.changedList[index] = changedConfig;

    // this.resetDataSource();
  }
  onAddLevelConfiguration() {

    if (this.configurationFormGroup.invalid) {
      this.markFormGroupTouched(this.configurationFormGroup);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
    let index = -1;
    this.changedConfig = cloneDeep(this.selectedConfiguration);
    if (this.changedConfig.valueType === DataTypes.boolean.valueOf()) {
      this.changedConfig.keyValue = this.changedBooleanValue;
      this.changedConfig.booleanValue = this.changedBooleanValue;

    } else {
      if (this.changedTextValue === '') {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
        return;
      }
      this.changedConfig.keyValue = this.changedTextValue;
    }
    if (!this.changedList) this.changedList = [];
    switch (this.selectedLevel) {
      case ConfigurationLevels.EmployeeLevel:
        index = this.changedList.findIndex(a => a.employeeId === this.selectedIdLevel1);
        if (index > -1) {
          if (!this.coreSession.checkActivitiesAvailability(ConstantURLs.configurationURL, MenuActions.Edit)) return;
          if (this.changedList[index].dataAction === DataActions.Add)
            this.changedConfig.dataAction = DataActions.Add;
          else
            this.changedConfig.dataAction = DataActions.Edit;

          this.changedConfig.employeeId = this.changedList[index].employeeId;
          this.changedConfig.employeeCodeName = this.changedList[index].employeeCodeName;
          this.changedList[index] = this.changedConfig;
        } else {
          this.changedConfig.dataAction = DataActions.Add;
          this.changedConfig.employeeId = this.selectedIdLevel1;
          this.changedConfig.employeeCodeName = this.selectedCaptionLevel1;
          this.changedList.push(this.changedConfig);
        }
        break;
      case ConfigurationLevels.CustomerLevel:
        index = this.changedList.findIndex(a => a.customerId === this.selectedIdLevel1 && a.outletId === this.selectedIdLevel2);
        if (index > -1) {
          if (!this.coreSession.checkActivitiesAvailability(ConstantURLs.configurationURL, MenuActions.Edit)) return;
          if (this.changedList[index].dataAction === DataActions.Add)
            this.changedConfig.dataAction = DataActions.Add;
          else
            this.changedConfig.dataAction = DataActions.Edit;

          this.changedConfig.customerId = this.changedList[index].customerId;
          this.changedConfig.customerCodeName = this.changedList[index].customerCodeName;
          this.changedConfig.outletId = this.changedList[index].outletId;
          this.changedConfig.outletCodeName = this.changedList[index].outletCodeName;
          this.changedList[index] = this.changedConfig;
        } else {
          this.changedConfig.dataAction = DataActions.Add;
          this.changedConfig.customerId = this.selectedIdLevel1;
          this.changedConfig.customerCodeName = this.selectedCaptionLevel1;
          this.changedConfig.outletId = this.selectedIdLevel2;
          this.changedConfig.outletCodeName = this.selectedCaptionLevel2;
          this.changedList.push(this.changedConfig);
        }
        break;
      case ConfigurationLevels.DivisionLevel:
        index = this.changedList.findIndex(a => a.divisionId === this.selectedIdLevel1);
        if (index > -1) {
          if (!this.coreSession.checkActivitiesAvailability(ConstantURLs.configurationURL, MenuActions.Edit)) return;
          if (this.changedList[index].dataAction === DataActions.Add)
            this.changedConfig.dataAction = DataActions.Add;
          else
            this.changedConfig.dataAction = DataActions.Edit;
          this.changedConfig.divisionId = this.changedList[index].divisionId;
          this.changedConfig.divisionCodeName = this.changedList[index].divisionCodeName;
          this.changedList[index] = this.changedConfig;
        } else {
          this.changedConfig.dataAction = DataActions.Add;
          this.changedConfig.divisionId = this.selectedIdLevel1;
          this.changedConfig.divisionCodeName = this.selectedCaptionLevel1;
          this.changedList.push(this.changedConfig);
        }
        break;
      case ConfigurationLevels.CustomerGroupLevel:
        index = this.changedList.findIndex(a => a.customerGroupId === this.selectedIdLevel1);

        if (index > -1) {
          if (!this.coreSession.checkActivitiesAvailability(ConstantURLs.configurationURL, MenuActions.Edit)) return;
          (this.changedList[index]);
          if (this.changedList[index].dataAction === DataActions.Add)
            this.changedConfig.dataAction = DataActions.Add;
          else
            this.changedConfig.dataAction = DataActions.Edit;

          this.changedConfig.customerGroupId = this.changedList[index].customerGroupId;
          this.changedConfig.customerGroupCodeName = this.changedList[index].customerGroupCodeName;
          this.changedList[index] = this.changedConfig;
        } else {
          this.changedConfig.dataAction = DataActions.Add;
          this.changedConfig.customerGroupId = this.selectedIdLevel1;
          this.changedConfig.customerGroupCodeName = this.selectedCaptionLevel1;
          this.changedList.push(this.changedConfig);
        }
        break;
      case ConfigurationLevels.ChannelLevel:
        index = this.changedList.findIndex(a => a.channelId === this.selectedIdLevel1 && a.subChannelId === this.selectedIdLevel2);
        if (index > -1) {
          if (!this.coreSession.checkActivitiesAvailability(ConstantURLs.configurationURL, MenuActions.Edit)) return;
          if (this.changedList[index].dataAction === DataActions.Add)
            this.changedConfig.dataAction = DataActions.Add;
          else
            this.changedConfig.dataAction = DataActions.Edit;

          this.changedConfig.channelId = this.changedList[index].channelId;
          this.changedConfig.channelCodeName = this.changedList[index].channelCodeName;
          this.changedConfig.subChannelId = this.changedList[index].subChannelId;
          this.changedConfig.subChannelCodeName = this.changedList[index].subChannelCodeName;
          this.changedList[index] = this.changedConfig;
        } else {
          this.changedConfig.dataAction = DataActions.Add;
          this.changedConfig.channelId = this.selectedIdLevel1;
          this.changedConfig.channelCodeName = this.selectedCaptionLevel1;
          this.changedConfig.subChannelId = this.selectedIdLevel2;
          this.changedConfig.subChannelCodeName = this.selectedCaptionLevel2;
          this.changedList.push(this.changedConfig);
        }
        break;
      case ConfigurationLevels.Organization:
        index = this.changedList.findIndex(a => a.organizationId === this.selectedIdLevel1);
        if (index > -1) {
          if (!this.coreSession.checkActivitiesAvailability(ConstantURLs.configurationURL, MenuActions.Edit)) return;
          if (this.changedList[index].dataAction === DataActions.Add)
            this.changedConfig.dataAction = DataActions.Add;
          else
            this.changedConfig.dataAction = DataActions.Edit;

          this.changedConfig.organizationId = this.changedList[index].organizationId;
          this.changedConfig.organizationCodeName = this.changedList[index].organizationCodeName;
          this.changedList[index] = this.changedConfig;
        } else {
          this.changedConfig.dataAction = DataActions.Add;
          this.changedConfig.organizationId = this.selectedIdLevel1;
          this.changedConfig.organizationCodeName = this.selectedCaptionLevel1;
          this.changedList.push(this.changedConfig);
        }
        break;
      case ConfigurationLevels.SecurityGroupLevel:
        index = this.changedList.findIndex(a => a.securityGroupId === this.selectedIdLevel1);
        if (index > -1) {
          if (!this.coreSession.checkActivitiesAvailability(ConstantURLs.configurationURL, MenuActions.Edit)) return;
          if (this.changedList[index].dataAction === DataActions.Add)
            this.changedConfig.dataAction = DataActions.Add;
          else
            this.changedConfig.dataAction = DataActions.Edit;

          this.changedConfig.securityGroupId = this.changedList[index].securityGroupId;
          this.changedConfig.securityGroupIdName = this.changedList[index].securityGroupIdName;
          this.changedList[index] = this.changedConfig;
        } else {
          this.changedConfig.dataAction = DataActions.Add;
          this.changedConfig.securityGroupId = this.selectedIdLevel1;
          this.changedConfig.securityGroupIdName = this.selectedCaptionLevel1;
          this.changedList.push(this.changedConfig);
        }
        break;
    }
    this.resetDataSource();
  }
  saveLevelConfiguration() {

    if (!this.changedList || this.changedList.length == 0) {
      this.onSaveCompleted.emit();
      return;
    }
    this.changedList.forEach(element => {
      element.configurationId = +element.configurationId,
        element.keyValue = element.keyValue + ''
    }
    );
    this.configurationService.saveLevelConfigurations(this.changedList, this.selectedLevel).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly));
          this.onSaveCompleted.emit();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );

  }
  public markFormGroupTouched(formGroup: FormGroup) {
    (<any>Object).values(formGroup.controls).forEach(control => {
      control.markAsTouched();

      if (control.controls) {
        this.markFormGroupTouched(control);
      }
    });
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.saveLevelConfiguration();
    });
  }
  resetDataSource() {
    this.dataSource = {
      data: this.changedList.filter(config => config.dataAction != DataActions.Delete),
      totalItems: this.changedList.filter(config => config.dataAction != DataActions.Delete).length
    }

  }
  isBooleanValue() {
    return this.selectedConfiguration.valueType === DataTypes.boolean.valueOf();
  }
  isStringValue() {
    return this.selectedConfiguration.valueType === DataTypes.String.valueOf();
  }
  isNumberValue() {
    return this.selectedConfiguration.valueType === DataTypes.number.valueOf();
  }
  isEmployeeLevel() {
    return this.selectedLevel == ConfigurationLevels.EmployeeLevel;
  }
  isCustomerLevel() {
    return this.selectedLevel == ConfigurationLevels.CustomerLevel;
  }
  isDivisionLevel() {
    return this.selectedLevel == ConfigurationLevels.DivisionLevel;
  }
  isCustomerGroupLevel() {
    return this.selectedLevel == ConfigurationLevels.CustomerGroupLevel;
  }
  isChannelLevel() {
    return this.selectedLevel == ConfigurationLevels.ChannelLevel;
  }
  isOrganizationLevel() {
    return this.selectedLevel == ConfigurationLevels.Organization;
  }
  isSecurityGroupLevel() {
    return this.selectedLevel == ConfigurationLevels.SecurityGroupLevel;
  }
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
  }
}
