import { Component, EventEmitter, Input, OnInit, Output, ViewChild } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { TranslateService } from '@ngx-translate/core';
import { CoreSession } from '../../../../core/core.session';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { DialogMode } from '../../../../shared/models/enums/dialog-mode.enum';
import { DialogResult } from '../../../../shared/models/enums/dialog-result.enum';
import { MultiSelectionOperation, RowOperation } from '../../../../shared/models/enums/shared-table-operation.enum';
import { ITextInput } from '../../../../shared/models/shared-table/custom-list.interface';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import * as cloneDeep from 'lodash/cloneDeep';
import { SelectCustomersComponent } from '../../../../shared/components/customers/select-customers/select-customers.component';
import { EmailService } from '../../email/email.service';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../../shared/models/constants/constant-configuration';
import { HttpErrorResponse } from '@angular/common/http';
import { MasterDataService } from '../../../master-data-definition/master-data.service';
import { DynamicTemplateEmailTypes } from '../../../../shared/models/enums/dynamic-template-email-types.enum';
import { EmployeeService } from '../../../employee/employee.service';
import { CommonButtonStyles } from '../../../../shared/models/enums/common-button-styles.enum';
import { CustomerService } from '../../../../shared/services/data-definition/customer/customers.service';
import { DynamicTemplateService } from '../dynamic-template.service';
import { EmailReportTypes } from '../../../../shared/models/enums/email-report-type-enum';

@Component({
  selector: 'app-dynamic-templates-entry',
  templateUrl: './dynamic-templates-entry.component.html',
  styleUrls: ['./dynamic-templates-entry.component.css']
})
export class DynamicTemplatesEntryComponent implements OnInit {
  @ViewChild("selectCustomerDialog", { static: true }) selectCustomerDialog: SelectCustomersComponent;
  @Input() events;
  @Input() dynamicTempObj: any;
  @Input() isEditMode: boolean = false;
  @Input() emailTypeId: number = DynamicTemplateEmailTypes.Customer.valueOf();
  assignementAllDescription = 'Desc_Apply_All_Customers'
  @Output() onSaveComplete = new EventEmitter();
  isCustomerTemplate: boolean = true;
  isEmployeeTemplate: boolean = false;
  allEmployees: boolean = false;
  isSummery: boolean = true;
  isShowAttach: boolean = false;
  saveBtnSubscription: any;
  templateForm: FormGroup;
  formEmployeeAssignement: FormGroup
  templateNameTextInput: ITextInput = {
    formControlName: "templateName",
    placeHolder: "Desc_Template_Name",
    label: "Desc_Template_Name",
    isRequierd: true
  };
  displayNameTextInput: ITextInput = {
    formControlName: "senderDisplayName",
    placeHolder: "Desc_Sender_Name",
    label: "Desc_Sender_Name"
  };
  subjectTextInput: ITextInput = {
    formControlName: "subject",
    placeHolder: "Desc_Email_Subject",
    label: "Desc_Email_Subject"
  };
  bodyTextInput: ITextInput = {
    formControlName: "body",
    placeHolder: "Desc_Email_Body",
    label: "Desc_Email_Body",
    isTextArea: true
  };
  customersSharedTable: ITableProperties = {
    pageSize: 50,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    isMultiSelection: true,
    showNewBtn: true,
    showEditButton: false,
    newBtnCaption: 'Desc_Add',
    rowOperations: [
      {
        operation: RowOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e',
      }],
    multiSelectionOperations: [
      {
        operation: MultiSelectionOperation.delete,
        title: 'Desc_Delete',
        icon: 'fa-solid fa-trash',
        color: '#f1685e',
        style: CommonButtonStyles.Negative.valueOf()
      }],
    columns: [
      { title: 'Desc_Customer', key: 'customerCodeName', isSortable: true, width: '50%' },
      { title: 'Desc_Outlet', key: 'outletCodeName', isSortable: true, width: '50%' }
    ]
  };

  organizationDropdownSettings = {
    singleSelection: false,
    idField: 'organizationId',
    textField: 'organizationCodeName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 1,
  };

  ReportTypeList: any[] = [];
  ReportTypeDataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  ReportTypeTableProperties: ITableProperties = {
    pageSize: 25,
    showPaginator: false,
    showSearch: false,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: false,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [{
      title: "Desc_Report_Type",
      key: "reportTypeDescription",
      isSortable: false,
      width: "50%"
    }
      ,
    {
      title: "Desc_Attached_Report",
      key: "reportDescription",
      isSortable: false,
      width: "50%"
    }
    ]
  }
  addReportTypeTableAction() {
    this.ReportTypeTableProperties.rowOperations.push(
      {
        operation: RowOperation.delete,
        title: "Desc_Delete",
        icon: "fa-solid fa-trash",
        color: "#f1685e"
      }
    )
  }
  navLinks: any[];
  navBarSelectedIndex: number = 0;
  transactionTypesDS: any[] = [];
  transactionTypesDSSummery: any[] = [];
  transactionTypesDSNotSummery: any[] = [];
  isTxTypeLoading: boolean = false;
  securityGroupList: any[] = [];
  receiverSecurityGroupList: any[] = [];
  appliedEmployeesList: any[] = [];
  receiverAppliedEmployeesList: any[] = [];
  addedSecurityGroups: any[] = [];
  receiverAddedSecurityGroups: any[] = [];
  // variableParameters = "{0} -> Customer Name" + "\n" + " {1} -> Customer Code" + "\n" + " {2} -> Transaction Date" + "\n" + " {3} -> Transaction Number" + "\n" + " {4} -> Net Total";
  variableParameters = "{0} -> Customer Name, {1} -> Customer Code, {2} -> Transaction Date, {3} -> Transaction Number, {4} -> Net Total";
  variableEmployeeParameters = " {0} -> Sender Name, {1} -> Sender Code, {2} -> Employee Name, {3} -> Employee Code, {4} -> Route Name, {5} -> Route Code, {6} - > End Of Day Date) ";
  variableEmployeeLoadOffloadParameters = " {0} -> Sender Employee Name, {1} -> Sender Employee Code, {2} -> Employee Name, {3} -> Employee Code, {4} -> Route Name, {5} -> Route Code, {6} -> Transaction ID, {7} -> Transaction Date, {8} -> Vehicle Name, {9} -> Vehicle Code, {10} -> Ref Warehouse Name, {11} -> Ref Warehouse Code, {12} -> Transaction Status";
  variableEmployeeNewCustomerParameters = "{0} -> Sender Employee Name, {1} -> Sender Employee Code, {2} -> Employee Name, {3} -> Employee Code, {4} -> Route Name, {5} -> Route Code, {6} -> Customer Name, {7} -> Customer Code, {8} -> Customer Phone, {9} -> Customer Email, {10} -> Customer Address, {11} -> Outlet Code, {12} -> Outlet Phone, {13} -> Outlet Email, {14} -> Outlet Address, {15} -> End Of Day Date ";
  channeldropdownSettings = {
    singleSelection: false,
    idField: 'channelSubChannelIds',
    textField: 'channelSubChannelDescriptions',
    selectAllText: '',
    unSelectAllText: '',
    position: 'top',
    allowSearchFilter: true,
    searchPlaceholderText: '',
    itemsShowLimit: 2
  };
  securityGroupDropDownSettings = {
    singleSelection: false,
    idField: 'securityGroupId',
    textField: 'securityGroupName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    itemsShowLimit: 6,
    maxHeight: 150
  };
  receiverSecurityGroupDropDownSettings = {
    singleSelection: false,
    idField: 'securityGroupId',
    textField: 'securityGroupName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    itemsShowLimit: 6,
    maxHeight: 150
  };
  groupDropDownSettings = {
    singleSelection: false,
    idField: 'groupId',
    textField: 'groupCodeName',
    selectAllText: '',
    unSelectAllText: '',
    allowSearchFilter: true,
    searchPlaceholderText: '',
    itemsShowLimit: 2,
  }
  allChannelsList: any[] = [];
  allGroupsList: any[] = [];
  customersDataSource: SharedTableResult = {
    totalItems: 0,
    data: [],
  };
  addedCustomersList: any[] = [];
  copyOfAddedCustomers: any[] = [];
  showSelectCustomersDialog: boolean = false;
  descriptionLanguages: any[] = [];
  bodyLanguages: any[] = [];
  subjectLanguages: any[] = [];
  displayNameLanguages: any[] = [];
  templateTypes: any[] = [];
  templateId: number = -1;
  organizationsList: any[] = [];
  originalOrgList: any[] = [];
  organizationIdsString: string = "";
  reportFiles: any[] = [];
  isReportFileLoading: boolean = false;
  isFileRequired: boolean = true;
  employeesList: any[] = [];
  receiverEmployeesList: any[] = [];
  employeeDropdownSettings = {
    singleSelection: false,
    idField: 'employeeId',
    textField: 'employeeCodeName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 4
  };
  receiverEmployeeDropdownSettings = {
    singleSelection: false,
    idField: 'employeeId',
    textField: 'employeeCodeName',
    selectAllText: '',
    unSelectAllText: '',
    searchPlaceholderText: '',
    allowSearchFilter: true,
    itemsShowLimit: 4
  };
  constructor(
    private coreSession: CoreSession,
    private translateService: TranslateService,
    private dynamicTemplateService: DynamicTemplateService,
    private sessionData: SessionDataProvider,
    private customerService: CustomerService,
    private employeeservice: EmployeeService,
    private masterDataService: MasterDataService,
  ) { }

  ngOnInit(): void {
    this.isCustomerTemplate = this.emailTypeId == DynamicTemplateEmailTypes.Customer.valueOf();
    this.isEmployeeTemplate = this.emailTypeId == DynamicTemplateEmailTypes.Employee.valueOf();
    if (this.isEditMode && this.dynamicTempObj && this.dynamicTempObj.organizationsList) {
      this.getSelectedOrganizationIdsAsString(this.dynamicTempObj.organizationsList);
    }
    this.addReportTypeTableAction();
    this.initForm();
    if (!this.isCustomerTemplate) {
      this.assignementAllDescription = 'Desc_Apply_All_Employees'
    }
    this.initEmployeeAssignementFrom();
    this.prepareNavigation();
    this.navLinks[0].isActive = true;
    this.fillOrganizations();
    this.prepareDropDownLanguage();
    this.subscribeSaveClick();
    this.populateEmailTypes();
    this.populateGroupsList();
    this.populateChannelsSubChannelsList();
    if (!this.isEditMode) {
      this.prepareNewObject();
    } else {
      this.fillUIFromObject();
      this.markFormAsTouched();
    }
  }
  prepareNewObject() {
    this.dynamicTempObj = {
      dTEmailType: this.emailTypeId,
      descriptionLanguages: [],
      displayNameLanguages: [],
      subjectLanguages: [],
      bodyLanguages: [],
      email: "",
      password: "",
      serverAddress: "",
      serverPort: -1,
      hasAttachment: false,
      inActive: false,
      allCustomers: false,
      allEmployees: false,
      emailTypes: [],
      dynamicTemplateCustomers: [],
      dynamicTemplateGroups: [],
      dynamicTemplateChannels: [],
      organizationsList: [],
    }
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.onSaveClicked();
    });
  }
  fillOrganizations() {
    this.masterDataService.getOrganizationList().subscribe(result => {
      this.organizationsList = result;
    });
  }
  prepareDropDownLanguage() {
    this.channeldropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.channeldropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.channeldropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
    this.groupDropDownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.groupDropDownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.groupDropDownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
    this.organizationDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.organizationDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.organizationDropdownSettings.searchPlaceholderText = this.translateService.instant(ConstantMessages.SearchCaption);
    this.securityGroupDropDownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.securityGroupDropDownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.receiverSecurityGroupDropDownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.receiverSecurityGroupDropDownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.employeeDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.employeeDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    this.receiverEmployeeDropdownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.receiverEmployeeDropdownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
  }
  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_Template_Definition',
        index: 0,
        isActive: false,
        hidden: false
      },
      {
        label: 'Desc_Template_Design',
        index: 1,
        isActive: false,
        hidden: false
      },
      {
        label: 'Desc_Applied_To_Cap',
        index: 2,
        isActive: false,
        hidden: !this.isCustomerTemplate
      },
      {
        label: 'Desc_Applied_To_Cap',
        index: 3,
        isActive: false,
        hidden: this.isCustomerTemplate
      }
    ];
  }
  initEmployeeAssignementFrom() {
    this.formEmployeeAssignement = new FormGroup({
      securityGroups: new FormControl(this.addedSecurityGroups, Validators.required),
      employeeId: new FormControl(this.appliedEmployeesList),
      receiverSecurityGroups: new FormControl(this.receiverAddedSecurityGroups, Validators.required),
      receiverEmployeeId: new FormControl(this.receiverAppliedEmployeesList),
    })
  }
  initForm() {
    this.templateForm = new FormGroup({
      // main data:
      templateName: new FormControl(null, Validators.required),
      senderDisplayName: new FormControl(null),
      email: new FormControl(null, [Validators.required, Validators.email, Validators.pattern('^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$')]),
      password: new FormControl(null, Validators.required),
      serverAddress: new FormControl(null, Validators.required),
      serverPort: new FormControl(null, Validators.required),
      hasAttachment: new FormControl(false),
      inActive: new FormControl(false),
      subject: new FormControl(null),
      body: new FormControl(null),
      templateTypes: new FormControl(null, Validators.required),
      applyOnAllCustomers: new FormControl(null),
      organizations: new FormControl([], Validators.required),
      reportFile: new FormControl(null),
      enableSSL: new FormControl(false),
      // customer assignment data:
      customers: new FormControl([]),
      groups: new FormControl([]),
      channels: new FormControl([]),
      allCustomers: new FormControl(false),
      allEmployees: new FormControl(false),
      // employee assignment data:
      employees: new FormControl([]),
      securityGroups: new FormControl([]),
      isSummery: new FormControl(true)
    });
  }

  getTemplateData(templateId: number) {
    if (templateId && templateId > -1) {
      this.dynamicTemplateService.getDynamicTemplateData(templateId).subscribe(
        (response) => {
          if (response.status !== null && response.status >= 0) {
            this.dynamicTempObj = response.data;
            this.fillUIFromObject();
          } else {
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              this.translateService.instant(ConstantMessages.ErrorHappened)
            );
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }
      );
    }
  }

  fillUIFromObject() {
    this.templateId = this.dynamicTempObj.templateId;
    this.templateTypes = this.dynamicTempObj.emailTypes;
    this.originalOrgList = this.dynamicTempObj.organizationsList;
    // Main Data:
    this.templateForm.get('templateName').setValue(
      this.dynamicTempObj.templateName);

    var displayName = this.dynamicTempObj.displayNameLanguages.
      filter(name =>
        name.languageId
        === this.coreSession.selectedLanguageId)[0];

    this.templateForm.get('senderDisplayName').setValue(displayName ? displayName.description : null);

    this.templateForm.get('email').setValue(this.dynamicTempObj.email);
    this.templateForm.get('password').setValue(this.dynamicTempObj.password);
    this.templateForm.get('serverAddress').setValue(this.dynamicTempObj.serverAddress);
    this.templateForm.get('serverPort').setValue(this.dynamicTempObj.serverPort);
    this.templateForm.get('hasAttachment').setValue(this.dynamicTempObj.hasAttachment);
    this.templateForm.get('inActive').setValue(this.dynamicTempObj.inActive);
    this.templateForm.get('enableSSL').setValue(this.dynamicTempObj.enableSSL);
    if (this.isCustomerTemplate) {
      this.templateForm.get('allCustomers').setValue(this.dynamicTempObj.allCustomers);
      this.templateForm.get('templateTypes').setValue(
        this.dynamicTempObj.emailTypes && this.dynamicTempObj.emailTypes.length > 0 ?
          this.dynamicTempObj.emailTypes[0].reportTypeId : null
      );
    }
    else {
      this.templateForm.get('allEmployees').setValue(this.dynamicTempObj.allEmployees);
      if (this.dynamicTempObj.employeeReports) {
        if (this.dynamicTempObj.employeeReports.filter(x => x.reportTypeId == EmailReportTypes.LoadRequest || x.reportTypeId == EmailReportTypes.OffloadRequest || x.reportTypeId == EmailReportTypes.NewCustomer).length > 0) {
          this.transactionTypesDS = this.transactionTypesDSNotSummery;
          this.templateForm.get('isSummery').setValue(false);
          this.isSummery = false;
          this.ReportTypeDataSource.data = this.dynamicTempObj.employeeReports;
          this.ReportTypeDataSource.totalItems = this.ReportTypeDataSource.data.length;

        } else {
          this.transactionTypesDS = this.transactionTypesDSSummery;
          this.templateForm.get('isSummery').setValue(true);
          this.isSummery = true;
          this.ReportTypeDataSource.data = this.dynamicTempObj.employeeReports;
          this.ReportTypeDataSource.totalItems = this.ReportTypeDataSource.data.length;
        }
      }
      if (!this.dynamicTempObj.employeeReports && this.dynamicTempObj.emailTypes && this.dynamicTempObj.emailTypes.length > 0) {
        this.transactionTypesDS = this.transactionTypesDSNotSummery;
        this.templateForm.get('isSummery').setValue(false);
        this.isSummery = false;
        this.ReportTypeDataSource.data = this.dynamicTempObj.emailTypes;
        this.ReportTypeDataSource.totalItems = this.ReportTypeDataSource.data.length;
      }

    }
    if (this.dynamicTempObj.hasAttachment && this.isCustomerTemplate) {
      this.isFileRequired = true;
      this.templateForm.get('reportFile').setValidators(Validators.required);
      this.templateForm.get('reportFile').updateValueAndValidity();
    }
    if (this.dynamicTempObj.emailTypes && this.dynamicTempObj.emailTypes.length > 0)
      this.populateReportFiles(this.dynamicTempObj.emailTypes[0].reportTypeId, true);
    // Design Data:

    var subject = this.dynamicTempObj.subjectLanguages.filter(s => s.languageId === this.coreSession.selectedLanguageId)[0];
    this.templateForm.get('subject').setValue(subject ? subject.description : null);

    var find = "@@";
    var re = new RegExp(find, "g");
    var body = this.dynamicTempObj.bodyLanguages.filter(b => b.languageId === this.coreSession.selectedLanguageId)[0];
    this.templateForm.get('body').setValue(body && body.description ? body.description.replace(re, "\n") : null);

    // Assignment Data:
    if (this.isCustomerTemplate) {
      if (this.dynamicTempObj.allCustomers) {
        this.navLinks[2].disable = true;
        this.addedCustomersList = [];
        this.templateForm.get('groups').setValue([]);
        this.templateForm.get('channels').setValue([]);
      } else {
        if (this.dynamicTempObj.dynamicTemplateCustomers && this.dynamicTempObj.dynamicTemplateCustomers.length > 0) {
          this.addedCustomersList = this.dynamicTempObj.dynamicTemplateCustomers;
          this.customersDataSource = {
            data: this.dynamicTempObj.dynamicTemplateCustomers,
            totalItems: this.dynamicTempObj.dynamicTemplateCustomers.length
          };
        }
        if (this.dynamicTempObj.dynamicTemplateGroups && this.dynamicTempObj.dynamicTemplateGroups.length > 0) {
          this.templateForm.get('groups').setValue(this.dynamicTempObj.dynamicTemplateGroups);
        }
        if (this.dynamicTempObj.dynamicTemplateChannels && this.dynamicTempObj.dynamicTemplateChannels.length > 0) {
          this.templateForm.get('channels').setValue(this.dynamicTempObj.dynamicTemplateChannels);
        }
      }
    }
    else {

      if (this.dynamicTempObj.dynamicTemplateEmployees && this.dynamicTempObj.dynamicTemplateEmployees.length > 0) {
        this.appliedEmployeesList = this.dynamicTempObj.dynamicTemplateEmployees;
        this.formEmployeeAssignement.get('employeeId').setValue(this.dynamicTempObj.dynamicTemplateEmployees)
      }
      if (this.dynamicTempObj.dynamicTemplateSGs && this.dynamicTempObj.dynamicTemplateSGs.length > 0) {
        this.formEmployeeAssignement.get('securityGroups').setValue(this.dynamicTempObj.dynamicTemplateSGs);
      }
      if (this.dynamicTempObj.dynamicTemplateReceiverSGs && this.dynamicTempObj.dynamicTemplateReceiverSGs.length > 0) {
        this.formEmployeeAssignement.get('receiverSecurityGroups').setValue(this.dynamicTempObj.dynamicTemplateReceiverSGs);
      }
      if (this.dynamicTempObj.dynamicTemplateReceiverEmployees && this.dynamicTempObj.dynamicTemplateReceiverEmployees.length > 0) {
        this.formEmployeeAssignement.get('receiverEmployeeId').setValue(this.dynamicTempObj.dynamicTemplateReceiverEmployees);
      }
      if (this.dynamicTempObj.allEmployees) {
        // this.navLinks[3].disable = true;
        this.allEmployees = true;
        this.appliedEmployeesList = [];
        this.formEmployeeAssignement.get('employeeId').setValue([]);
        this.formEmployeeAssignement.get('securityGroups').setValue([]);
      }
    }

    // Organization data:
    if (this.dynamicTempObj.organizationsList && this.dynamicTempObj.organizationsList.length > 0) {
      this.repopulateGroupsList();
      this.fillEmployeesList()
      this.templateForm.get('organizations').setValue(this.dynamicTempObj.organizationsList);
    }

    if (this.isEditMode) {
      if (this.templateForm.get('hasAttachment').value) {
        this.isFileRequired = true;
      } else {
        this.isFileRequired = false;
      }
    }
  }

  markFormAsTouched() {
    if (this.isCustomerTemplate)
      this.templateForm.get('allCustomers').markAsTouched();
    else
      this.templateForm.get('allEmployees').markAsTouched();
    this.templateForm.updateValueAndValidity();
  }

  fillTemplateObject() {
    if (this.isEditMode) {
      this.dynamicTempObj.templateId = this.templateId;
    }
    if (this.isEmployeeTemplate && this.templateForm.get('templateTypes').value != EmailReportTypes.NewCustomer) {
      this.templateForm.get('hasAttachment').setValue(true);
    }
    // Main Data:
    this.dynamicTempObj.dtEmailType = this.emailTypeId;
    this.dynamicTempObj.descriptionLanguages = this.descriptionLanguages;
    this.dynamicTempObj.descriptionLanguages.push({
      languageId: this.coreSession.selectedLanguageId,
      description: this.templateForm.get('templateName').value
    });

    this.dynamicTempObj.displayNameLanguages = this.displayNameLanguages;
    this.dynamicTempObj.displayNameLanguages.push({
      languageId: this.coreSession.selectedLanguageId,
      description: this.templateForm.get('senderDisplayName').value
    });

    this.dynamicTempObj.email = this.templateForm.get('email').value;
    this.dynamicTempObj.password = this.templateForm.get('password').value;
    this.dynamicTempObj.serverAddress = this.templateForm.get('serverAddress').value;
    this.dynamicTempObj.serverPort = +this.templateForm.get('serverPort').value;
    this.dynamicTempObj.hasAttachment = this.templateForm.get('hasAttachment').value;
    this.dynamicTempObj.inActive = this.templateForm.get('inActive').value;
    if (this.isCustomerTemplate)
      this.dynamicTempObj.allCustomers = this.templateForm.get('allCustomers').value;
    else {
      this.dynamicTempObj.allEmployees = this.templateForm.get('allEmployees').value;
      this.allEmployees = this.dynamicTempObj.allEmployees;
    }
    this.dynamicTempObj.enableSSL = this.templateForm.get('enableSSL').value;
    this.dynamicTempObj.emailTypes = this.templateTypes;
    this.dynamicTempObj.reportID = this.templateForm.get('reportFile').value ? this.templateForm.get('reportFile').value : -1;

    // Design Data:
    this.dynamicTempObj.subjectLanguages = this.subjectLanguages;
    this.dynamicTempObj.subjectLanguages.push({
      languageId: this.coreSession.selectedLanguageId,
      description: this.templateForm.get('subject').value
    });

    this.bodyLanguages.map(b =>
      b.description.replace(/(\r\n|\n|\r)/gm, "@@"));
    this.dynamicTempObj.bodyLanguages = this.bodyLanguages;
    this.dynamicTempObj.bodyLanguages.push({
      languageId: this.coreSession.selectedLanguageId,
      description: this.templateForm.get('body').value ? this.templateForm.get('body').value.replace(/(\r\n|\n|\r)/gm, "@@") : null
    });

    // AssignmentData:
    //#region [customer assignment]
    if (this.isCustomerTemplate) {
      if (this.dynamicTempObj.allCustomers === 1) {
        this.dynamicTempObj.dynamicTemplateCustomers = [];
        this.dynamicTempObj.dynamicTemplateGroups = [];
        this.dynamicTempObj.dynamicTemplateChannels = [];
      } else {
        // customers =>
        if (this.addedCustomersList) {
          this.dynamicTempObj.dynamicTemplateCustomers = this.addedCustomersList;
        }
        // groups =>
        if (this.templateForm.get('groups').value) {
          this.dynamicTempObj.dynamicTemplateGroups = this.templateForm.get('groups').value;
        }
        // channels =>
        if (this.templateForm.get('channels').value) {
          this.dynamicTempObj.dynamicTemplateChannels = this.templateForm.get('channels').value;
        }
      }
    }
    //#endregion
    //#region [Employee assignment]
    else {
      this.dynamicTempObj.emailTypes = [];
      if (this.isSummery) {
        this.dynamicTempObj.employeeReports = this.ReportTypeDataSource.data;
      } else {
        let obj = {
          reportId: this.templateForm.get('reportFile').value == null ? -1 : this.templateForm.get('reportFile').value,
          reportTypeId: this.templateForm.get('templateTypes').value,
        }
        this.dynamicTempObj.employeeReports = [];
        this.dynamicTempObj.employeeReports.push(obj);
        this.dynamicTempObj.reportID = -1;
        this.dynamicTempObj.reportTypeId = -1;
      }

      if (this.dynamicTempObj.allEmployees === 1) {
        this.allEmployees = true;
        this.dynamicTempObj.dynamicTemplateEmployees = [];
        // this.dynamicTempObj.dynamicTemplateSGs = [];
      } else {
        //employees
        if (this.formEmployeeAssignement.get('employeeId').value)
          this.dynamicTempObj.dynamicTemplateEmployees = this.formEmployeeAssignement.get('employeeId').value

        //security groups
        if (this.formEmployeeAssignement.get('securityGroups').value)
          this.dynamicTempObj.dynamicTemplateSGs = this.formEmployeeAssignement.get('securityGroups').value
        //Receiver employees
        if (this.formEmployeeAssignement.get('receiverEmployeeId').value)
          this.dynamicTempObj.dynamicTemplateReceiverEmployees = this.formEmployeeAssignement.get('receiverEmployeeId').value
        //Receiver security groups
        if (this.formEmployeeAssignement.get('receiverSecurityGroups').value)
          this.dynamicTempObj.dynamicTemplateReceiverSGs = this.formEmployeeAssignement.get('receiverSecurityGroups').value

      }

    }
    //#endregion
    // Organizations:
    if (this.templateForm.get('organizations').value) {
      this.dynamicTempObj.organizationsList = this.templateForm.get('organizations').value;
    }
    this.saveTemplateToDB(this.dynamicTempObj);
  }

  populateGroupsList() {
    this.allGroupsList = [];
    if (this.forceOrganizationFilterForCustomerGroups()) {
      if (this.organizationIdsString != null) {
        this.customerService.getAllCustomerGroups(this.organizationIdsString).subscribe(result => {
          this.allGroupsList = result.data;
        });
      }
    } else {
      this.customerService.getAllCustomerGroups(this.organizationIdsString ? this.organizationIdsString : "").subscribe(result => {
        this.allGroupsList = result.data;
      });
    }

  }

  populateChannelsSubChannelsList() {
    this.customerService.GetAllCustomerChannels(null).subscribe(result => {
      this.allChannelsList = result;
    });
  }

  populateEmailTypes() {
    this.dynamicTemplateService.getDynamicTemplateEmailTypes(this.emailTypeId).subscribe(
      (response) => {
        if (response.status !== null && response.status >= 0) {
          this.transactionTypesDS = response.data;
          // if (this.dynamicTempObj.employeeReports != null && this.dynamicTempObj.employeeReports.length > 0)
          //   for (let employeeReport of this.dynamicTempObj.employeeReports) {
          //     this.transactionTypesDS = this.transactionTypesDS.filter(report => report.reportTypeId !== employeeReport.reportTypeId);
          //   }

          if (this.emailTypeId == DynamicTemplateEmailTypes.Employee) {
            this.transactionTypesDSSummery = this.transactionTypesDS.filter(report => report.reportTypeId !== EmailReportTypes.LoadRequest && report.reportTypeId !== EmailReportTypes.OffloadRequest && report.reportTypeId !== EmailReportTypes.NewCustomer);
            this.transactionTypesDSNotSummery = this.transactionTypesDS.filter(report => report.reportTypeId === EmailReportTypes.LoadRequest || report.reportTypeId === EmailReportTypes.OffloadRequest || report.reportTypeId === EmailReportTypes.NewCustomer);

            if (this.isSummery) {
              this.transactionTypesDS = this.transactionTypesDSSummery;
            }
            else {
              this.transactionTypesDS = this.transactionTypesDSNotSummery;
              if (this.isEditMode) {
                if (this.dynamicTempObj.employeeReports && this.dynamicTempObj.employeeReports.length > 0) {
                  this.templateForm.get('templateTypes').setValue(this.dynamicTempObj.employeeReports[0].reportTypeId);
                }
                if (this.dynamicTempObj.emailTypes && this.dynamicTempObj.emailTypes.length > 0) {
                  this.templateForm.get('templateTypes').setValue(this.dynamicTempObj.emailTypes[0].reportTypeId);
                }
              }
              if ((this.templateForm.get('templateTypes').value == EmailReportTypes.NewCustomer || this.templateForm.get('templateTypes').value == EmailReportTypes.LoadRequest
                || this.templateForm.get('templateTypes').value == EmailReportTypes.OffloadRequest) && !this.isSummery) {
                this.isShowAttach = true;
              } else {
                this.isShowAttach = false;
              }
              this.populateReportFiles(this.templateForm.get('templateTypes').value, true);
            }
          }
        } else {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    )
  }

  populateReportFiles(transactionTypeId: number, isEditMode?: boolean) {
    this.isReportFileLoading = true;
    this.dynamicTemplateService.GetDynamicTemplateReportFiles(transactionTypeId).subscribe(response => {
      this.isReportFileLoading = false;
      if (response.status !== null && response.status >= 0) {
        this.reportFiles = response.data;
        if (isEditMode) {
          this.templateForm.get('reportFile').setValue(this.dynamicTempObj.reportID && this.dynamicTempObj.reportID !== -1 ? this.dynamicTempObj.reportID : null);
        }
        if (this.reportFiles.length == 1) {
          this.templateForm.get('reportFile').setValue(this.reportFiles[0].reportId && this.reportFiles[0].reportId !== -1 ? this.reportFiles[0].reportId : null);
        }
        if (this.reportFiles.length > 0) {
          if (this.reportFiles[0].reportTypeId == EmailReportTypes.NewCustomer || this.reportFiles[0].reportTypeId == EmailReportTypes.LoadRequest
            || this.reportFiles[0].reportTypeId == EmailReportTypes.OffloadRequest)
            this.isShowAttach = true;
          else this.isShowAttach = false;
        }

      } else {
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    }, (error: HttpErrorResponse) => {
      this.isReportFileLoading = false;
      this.coreSession.showError(
        this.translateService.instant(ConstantMessages.ErrorCaption),
        this.translateService.instant(ConstantMessages.ErrorHappened)
      );
    }
    );
  }

  onSaveClicked() {
    this.resetEmptyStringValues();
    if (!this.isSummery && this.templateForm.invalid) {
      this.coreSession.markFormGroupTouched(this.templateForm as FormGroup);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }

    if (!this.isCustomerTemplate) {
      if (this.isSummery) {
        if (this.ReportTypeDataSource.data == null || this.ReportTypeDataSource.totalItems == 0) {
          this.coreSession.markFormGroupTouched(this.templateForm as FormGroup);
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillOneReportTypeAtLeast));
          this.ChangeDataView(0);
          return;
        }
      } else {
        if (this.templateForm.get('templateTypes').value == null) {
          this.coreSession.markFormGroupTouched(this.templateForm as FormGroup);
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillOneReportTypeAtLeast));
          this.ChangeDataView(0);
          return;
        }
      }


    }
    if (this.templateForm.get('email').invalid) {
      this.templateForm.get('email').markAsTouched()
      // this.coreSession.markFormGroupTouched(this.templateForm as FormGroup);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgInsertValidEmail));
      this.ChangeDataView(0);
      return;
    }
    if (this.isCustomerTemplate && this.templateForm.invalid) {
      this.coreSession.markFormGroupTouched(this.templateForm as FormGroup);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      this.ChangeDataView(0);
      return;
    }
    if (this.isCustomerTemplate &&
      !this.templateForm.get('allCustomers').value &&
      (!this.addedCustomersList || this.addedCustomersList.length === 0) &&
      (!this.templateForm.get('groups').value || this.templateForm.get('groups').value.length === 0) &&
      (!this.templateForm.get('channels').value || this.templateForm.get('channels').value.length === 0)
    ) {
      this.ChangeDataView(2);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAssignDyanmicTemplate));
      return;
    }
    else if (!this.isCustomerTemplate
      && !this.templateForm.get('allEmployees').value
      && (!this.addedSecurityGroups || this.addedSecurityGroups.length === 0 || !this.appliedEmployeesList || this.appliedEmployeesList.length === 0)
      && ((!this.formEmployeeAssignement.get('employeeId').value || this.formEmployeeAssignement.get('employeeId').value.length === 0) && (!this.formEmployeeAssignement.get('securityGroups').value || this.formEmployeeAssignement.get('securityGroups').value.length === 0))) {
      this.ChangeDataView(3);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgAssignDyanmicTemplateToEmployee));
      return;
    }
    // dynamicTemplateSGs to object
    // dynamicTemplateEmployees to object
    this.fillTemplateObject();
  }

  saveTemplateToDB(dynamicTempObj) {
    this.dynamicTemplateService.saveDynamicTemplate(dynamicTempObj).subscribe(
      (response) => {
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(
            this.translateService.instant(ConstantMessages.SuccessCaption),
            this.translateService.instant(response.message)
          );
          this.onSaveComplete.emit();
        } else {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(response.message)
          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }
  resetEmptyStringValues() {
    if (this.templateForm.get('templateName').value &&
      (this.templateForm.get('templateName').value.trim() === "" || this.templateForm.get('templateName').value.trim().length === 0)
    ) {
      this.templateForm.get('templateName').setValue(null);
    }

    if (this.templateForm.get('serverAddress').value &&
      (this.templateForm.get('serverAddress').value.trim() === "" || this.templateForm.get('serverAddress').value.trim().length === 0)
    ) {
      this.templateForm.get('serverAddress').setValue(null);
    }

    if (this.templateForm.get('password').value &&
      (this.templateForm.get('password').value.trim() === "" || this.templateForm.get('password').value.trim().length === 0)
    ) {
      this.templateForm.get('password').setValue(null);
    }

    if (this.templateForm.get('email').value &&
      (this.templateForm.get('email').value.trim() === "" || this.templateForm.get('email').value.trim().length === 0)
    ) {
      this.templateForm.get('email').setValue(null);
    }

    if (this.templateForm.get('senderDisplayName').value &&
      (this.templateForm.get('senderDisplayName').value.trim() === "" || this.templateForm.get('senderDisplayName').value.trim().length === 0)
    ) {
      this.templateForm.get('senderDisplayName').setValue(null);
    }

    if (this.templateForm.get('subject').value &&
      (this.templateForm.get('subject').value.trim() === "" || this.templateForm.get('subject').value.trim().length === 0)
    ) {
      this.templateForm.get('subject').setValue(null);
    }

    if (this.templateForm.get('body').value &&
      (this.templateForm.get('body').value.trim() === "" || this.templateForm.get('body').value.trim().length === 0)
    ) {
      this.templateForm.get('body').setValue(null);
    }
  }

  onTemplateOtherLanguagesTextSubmitted(value) {
    this.descriptionLanguages = value;
  }
  onSenderOtherLanguagesTextSubmitted(value) {
    this.displayNameLanguages = value;
  }
  onSubjOtherLanguagesTextSubmitted(value) {
    this.subjectLanguages = value;
  }
  onBodyOtherLanguagesTextSubmitted(value) {
    this.bodyLanguages = value;
  }

  onChangeDataView(index: number) {
    if (index == 1 && !this.isSummery && this.templateForm.get('templateTypes').value == null) {
      return;
    }
    if (index > 1 &&
      (!this.templateForm.get('organizations').value || this.templateForm.get('organizations').value.length === 0)
    ) {
      this.templateForm.get('organizations').markAsTouched();
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.SelectOrganization));
      this.navLinks.forEach(a => a.isActive = false);
      this.navBarSelectedIndex = 0;
      this.navLinks[0].isActive = true;
      return;
    }
    this.navLinks.forEach(a => a.isActive = false);
    this.navBarSelectedIndex = index;
    this.navLinks[index].isActive = true;
  }

  onTxTypeChanged(value) {
    this.templateForm.get('reportFile').reset();
    this.reportFiles = [];
    this.templateTypes = [];
    if (value && value != undefined) {
      this.templateTypes.push(value);
      this.populateReportFiles(value.reportTypeId);
    }
    if (value && (value.reportTypeId == EmailReportTypes.NewCustomer || value.reportTypeId == EmailReportTypes.LoadRequest || value.reportTypeId == EmailReportTypes.OffloadRequest)) {
      this.isShowAttach = true;
    }

    if (value && value.reportTypeId != EmailReportTypes.NewCustomer) {
      if (this.templateForm.get('hasAttachment')) {
        this.templateForm.get('reportFile').setValidators(Validators.required);
      } else {
        this.templateForm.get('reportFile').setValidators(Validators.nullValidator);
      }
    } else {
      this.templateForm.get('reportFile').setValidators(Validators.required);
    }
    if(this.isSummery){
    this.isFileRequired = true;
    }
    this.templateForm.get('reportFile').updateValueAndValidity();

  }

  onReportFileChanged(reportFile) {
    if (reportFile && reportFile != undefined) {
    }
  }

  onHasAttachmentChange() {
    this.templateForm.get('reportFile').setValue(null);
    if (this.templateForm.get('hasAttachment').value) {
      this.isFileRequired = true;
      this.templateForm.get('reportFile').setValidators(Validators.required);
    } else {
      this.isFileRequired = false;
      this.templateForm.get('reportFile').setValidators(null);
      this.templateForm.get('reportFile').setValue(null)
    }
    this.templateForm.get('reportFile').updateValueAndValidity();
  }


  onIsSummeryChange() {
    this.templateForm.get('hasAttachment').setValue(true);

    this.templateForm.get('templateTypes').setValue(null);
    this.templateForm.get('reportFile').setValue(null);
    if (this.templateForm.get('isSummery').value) {
      this.transactionTypesDS = this.transactionTypesDSSummery;
      this.isSummery = true;
      this.isShowAttach = false;
    } else {
      this.transactionTypesDS = this.transactionTypesDSNotSummery;
      this.isSummery = false;
      this.isShowAttach = true;
    }

  }

  onRowOperationForCustomers(event: any) {

    switch (event.operation) {
      case RowOperation.delete:
        this.onDeleteAppliedCustomer(event.object);
        break;
    }
  }

  onDeleteAppliedCustomer(deletedOutlet: any) {
    var index = this.addedCustomersList.findIndex(x => x.customerId === deletedOutlet.customerId && x.outletId === deletedOutlet.outletId);
    if (index >= 0) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.addedCustomersList.splice(index, 1);
            this.fillCustomersList();
          }
        });
    }
  }
  fillCustomersList() {
    this.customersDataSource = {
      totalItems: this.addedCustomersList.length,
      data: this.addedCustomersList
    };
  }
  openSelectCustomersDialog() {
    this.copyOfAddedCustomers = null;
    this.copyOfAddedCustomers = cloneDeep(this.addedCustomersList);
    this.showSelectCustomersDialog = true;
    this.selectCustomerDialog.showDialog('').then(
      (result) => {
        if (result != -1) {
          this.afterAddingSelectedCustomers(result)
        } else {
          this.closeSelectCustomersDialog();
        }
      });
  }
  afterAddingSelectedCustomers(selectedCustomers) {
    this.addedCustomersList = selectedCustomers;
    this.fillCustomersList();
    this.closeSelectCustomersDialog();
  }

  closeSelectCustomersDialog() {
    this.showSelectCustomersDialog = false;
  }

  ChangeDataView(index: number) {
    this.navLinks.forEach(a => a.isActive = false);
    this.navBarSelectedIndex = index;
    this.navLinks[index].isActive = true;
  }
  onallEmployeesSelected() {

    if (this.templateForm.get('allEmployees').value) {

      if ((this.formEmployeeAssignement.get('employeeId').value && this.formEmployeeAssignement.get('employeeId').value.length > 0) ||
        (this.formEmployeeAssignement.get('securityGroups').value && this.formEmployeeAssignement.get('securityGroups').value.length > 0)) {
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDescAssignmentEmployeeSecurityGroupsWillBeRemoved), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
          (res: DialogResult) => {
            if (res === DialogResult.Yes) {
              this.formEmployeeAssignement.get('employeeId').setValue([]);
              this.formEmployeeAssignement.get('securityGroups').setValue([]);
              this.formEmployeeAssignement.disable()
              // this.navLinks[3].disable = true;
              this.appliedEmployeesList = [];
              this.addedSecurityGroups = [];
              this.allEmployees = true;
            } else {
              this.templateForm.get('allEmployees').setValue(false);
              this.allEmployees = false;
            }
          });
      } else {
        this.formEmployeeAssignement.get('employeeId').setValue([]);
        this.formEmployeeAssignement.get('securityGroups').setValue([]);
        this.allEmployees = true;
        // this.navLinks[3].disable = true;
        this.appliedEmployeesList = [];
        this.addedSecurityGroups = [];
      }
    } else {
      this.allEmployees = false;
    }
  }
  onAllcustomersSelected() {
    this.templateForm.get('allCustomers').markAsTouched();
    if (this.isCustomerTemplate) {
      if (this.templateForm.get('allCustomers').value) {
        if (
          (this.templateForm.get('groups').value && this.templateForm.get('groups').value.length > 0) ||
          (this.templateForm.get('channels').value && this.templateForm.get('channels').value.length > 0) ||
          this.addedCustomersList.length > 0) {
          this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgAssignmentCustomerGroupsChannelWillBeRemoved), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
            (res: DialogResult) => {
              if (res === DialogResult.Yes) {
                this.templateForm.get('groups').setValue([]);
                var allGroupsList = cloneDeep(this.allGroupsList);
                this.allGroupsList = [];
                this.allGroupsList = allGroupsList;

                this.templateForm.get('channels').setValue([]);
                var allChannelsList = cloneDeep(this.allChannelsList);
                this.allChannelsList = [];
                this.allChannelsList = allChannelsList;

                this.navLinks[2].disable = true;

                this.addedCustomersList = [];
                this.customersDataSource = {
                  data: [],
                  totalItems: 0
                }
              } else {
                this.templateForm.get('allCustomers').setValue(false);
              }
            });
        } else {
          this.templateForm.get('groups').setValue([]);
          var allGroupsList = cloneDeep(this.allGroupsList);
          this.allGroupsList = [];
          this.allGroupsList = allGroupsList;

          this.templateForm.get('channels').setValue([]);
          var allChannelsList = cloneDeep(this.allChannelsList);
          this.allChannelsList = [];
          this.allChannelsList = allChannelsList;

          this.navLinks[2].disable = true;
          this.addedCustomersList = [];
          this.customersDataSource = {
            data: [],
            totalItems: 0
          }
        }
      } else {

        this.navLinks[2].disable = false;
      }
    }
  }

  onChangeOrganizationSelection(isSelectAll: boolean, isDeSelectAll: boolean, isDeSelect: boolean, isSelect: boolean, event?: any) {
    if (
      isDeSelect &&
      !this.templateForm.get('allCustomers').value && !this.templateForm.get('allEmployees').value && (
        (this.templateForm.get('groups').value && this.templateForm.get('groups').value.length > 0) ||
        (this.templateForm.get('channels').value && this.templateForm.get('channels').value.length > 0) ||
        this.addedCustomersList && this.addedCustomersList.length > 0)
    ) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgChangeOrganizationRemoveApplyData), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.originalOrgList = this.templateForm.get('organizations').value;
            this.resetAppliedToData();
            this.repopulateGroupsList();
          } else {
            this.templateForm.get('organizations').setValue(this.originalOrgList);
            this.repopulateGroupsList();
          }
        });
    } else if (
      isDeSelect &&
      !this.templateForm.get('allEmployees').value && (
        (this.formEmployeeAssignement.get('employeeId').value && this.formEmployeeAssignement.get('employeeId').value.length > 0) ||
        (this.formEmployeeAssignement.get('securityGroups').value && this.formEmployeeAssignement.get('securityGroups').value.length > 0 ||
          (this.formEmployeeAssignement.get('receiverEmployeeId').value && this.formEmployeeAssignement.get('receiverEmployeeId').value.length > 0) ||
          (this.formEmployeeAssignement.get('receiverSecurityGroups').value && this.formEmployeeAssignement.get('receiverSecurityGroups').value.length > 0))
      )) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgChangeOrganizationRemoveApplyData), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.originalOrgList = this.templateForm.get('organizations').value;
            this.formEmployeeAssignement.get('employeeId').setValue([]);
            this.formEmployeeAssignement.get('securityGroups').setValue([]);
            this.formEmployeeAssignement.get('receiverEmployeeId').setValue([]);
            this.formEmployeeAssignement.get('receiverSecurityGroups').setValue([]);
          } else {
            this.templateForm.get('organizations').setValue(this.originalOrgList);
          }
        });
    } else {
      if (isSelectAll) {
        this.originalOrgList = event;
      } else if (isSelect) {
        this.originalOrgList.push(event);
      } else if (isDeSelectAll) {
        this.originalOrgList = [];
      } else if (isDeSelect) {
        var i = this.originalOrgList.findIndex(o => o.organizationId === event.organizationId);
        if (i > -1) {
          this.originalOrgList.splice(i, 1);
        }
      }
      if (!this.isCustomerTemplate && isDeSelectAll) {
        this.securityGroupList = []
        this.employeesList = []
        this.receiverSecurityGroupList = []
        this.receiverEmployeesList = []
      }
      this.repopulateGroupsList();
      this.fillEmployeesList()
    }
  }


  repopulateGroupsList() {
    if (this.forceOrganizationFilterForCustomerGroups()) {
      let organizations = this.templateForm.get('organizations').value;
      this.getSelectedOrganizationIdsAsString(organizations);
      this.populateGroupsList();
    }
    if (!this.isCustomerTemplate && this.originalOrgList.length > 0)
      this.fillSecurityGroupsList();
  }
  fillSecurityGroupsList() {
    this.employeeservice.fillSecurityGroupsList(this.organizationIdsString).subscribe(
      (result) => {
        this.securityGroupList = result.data;
        this.receiverSecurityGroupList = result.data;
      });
  }
  fillEmployeesList() {
    this.getSelectedOrganizationIdsAsString(this.isEditMode ? this.dynamicTempObj.organizationsList : (this.originalOrgList != null ? this.originalOrgList : null))
    this.employeeservice.getALLEmployees(this.organizationIdsString).subscribe(
      (result) => {
        this.employeesList = result.data.routeEmployeeList;
        this.receiverEmployeesList = result.data.employeeList;
      });
  }
  resetAppliedToData() {
    this.addedCustomersList = [];
    this.customersDataSource = {
      data: [],
      totalItems: 0
    }
    this.templateForm.get('groups').setValue([]);
    var allGroupsList = cloneDeep(this.allGroupsList);
    this.allGroupsList = [];
    this.allGroupsList = allGroupsList;

    this.templateForm.get('channels').setValue([]);
    var allGroupsList = cloneDeep(this.allGroupsList);
    this.allGroupsList = [];
    this.allGroupsList = allGroupsList;
  }

  getSelectedOrganizationIdsAsString(organizationIds: any[]) {

    let organizationsList = organizationIds != null ? organizationIds : this.templateForm.get('organizations').value;
    this.organizationIdsString = null;
    if (organizationsList && organizationsList.length > 0) {
      this.organizationIdsString = organizationsList.map(({ organizationId }) => organizationId).join(',');
    }
  }

  forceOrganizationFilterForCustomerGroups() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.ForceOrganizationFilterForCustomerGroups).toLowerCase() === "true"
  }

  forceCustomerOrganizationSelection() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.ForceCustomerOrganizationSelection).toLowerCase() === "true";
  }
  onMultiSelectionOperationForCustomers(event: any) {
    switch (event.operation) {
      case MultiSelectionOperation.delete: {
        this.onDeleteSelectedAddedCustomers(event.object);
        break;
      }
    }
  }
  onDeleteSelectedAddedCustomers(selectedCustomersList) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
      (res: DialogResult) => {
        if (res === DialogResult.Yes) {
          selectedCustomersList.forEach(customer => {
            var index = this.addedCustomersList.findIndex(x => x.customerId === customer.customerId && x.outletId === customer.outletId);
            if (index >= 0) {
              this.addedCustomersList.splice(index, 1);
            }
          });
        }
        this.fillCustomersList();
      });
  }
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
  }
  selectedReportTypeIndex: number = -1;
  addEditButton = 'Desc_Add'
  onAddEditReportTypes() {
    if (this.templateForm.get('templateTypes').value == null || this.templateForm.get('reportFile').value == null) {
      this.templateForm.get('templateTypes').markAsTouched();
      this.templateForm.get('reportFile').markAsTouched();
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
    this.ReportTypeDataSource.data.push({
      reportDescription: (this.reportFiles.find(r => r.reportId == this.templateForm.get('reportFile').value)).reportDescription, reportTypeDescription: (this.transactionTypesDS.find(reportType => reportType.reportTypeId == this.templateForm.get('templateTypes').value)).reportTypeDescription, reportId: this.templateForm.get('reportFile').value, reportTypeId: this.templateForm.get('templateTypes').value
    })
    this.transactionTypesDS = this.transactionTypesDS.filter(reportType => reportType.reportTypeId !== this.templateForm.get('templateTypes').value);
    this.templateForm.get('templateTypes').reset();
    this.templateForm.get('reportFile').reset();
    this.ReportTypeDataSource.totalItems = this.ReportTypeDataSource.data.length
  }
  clear() {
    this.templateForm.get('templateTypes').reset();
    this.templateForm.get('reportFile').reset();
    this.selectedReportTypeIndex = -1;
    this.addEditButton = 'Desc_Add'
    this.ReportTypeList = []
  }
  onReportTypeRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.delete:
        this.ReportTypeDataSource.data.splice(event.index, 1);
        this.ReportTypeDataSource.totalItems = this.ReportTypeDataSource.totalItems - 1;
        break;
    }
    this.transactionTypesDS.push({
      reportTypeId: event.object.reportTypeId, reportTypeDescription: event.object.reportTypeDescription
    })
    this.transactionTypesDS = this.transactionTypesDS.filter(reportType => reportType.reportTypeId !== -1);
  }
}
