import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { TranslateModule } from '@ngx-translate/core';
import { SharedModule } from '../../../shared/shared.module';
import { NgbModule } from '@ng-bootstrap/ng-bootstrap';
import { NgSelectModule } from '@ng-select/ng-select';
import { NgOptionHighlightModule } from '@ng-select/ng-option-highlight';
import { DynamicTemplatesEntryComponent } from './dynamic-templates-entry/dynamic-templates-entry.component';
import { DynamicTemplatesListComponent } from './dynamic-templates-list/dynamic-templates-list.component';
import { NgMultiSelectDropDownModule } from 'ng-multiselect-dropdown';



@NgModule({
  declarations: [
    DynamicTemplatesEntryComponent,
    DynamicTemplatesListComponent
  ],
  imports: [
    CommonModule,
    ReactiveFormsModule,
    FormsModule,
    SharedModule,
    TranslateModule.forChild(),
    NgbModule,
    NgSelectModule,
    NgOptionHighlightModule,
    NgMultiSelectDropDownModule,
  ], exports: [
    DynamicTemplatesListComponent
  ]
})
export class DynamicTemplatesModule { }
