import { Component, OnInit, OnDestroy, Output,EventEmitter } from "@angular/core";

import { CoreSession } from "../../../../core/core.session";
import { EmailService } from "../email.service";
import { SharedTableResult } from "../../../../shared/models/shared-table/shared-table-result.interface";
import { ConstantMessages } from "../../../../shared/models/constants/constant-message";
import { EmailTemplateModel } from "../../../../shared/models/email/email.model";

@Component({
  selector: 'app-email-compose-btn',
  templateUrl: './compose-options.component.html',
  styleUrls: ['./compose-options.component.css']
})
export class EmailComposeOptionsComponent implements OnInit, OnDestroy {

  //#region [DECLARATIONS]

  /* @Input('ToEmail') toEmail: string = ''; */
  @Output('onTemplateSelected') templateSelectedEvent = new EventEmitter();

 /*  showSlider: boolean = false;
  sendCaption: string = 'Desc_Send';
  sendClicked: Subject<void> = new Subject<void>(); */
  emailTemplatesList: EmailTemplateModel[];
  emailTempObj: EmailTemplateModel;

  //#endregion

  //#region [CONSTRUCTOR]

  constructor(
    public coreSession: CoreSession,
    private emailService: EmailService
  ) {

  }

  ngOnInit() {
    this.emailTempObj = new EmailTemplateModel();
    this.populateEmailTemplates();
  }

  ngOnChanges() {
  }

  ngOnDestroy() {
  }

  //#endregion

  //#region [EVENTS]

  onComposeClicked(emailTemp) {
    this.emailTempObj = emailTemp;
    if(this.emailTempObj)
    {
      //by bushra for test 
      this.templateSelectedEvent.emit(this.emailTempObj);
    }
    /* this.showSlider = true; */
  }

  /* onSendClick() {
    this.sendClicked.next()
  } */

  //#endregion

  //#region [METHODS]

  /* closeNewMessage() {
    this.showSlider = false;
  } */

  populateEmailTemplates() {
    this.emailService.getEmailsList(true).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          let dataSource = <SharedTableResult>response.data;
          if (dataSource && dataSource.data) {
            this.emailTemplatesList = dataSource.data;
          }
        } else {
          this.coreSession.showError(response.message, '');
        }
      },
      error => {
        this.coreSession.showError(ConstantMessages.ErrorHappened, '');
      }
    );
  }

  //#endregion
}
