import { Component, OnInit, OnDestroy, Input, Output, EventEmitter } from "@angular/core";
import { Observable } from "rxjs";
import { EmailTemplateModel } from "../../../../../shared/models/email/email.model";
import { FormGroup, FormControl, Validators } from "@angular/forms";
import { ITextInput } from "../../../../../shared/models/shared-table/custom-list.interface";
import { CoreSession } from "../../../../../core/core.session";
import { EmailService } from "../../email.service";
import { TranslateService } from "@ngx-translate/core";
import { Router } from "@angular/router";
import { HttpErrorResponse } from "@angular/common/http";
import { ConstantMessages } from "../../../../../shared/models/constants/constant-message";
import { ConstantURLs } from "../../../../../shared/models/constants/constant-URL";
@Component({
  selector: "app-email-temp-entry",
  templateUrl: "./email-entry.component.html",
  styleUrls: ["./email-entry.component.css"]
})
export class EmailTemplateEntryComponent implements OnInit, OnDestroy {

  @Input() events;
  @Input() EmailTemp: EmailTemplateModel;
  @Input() isEditMode: boolean;
  @Output() onSaveCompleted = new EventEmitter();
  isExcludedTypeCRM: boolean = false;
  saveBtnSubscription: any;
  myForm: FormGroup;
  selectedEmailType: number = -1;
  emailTempObj: EmailTemplateModel;
  documentTypes: any[] = [];
  emailTypes: any[] = [];
  nameLanguages: any[] = [];
  subjectLanguages: any[] = [];
  bodyLanguages: any[] = [];
  nameValue: number = 1;
  subjectValue: number = 2;
  bodyValue: number = 3;
  showDocumentTypes: boolean = false;
  showBodyHint = false;
  showDestinationEmail = false;
  showBodyEmail = true;
  txtDefectItems = "{0} => Outlet Name/Outlet Code , {1} => Employee Name , {2} => Defected Cells";
  txtICash = "Old Balance => {0}, Amount => {1} , New Balance => {2}";
  txtProofs = "{0} Customer Name";
  txtWlcomeCustomer = "{0} => Customer Name";
  txtSurvey = "{0} => Customer Name";
  // txtExceed = "{0} => Supervisor Name";
  txtPrintOuts = "{0} => Customer Name";
  txtSupervisorWithCustomer = "{0} => Supervisor Name, {1} => Customer Name"
  txtQCActions = "{0} => Warehouse/Vehicle, {1} => Warehouse/Vehicle Name - Warehouse/Vehicle Code, {2} => Item Name - Item Code, {3} => [Field] [Answer] [Acceptable Level]";
  txtApproval = "{0} => Financial Entry Type , {1} => Financial Entry Code ";
  txtOrderCustomerApp = "{0} => Order Id, {1} => Net Total"
  txtBodyDataTemplate = "";
  showSubjectHint = false;
  txtSubjectHint = "{0} => Transaction ID , {1} => Transaction Type"
  nameTextInput: ITextInput = {
    formControlName: "name",
    placeHolder: "Desc_Name",
    label: "Desc_Name"
  };
  subjectTextInput: ITextInput = {
    formControlName: "subject",
    placeHolder: "Desc_Email_Subject",
    label: "Desc_Email_Subject"
  };
  bodyTextInput: ITextInput = {
    formControlName: "body",
    placeHolder: "Desc_Email_Body",
    label: "Desc_Email_Body",
    isTextArea: true
  };
  constructor(
    private coreSession: CoreSession,
    private emailService: EmailService,
    private translateService: TranslateService,
    private router: Router
  ) { }

  ngOnInit() {
    this.GetEmailTypes();
    this.subscribeSaveClick();
    this.emailTempObj = new EmailTemplateModel();
    if (this.EmailTemp && this.EmailTemp.emailTempId > 0) {
      this.showBodyHint = true;
      this.OnEmailTypeChange(this.EmailTemp);
      this.getEmailTemplateDetail();
    }
    this.initForm();
  }

  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
  }
  onSaveClicked() {

    if (this.selectedEmailType === 1 || this.selectedEmailType === 2 || this.selectedEmailType === 10) {
      this.myForm.get('emailDestination').setValidators([Validators.required, Validators.email, Validators.pattern('^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$')]);
      this.myForm.get('emailDestination').updateValueAndValidity();
    } else {
      this.myForm.get('body').setValidators(Validators.required);
      this.myForm.get('body').updateValueAndValidity();
      this.myForm.get('emailDestination').setValidators([Validators.email, Validators.pattern('^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$')]);
      this.myForm.get('emailDestination').updateValueAndValidity();
    }

    if (this.myForm.invalid) {
      if (this.email.invalid) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgInsertValidEmail));
        return;
      }
      this.coreSession.markFormGroupTouched(this.myForm as FormGroup);
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return;
    }
    this.fillObjectFromUI();
    this.saveEmailTemplateData();
  }
  onOtherLanguagesTextSubmitted(event, type) {
    switch (type) {
      case this.nameValue:
        this.nameLanguages = event;
        break;
      case this.subjectValue:
        this.subjectLanguages = event;
        break;
      case this.bodyValue:
        this.bodyLanguages = event;
        break;
      default:
        break;
    }
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.onSaveClicked();
    });
  }
  getEmailTemplateDetail() {
    this.emailService
      .getEmailTemplateDetail(this.EmailTemp.emailTempId)
      .subscribe(
        response => {
          if (response.status != null && response.status >= 0) {
            this.emailTempObj = response.data;
            this.fillUIforEditMode();
          } else {
            this.coreSession.showError(
              "",
              this.translateService.instant(response.message)
            );
            this.closeComponent();
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.showError(ConstantMessages.ErrorHappened, "");
        }
      );
  }

  GetEmailTypes() {
    this.emailService.GetEmailTypes(this.isExcludedTypeCRM).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.emailTypes = response.data;
        } else {
          this.coreSession.showError(
            "",
            this.translateService.instant(response.message)
          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(ConstantMessages.ErrorHappened, "");
      }
    );
  }

  getDocumentTypes() {
  }

  initForm() {
    this.myForm = new FormGroup({
      name: new FormControl("", Validators.required),
      emailType: new FormControl({}, Validators.required),
      address: new FormControl("", Validators.required),
      emailDestination: new FormControl("", [Validators.email, Validators.pattern('^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$')]),
      port: new FormControl("", Validators.required),
      email: new FormControl("", [Validators.required, Validators.email, Validators.pattern('^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\\.[a-zA-Z]{2,4}$')]),
      psw: new FormControl("", Validators.required),
      subject: new FormControl("", Validators.required),
      body: new FormControl(""),
      documentTypeId: new FormControl(-1),
      attachmentMandatory: new FormControl(),
      enableSSL: new FormControl(this.emailTempObj.enableSSL),
      inActive: new FormControl(!this.emailTempObj.isActive)
    });
  }

  saveEmailTemplateData() {
    this.emailService.saveTemplate(this.emailTempObj).subscribe(
      response => {
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(response.message), "");
          this.onSaveCompleted.emit();
        } else {
          this.coreSession.showError("", this.translateService.instant(response.message));
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(ConstantMessages.ErrorHappened, "");
      }
    );
  }

  closeComponent() {
    this.router
      .navigateByUrl("/RefrshComponent", { skipLocationChange: true })
      .then(() => this.router.navigate([ConstantURLs.emailTemplatesURL]));
  }

  fillObjectFromUI() {
    this.emailTempObj.name = this.name.value;
    this.emailTempObj.descriptionLanguages = this.nameLanguages;
    this.emailTempObj.descriptionLanguages.push({
      languageId: this.coreSession.selectedLanguageId,
      description: this.name.value
    });
    this.emailTempObj.body = this.body.value.replace(/(\r\n|\n|\r)/gm, "@@");
    this.emailTempObj.bodyLanguages = this.bodyLanguages;
    this.emailTempObj.bodyLanguages.push({
      languageId: this.coreSession.selectedLanguageId,
      description: this.body.value.replace(/(\r\n|\n|\r)/gm, "@@")
    });
    this.emailTempObj.subject = this.subject.value;
    this.emailTempObj.subjectLanguages = this.subjectLanguages;
    this.emailTempObj.subjectLanguages.push({
      languageId: this.coreSession.selectedLanguageId,
      description: this.subject.value
    });
    this.emailTempObj.serverAddress = this.address.value;
    this.emailTempObj.emailDestination = this.emailDestination.value == undefined || this.emailDestination.value == null ? '' : this.emailDestination.value;
    this.emailTempObj.email = this.email.value;
    this.emailTempObj.emailPort = +this.port.value;
    this.emailTempObj.password = this.password.value;
    this.emailTempObj.emailTypeId = this.emailType.value;
    this.emailTempObj.documentTypeId = this.documentTypeId.value;
    if (this.enableSSL.value == undefined) this.emailTempObj.enableSSL = false;
    else this.emailTempObj.enableSSL = this.enableSSL.value;

    if (this.inActive.value == undefined) this.emailTempObj.isActive = false;
    else this.emailTempObj.isActive = !this.inActive.value;
  }

  fillUIforEditMode() {

    this.name.setValue(this.emailTempObj.name);
    var find = "@@";
    var re = new RegExp(find, "g");
    this.body.setValue(this.emailTempObj.body.replace(re, "\n"));
    this.subject.setValue(this.emailTempObj.subject);
    this.address.setValue(this.emailTempObj.serverAddress);
    this.emailDestination.setValue(this.emailTempObj.emailDestination);
    this.email.setValue(this.emailTempObj.email);
    this.port.setValue(this.emailTempObj.emailPort);
    this.password.setValue(this.emailTempObj.password);
    this.enableSSL.setValue(this.emailTempObj.enableSSL);
    this.inActive.setValue(!this.emailTempObj.isActive);
    this.emailType.setValue(this.emailTempObj.emailTypeId);
    this.documentTypeId.setValue(this.emailTempObj.documentTypeId);
  }

  // markAsTouched() {
  //   this.name.markAsTouched();
  //   this.address.markAsTouched();
  //   this.port.markAsTouched();
  //   this.email.markAsTouched();
  //   this.password.markAsTouched();
  //   this.subject.markAsTouched();
  //   this.body.markAsTouched();
  // }

  get name() {
    return this.myForm.get("name");
  }
  get address() {
    return this.myForm.get("address");
  }
  get emailDestination() {
    return this.myForm.get("emailDestination");
  }
  get port() {
    return this.myForm.get("port");
  }
  get email() {
    return this.myForm.get("email");
  }
  get password() {
    return this.myForm.get("psw");
  }
  get emailType() {
    return this.myForm.get("emailType");
  }
  get documentTypeId() {
    return this.myForm.get("documentTypeId");
  }
  get subject() {
    return this.myForm.get("subject");
  }
  get body() {
    return this.myForm.get("body");
  }
  get attachmentMandatory() {
    return this.myForm.get("attachmentMandatory");
  }
  get enableSSL() {
    return this.myForm.get("enableSSL");
  }
  get inActive() {
    return this.myForm.get("inActive");
  }

  onDocumentTypeChange(type: any) {

  }

  OnEmailTypeChange(type: any) {
    this.showBodyHint = true;
    this.showDocumentTypes = false;
    this.txtBodyDataTemplate = '';
    this.documentTypes = [];
    if (type != undefined) {
      this.selectedEmailType = type.emailTypeID == undefined ? type.emailTypeId : type.emailTypeID;
      switch (this.selectedEmailType) {
        case 1:
          this.txtBodyDataTemplate = this.txtSurvey;
          this.showDestinationEmail = true;
          this.showSubjectHint = false;
          break;
        case 2:
          this.txtBodyDataTemplate = this.txtDefectItems;
          this.showDestinationEmail = true;
          this.showSubjectHint = false;
          break;
        case 3:
          this.txtBodyDataTemplate = this.txtICash;
          this.showDestinationEmail = false;
          this.showSubjectHint = false;
          if (this.myForm != undefined)
            this.myForm.get('emailDestination').reset();
          break;
        case 4:
          this.txtBodyDataTemplate = this.txtICash;
          this.showDestinationEmail = false;
          this.showSubjectHint = false;
          if (this.myForm != undefined)
            this.myForm.get('emailDestination').reset();
          break;
        case 5:
          this.txtBodyDataTemplate = this.txtWlcomeCustomer;
          if (this.myForm != undefined)
            this.myForm.get('emailDestination').reset();
          this.showDestinationEmail = false;
          this.showSubjectHint = false;
          break;
        case 6:
          this.txtBodyDataTemplate = this.txtPrintOuts;
          this.showDestinationEmail = false;
          this.showSubjectHint = true;
          if (this.myForm != undefined)
            this.myForm.get('emailDestination').reset();
          break;
        case 7:
          this.txtBodyDataTemplate = this.txtSupervisorWithCustomer;
          this.showDestinationEmail = true;
          this.showSubjectHint = false;
          break;
        case 8:
          break;
        case 9:
          this.txtBodyDataTemplate = this.txtProofs;
          this.showDestinationEmail = false;
          this.showDocumentTypes = true;
          this.showSubjectHint = false;
          this.getDocumentTypes();
          if (this.myForm != undefined)
            this.myForm.get('emailDestination').reset();
          break;
        case 10:
          this.showDestinationEmail = true;
          this.showBodyEmail = false;
          break;
        case 12:
          this.txtBodyDataTemplate = this.txtQCActions;
          this.showDestinationEmail = false;
          break;
        case 13:
          this.showDestinationEmail = true;
          break;
        case 11:
          this.txtBodyDataTemplate = this.txtApproval;
          this.showDestinationEmail = false;
          this.showSubjectHint = false;
          break;
        case 16:
          this.txtBodyDataTemplate = this.txtOrderCustomerApp;
          this.showDestinationEmail = false;
          this.showSubjectHint = false;
          break;
        case 15://should be default not another case to be more dynamic
          this.txtBodyDataTemplate = this.txtSupervisorWithCustomer;
          this.showDestinationEmail = true;
          this.showSubjectHint = false;
          break;
      }
    }
  }
}
