import { Component, OnDestroy, OnInit, ViewChild } from "@angular/core";
import { ITableProperties } from "../../../../../shared/models/shared-table/table-properties.interface";
import { SharedTableResult } from "../../../../../shared/models/shared-table/shared-table-result.interface";
import { Subject } from "rxjs";
import { EmailTemplateModel } from "../../../../../shared/models/email/email.model";
import { EmailService } from "../../email.service";
import { CoreSession } from "../../../../../core/core.session";
import { RowOperation } from "../../../../../shared/models/enums/shared-table-operation.enum";
import { ConstantMessages } from "../../../../../shared/models/constants/constant-message";
import { TranslateService } from "@ngx-translate/core";
import { ConstantURLs } from '../../../../../shared/models/constants/constant-URL';
import { MenuActions } from '../../../../../shared/models/enums/menu-actions-enum';
import { NavBarService } from "../../../../../core/sidebar/sidebar.service";
import { NavigationData } from "../../../../../shared/models/navigation-data/navigation-data.model";
import { SharedDialogComponent } from "../../../../../shared/components/shared-dialog/shared-dialog.component";

@Component({
  selector: 'app-email-temp-list',
  templateUrl: './email-list.component.html',
  styleUrls: ['./email-list.component.css']
})
export class EmailTemplateListComponent implements OnInit, OnDestroy {

  TabelData: ITableProperties = {
    pageSize: 1000,
    showPaginator: false,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: false,
    rowOperations: [
    ],
    multiSelectionOperations: [],
    columns: [
      {
        title: 'Desc_Name',
        key: 'name',
        isSortable: true,
        width: '25%'
      },
      {
        title: 'Desc_Email_Subject',
        key: 'subject',
        isSortable: true,
        width: '25%'
      },
      {
        title: 'Desc_Status',
        key: 'status',
        isSortable: true,
        useTranslate: true,
        width: '25%',
      }
      ,
      {
        title: 'Desc_Email_Type',
        key: 'description',
        isSortable: true,
        width: '25%',
      }
    ]
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  showNewSlider = false;
  saveSubject: Subject<void> = new Subject<void>();
  emailTemp: EmailTemplateModel;
  isEditMode: boolean = false;
  navLinks: any[];
  @ViewChild('ItemEntryDialog', { static: true }) ItemEntryDialog: SharedDialogComponent;

  constructor(
    private emailService: EmailService,
    public coreSession: CoreSession,
    private translateService: TranslateService,
    private navService:NavBarService
  ) { }
  ngOnInit() {
    this.coreSession.SetTitle('Email');
    this.prepareNavigation();
    var index = this.navLinks.findIndex(x => x.link == this.navService.searchMenuURL);
    if (index == -1) index = 0;
    this.navLinks[index].isActive = true;
    this.setNavigation(this.navLinks[index]);
    this.populateTable();

    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.emailTemplatesURL, MenuActions.Add)) {
      this.TabelData.showNewBtn = true;
    }
    this.addEditAction();
  }

  openItemEntryDialog() {
    this.ItemEntryDialog.Show(true).then((res) => { });
  }
  addEditAction()
  {

    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.emailTemplatesURL, MenuActions.Edit)) {
      this.TabelData.rowOperations.push({
        operation: RowOperation.edit,
        title: "Desc_Edit",
        icon: "fa-regular fa-pen-to-square",
        color: "#12344d"
      });
    }

  }

  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_Email_Templates',
        index: 0,
        isActive: false,
        hidden: false,
        disable: false
      }
    ];
  }

  onRowOperation(event: any) {
    this.isEditMode = false;

    switch (event.operation) {
      case RowOperation.edit:
        if (event && event.object) {
          this.isEditMode = true;
          this.emailTemp = event.object;
          this.showNewSlider = true;
          this.openItemEntryDialog()
        }
        break;
    }
  }
  onGenerateClicked() {
    this.emailTemp = new EmailTemplateModel();
    this.isEditMode = false;
    this.showNewSlider = true;
    this.openItemEntryDialog()
  }
  closeSlider() {
    this.showNewSlider = false;
    this.ItemEntryDialog.Close()
  }
  onSaveClick() {
    this.saveSubject.next();
  }
  onItemSaved() {
    this.closeSlider();
    this.populateTable();
  }
  onTableFilterChanged(event) {
  }
  populateTable() {
    this.coreSession.ModalLoading.Show();
    this.emailService.getEmailsList(false).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.dataSource = <SharedTableResult>response.data;
          (this.dataSource.data, "datasource");
        } else {
          this.coreSession.showError(response.message, '');
        }
      },
      error => {
        this.coreSession.showError(ConstantMessages.ErrorHappened, '');
      }
    );
  }
  ngOnDestroy() {
    this.navService.setNavigation([]);
  }
  onChangeSeletedTab(tab) {
    this.setNavigation(tab);
  }
  setNavigation(tab) {
    let navigationList: NavigationData[] = [];
    navigationList.push(
      {
        Name: 'Desc_Settings',
        URL: ConstantURLs.settingsURL
      },
      {
        Name: tab.label,
        URL: undefined
      }
    );
    this.navService.setNavigation(navigationList);
  }
}
