import { NgModule } from "@angular/core";
import { CommonModule } from "@angular/common";
import { ReactiveFormsModule, FormsModule } from "@angular/forms";
import { TranslateModule } from "@ngx-translate/core";
import { NgbModule } from "@ng-bootstrap/ng-bootstrap";
import { NgSelectModule } from "@ng-select/ng-select";
import { EmailTemplateListComponent } from "./email-temp/list/email-list.component";
import { EmailTemplateEntryComponent } from "./email-temp/entry/email-entry.component";
import { EmailComposeOptionsComponent } from "./compose-options/compose-options.component";
import { SharedModule } from "../../../shared/shared.module";
import { NgOptionHighlightModule } from "@ng-select/ng-option-highlight";

@NgModule({
  declarations: [
    EmailTemplateListComponent,
    EmailTemplateEntryComponent,
    EmailComposeOptionsComponent,
  ],
  imports: [
    CommonModule,
    ReactiveFormsModule,
    FormsModule,
    SharedModule,
    TranslateModule.forChild(),
    NgbModule,
    NgSelectModule,
    NgOptionHighlightModule,
  ],
  exports: [EmailComposeOptionsComponent],
})
export class EmailModule {}
