import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { map } from "rxjs/operators";
import { ResponseModel } from "../../../shared/models/api-models/api-models";
import { EmailTemplateModel } from "../../../shared/models/email/email.model";
import { CoreSession } from '../../../core/core.session';


@Injectable({
  providedIn: 'root'
})
export class EmailService {
  private url = '';
  httpOptions;

  constructor(private http: HttpClient, @Inject('BASE_URL') baseUrl: string, private coreSession: CoreSession) {
    this.url = baseUrl + 'Email';
    this.httpOptions = {
      headers: new HttpHeaders({
        'Content-Type': 'application/json'
      })
    };
  }

  saveTemplate(emailTempObj: EmailTemplateModel) {
    const urlValue = this.url + "/ModifyEmailTemplate";
    return this.http.post<ResponseModel>(urlValue, emailTempObj).pipe(
      map(response => {
        return response;
      })
    );
  }

  saveReportScheduleTemplate(emailTempObj: EmailTemplateModel) {
    const urlValue = this.url + "/InsertReportScheduleTemplate";
    return this.http.post<ResponseModel>(urlValue, emailTempObj).pipe(
      map(response => {
        return response;
      })
    );
  }

  getReportScheduleTemplateDetail() {
    const urlValue = this.url + "/GetReportScheduleTemplateDetail";
    return this.http.post<ResponseModel>(urlValue, "")
      .map(response => {
        return response;
      })
  }

  sendEmail(emailData: FormData) {
    return this.http.post(this.url + '/UploadFiles', emailData).map(
      (response: Response) => {
        let res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      });
  }

  getEmailsList(filter) {
    const urlValue = this.url + "/GetEmailTemplatesList";
    let generalFilter = {
      showActiveOnly: filter
    }
    return this.http.post<ResponseModel>(urlValue, generalFilter)
      .map(response => {
        return response;
      })
  }

  GetEmailTypes(isExcludedTypeCRM: boolean) {
    const urlValue = this.url + "/GetEmailTypes";
    let emailType = {
      isExcludedTypeCRM: isExcludedTypeCRM
    }
    return this.http.post<ResponseModel>(urlValue, emailType)
      .map(response => {
        return response;
      })
  }

  getEmailTemplateDetail(emailTempId) {
    const urlValue = this.url + "/GetEmailTemplateDetail";
    return this.http.post<ResponseModel>(urlValue, emailTempId)
      .map(response => {
        return response;
      })
  }
  getActiveEmailTemplatesList(filter) {
    const urlValue = this.url + '/GetActiveEmailTemplatesList';
    return this.http.post<ResponseModel>(urlValue, filter).map(response => {
      return response.data;
    });
  }

  // getDynamicTemplates(dynamicTemplateEmailTypes) {
  //   const urlValue = this.url + "/GetDynamicTemplates";
  //   return this.http.post<ResponseModel>(urlValue, dynamicTemplateEmailTypes)
  //     .map(response => {
  //       return response;
  //     });
  // }

  // getDynamicTemplateData(templateId) {
  //   const urlValue = this.url + "/GetDynamicTemplateData";
  //   return this.http.post<ResponseModel>(urlValue, templateId)
  //     .map(response => {
  //       return response;
  //     });
  // }

  // saveDynamicTemplate(dynamicTempObj) {
  //   const urlValue = this.url + "/InsertDynamicTemplate";
  //   return this.http.post<ResponseModel>(urlValue, dynamicTempObj)
  //     .map(response => {
  //       return response;
  //     });
  // }

  // getDynamicTemplateEmailTypes(emailTypeId: number) {
  //   const urlValue = this.url + "/GetDynamicTemplateEmailTypes";
  //   return this.http.post<ResponseModel>(urlValue, emailTypeId)
  //     .map(response => {
  //       return response;
  //     });
  // }

  // GetDynamicTemplateReportFiles(transactionTypeId: number) {
  //   const urlValue = this.url + "/GetDynamicTemplateReportFiles";
  //   return this.http.post<ResponseModel>(urlValue, transactionTypeId)
  //     .map(response => {
  //       return response;
  //     });
  // }

  // updateDynamicTemplateActiveStatus(dynamicTempObj) {
  //   const urlValue = this.url + "/UpdateDynamicTemplateActiveStatus";
  //   return this.http.post<ResponseModel>(urlValue, dynamicTempObj)
  //     .map(response => {
  //       return response;
  //     });
  // }
}
