import { Injectable, Inject } from "@angular/core";
import { HttpClient, HttpHeaders } from "@angular/common/http";
import { ResponseModel } from "../../../shared/models/api-models/api-models";
import { CoreSession } from '../../../core/core.session';
import { ConstantMessages } from "../../../shared/models/constants/constant-message";
import { TranslateService } from '@ngx-translate/core';
@Injectable({
  providedIn: 'root'
})
export class SendEmailService {
  private url = '';
  httpOptions;
  constructor(private http: HttpClient, private translateService: TranslateService, @Inject('BASE_URL') baseUrl: string, private coreSession: CoreSession) {
    this.url = baseUrl + 'SendEmail';
    this.httpOptions = {
      headers: new HttpHeaders({
        'Content-Type': 'application/json',
        Authorization: 'my-auth-token'
      })
    };
  }
  GetTransactionsEmails(transactionEmailHistoryFilter) {
    const urlValue = this.url + "/GetTransactionsEmails";
    return this.http.post<ResponseModel>(urlValue, transactionEmailHistoryFilter)
      .map(response => {
        return response;
      })
  }
  GetTransactionsEmailsForSharedTable(filter) {
    const urlValue = this.url + "/GetTransactionsEmailsForSharedTable";
    return this.http.post<ResponseModel>(urlValue, JSON.stringify(filter), this.httpOptions)
      .map(
        (response) => {
          const res = new ResponseModel();
          res.data = response['data'];
          res.message = response['message'];
          res.status = response['status'];
          return res;
        }
      );

  }
  resendTransactionsEmail(transactionsEmails) {
    const urlValue = this.url + "/ResendTransactionsEmail";
    return this.http.post<ResponseModel>(urlValue, transactionsEmails)
      .map(response => {
        return response;
      })
  }
  ShowReport(transaction: any, isShowHide: boolean) {

    // const urlValue = this.url + "/ShowReport" ;
    // return this.http.post<ResponseModel>(urlValue, transaction)
    //   .map(response => {
    //     return response;
    //   })

    const urlValue = this.url + "/ShowReport";
    if (isShowHide) {
      this.coreSession.ModalLoading.Show();
    }
    this.http.post(urlValue, transaction, { responseType: "blob" }).map(res => {
      var blob = new Blob([res], { type: "application/pdf" });
      return blob;
    }).subscribe(
      success => {
        const fileURL = URL.createObjectURL(success);
        window.open(fileURL, "_blank");
        if (isShowHide) {
          this.coreSession.ModalLoading.Hide();
        }
      },
      err => {
        if (err.status != '404') {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.Desc_Server_Error_While_Downloading_File));
        }
        if (isShowHide) {
          this.coreSession.ModalLoading.Hide();
        }
      }
    );
  }
  // GetTransactionsEmailData(transactionEmail) {
  //   const urlValue = this.url + "/GetTransactionsEmailData" ;
  //   return this.http.post<ResponseModel>(urlValue, transactionEmail)
  //     .map(response => {
  //       return response;
  //     })
  // }
} 