import { ExcelSheetTemplatesService } from './../excelSheetTemplate.service';
import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { TranslateService } from '@ngx-translate/core';
import { Observable } from 'rxjs';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { CoreSession } from '../../../../core/core.session';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { ExcelSheetTypes } from '../../../../shared/models/enums/excel-sheet-types.enum';
import { ItemService } from '../../../../shared/services/data-definition/product/item.service';


@Component({
    selector: 'app-excel-sheet-templates-entry',
    templateUrl: './excel-sheet-templates-entry.component.html',
    styleUrls: ['./excel-sheet-templates-entry.component.css']
})
export class ExcelSheetDynamicTemplatesEntryComponent implements OnInit {

    @Output() onSaveCompleted = new EventEmitter();
    @Input() saveEvent: Observable<void>;
    @Input() templateObject: any = {};;
    @Input() isEditMode: boolean = false;
    @Input() isViewMode: boolean = false;
    hiddenSubmit: boolean = false;
    saveBtnSubscription: any;
    templateForm: FormGroup;
    excelSheetTypesList: any[] = [];
    parentLevelList: any[] = [];
    sSCCLevelList: any[] = [];
    vendorDataSource: any[] = [];
    excelSheetData: any[] = [];
    isValidInput: boolean = true;
    dataSource: SharedTableResult = {
        totalItems: 0,
        data: []
    };

    TableProperties: ITableProperties = {
        pageSize: this.coreSession.pageSize,
        showPaginator: false,
        showSearch: true,
        isOnline: false,
        isMultiSelection: false,
        showOptionPerLine: false,
        showEditButton: false,
        rowOperations: [],
        multiSelectionOperations: [],
        columns: [
            {
                title: 'Desc_Template_Columns',
                key: 'defaultValue',
                isSortable: true,
                width: '50%'
            },
            {
                title: 'Desc_Value',
                key: 'dynamicValue',
                isSortable: false,
                width: '50%',
                isEditablePerRow: true
            },
        ]
    };
    constructor(
        public coreSession: CoreSession,
        private translateService: TranslateService,
        private itemService: ItemService,
        private excelSheetTemplatesService: ExcelSheetTemplatesService) {
    }
    ngOnInit() {
        this.subscribeSaveClick();
        this.initTemplateForm();
        this.fillVendorList()
        this.fillExcelSheetTypesList();
        this.fillParentLevelList();
        this.fillSSCCLevelList();
        if (this.isEditMode || this.isViewMode) {
            this.templateObject.isEditMode = true;
            this.populateExcelSheet(this.templateObject);
            if (this.templateObject.excelSheetList && this.templateObject.excelSheetList.length > 0) {
                this.dataSource = {
                    totalItems: this.templateObject.excelSheetList.length,
                    data: this.templateObject.excelSheetList
                };
            }
            this.templateForm.disable();
        }
        if (this.isViewMode) {
            this.coreSession.SetTitle('View Excel Sheet Dynamic Template');
            this.templateForm.disable();
            this.TableProperties.columns = [
                {
                    title: 'Desc_Template_Columns',
                    key: 'defaultValue',
                    isSortable: true,
                    width: '50%'
                },
                {
                    title: 'Desc_Value',
                    key: 'dynamicValue',
                    isSortable: false,
                    width: '50%',
                    isEditablePerRow: false
                }
            ]
        }
    }
    ngOnDestroy() {
        this.saveBtnSubscription.unsubscribe();
    }
    initTemplateForm() {
        this.templateForm = new FormGroup({
            vendorId: new FormControl({ value: this.isEditMode || this.isViewMode ? this.templateObject.vendorId : null, disabled: this.isViewMode }, Validators.required),
            excelSheetTypeId: new FormControl({ value: this.isEditMode || this.isViewMode ? this.templateObject.excelSheetTypeId : null, disabled: this.isViewMode }, Validators.required),
            parentLevelId: new FormControl({ value: this.isEditMode || this.isViewMode ? this.templateObject.parentLevelId : 1, disabled: this.isViewMode }, Validators.required),
            ssccLevelId: new FormControl({ value: this.isEditMode || this.isViewMode ? this.templateObject.ssccLevelId : 1, disabled: this.isViewMode }, Validators.required),
        });

    }
    subscribeSaveClick() {
        this.saveBtnSubscription = this.saveEvent.subscribe(() => {
            this.onSaveExcelSheetDynamicTemplate();
        });
    }
    fillExcelSheetTypesList() {
        this.excelSheetTypesList = [];
        this.excelSheetTypesList.push(
            { 'excelSheetType': ExcelSheetTypes.Input.valueOf(), 'excelSheetTypeName': this.translateService.instant(ConstantMessages.Desc_Input_Caption) }
        );
    }
    fillParentLevelList() {
        this.parentLevelList = [];
        this.parentLevelList.push(0, 1);
    }
    fillSSCCLevelList() {
        this.sSCCLevelList = [];
        this.sSCCLevelList.push(1, 2);
    }
    fillVendorList() {
        this.itemService.getAllVendors(true).subscribe(
            response => {
                this.vendorDataSource = response;
            },
            (error: HttpErrorResponse) => {
                this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
            }
        );
    }
    fillTemplateObject() {
        this.templateObject = new Object();
        this.templateObject.vendorId = this.templateForm.get('vendorId').value ? this.templateForm.get('vendorId').value : -1;
        this.templateObject.excelSheetTypeId = this.templateForm.get('excelSheetTypeId').value;
        this.templateObject.parentLevelId = this.templateForm.get('parentLevelId').value;
        this.templateObject.ssccLevelId = this.templateForm.get('ssccLevelId').value;
        this.templateObject.excelSheetList = this.dataSource.data;
        this.dataSource.data.forEach(response => {
            if (response.defaultValue == "ExpiryDate") {
                if (response.dynamicValue != "") {
                    if (response.dynamicValue != null) {
                        this.dataSource.data.forEach(result => {
                            if (result.defaultValue == "ExpiryDateFormat") {
                                if (result.dynamicValue == "" || result.dynamicValue == null) {
                                    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillExpiryDateFormat));
                                    this.isValidInput = false;
                                }
                            }
                        })

                    } else {
                        this.isValidInput = true;
                        return this.isValidInput
                    }
                } else {
                    this.isValidInput = true;
                    return this.isValidInput
                }
            }
        });
        this.dataSource.data.forEach(x => {
            if (x.defaultValue == "ExpiryDateFormat") {
                if (x.dynamicValue != "") {
                    if (x.dynamicValue != null) {
                        let returnedDate = "";
                        const dateFormat = ["yyMMdd", "ddMMyyyy", "yyyyMMdd", "MMddyyyy", "MMddyy", "ddMMMyyyy", "dd/MM/yyyy", "dd-MM-yyyy", "yyyy-MM-dd", "MM/dd/yyyy", "MM-dd-yyyy", "MM/dd/yy", "yy/MM/dd", "dd-MMM-yy"];
                        if (dateFormat.includes(x.dynamicValue)) {
                            returnedDate = x.dynamicValue.toString();
                            this.isValidInput = true;
                        } else {
                            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgExpiryDateFormat));
                            this.isValidInput = false;
                        }
                    }
                }
            }
        })
        this.dataSource.data.forEach(res => {
            if (res.defaultValue == "GTIN") {
                if (res.dynamicValue == null || res.dynamicValue == "") {
                    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillGTIN));
                    this.isValidInput = false;
                }
            }
        });
        this.dataSource.data.forEach(x => {
            if (x.defaultValue == "Serial") {
                if (x.dynamicValue == null || x.dynamicValue == "") {
                    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillSerialNo));
                    this.isValidInput = false;
                }
            }
        });
        this.dataSource.data.forEach(x => {
            if (x.defaultValue == "ParentSerial") {
                if (x.dynamicValue == null || x.dynamicValue == "") {
                    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillParentSerial));
                    this.isValidInput = false;
                }
            }
        });
        this.dataSource.data.forEach(x => {
            if (x.defaultValue == "SSCCBarcode") {
                if (x.dynamicValue == null || x.dynamicValue == "") {
                    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillSSCCBarcode));
                    this.isValidInput = false;
                }
            }
        });
        this.dataSource.data.forEach(x => {
            if (x.defaultValue == "ParentSSCCBarcode") {
                if (x.dynamicValue == null || x.dynamicValue == "") {
                    this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillParentSSCCBarcode));
                    this.isValidInput = false;
                }
            }
        });
    }
    populateExcelSheet(object) {
        this.excelSheetTemplatesService.getExcelSheetSharedTable(object).subscribe(
            (response) => {
                this.dataSource = {
                    data: response.data,
                    totalItems: response.data.length
                };
            });
        (error: HttpErrorResponse) => {
            this.coreSession.showError(ConstantMessages.ErrorHappened, '');
        };
    }
    onSubmit() {
        if (this.templateForm.invalid) {
            this.coreSession.markFormGroupTouched(this.templateForm);
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
            return;
        }
        this.templateObject = new Object();
        this.templateObject.isEditMode = false;
        this.templateForm.disable();
        this.hiddenSubmit = true;
        this.templateObject = new Object();
        this.templateObject.vendorId = this.templateForm.get('vendorId').value ? this.templateForm.get('vendorId').value : -1;
        this.templateObject.excelSheetTypeId = this.templateForm.get('excelSheetTypeId').value;
        this.templateObject.parentLevelId = this.templateForm.get('parentLevelId').value;
        this.templateObject.ssccLevelId = this.templateForm.get('ssccLevelId').value;
        this.populateExcelSheet(this.templateObject);
    }
    onSaveExcelSheetDynamicTemplate() {
        if (this.templateForm.invalid) {
            this.coreSession.markFormGroupTouched(this.templateForm);
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
            return;
        }
        this.fillTemplateObject();
        if (this.isValidInput) {
            if (!this.isEditMode) {
                this.InsertExcelSheet();
            }
            else {
                this.UpdateExcelSheet();
            }
        }
    }
    InsertExcelSheet() {
        this.excelSheetTemplatesService.InsertExcelSheetDynamicTemplate(this.templateObject).subscribe(
            result => {
                if (result.status != null && result.status >= 0) {
                    this.onSaveCompleted.emit();
                    this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
                } else {
                    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), result.message);
                }
            }, (error: HttpErrorResponse) => {
                this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorCaption));
            });
    }
    UpdateExcelSheet() {
        this.excelSheetTemplatesService.UpdateExcelSheetDynamicTemplate(this.templateObject).subscribe(
            (response) => {
                if (response.status != null && response.status >= 0) {
                    this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
                    this.onSaveCompleted.emit();
                } else {
                    this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
                }
            }, (error: HttpErrorResponse) => {
                this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorCaption));
            }
        );
    }
}
