import { Injectable, Inject } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { CoreSession } from '../../../core/core.session';
import { ResponseModel } from '../../../shared/models/api-models/api-models';


@Injectable({
  providedIn: 'root'
})
export class ExcelSheetTemplatesService {

  httpOptions;
  private url = '';
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "ExcelSheetTemplates/";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }
  getExcelSheetDynamicTemplateListSharedTable(filter: any) {
    const urlValue: string = this.url + 'GetExcelSheetDynamicTemplateListSharedTable';
    return this.http.post(urlValue, JSON.stringify(filter), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  getExcelSheetSharedTable(templateObject: any) {
    const urlValue = this.url + 'GetExcelSheet';
    return this.http.post<ResponseModel>(urlValue, templateObject).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  }
  UpdateExcelSheetDynamicTemplate(templateObject: any) {
    const urlValue: string = this.url + 'UpdateExcelSheetDynamicTemplate';
    return this.http.post<ResponseModel>(urlValue, templateObject).map((response) => {
      const res = new ResponseModel();
      res.data = response["data"];
      res.message = response["message"];
      res.status = response["status"];
      return res;
    });
  }
  InsertExcelSheetDynamicTemplate(templateObject: any) {
    const urlValue: string = this.url + 'InsertExcelSheetDynamicTemplate';
    return this.http.post<ResponseModel>(urlValue, templateObject).map((response) => {
      const res = new ResponseModel();
      res.data = response["data"];
      res.message = response["message"];
      res.status = response["status"];
      return res;
    });
  }
  getExcelSheetTemplateData(vendorId: number, excelSheetTypeId: number) {
    const urlValue: string = this.url + "GetExcelSheetTemplateData";
    let excelTemplate = {
      vendorId: vendorId,
      excelSheetTypeId: excelSheetTypeId
    }
    return this.http.post<ResponseModel>(urlValue, excelTemplate).map(
      response => {
        return response;
      });
  }
  deleteExcelSheetData(vendorId: number, excelSheetTypeId: number) {
    const urlValue: string = this.url + "DeleteExcelSheetData";
    let templateObject = {
      vendorId: vendorId,
      excelSheetTypeId: excelSheetTypeId
    }
    return this.http.post<ResponseModel>(urlValue, templateObject).map(
      response => {
        return response;
      });
  }


}
