import { Component, Input, OnInit, ViewChild } from '@angular/core';
import { NgbModal, NgbModalRef } from '@ng-bootstrap/ng-bootstrap';
import { DialogResult } from '../../../shared/models/enums/dialog-result.enum';

@Component({
  selector: 'app-incube-support-dialog',
  templateUrl: './incube-support-dialog.component.html',
  styleUrls: ['./incube-support-dialog.component.css']
})
export class IncubeSupportDialogComponent implements OnInit {

  modalRef: NgbModalRef;
  @ViewChild('IncubeSupportNoteDialog', { static: true }) IncubeSupportNoteDialog: any;
  // @Input() orderId = null;
  OkResult: DialogResult = DialogResult.Ok;
  SupportNote = null;

  constructor(
    private modalService: NgbModal
  ) {
  }

  ngOnInit() {
  }
  ngOnDestroy() {
    this.modalService.dismissAll();
  }
  ngOnChanges() {
    this.SupportNote = null;
  }
  isValid(){
    if(this.SupportNote && this.SupportNote != '' && this.SupportNote.trim() && this.SupportNote.trim() != ''){
      return true;
    }else{
      return false;
    }
  }
  public showDialog() {
    this.SupportNote = '';
    return this.modalService.open(this.IncubeSupportNoteDialog, { centered: true }).result.then(
      (result) => {
        if (result === DialogResult.Ok) {
          return this.SupportNote;
        } else {
          return -1;
        }
      });
  }

}
