import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { Observable } from 'rxjs';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { CoreSession } from '../../../../core/core.session';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { OperatorLoginFailuresService } from '../operatorLoginFailures.service';
import { DialogMode } from '../../../../shared/models/enums/dialog-mode.enum';
import { DialogResult } from '../../../../shared/models/enums/dialog-result.enum';


@Component({
    selector: 'app-operator-login-failures-entry',
    templateUrl: './operator-login-failures-entry.component.html',
    styleUrls: ['./operator-login-failures-entry.component.css']
})
export class OperatorLoginFailuresEntryComponent implements OnInit {

    @Output() onSaveCompleted = new EventEmitter();
    @Input() saveEvent: Observable<void>;
    @Input() operatorObject: any = {};;
    @Input() isViewMode: boolean = false;
    saveBtnSubscription: any;
    dataSource: SharedTableResult = {
        totalItems: 0,
        data: []
    };

    TableProperties: ITableProperties = {
        pageSize: this.coreSession.pageSize,
        showPaginator: false,
        showSearch: false,
        isOnline: false,
        isMultiSelection: false,
        showOptionPerLine: false,
        showEditButton: false,
        rowOperations: [],
        multiSelectionOperations: [],
        columns: [
            {
                title: 'Desc_Machine_Name',
                key: 'machineName',
                isSortable: true,
                width: '75%'
            },
            {
                title: 'Desc_Login_Date',
                key: 'loginDate',
                isSortable: false,
                width: '20%',
                isDate: true
            },
            {
                title: 'Desc_Cleared',
                key: 'isCleared',
                isSortable: false,
                width: '8%',
            },
        ]
    };
    constructor(
        public coreSession: CoreSession,
        private operatorLoginFailuresService: OperatorLoginFailuresService,
        private translateService: TranslateService) {
    }
    ngOnInit() {
        if (this.isViewMode) {
            this.populateOperatorLoginFailuresDetails(this.operatorObject);
        }
    }
    ngOnDestroy() {
        // this.saveBtnSubscription.unsubscribe();
    }
    populateOperatorLoginFailuresDetails(object) {
        this.operatorLoginFailuresService.getOperatorLoginFailuresDetailsSharedTable(object).subscribe(
            (response) => {
                this.coreSession.ModalLoading.Hide();
                this.dataSource = {
                    data: response.data,
                    totalItems: response.data.length
                };
            });
        (error: HttpErrorResponse) => {
            this.coreSession.ModalLoading.Hide();
            this.coreSession.showError(ConstantMessages.ErrorHappened, '');
        };
    }
    onClickUnlock() {
        this.unLockOperator();
    }
    unLockOperator() {
        this.coreSession.ModalDialog.ShowMessage(
            this.translateService.instant(ConstantMessages.MsgUnlockConfirmation),
            DialogMode.YesNo,
            this.translateService.instant(ConstantMessages.Unlock)
        ).then((result: DialogResult) => {
            if (result === DialogResult.Yes) {
                this.coreSession.ModalLoading.Show();
                this.operatorLoginFailuresService.unlockOperator(this.operatorObject)
                    .subscribe(
                        response => {
                            this.coreSession.ModalLoading.Hide();
                            if (response.status != null && response.status >= 0) {
                                this.onSaveCompleted.emit();
                                this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgUnlockedSuccessfully));
                                this.populateOperatorLoginFailuresDetails(this.operatorObject);
                            } else {
                                this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(response.message));
                            }
                        },
                        error => {
                            this.coreSession.ModalLoading.Hide();
                            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
                        }
                    );
            }
        });
    }
}
