import { HttpErrorResponse } from '@angular/common/http';
import { Component, OnInit } from '@angular/core';
import { TranslateService } from '@ngx-translate/core';
import { Subject } from 'rxjs';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { CoreSession } from '../../../../core/core.session';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { MenuActions } from '../../../../shared/models/enums/menu-actions-enum';
import { RowOperation } from '../../../../shared/models/enums/shared-table-operation.enum';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { NavBarService } from '../../../../core/sidebar/sidebar.service';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { OperatorLoginFailuresService } from '../operatorLoginFailures.service';
import { FormControl, FormGroup } from '@angular/forms';
import * as cloneDeep from 'lodash/cloneDeep';
import { NavigationData } from '../../../../shared/models/navigation-data/navigation-data.model';


@Component({
    selector: 'app-operator-login-failures-list',
    templateUrl: './operator-login-failures-list.component.html',
    styleUrls: ['./operator-login-failures-list.component.css']
})
export class OperatorLoginFailuresListComponent implements OnInit {

    saveSubject: Subject<void> = new Subject<void>();
    showOperatorEntrySlider = false;
    isViewMode = false;
    operatorObject: any = null;
    operatorLoginFilterForm: FormGroup;
    operatorNamesList: any[] = [];


    TableData: ITableProperties = {
        pageSize: this.coreSession.pageSize,
        showPaginator: true,
        isOnline: true,
        showSearch: true,
        showSearchBtn: true,
        showNewBtn: false,
        isMultiSelection: false,
        rowOperations: [],
        multiSelectionOperations: [],
        columns: [
            { title: 'Desc_Operator_Name', key: 'operatorName', isSortable: true, width: '50%' },
            { title: 'Desc_Login_Type', key: 'loginType', isSortable: true, width: '30%' },
            { title: 'Desc_Locked', key: 'isLocked', isSortable: true, width: '20%' }
        ]
    };
    dataSource: SharedTableResult = {
        totalItems: 0,
        data: []
    };
    operatorLoginFilter: any = {
        customListFilter: {
            searchFilter: '',
            page: 0,
            pageSize: this.coreSession.pageSize
        },
        operatorId: -1,
    };
    navLinks: any[] = [];
    constructor(
        private coreSession: CoreSession,
        private translateService: TranslateService,
        private operatorLoginFailuresService: OperatorLoginFailuresService,
        private sessionDataProvider: SessionDataProvider,
        private navService: NavBarService) {
    }
    ngOnInit() {
        this.coreSession.SetTitle('Operator Login Failures');
        this.prepareNavigation();
        var index = this.navLinks.findIndex(x => x.link == this.navService.searchMenuURL);
        if (index == -1) index = 0;
        this.navLinks[index].isActive = true;
        this.setNavigation(this.navLinks[index]);
        this.addActions();
        this.fillOperatorNameDataSource();
        this.initFilterForm();
        this.populateOperatorLoginFailuresList();
    }
    prepareNavigation() {
        for (let menu of this.sessionDataProvider.allMenusAvailable) {
            if (menu.menuId === ('900-001-14')) {
                let newName = {
                    label: menu.menuName,
                    isActive: false,
                    hidden: false,
                    disable: false,
                };
                this.navLinks.push(newName);
            }
        }
    }
    addActions() {
        if (this.coreSession.checkActivitiesAvailability(ConstantURLs.operatorLoginFailuresURL, MenuActions.View)) {
            this.TableData.rowOperations.push(
                {
                    operation: RowOperation.View,
                    title: "Desc_View",
                    icon: "fa-regular fa-eye",
                    color: "#12344d"
                });
        }
    }
    populateOperatorLoginFailuresList() {
        this.operatorLoginFilter.operatorId = this.operatorLoginFilterForm.get('operatorId').value ? this.operatorLoginFilterForm.get('operatorId').value : -1;
        this.coreSession.ModalLoading.Show();
        this.operatorLoginFailuresService.getOperatorLoginFailuresListSharedTable(this.operatorLoginFilter).subscribe(response => {
            this.coreSession.ModalLoading.Hide();
            if (response.status != null && response.status >= 0) {
                this.dataSource = {
                    totalItems: response.data.totalItems,
                    data: response.data.data,
                }
            } else {
                this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
            }
        }, (error: HttpErrorResponse) => {
            this.coreSession.ModalLoading.Hide();
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        });
    }
    fillOperatorNameDataSource() {
        this.operatorLoginFailuresService.getOperatorName().subscribe(
            (response) => {
                if (response.status !== null && response.status >= 0) {
                    this.operatorNamesList = response.data;
                } else {
                    this.coreSession.showError(
                        this.translateService.instant(ConstantMessages.ErrorCaption),
                        this.translateService.instant(ConstantMessages.ErrorHappened)
                    );
                }
            }, (error: HttpErrorResponse) => {
                this.coreSession.showError(
                    this.translateService.instant(ConstantMessages.ErrorCaption),
                    this.translateService.instant(ConstantMessages.ErrorHappened)
                );
            }
        )
    }
    onTableFilterChanged(query: any) {
        this.operatorLoginFilter.customListFilter = query;
        this.populateOperatorLoginFailuresList();
    }
    onFindButtonClicked(result) {
        this.operatorLoginFilter.customListFilter.page = 0;
        this.populateOperatorLoginFailuresList();
    }
    onRowOperation(event: any) {
        switch (event.operation) {
            case RowOperation.View:
                this.isViewMode = true;
                this.showOperatorEntrySlider = true;
                this.operatorObject = cloneDeep(event.object);
        }
    }
    closeOperatorEntrySlider() {
        this.isViewMode = false;
        this.operatorObject = null;
        this.showOperatorEntrySlider = false;
        this.coreSession.SetTitle('Operator Login Failures');
    }
    afterUnlockOperator() {
        this.closeOperatorEntrySlider();
        this.populateOperatorLoginFailuresList();
    }
    ngOnDestroy() {
        this.navService.setNavigation([]);
    }
    onChangeSeletedTab(tab) {
        this.setNavigation(tab);
    }
    setNavigation(tab) {
        let navigationList: NavigationData[] = [];
        navigationList.push(
            {
                Name: 'Desc_Settings',
                URL: ConstantURLs.settingsURL
            },
            {
                Name: tab.label,
                URL: undefined
            }
        );
        this.navService.setNavigation(navigationList);
    }
    onReset() {
        this.operatorLoginFilterForm.reset();
    }
    initFilterForm() {
        this.operatorLoginFilterForm = new FormGroup({
            operatorId: new FormControl(),
        })
    }
}

    //#endregion

