import { Injectable, Inject } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { CoreSession } from '../../../core/core.session';
import { ResponseModel } from '../../../shared/models/api-models/api-models';


@Injectable({
  providedIn: 'root'
})
export class OperatorLoginFailuresService {

  httpOptions;
  private url = '';
  constructor(
    private http: HttpClient,
    @Inject("BASE_URL") baseUrl: string,
    private coreSession: CoreSession
  ) {
    this.url = baseUrl + "OperatorLoginFailures/";
    this.httpOptions = {
      headers: new HttpHeaders({
        "Content-Type": "application/json",
      }),
    };
  }
  getOperatorLoginFailuresListSharedTable(filter: any) {
    const urlValue: string = this.url + 'GetOperatorLoginFailuresListSharedTable';
    return this.http.post(urlValue, JSON.stringify(filter), this.httpOptions).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }
  getOperatorLoginFailuresDetailsSharedTable(operatorObject: any) {
    const urlValue = this.url + 'GetOperatorLoginFailuresDetailsSharedTable';
    return this.http.post<ResponseModel>(urlValue, operatorObject).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  }
  getOperatorName() {
    const urlValue = this.url + "GetOperatorNames";
    return this.http.post<ResponseModel>(urlValue, "")
      .map(response => {
        return response;
      });
  }
  unlockOperator(operatorObject: any) {
    const urlValue = this.url + 'UnlockOperator';
    return this.http.post<ResponseModel>(urlValue, operatorObject).map(response => {
      return response;
    });
  }
}
