import { Component, OnInit, ViewChild} from '@angular/core';
import { CoreSession } from '../../../core/core.session';
import { SettingsService } from '../settings.service';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { Router, ActivatedRoute } from '@angular/router';
import { TranslateService } from '@ngx-translate/core';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { DialogResult } from '../../../shared/models/enums/dialog-result.enum';
import { NgbModalConfig, NgbModal } from '@ng-bootstrap/ng-bootstrap';
import { DialogMode } from '../../../shared/models/enums/dialog-mode.enum';

@Component({
  selector: 'app-restore-default-captions',
  templateUrl: './restore-default-captions.component.html',
  styleUrls: ['./restore-default-captions.component.css']
})
export class RestoreDefaultCaptionsComponent implements OnInit {

  @ViewChild('restoreDefaultsDialog', { static: true }) restoreDefaultsDialog: any;
  OkResult: DialogResult = DialogResult.Ok;
  modulesList: any[] = [];
  restoredModulesList: any[] = [];
  selectAll = false;
  constructor(private coreSession: CoreSession,
    private settingService: SettingsService,
    private sessionDataProvider: SessionDataProvider,
    private router: Router,
    private translateService: TranslateService,
    private config: NgbModalConfig,
    private modalService: NgbModal) { }

  ngOnInit() {
    this.getSonicModules();

  }
  onSubmit() {
    this.getRestoredModules();
    if (this.restoredModulesList.length) {
    this.coreSession.ModalDialog.
      ShowMessage(this.translateService.instant(ConstantMessages.Desc_Do_You_Want_To_Restore), DialogMode.YesNo,
        this.translateService.instant(ConstantMessages.WarningCaption))
      .then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.RestoreDefaultDescriptions();
          }
        });
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.Desc_No_Changes_Were_Made));
      }
  }
  getSonicModules() {
    this.coreSession.ModalLoading.Show();
    this.settingService.getAllAvailableModules().subscribe(result => {
      this.coreSession.ModalLoading.Hide();
      this.modulesList = result.data;
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(ConstantMessages.ErrorHappened, '');
    });
  }
  RestoreDefaultDescriptions() {
    this.coreSession.ModalLoading.Show();
    this.settingService.restoreDefaultDescriptions(this.restoredModulesList).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption),
           this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly));
           this.restoredModulesList = [];
           window.location.reload();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption),
         this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  public showDialog() {
    this.restoredModulesList = [];
    return this.modalService.open(this.restoreDefaultsDialog, { centered: true}).result.then(
      (result) => {
        if (result === DialogResult.Ok) {
        } else {
          return -1;
        }
      });
  }
  getRestoredModules() {
    this.modulesList.forEach(module => {
      if ( module['applyReset']) {
         this.restoredModulesList.push(module);
      }
    });
  }
  onSelectAllChange(){
      this.modulesList.forEach(module => {
        module['applyReset'] = this.selectAll;
      });
  }
  onChange() {
    this.modulesList.forEach(module => {
      this.selectAll = false;
    });
}
}
