import { Component, OnInit, OnDestroy, Input, Output, EventEmitter } from '@angular/core';
import { MenuModel } from '../../../../shared/models/menu/menu.model';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { Observable, Subscription } from 'rxjs';
import { SettingsService } from '../../settings.service';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { CoreSession } from '../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { NavBarService } from '../../../../core/sidebar/sidebar.service';
import { MasterDataService } from '../../../master-data-definition/master-data.service';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { DialogMode } from '../../../../shared/models/enums/dialog-mode.enum';
import { DialogResult } from '../../../../shared/models/enums/dialog-result.enum';
import { HttpErrorResponse } from '@angular/common/http';
import { ITextInput } from '../../../../shared/models/shared-table/custom-list.interface';
import { SecurityGroupsModel } from '../../../../shared/models/security-groups/security-groups-model';
import { FormMode } from '../../../../shared/models/enums/form-mode.enum';
import { TextLanguage } from '../../../../shared/models/general/textLanguage.model';
import { SecurityGroupManagementService } from '../../../../shared/services/settings/security-group-management.service';
import { ShepherdService } from 'angular-shepherd';
import { TourService } from '../../../../shared/shepherd-config/shepherd-config';
import { ComponentVisitService } from '../../../../shared/shepherd-config/trackTour.service';


@Component({
  selector: 'app-security-groups-privilege',
  templateUrl: './security-groups-privilege.component.html',
  styleUrls: ['./security-groups-privilege.component.css']
})
export class SecurityGroupsPrivilegeComponent implements OnInit, OnDestroy {
  otherLanguages: any[] = [];
  descriptionLanguages: any[];
  descriptions: any[];
  actionTypesList: any;
  isAddAction: boolean;
  dropDownSettings = {
    singleSelection: false,
    idField: 'actionTypeId',
    textField: 'actionTypeName',
    selectAllText: '',
    unSelectAllText: '',
    position: 'top',
    allowSearchFilter: false,
    searchPlaceholderText: '',
    itemsShowLimit: 2
  };
  securityGroupNameInput: ITextInput = {
    formControlName: "name",
    placeHolder: "Desc_Security_Group_Name",
    label: "Desc_Security_Group_Name"
  };
  isOpened: boolean = false;
  filterThirdLevelMenus: MenuModel[] = [];
  filterSecondLevelMenus: MenuModel[] = [];
  filterFirstLevelMenus: MenuModel[] = [];
  filterForthLevelMenus: MenuModel[] = [];
  filterFivthLevelMenus: MenuModel[] = [];
  filterSixthLevelMenus: MenuModel[] = [];

  originalAddedMenus: MenuModel[] = [];
  addedMenus: MenuModel[] = [];
  allMenusAvailable: MenuModel[] = [];
  isReload: boolean = false;

  // isSecurityGroupLoading: boolean = false;
  isOrganizationLoading: boolean = false;
  // originalSecurityGroupId: number = 1;
  mainOrganizationId: number = 1;
  // newSecurityGroupId: number;
  // securityGroupList: any[] = [];
  organizationList: any[] = [];

  parentMenuId: string = "";
  searchTerm: string;
  descToDisplay: string = "";
  splittedIds: any[];
  saveBtnSubscription: any;
  isAllAvailableChecked: boolean = false;
  isChangesDetected: boolean = false;
  myForm: FormGroup;
  @Input() events: Observable<void>;
  @Input() securityGroupModel: SecurityGroupsModel;
  @Input() mode: FormMode;
  @Input() isClone: boolean;
  @Output() onSaveCompleted = new EventEmitter();

  constructor(private settingService: SettingsService, private sessionDataProvider: SessionDataProvider,
    public coreSession: CoreSession, private translateService: TranslateService,
    private navService: NavBarService,
    private masterDataService: MasterDataService,
    private securityGroupManagementService: SecurityGroupManagementService,
    private shepherdService: ShepherdService,
    private tourService: TourService,
    private componentVisitService: ComponentVisitService
  ) { }

  CheckBoxClicked() {
    this.isOpened = !this.isOpened;
  }
  isDisabled(menu: MenuModel) {
    if (!menu.actionTypes || menu.actionTypes.length === 0) {
      return true;
    } else {
      return false;
    }
  }
  startTour(forceTour?) {
    this.tourStartTimeout = setTimeout((data => {
      if(!forceTour)
      if (this.tourService.isTourCompletedForComponent('security-group-entry')) {
        return;
      }

      if(this.tourService.isFirstTour() || forceTour){
        const elementSelectors = ['#security-def', '#search-def', '#menu-only-def', '#menus-def'
        ]; // Target each column by its uniif(!forceTour)que ID
      const titles = [];
      const texts = [];
      for (let index = 0; index < elementSelectors.length; index++) {
        const { title, text } = this.getTitleAndText(index);
        titles.push(title);
        texts.push(text);
      }
      const steps = this.tourService.generateSteps(elementSelectors, titles, texts);
      this.shepherdService.defaultStepOptions = this.tourService.defaultStepOptions;
      this.shepherdService.modal = true;
      this.shepherdService.addSteps(steps);
      this.shepherdService.start();
    }
    }), 1000)
  }
  private tourStartTimeout: any;
  ngAfterViewInit() {
    this.startTour()
  }
  getTitleAndText(index: number): { title: string, text: string } {
    let title = '';
    let text = '';

    switch (index) {
      case 0:
        title = "Desc_Security_Group_Name";
        text = 'Desc_Define_Security_Group_Name';
        break;
      case 1:
        title = "Desc_Search_Menus";
        text = "Desc_Search_For_Menus";
        break;
      case 2:
        title = `Desc_Show_Selected_Menus_Only`;
        text = `Desc_Show_Selected_Menus_Only`;
        break;
      case 3:
        title = `Desc_Menus`;
        text = `Desc_Select_Menu_And_Privilege`;
        break;
      case 4:
      case 5:
        title = `Step ${index + 1} Title`;
        text = `Step ${index + 1} Content`;
        break;
      default:
        title = `Step ${index + 1}`;
        text = `Content in defult at bottom.`;
    }

    return { title, text };
  }

  operatorid : Number
  tourSubscription:Subscription
  ngOnInit() {

    this.operatorid = this.coreSession.CurrentOperator.operatorId;

    this.coreSession.SetTitle('Security Group Privileges');
    this.initForm();
    if (this.mode === FormMode.Edit) {
      this.fillEditObject();
    }
    this.subscribeSaveClick();
    this.fillOrganizationList();
    this.fillMenuList();
    this.dropDownSettings.selectAllText = this.translateService.instant(ConstantMessages.SelectAllCaption);
    this.dropDownSettings.unSelectAllText = this.translateService.instant(ConstantMessages.UnSelectAllCaption);
    if (this.isClone) {
      this.securityGroupModel.securityGroupId = -1;
    }

    this.tourSubscription = this.tourService.startTourEntry$.subscribe(() => {
      this.startTour(true);
    });

  }
  onOtherLanguagesTextSubmitted(event) {
    this.descriptions = event;
  }


  initForm() {

    this.myForm = new FormGroup({
      name: new FormControl("", Validators.required),
      group: new FormControl(this.coreSession.CurrentOperator.organizationId, Validators.required),
    });
  }

  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
    this.componentVisitService.markComponentVisited('security-group-entry');

    if (this.tourSubscription) {
      this.tourSubscription.unsubscribe();
    }
  }

  isMenuClicked(menu: MenuModel) {
    menu.hide = !menu.hide;
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      this.onSaveClicked();
    });
  }
  isChildMenuClicked(childMenu: MenuModel) {
    childMenu.hideChild = !childMenu.hideChild;
  }
  showAllAvailable() {
    // this.onChangeSecurityGroup(this.newSecurityGroupId, this.isAllAvailableChecked);
    if (this.isAllAvailableChecked) {
      this.originalAddedMenus = JSON.parse(JSON.stringify(this.addedMenus));
      for (let x1 = 0; x1 < this.addedMenus.length; x1++) {
        this.addedMenus = this.addedMenus.filter(x => x.isAvailable);
        for (let x2 = 0; x2 < this.addedMenus[x1].childMenus.length; x2++) {
          this.addedMenus[x1].childMenus = this.addedMenus[x1].childMenus.filter(x => x.isAvailable);
          for (let x3 = 0; x3 < this.addedMenus[x1].childMenus[x2].childMenus.length; x3++) {
            this.addedMenus[x1].childMenus[x2].childMenus = this.addedMenus[x1].childMenus[x2].childMenus.filter(x => x.isAvailable);
            for (let x4 = 0; x4 < this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus.length; x4++) {
              this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus = this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus.filter(x => x.isAvailable);
              for (let x5 = 0; x5 < this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus[x4].childMenus.length; x5++) {
                this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus[x4].childMenus = this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus[x4].childMenus.filter(x => x.isAvailable);
                for (let x6 = 0; x6 < this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus[x4].childMenus[x5].childMenus.length; x6++) {
                  this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus[x4].childMenus[x5].childMenus = this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus[x4].childMenus[x5].childMenus.filter(x => x.isAvailable);

                }
              }
            }
          }
        }
      }
    } else {
      this.addedMenus = JSON.parse(JSON.stringify(this.originalAddedMenus));
    }
  }

  toggleClicked() {
    this.isAllAvailableChecked = !this.isAllAvailableChecked;
  }

  onChangeOrganization(organization: any) {
    this.securityGroupModel.organizationId = organization.organizationId;
  }

  fillOrganizationList() {
    this.organizationList = [];
    this.isOrganizationLoading = true;
    this.masterDataService.getOrganizationList().subscribe(result => {

      this.organizationList = result;
      // if add mode select first elemnt else select saved org id
      this.isOrganizationLoading = false;

      // this.myForm.get('group').setValue(this.mainOrganizationId);
      // this.myForm.get('group').markAsTouched();
    });
  }

  fillEditObject() {
    this.myForm.get('group').setValue(this.securityGroupModel.organizationId);
    if (this.isClone) {
      this.myForm.get('name').setValue(this.translateService.instant(ConstantMessages.Desc_Copied_From) + " " + this.securityGroupModel.securityGroupName);
    } else {
      this.myForm.get('name').setValue(this.securityGroupModel.securityGroupName);
    }
    this.descriptions = this.securityGroupModel.descritpions;
  }

  fillMenuList() {

    this.settingService.getMenusList(this.securityGroupModel.securityGroupId, this.mode).subscribe(result => {
      debugger
      this.allMenusAvailable = result.menusList;
      this.addedMenus = result.addedList;
      this.addedMenus.forEach(x => {
        this.checkIfAllChildsChecked(x, x.parentMenuId);
      });
      this.originalAddedMenus = JSON.parse(JSON.stringify(this.addedMenus));
    });
  }
  checkBoxChanged(menu: MenuModel, isFromAction: boolean, isSelectAllAction: boolean, isParentSelectAll: boolean) {
    let Index = this.allMenusAvailable.findIndex(x => x.menuId === menu.menuId);
    this.isChangesDetected = true;

    this.allAvailableCachingDataChange(menu, Index, isFromAction, isSelectAllAction, isParentSelectAll);

    let splitMenuId = [];
    if (menu.isWebMenu) {
      if (menu.parentMenuId.includes('-')) {
        splitMenuId = menu.parentMenuId.split('-');
      } else {
        splitMenuId[0] = menu.parentMenuId;
      }
    } else {
      if (menu.parentMenus.includes('-')) {
        splitMenuId = menu.parentMenus.split('-');
      } else {
        splitMenuId[0] = menu.parentMenus;
      }
    }
    let firstIndex = -1;

    firstIndex = this.addedMenus.findIndex(x => x.menuId === splitMenuId[0]);
    this.checkIfAllChildsChecked(this.addedMenus[firstIndex], this.addedMenus[firstIndex].parentMenuId);
  }
  selectAllChecked(menu: MenuModel, isSelectChecked: boolean) {
    menu.isSelectAllChecked = !menu.isSelectAllChecked;
    if (menu.isParentMenu && menu.childMenus && menu.childMenus.length > 0) {
      menu.childMenus.forEach(x => {
        if (x.isParentMenu && x.childMenus && x.childMenus.length > 0) {
          this.selectAllChecked(x, isSelectChecked);
        } else {
          this.checkBoxChanged(x, false, true, isSelectChecked);
        }
      });
    }
    // '2100' is the chatting menu ID, the chatting menu is a ParentMenu with no childMenus.
    else if (menu.isParentMenu && menu.menuId === '2100') {
      if (menu.isSelectAllChecked) {
        var menuidx = this.allMenusAvailable.findIndex(m => m.menuId === '2100');
        if (menuidx === -1) {
          this.allMenusAvailable.push(menu);
        }
      } else {
        var menuidx = this.allMenusAvailable.findIndex(m => m.menuId === '2100');
        if (menuidx > -1) {
          this.allMenusAvailable.splice(menuidx, 1);
        }
      }
    }
  }

  checkIfAllChildsChecked(menu: MenuModel, parentId: string) {
    let allMenusAvailable = true;
    let passedParentId = false;
    for (let index = 0; index < menu.childMenus.length; index++) {
      let x = menu.childMenus[index];
      if (x.isParentMenu && x.childMenus && x.childMenus.length > 0) {
        this.checkIfAllChildsChecked(x, parentId);
        if (!x.isSelectAllChecked) {
          allMenusAvailable = false;
          if (this.parentMenuId === x.parentMenuId) {
            passedParentId = true;
          }
        }
      } else {
        if (!x.isAvailable) {
          allMenusAvailable = false;
          if (this.parentMenuId === x.parentMenuId) {
            passedParentId = true;
          }
        }
      }
      if (passedParentId && !allMenusAvailable && this.parentMenuId !== x.parentMenuId) {
        break;
      }
    }
    if (allMenusAvailable) {
      menu.isSelectAllChecked = true;
    } else {
      menu.isSelectAllChecked = false;
    }
    // Chatting menu id is '2100', chatting menu has no child menus
    if (menu.menuId === '2100') {
      menu.isSelectAllChecked = menu.isAvailable;
    }
  }
  onItemSelect(action: any, isAddAction: boolean, menu: MenuModel) {
    this.actionTypesList = action;
    this.isAddAction = isAddAction;
    this.checkBoxChanged(menu, true, false, false);
  }
  onSelectAll(actions: any[], menu: MenuModel) {
    this.actionTypesList = [];
    this.checkBoxChanged(menu, true, true, false);
    let menuIndex = this.allMenusAvailable.findIndex(x => x.menuId === menu.menuId);
    this.allMenusAvailable[menuIndex].addedActionTypes = actions;
  }
  setAddedActions(menu: MenuModel) {
    let menuIndex = this.allMenusAvailable.findIndex(x => x.menuId === menu.menuId);
    if (this.allMenusAvailable[menuIndex].actionTypes
      && this.allMenusAvailable[menuIndex].actionTypes.length > 0
      && this.actionTypesList) {
      let index = this.allMenusAvailable[menuIndex].actionTypes.findIndex(x => x.actionTypeId === this.actionTypesList.actionTypeId);

      if (index > -1) {
        if (!this.isAddAction) {
          this.allMenusAvailable[menuIndex].actionTypes[index].isAdded = false;
          let addedIndex = this.allMenusAvailable[menuIndex].addedActionTypes.findIndex(x => x.actionTypeId === this.actionTypesList.actionTypeId);
          this.allMenusAvailable[menuIndex].addedActionTypes.splice(addedIndex, 1);
        } else if (this.allMenusAvailable[menuIndex].addedActionTypes.findIndex(x => x.actionTypeId === this.actionTypesList.actionTypeId) <= 0) {
          this.allMenusAvailable[menuIndex].actionTypes[index].isAdded = true;
          if (this.allMenusAvailable[menuIndex].addedActionTypes.findIndex(x => x.actionTypeId === this.actionTypesList.actionTypeId) < 0)
            this.allMenusAvailable[menuIndex].addedActionTypes.push(this.actionTypesList);
        }
      }
    }
  }

  setMenusAvailability(splittedMenuIds: string[], numOfLevels: number, menu: MenuModel, isMenuAdded: boolean, isFromAction: boolean) {
    //the original index and menus is added to keep a copy of the main data because when the user search for a menu
    //or show only added menus the system will filter the menus so when he re set the system to show all menus
    //system will keep the edited values.
    //*NOTE: For adding new level you only need to add the next menu sequence eg. fifthIndex and fifthMenu
    //depending on the level before and same goes to the original menu part.
    let firstIndexOriginal = -1;
    let secondIndexOriginal = -1;
    let thirdIndexOriginal = -1;
    let forthIndexOriginal = -1;
    let fivthIndexOriginal = -1;
    let sixthIndexOriginal = -1;
    let firstIndex = -1
    let secondIndex = -1;
    let thirdIndex = -1;
    let forthIndex = -1;
    let fivthIndex = -1;
    let sixthIndex = -1;
    let firstLevelOriginalMenu = new MenuModel;
    let secondLevelOriginalMenu = new MenuModel;
    let thirdLevelOriginalMenu = new MenuModel;
    let forthLevelOriginalMenu = new MenuModel;
    let fivthLevelOriginalMenu = new MenuModel;
    let sixthLevelOriginalMenu = new MenuModel;
    let firstLevelMenu = new MenuModel;
    let secondLevelMenu = new MenuModel;
    let thirdLevelMenu = new MenuModel;
    let forthLevelMenu = new MenuModel;
    let fivthLevelMenu = new MenuModel;
    let sixthLevelMenu = new MenuModel;

    if (1 <= numOfLevels) {//first level

      firstIndexOriginal = this.originalAddedMenus.findIndex(x => x.menuId === splittedMenuIds[0]);
      firstLevelOriginalMenu = this.originalAddedMenus[firstIndexOriginal];
      firstLevelOriginalMenu.isSelectAllChecked = isMenuAdded;
      firstLevelOriginalMenu.isAvailable = isMenuAdded;
      firstIndex = this.addedMenus.findIndex(x => x.menuId === splittedMenuIds[0]);
      firstLevelMenu = this.addedMenus[firstIndex];
      let isAddedChanged = false;
      if (firstLevelMenu.isAvailable !== isMenuAdded) {
        isAddedChanged = true;
      }
      firstLevelMenu.isSelectAllChecked = isMenuAdded;
      firstLevelMenu.isAvailable = isMenuAdded;
      if (firstLevelMenu.actionTypes && firstLevelMenu.actionTypes.length > 0 && isAddedChanged && !isFromAction) {
        firstLevelMenu.addedActionTypes = (isMenuAdded ? firstLevelMenu.actionTypes : []);
        firstLevelOriginalMenu.addedActionTypes = (isMenuAdded ? firstLevelOriginalMenu.actionTypes : []);
      }
    }
    if (2 <= numOfLevels && firstLevelMenu && firstLevelOriginalMenu) {//second level
      secondIndexOriginal = firstLevelOriginalMenu.childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? splittedMenuIds[0] + '-' + splittedMenuIds[1] : splittedMenuIds[1]));
      secondLevelOriginalMenu = firstLevelOriginalMenu.childMenus[secondIndexOriginal];
      secondLevelOriginalMenu.isSelectAllChecked = isMenuAdded;
      secondLevelOriginalMenu.isAvailable = isMenuAdded;
      secondIndex = firstLevelMenu.childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? splittedMenuIds[0] + '-' + splittedMenuIds[1] : splittedMenuIds[1]));
      secondLevelMenu = firstLevelMenu.childMenus[secondIndex];
      let isAddedChanged = false;
      if (secondLevelMenu.isAvailable !== isMenuAdded) {
        isAddedChanged = true;
      }
      secondLevelMenu.isSelectAllChecked = isMenuAdded;
      secondLevelMenu.isAvailable = isMenuAdded;
      if (secondLevelMenu.actionTypes && secondLevelMenu.actionTypes.length > 0 && isAddedChanged && !isFromAction) {
        secondLevelMenu.addedActionTypes = (isMenuAdded ? secondLevelMenu.actionTypes : []);
        secondLevelOriginalMenu.addedActionTypes = (isMenuAdded ? secondLevelOriginalMenu.actionTypes : []);
      }
      this.parentMenuId = splittedMenuIds[0];
    }
    if (3 <= numOfLevels && secondLevelMenu && secondLevelOriginalMenu) {//third level
      thirdIndexOriginal = secondLevelOriginalMenu.childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? splittedMenuIds[0] + '-' + splittedMenuIds[1] + '-' + splittedMenuIds[2] : splittedMenuIds[2]));
      thirdLevelOriginalMenu = secondLevelOriginalMenu.childMenus[thirdIndexOriginal];
      thirdLevelOriginalMenu.isSelectAllChecked = isMenuAdded;
      thirdLevelOriginalMenu.isAvailable = isMenuAdded;

      thirdIndex = secondLevelMenu.childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? splittedMenuIds[0] + '-' + splittedMenuIds[1] + '-' + splittedMenuIds[2] : splittedMenuIds[2]));
      thirdLevelMenu = secondLevelMenu.childMenus[thirdIndex];
      let isAddedChanged = false;
      if (thirdLevelMenu.isAvailable !== isMenuAdded) {
        isAddedChanged = true;
      }
      thirdLevelMenu.isSelectAllChecked = isMenuAdded;
      thirdLevelMenu.isAvailable = isMenuAdded;

      if (thirdLevelMenu.actionTypes && thirdLevelMenu.actionTypes.length > 0 && isAddedChanged && !isFromAction) {
        thirdLevelMenu.addedActionTypes = (isMenuAdded ? thirdLevelMenu.actionTypes : []);
        thirdLevelOriginalMenu.addedActionTypes = (isMenuAdded ? thirdLevelOriginalMenu.actionTypes : []);
      }
      this.parentMenuId = (menu.isWebMenu ? splittedMenuIds[0] + '-' + splittedMenuIds[1] : splittedMenuIds[1]);
    }
    if (4 <= numOfLevels && thirdLevelMenu && thirdLevelOriginalMenu) {//forth level
      forthIndexOriginal = thirdLevelOriginalMenu.childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? splittedMenuIds[0] + '-' + splittedMenuIds[1] + '-' + splittedMenuIds[2] + '-' + splittedMenuIds[3] : splittedMenuIds[3]));
      forthLevelOriginalMenu = thirdLevelOriginalMenu.childMenus[forthIndexOriginal];
      forthLevelOriginalMenu.isSelectAllChecked = isMenuAdded;
      forthLevelOriginalMenu.isAvailable = isMenuAdded;

      forthIndex = thirdLevelMenu.childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? splittedMenuIds[0] + '-' + splittedMenuIds[1] + '-' + splittedMenuIds[2] + '-' + splittedMenuIds[3] : splittedMenuIds[3]));
      forthLevelMenu = thirdLevelMenu.childMenus[forthIndex];
      let isAddedChanged = false;
      if (forthLevelMenu.isAvailable !== isMenuAdded) {
        isAddedChanged = true;
      }
      forthLevelMenu.isSelectAllChecked = isMenuAdded;
      forthLevelMenu.isAvailable = isMenuAdded;

      if (forthLevelMenu.actionTypes && forthLevelMenu.actionTypes.length > 0 && isAddedChanged && !isFromAction) {
        forthLevelMenu.addedActionTypes = (isMenuAdded ? forthLevelMenu.actionTypes : []);
        forthLevelOriginalMenu.addedActionTypes = (isMenuAdded ? forthLevelOriginalMenu.actionTypes : []);
      }
      this.parentMenuId = (menu.isWebMenu ? splittedMenuIds[0] + '-' + splittedMenuIds[1] + '-' + splittedMenuIds[2] : splittedMenuIds[2]);
    }

    if (5 <= numOfLevels && forthLevelMenu && forthLevelOriginalMenu) {//fivth level
      fivthIndexOriginal = forthLevelOriginalMenu.childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? splittedMenuIds[0] + '-' + splittedMenuIds[1] + '-' + splittedMenuIds[2] + '-' + splittedMenuIds[3] + '-' + splittedMenuIds[4] : splittedMenuIds[4]));

      fivthLevelOriginalMenu = forthLevelOriginalMenu.childMenus[fivthIndexOriginal];
      fivthLevelOriginalMenu.isSelectAllChecked = isMenuAdded;
      fivthLevelOriginalMenu.isAvailable = isMenuAdded;


      fivthIndex = forthLevelMenu.childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? splittedMenuIds[0] + '-' + splittedMenuIds[1] + '-' + splittedMenuIds[2] + '-' + splittedMenuIds[3] + '-' + splittedMenuIds[4] : splittedMenuIds[4]));
      fivthLevelMenu = forthLevelMenu.childMenus[fivthIndex];
      let isAddedChanged = false;
      if (fivthLevelMenu.isAvailable !== isMenuAdded) {
        isAddedChanged = true;
      }
      fivthLevelMenu.isSelectAllChecked = isMenuAdded;
      fivthLevelMenu.isAvailable = isMenuAdded;

      if (fivthLevelMenu.actionTypes && fivthLevelMenu.actionTypes.length > 0 && isAddedChanged && !isFromAction) {
        fivthLevelMenu.addedActionTypes = (isMenuAdded ? fivthLevelMenu.actionTypes : []);
        fivthLevelOriginalMenu.addedActionTypes = (isMenuAdded ? fivthLevelOriginalMenu.actionTypes : []);
      }
      this.parentMenuId = (menu.isWebMenu ? splittedMenuIds[0] + '-' + splittedMenuIds[1] + '-' + splittedMenuIds[2] + '-' + splittedMenuIds[3] : splittedMenuIds[3]);
    }
    if (6 <= numOfLevels && fivthLevelMenu && fivthLevelOriginalMenu) {//fivth level
      sixthIndexOriginal = fivthLevelOriginalMenu.childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? splittedMenuIds[0] + '-' + splittedMenuIds[1] + '-' + splittedMenuIds[2] + '-' + splittedMenuIds[3] + '-' + splittedMenuIds[4] + '-' + splittedMenuIds[5] : splittedMenuIds[5]));
      sixthLevelOriginalMenu = fivthLevelOriginalMenu.childMenus[sixthIndexOriginal];
      sixthLevelOriginalMenu.isSelectAllChecked = isMenuAdded;
      sixthLevelOriginalMenu.isAvailable = isMenuAdded;
      sixthIndex = fivthLevelMenu.childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? splittedMenuIds[0] + '-' + splittedMenuIds[1] + '-' + splittedMenuIds[2] + '-' + splittedMenuIds[3] + '-' + splittedMenuIds[4] + '-' + splittedMenuIds[5] : splittedMenuIds[5]));
      sixthLevelMenu = fivthLevelMenu.childMenus[sixthIndex];
      let isAddedChanged = false;
      if (sixthLevelMenu.isAvailable !== isMenuAdded) {
        isAddedChanged = true;
      }
      sixthLevelMenu.isSelectAllChecked = isMenuAdded;
      sixthLevelMenu.isAvailable = isMenuAdded;

      if (sixthLevelMenu.actionTypes && sixthLevelMenu.actionTypes.length > 0 && isAddedChanged && !isFromAction) {
        sixthLevelMenu.addedActionTypes = (isMenuAdded ? sixthLevelMenu.actionTypes : []);
        sixthLevelOriginalMenu.addedActionTypes = (isMenuAdded ? sixthLevelOriginalMenu.actionTypes : []);
      }
      this.parentMenuId = (menu.isWebMenu ? splittedMenuIds[0] + '-' + splittedMenuIds[1] + '-' + splittedMenuIds[2] + '-' + splittedMenuIds[3] + '-' + splittedMenuIds[4] : splittedMenuIds[4]);
    }
  }

  allAvailableCachingDataChange(menu: MenuModel, index: number, isFromAction: boolean, isSelectAllAction: boolean, isParentSelectAll: boolean) {

    if (!menu.isWebMenu) {
      if (menu.parentMenus.includes('-')) {
        this.splittedIds = menu.parentMenus.split('-');
      }
      else {
        this.splittedIds[0] = menu.parentMenus;
      }
    } else {
      if (menu.menuId.includes('-')) {
        this.splittedIds = menu.menuId.split('-');
      }
      else {
        this.splittedIds[0] = menu.menuId;
      }
    }

    if (menu && this.allMenusAvailable.some(menus => menus.menuId.toString() === menu.menuId.toString()) && !isFromAction && !isParentSelectAll) {
      if (this.allMenusAvailable[index].parentMenuId) {
        this.parentMenuId = this.allMenusAvailable[index].parentMenuId;
      }

      //check the split level which will inform us which level is the menu at
      if (this.splittedIds.length === 6) {
        this.setMenusAvailability(this.splittedIds, 6, menu, false, isFromAction);
      }
      if (this.splittedIds.length === 5) {
        this.setMenusAvailability(this.splittedIds, 5, menu, false, isFromAction);
      }
      if (this.splittedIds.length === 4) {

        this.setMenusAvailability(this.splittedIds, 4, menu, false, isFromAction);
        // let firstIndexOriginal = this.originalAddedMenus.findIndex(x => x.menuId === this.splittedIds[0]);
        // let secondIndexOriginal = this.originalAddedMenus[firstIndexOriginal].childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] : this.splittedIds[1]));
        // let thirdIndexOriginal = this.originalAddedMenus[firstIndexOriginal].childMenus[secondIndexOriginal].childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] + '-' + this.splittedIds[2] : this.splittedIds[2]));
        // let forthIndexOriginal = this.originalAddedMenus[firstIndexOriginal].childMenus[secondIndexOriginal].childMenus[thirdIndexOriginal].childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] + '-' + this.splittedIds[2] + '-' + this.splittedIds[3] : this.splittedIds[3]));

        // let firstIndex = this.addedMenus.findIndex(x => x.menuId === this.splittedIds[0]);
        // let secondIndex = this.addedMenus[firstIndex].childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] : this.splittedIds[1]));
        // let thirdIndex = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] + '-' + this.splittedIds[2] : this.splittedIds[2]));
        // let forthIndex = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] + '-' + this.splittedIds[2] + '-' + this.splittedIds[3] : this.splittedIds[3]));

        // let addedMenuOriginal = this.originalAddedMenus[firstIndexOriginal].childMenus[secondIndexOriginal].childMenus[thirdIndexOriginal].childMenus[forthIndexOriginal];
        // let addedMenu = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus[forthIndex];


        // this.parentMenuId = (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] + '-' + this.splittedIds[2] : this.splittedIds[2]);
        // let parentFirstAddedMenu = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex];
        // let parentSecondAddedMenu = this.addedMenus[firstIndex].childMenus[secondIndex];
        // let parentThirdAddedMenu = this.addedMenus[firstIndex];

        // parentFirstAddedMenu.isSelectAllChecked = false;
        // parentSecondAddedMenu.isSelectAllChecked = false;
        // parentThirdAddedMenu.isSelectAllChecked = false;

        // parentFirstAddedMenu.isAvailable = false;
        // parentSecondAddedMenu.isAvailable = false;
        // parentThirdAddedMenu.isAvailable = false;

        // addedMenu.isAvailable = false;
        // addedMenuOriginal.isAvailable = false;
        // addedMenu.addedActionTypes = [];
        // addedMenuOriginal.addedActionTypes = [];
        // this.setAddedActions(addedMenu);
      }
      else
        if (this.splittedIds.length === 3) {
          this.setMenusAvailability(this.splittedIds, 3, menu, false, isFromAction);
        }
        else if (this.splittedIds.length === 2) {
          this.setMenusAvailability(this.splittedIds, 2, menu, false, isFromAction);
        }
        else {
          this.setMenusAvailability(this.splittedIds, 1, menu, false, isFromAction);
        }
      if (index > -1) {
        this.allMenusAvailable.splice(index, 1);
      }
      let isValid: boolean = false;
      if (this.allMenusAvailable.filter(menu => menu.menuId === this.parentMenuId && (menu.childMenus && menu.childMenus.length == 0 || !menu.childMenus)) && this.allMenusAvailable.filter(menu => menu.menuId === this.parentMenuId && (menu.childMenus && menu.childMenus.length == 0 || !menu.childMenus)).length === 1) {
        isValid = true;
      }

      if (!isValid && this.allMenusAvailable.filter(menu => (menu.menuId.includes(this.parentMenuId + '-') && menu.parentMenuId === this.parentMenuId)) && this.allMenusAvailable.filter(menu => (menu.menuId.includes(this.parentMenuId + '-') && menu.parentMenuId === this.parentMenuId)).length === 1) {
        isValid = true;
      }

      if (!isValid && this.allMenusAvailable.filter(menu => (!menu.isWebMenu && menu.parentMenus && menu.parentMenus.includes(this.parentMenuId + '-'))) && this.allMenusAvailable.filter(menu => (!menu.isWebMenu && menu.parentMenus && menu.parentMenus.includes(this.parentMenuId + '-'))).length === 0) {
        isValid = true;
      }

      if (isValid) {

        let Index1 = this.allMenusAvailable.findIndex(x => x.menuId === this.parentMenuId);
        if (!menu.isWebMenu) {
          this.parentMenuId = menu.parentMenus;
        }
        if (this.parentMenuId.includes('-')) {
          if (this.allMenusAvailable.filter(menu => menu.menuId === this.allMenusAvailable[Index1].parentMenuId
            || menu.menuId.includes(this.allMenusAvailable[Index1].menuId + '-')
            || (!menu.isWebMenu && menu.parentMenus && menu.parentMenus.includes(this.allMenusAvailable[Index1].parentMenuId + '-'))).length === 1) {
            this.parentMenuId = this.allMenusAvailable[Index1].parentMenuId;
            if (Index1 > -1) {
              this.allMenusAvailable.splice(Index1, 1);
            }
            Index1 = this.allMenusAvailable.findIndex(x => x.menuId === this.parentMenuId)

            if (Index1 > 0 && menu.parentMenus.split('-').length === 4) {
              if (Index1 > -1) {
                this.allMenusAvailable.splice(Index1, 1);
              }
              Index1 = this.allMenusAvailable.findIndex(x => x.menuId === this.parentMenuId);
            }
          }
        }

        if (Index1 > -1 && this.allMenusAvailable.filter(x => x.parentMenuId === this.parentMenuId).length <= 0) {

          this.allMenusAvailable.splice(Index1, 1);


          if (menu.parentMenuIdsList
            && menu.parentMenuIdsList.length > 0
            && this.allMenusAvailable.filter(x => x.menuId === menu.parentMenuIdsList[0]).length === 1
            && this.allMenusAvailable.filter(x => x.parentMenuId === menu.parentMenuIdsList[0]).length === 0) {
            let finalIndex = this.allMenusAvailable.findIndex(x => x.menuId === menu.parentMenuIdsList[0]);
            if (finalIndex >= 0) {
              this.allMenusAvailable.splice(finalIndex, 1);
            }
          }
        }
      }
    }//remove the available menu when unchecked
    else {
      //add the menu to the allmenusAvailable which will give the user access directly to the added menu
      if (this.splittedIds.length > 1) {
        if (menu.isWebMenu) {
          this.splittedIds = menu.menuId.split('-');
        } else {
          this.splittedIds = menu.parentMenus.split('-');
        }
        if (menu && (this.allMenusAvailable.filter(menus => menus.parentMenuId === menu.parentMenuId).length === 0) || this.allMenusAvailable.length === 0) {
          let firstIndex = -1;
          let secondIndex = -1;
          let thirdIndex = -1;
          let forthIndex = -1;
          let fivthIndex = -1;
          let sixthIndex = -1;
          firstIndex = this.addedMenus.findIndex(x => x.menuId === this.splittedIds[0]);
          if (firstIndex > -1)
            secondIndex = this.addedMenus[firstIndex].childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] : this.splittedIds[1]));
          if (secondIndex > -1)
            thirdIndex = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] + '-' + this.splittedIds[2] : this.splittedIds[2]));
          if (thirdIndex > -1)
            forthIndex = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] + '-' + this.splittedIds[2] + '-' + this.splittedIds[3] : this.splittedIds[3]));
          if (forthIndex > -1)
            fivthIndex = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus[forthIndex].childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] + '-' + this.splittedIds[2] + '-' + this.splittedIds[3] + '-' + this.splittedIds[4] : this.splittedIds[4]));
          if (fivthIndex > -1)
            sixthIndex = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus[forthIndex].childMenus[fivthIndex].childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] + '-' + this.splittedIds[2] + '-' + this.splittedIds[3] + '-' + this.splittedIds[4] + '-' + this.splittedIds[5] : this.splittedIds[5]));
          if (!this.allMenusAvailable.find(x => x.menuId === this.addedMenus[firstIndex].menuId)) {
            this.allMenusAvailable.push(this.coreSession.cloneObject(this.addedMenus[firstIndex]));
          }
          if (!this.allMenusAvailable.find(x => x.menuId === this.addedMenus[firstIndex].childMenus[secondIndex].menuId)) {
            this.allMenusAvailable.push(this.coreSession.cloneObject(this.addedMenus[firstIndex].childMenus[secondIndex]));
          }

          if (thirdIndex > -1 && !this.allMenusAvailable.find(x => x.menuId === this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].menuId)) {
            this.allMenusAvailable.push(this.coreSession.cloneObject(this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex]));
          }
          if (forthIndex > -1 && !this.allMenusAvailable.find(x => x.menuId === this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus[forthIndex].menuId)) {

            this.allMenusAvailable.push(this.coreSession.cloneObject(this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus[forthIndex]));
          }

          if (fivthIndex > -1 && !this.allMenusAvailable.find(x => x.menuId === this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus[forthIndex].childMenus[fivthIndex].menuId)) {

            this.allMenusAvailable.push(this.coreSession.cloneObject(this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus[forthIndex].childMenus[fivthIndex]));
          }

          //if (sixthIndex > -1 && !this.allMenusAvailable.find(x => x.menuId === this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus[forthIndex].childMenus[fivthIndex].childMenus[sixthIndex].menuId)) {
          //  this.allMenusAvailable.push(this.coreSession.cloneObject(this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus[forthIndex].childMenus[fivthIndex].childMenus[sixthIndex]));
          //}
          let allMenusIndex = this.allMenusAvailable.findIndex(x => x.menuId === menu.parentMenuId);
          let allParentMenusIndex = this.allMenusAvailable.findIndex(x => x.menuId === this.splittedIds[0]);

          this.allMenusAvailable[allMenusIndex].childMenus = null;
          this.allMenusAvailable[allParentMenusIndex].childMenus = null;
        }
      } else {
        if (menu && (this.allMenusAvailable.filter(menus => menus.menuId.toString().includes(menu.parentMenuId.toString())).length === 0) || this.allMenusAvailable.length === 0) {

          let addedIndex = this.addedMenus.findIndex(x => x.menuId === menu.parentMenuId);
          if (!this.allMenusAvailable.find(x => x.menuId === this.addedMenus[addedIndex].menuId)) {
            this.allMenusAvailable.push(this.coreSession.cloneObject(this.addedMenus[addedIndex]));
          }
          let allMenusIndex = this.allMenusAvailable.findIndex(x => x.menuId === menu.parentMenuId);
          this.allMenusAvailable[allMenusIndex].childMenus = null;
        }
      }
      if (!this.allMenusAvailable.find(x => x.menuId === menu.menuId)) {
        this.allMenusAvailable.push(this.coreSession.cloneObject(menu));
      }

      let Index = this.allMenusAvailable.findIndex(x => x.menuId === menu.menuId);
      let addedMenu = this.allMenusAvailable[Index];
      addedMenu.isAvailable = true;
      addedMenu.childMenus = null;
      //check the split level which will inform us which level is the menu at
      if (this.splittedIds.length === 6) {
        this.setMenusAvailability(this.splittedIds, 6, menu, true, isFromAction);
      }
      else if (this.splittedIds.length === 5) {
        this.setMenusAvailability(this.splittedIds, 5, menu, true, isFromAction);
      }
      else if (this.splittedIds.length === 4) {
        this.setMenusAvailability(this.splittedIds, 4, menu, true, isFromAction);
        // let firstIndexOriginal = this.originalAddedMenus.findIndex(x => x.menuId === this.splittedIds[0]);
        // let secondIndexOriginal = this.originalAddedMenus[firstIndexOriginal].childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] : this.splittedIds[1]));
        // let thirdIndexOriginal = this.originalAddedMenus[firstIndexOriginal].childMenus[secondIndexOriginal].childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] + '-' + this.splittedIds[2] : this.splittedIds[2]));
        // let forthIndexOriginal = this.originalAddedMenus[firstIndexOriginal].childMenus[secondIndexOriginal].childMenus[thirdIndexOriginal].childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] + '-' + this.splittedIds[2] + '-' + this.splittedIds[3] : this.splittedIds[3]));

        // let firstIndex = this.addedMenus.findIndex(x => x.menuId === this.splittedIds[0]);
        // let secondIndex = this.addedMenus[firstIndex].childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] : this.splittedIds[1]));
        // let thirdIndex = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] + '-' + this.splittedIds[2] : this.splittedIds[2]));
        // let forthIndex = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus.findIndex(x => x.menuId === (menu.isWebMenu ? this.splittedIds[0] + '-' + this.splittedIds[1] + '-' + this.splittedIds[2] + '-' + this.splittedIds[3] : this.splittedIds[3]));

        // let addedMenuOriginal = this.originalAddedMenus[firstIndexOriginal].childMenus[secondIndexOriginal].childMenus[thirdIndexOriginal].childMenus[forthIndexOriginal];
        // let addedMenu = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus[forthIndex];

        // let parentFirstAddedMenu = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex];
        // let parentSecondAddedMenu = this.addedMenus[firstIndex].childMenus[secondIndex];
        // let parentThirdAddedMenu = this.addedMenus[firstIndex];

        // parentFirstAddedMenu.isSelectAllChecked = true;
        // parentSecondAddedMenu.isSelectAllChecked = true;
        // parentThirdAddedMenu.isSelectAllChecked = true;

        // parentFirstAddedMenu.isAvailable = true;
        // parentSecondAddedMenu.isAvailable = true;
        // parentThirdAddedMenu.isAvailable = true;

        // if (addedMenu.actionTypes && addedMenu.actionTypes.length > 0 && !addedMenu.isAvailable) {
        //   addedMenu.addedActionTypes = addedMenu.actionTypes;
        //   addedMenuOriginal.addedActionTypes = addedMenu.actionTypes;
        // }
        // addedMenuOriginal.isAvailable = true;
        // addedMenu.isAvailable = true;
      }
      else if (this.splittedIds.length === 3) {
        this.setMenusAvailability(this.splittedIds, 3, menu, true, isFromAction);
      }
      else if (this.splittedIds.length === 2) {
        this.setMenusAvailability(this.splittedIds, 2, menu, true, isFromAction);
      }
      else {
        this.setMenusAvailability(this.splittedIds, 1, menu, true, isFromAction);
      }
    }//add the checked menu and set the checkboxes to available
    let menuIndex = this.allMenusAvailable.findIndex(x => x.menuId === menu.menuId);

    if (menuIndex >= 0) {
      if (!isFromAction) {
        this.allMenusAvailable[menuIndex].addedActionTypes = menu.addedActionTypes.map(x => Object.assign({}, x));
      } else {
        this.setAddedActions(menu);
      }
    }
  }

  checkIsValid() {
    if (!this.myForm.get('name').value || this.myForm.get('name').value === '') {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.EnterSecurityGroupName));
      return false;
    }
    // else if (!this.securityGroupModel.organizationId || this.securityGroupModel.organizationId === -1) {
    //   this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.SelectOrganization));
    //   return false;
    // }
    return true;
  }

  onSaveClicked() {
    if (this.checkIsValid()) {
      this.saveGroupToDB();
      // this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.SelectSecurityGroup));
      // return;
    }
  }

  saveGroupToDB() {
    let descriptions = this.descriptions;
    if (descriptions.findIndex(x => x.languageId === this.coreSession.selectedLanguageId) < 0) {
      descriptions.push({
        languageId: this.coreSession.selectedLanguageId,
        description: this.myForm.get('name').value,
        securityGroupId: -1
      });
    }
    let securityGroupMenusAndID = {
      descriptions: descriptions,
      menus: this.allMenusAvailable,
      securityGroupId: this.securityGroupModel.securityGroupId,
      organizationId: this.securityGroupModel.organizationId
    };
    this.securityGroupManagementService.saveSecurityGroup(securityGroupMenusAndID).subscribe(response => {
      if (response.status != null && response.status >= 0) {
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
        this.isReload = true;
        this.allMenusAvailable.sort((a, b) => (a.menuId > b.menuId) ? 1 : ((b.menuId > a.menuId) ? -1 : 0));
        this.sessionDataProvider.allMenusAvailable = this.allMenusAvailable;
        this.isAllAvailableChecked = false;
        // this.onChangeSecurityGroup(this.originalSecurityGroupId);
        this.onSaveCompleted.emit();
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();

        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  searchData() {

    if (this.searchTerm !== "") {
      this.filterFirstLevelMenus = [];
      this.filterSecondLevelMenus = [];
      this.filterThirdLevelMenus = [];
      this.filterForthLevelMenus = [];
      this.filterFivthLevelMenus = [];
      this.filterSixthLevelMenus = [];
      // this.addedMenus = this.originalAddedMenus.map(x => Object.assign({}, x));
      this.addedMenus = JSON.parse(JSON.stringify(this.originalAddedMenus));
      for (let x1 = 0; x1 < this.addedMenus.length; x1++) {
        //second level
        for (let x2 = 0; x2 < this.addedMenus[x1].childMenus.length; x2++) {
          //third level
          for (let x3 = 0; x3 < this.addedMenus[x1].childMenus[x2].childMenus.length; x3++) {
            //forth level
            for (let x4 = 0; x4 < this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus.length; x4++) {
              //fivth level
              for (let x5 = 0; x5 < this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus[x4].childMenus.length; x5++) {
                //sixth level
                for (let x6 = 0; x6 < this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus[x4].childMenus[x5].childMenus.length; x6++) {

                  if (this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus[x4].childMenus[x5].childMenus[x6].menuName.toLowerCase().includes(this.searchTerm.toLowerCase())) {
                    if (this.filterSixthLevelMenus.findIndex(x => x.menuId === this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus[x4].childMenus[x5].childMenus[x6].menuId) < 0) {
                      this.filterSixthLevelMenus.push(this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus[x4].childMenus[x5].childMenus[x6]);
                    }
                  }
                }

                if (this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus[x4].childMenus[x5].menuName.toLowerCase().includes(this.searchTerm.toLowerCase())) {
                  if (this.filterFivthLevelMenus.findIndex(x => x.menuId === this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus[x4].childMenus[x5].menuId) < 0) {
                    this.filterFivthLevelMenus.push(this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus[x4].childMenus[x5]);
                  }
                }
              }
              if (this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus[x4].menuName.toLowerCase().includes(this.searchTerm.toLowerCase())) {
                if (this.filterForthLevelMenus.findIndex(x => x.menuId === this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus[x4].menuId) < 0) {
                  this.filterForthLevelMenus.push(this.addedMenus[x1].childMenus[x2].childMenus[x3].childMenus[x4]);
                }
              }
            }
            if (this.addedMenus[x1].childMenus[x2].childMenus[x3].menuName.toLowerCase().includes(this.searchTerm.toLowerCase())) {
              if (this.filterThirdLevelMenus.findIndex(x => x.menuId === this.addedMenus[x1].childMenus[x2].childMenus[x3].menuId) < 0) {
                this.filterThirdLevelMenus.push(this.addedMenus[x1].childMenus[x2].childMenus[x3]);
              }
            }
          }
          if (this.addedMenus[x1].childMenus[x2].menuName.toLowerCase().includes(this.searchTerm.toLowerCase())) {
            if (this.filterSecondLevelMenus.findIndex(x => x.menuId === this.addedMenus[x1].childMenus[x2].menuId) < 0) {
              this.filterSecondLevelMenus.push(this.addedMenus[x1].childMenus[x2]);
            }
          }
        }
        if (this.addedMenus[x1].menuName.toLowerCase().includes(this.searchTerm.toLowerCase())) {
          if (this.filterFirstLevelMenus.findIndex(x => x.menuId === this.addedMenus[x1].menuId) < 0) {
            this.filterFirstLevelMenus.push(this.addedMenus[x1]);
          }
        }
      }

      if (this.filterSixthLevelMenus.length > 0) {
        for (let x6 = 0; x6 < this.filterSixthLevelMenus.length; x6++) {
          if (this.filterFivthLevelMenus.filter(x => x.menuId === this.filterSixthLevelMenus[x6].parentMenuId).length < 1) {
            let splittedIDs = this.filterSixthLevelMenus[x6].isWebMenu ? this.filterSixthLevelMenus[x6].parentMenuId.split('-') : this.filterSixthLevelMenus[x6].parentMenus.split('-');
            let firstIndex = this.addedMenus.findIndex(x => x.menuId === splittedIDs[0]);
            let secondIndex = this.addedMenus[firstIndex].childMenus.findIndex(x => x.menuId === (x.isWebMenu ? splittedIDs[0] + '-' + splittedIDs[1] : splittedIDs[1]));
            let thirdIndex = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus.findIndex(x => x.menuId === (x.isWebMenu ? splittedIDs[0] + '-' + splittedIDs[1] + '-' + splittedIDs[2] : splittedIDs[2]));
            let forthIndex = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus.findIndex(x => x.menuId === (x.isWebMenu ? splittedIDs[0] + '-' + splittedIDs[1] + '-' + splittedIDs[2] + '-' + splittedIDs[3] : splittedIDs[3]));
            let fivthIndex = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus[forthIndex].childMenus.findIndex(x => x.menuId === (x.isWebMenu ? splittedIDs[0] + '-' + splittedIDs[1] + '-' + splittedIDs[2] + '-' + splittedIDs[3] + '-' + splittedIDs[4] : splittedIDs[4]));

            this.filterFivthLevelMenus.push(this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus[forthIndex].childMenus[fivthIndex]);
            let sixthIndex = this.filterFivthLevelMenus.findIndex(x => x.menuId === (x.isWebMenu ? splittedIDs[0] + '-' + splittedIDs[1] + '-' + splittedIDs[2] + '-' + splittedIDs[3] + '-' + splittedIDs[4] : splittedIDs[4]));
            this.filterFivthLevelMenus[sixthIndex].childMenus = this.filterSixthLevelMenus.filter(x => (x.isWebMenu ? x.menuId : x.parentMenuIdsList).includes(this.filterFivthLevelMenus[sixthIndex].menuId));
          }

        }
      }

      if (this.filterFivthLevelMenus.length > 0) {
        for (let x5 = 0; x5 < this.filterFivthLevelMenus.length; x5++) {
          if (this.filterForthLevelMenus.filter(x => x.menuId === this.filterFivthLevelMenus[x5].parentMenuId).length < 1) {
            let splittedIDs = this.filterFivthLevelMenus[x5].isWebMenu ? this.filterFivthLevelMenus[x5].parentMenuId.split('-') : this.filterFivthLevelMenus[x5].parentMenus.split('-');
            let firstIndex = this.addedMenus.findIndex(x => x.menuId === splittedIDs[0]);
            let secondIndex = this.addedMenus[firstIndex].childMenus.findIndex(x => x.menuId === (x.isWebMenu ? splittedIDs[0] + '-' + splittedIDs[1] : splittedIDs[1]));
            let thirdIndex = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus.findIndex(x => x.menuId === (x.isWebMenu ? splittedIDs[0] + '-' + splittedIDs[1] + '-' + splittedIDs[2] : splittedIDs[2]));
            let forthIndex = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus.findIndex(x => x.menuId === (x.isWebMenu ? splittedIDs[0] + '-' + splittedIDs[1] + '-' + splittedIDs[2] + '-' + splittedIDs[3] : splittedIDs[3]));

            this.filterForthLevelMenus.push(this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex].childMenus[forthIndex]);
            let fivthIndex = this.filterForthLevelMenus.findIndex(x => x.menuId === (x.isWebMenu ? splittedIDs[0] + '-' + splittedIDs[1] + '-' + splittedIDs[2] + '-' + splittedIDs[3] : splittedIDs[3]));
            this.filterForthLevelMenus[fivthIndex].childMenus = this.filterFivthLevelMenus.filter(x => (x.isWebMenu ? x.menuId : x.parentMenuIdsList).includes(this.filterForthLevelMenus[fivthIndex].menuId));


          }

        }
      }

      if (this.filterForthLevelMenus.length > 0) {
        for (let x4 = 0; x4 < this.filterForthLevelMenus.length; x4++) {
          if (this.filterThirdLevelMenus.filter(x => x.menuId === this.filterForthLevelMenus[x4].parentMenuId).length < 1) {
            let splittedIDs = this.filterForthLevelMenus[x4].isWebMenu ? this.filterForthLevelMenus[x4].parentMenuId.split('-') : this.filterForthLevelMenus[x4].parentMenus.split('-');
            let firstIndex = this.addedMenus.findIndex(x => x.menuId === splittedIDs[0]);

            let secondIndex = this.addedMenus[firstIndex].childMenus.findIndex(x => x.menuId === (x.isWebMenu ? splittedIDs[0] + '-' + splittedIDs[1] : splittedIDs[1]));
            let thirdIndex = this.addedMenus[firstIndex].childMenus[secondIndex].childMenus.findIndex(x => x.menuId === (x.isWebMenu ? splittedIDs[0] + '-' + splittedIDs[1] + '-' + splittedIDs[2] : splittedIDs[2]));
            this.filterThirdLevelMenus.push(this.addedMenus[firstIndex].childMenus[secondIndex].childMenus[thirdIndex]);
            let forthIndex = this.filterThirdLevelMenus.findIndex(x => x.menuId === (x.isWebMenu ? splittedIDs[0] + '-' + splittedIDs[1] + '-' + splittedIDs[2] : splittedIDs[2]));
            this.filterThirdLevelMenus[forthIndex].childMenus = this.filterForthLevelMenus.filter(x => (x.isWebMenu ? x.menuId : x.parentMenuIdsList).includes(this.filterThirdLevelMenus[forthIndex].menuId));
          }
        }
      }

      if (this.filterThirdLevelMenus.length > 0) {
        for (let x3 = 0; x3 < this.filterThirdLevelMenus.length; x3++) {
          if (this.filterSecondLevelMenus.filter(x => x.menuId === this.filterThirdLevelMenus[x3].parentMenuId).length < 1) {
            let splittedIDs = this.filterThirdLevelMenus[x3].isWebMenu ? this.filterThirdLevelMenus[x3].parentMenuId.split('-') : this.filterThirdLevelMenus[x3].parentMenus.split('-');
            let index = this.addedMenus.findIndex(x => x.menuId === splittedIDs[0]);
            let childIndex = this.addedMenus[index].childMenus.findIndex(x => x.menuId === this.filterThirdLevelMenus[x3].parentMenuId);
            this.filterSecondLevelMenus.push(this.addedMenus[index].childMenus[childIndex]);
            let childOfChildIndex = this.filterSecondLevelMenus.findIndex(x => x.menuId === this.filterThirdLevelMenus[x3].parentMenuId);
            this.filterSecondLevelMenus[childOfChildIndex].childMenus = this.filterThirdLevelMenus.filter(x => (x.isWebMenu ? x.menuId : x.parentMenuIdsList).includes(this.filterSecondLevelMenus[childOfChildIndex].menuId));
          }
        }
      }

      if (this.filterSecondLevelMenus.length > 0) {
        for (let x2 = 0; x2 < this.filterSecondLevelMenus.length; x2++) {
          if (this.filterFirstLevelMenus.filter(x => x.menuId === this.filterSecondLevelMenus[x2].parentMenuId).length < 1) {
            let index = this.addedMenus.findIndex(x => x.menuId === this.filterSecondLevelMenus[x2].parentMenuId);
            this.filterFirstLevelMenus.push(this.addedMenus[index]);
            let childIndex = this.filterFirstLevelMenus.indexOf(this.addedMenus[index])
            this.filterFirstLevelMenus[childIndex].childMenus = this.filterSecondLevelMenus.filter(x => x.parentMenuIdsList.includes(this.filterFirstLevelMenus[childIndex].menuId));
          }
        }
      }
      this.addedMenus = this.filterFirstLevelMenus.map(x => Object.assign({}, x));
    } else {
      this.addedMenus = this.originalAddedMenus.map(x => Object.assign({}, x));
    }
    if (!this.addedMenus || this.addedMenus.length < 1) {
      this.descToDisplay = "Desc_No_Menus_Found";
    }
  }
}
