import { Component, OnDestroy, OnInit, ViewChild } from '@angular/core';
import { EmailService } from '../../email/email.service';
import { CoreSession } from '../../../../core/core.session';
import { TranslateService } from '@ngx-translate/core';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { Subject } from 'rxjs';
import { RowOperation } from '../../../../shared/models/enums/shared-table-operation.enum';
import { SecurityGroupsModel } from '../../../../shared/models/security-groups/security-groups-model';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { SettingsService } from '../../settings.service';
import { FormMode } from '../../../../shared/models/enums/form-mode.enum';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { Router, ActivatedRoute } from '@angular/router';
import { NavBarService } from '../../../../core/sidebar/sidebar.service';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { MenuActions } from '../../../../shared/models/enums/menu-actions-enum';
import { HttpErrorResponse } from '@angular/common/http';
import { DialogResult } from '../../../../shared/models/enums/dialog-result.enum';
import { DialogMode } from '../../../../shared/models/enums/dialog-mode.enum';
import { NavigationData } from '../../../../shared/models/navigation-data/navigation-data.model';
import { SecurityGroupManagementService } from '../../../../shared/services/settings/security-group-management.service';
import { SharedDialogComponent } from '../../../../shared/components/shared-dialog/shared-dialog.component';

@Component({
  selector: 'app-security-groups-privilege-list',
  templateUrl: './security-groups-privilege-list.component.html',
  styleUrls: ['./security-groups-privilege-list.component.css']
})
export class SecurityGroupsPrivilegeListComponent implements OnInit, OnDestroy {

  constructor(private settingsService: SettingsService,
    public coreSession: CoreSession,
    private translateService: TranslateService,
    private router: Router,
    private route: ActivatedRoute,
    private navService: NavBarService,
    private sessionDataProvider: SessionDataProvider,
    private securityGroupManagementService: SecurityGroupManagementService,
  ) { }

  headerString = "Desc_SecurityGroup_Management";
  @ViewChild('ItemEntryDialog', { static: true }) ItemEntryDialog: SharedDialogComponent;

  TableData: ITableProperties = {
    pageSize: 50,
    showPaginator: true,
    showSearch: true,
    isOnline: false,
    showSearchBtn: false,
    showNewBtn: true,
    rowOperations: [
    ],
    multiSelectionOperations: [],
    columns: [
      {
        title: 'Desc_Security_Group_Name',
        key: 'securityGroupName',
        isSortable: true,
        width: '50%'
      },
      {
        title: 'Desc_Vendor',
        key: 'organizationNameCode',
        isSortable: true,
        width: '50%'
      }
    ]
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  formMode: FormMode;
  showNewSlider = false;
  isClone: boolean = false;
  saveSubject: Subject<void> = new Subject<void>();
  securityGroupModel: SecurityGroupsModel;
  navLinks: any[];

  showSharedTable = true
  ngOnInit() {
    this.prepareNavigation();
    var index = this.navLinks.findIndex(x => x.link == this.navService.searchMenuURL);
    if (index == -1) index = 0;
    this.navLinks[index].isActive = true;
    this.setNavigation(this.navLinks[index]);
    this.coreSession.SetTitle('Security');
    this.populateTable();

    this.TableData.rowOperations.push({
      operation: RowOperation.delete,
      title: "Desc_Delete",
      icon: "fa-solid fa-trash",
      color: "#f1685e"
    });
    this.TableData.rowOperations.push({
      operation: RowOperation.edit,
      title: "Desc_Edit",
      icon: "fa-regular fa-pen-to-square",
      color: "#12344d"
    });
    this.TableData.rowOperations.push(
      {
        operation: RowOperation.Clone,
        title: 'Desc_Clone',
        icon: 'fa fa-clone',
        color: '#12344d',
      });
  }
  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_SecurityGroup_Management',
        index: 0,
        isActive: true,
      }
    ];
  }

  openItemEntryDialog() {
    this.ItemEntryDialog.Show(true).then((res) => { });
  }
  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.edit:
        if (event && event.object) {
          this.formMode = FormMode.Edit;
          this.securityGroupModel = event.object;
          this.showNewSlider = true;
          this.openItemEntryDialog()
        }
        break;
      case RowOperation.delete:
          this.onDeleteSecurityGroup(event.object.securityGroupId);

        break;
      case RowOperation.Clone:
        this.formMode = FormMode.Edit;
        this.securityGroupModel = event.object;
        this.isClone = true
        this.showNewSlider = true;
        this.openItemEntryDialog()

        break;
    }
  }

  onDeleteSecurityGroup(selectedSecurityGroupId: any) {
    this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgDeleteConfirmation), DialogMode.YesNo
      , this.translateService.instant(ConstantMessages.Delete))
      .then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {

            this.coreSession.ModalLoading.Show();

            this.securityGroupManagementService.deleteSecurityGroup(selectedSecurityGroupId).subscribe(response => {
              this.coreSession.ModalLoading.Hide();
              if (response.status != null && response.status >= 0) {
                this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgDeletedSuccessfully));
                this.populateTable();
              } else {
                this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
              }
            },
              (error: HttpErrorResponse) => {
                this.coreSession.ModalLoading.Hide();
                this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorCaption));
              }
            );
          }
        });
  }

  onGenerateClicked() {
    this.securityGroupModel = new SecurityGroupsModel();
    this.formMode = FormMode.Add;
    this.showNewSlider = true;
    this.showSharedTable = false
    this.openItemEntryDialog()
  }

  closeSlider() {
    this.showNewSlider = false;
    this.isClone = false;
    this.showSharedTable = true
    this.ItemEntryDialog.Close()
  }

  onSaveClick() {
    this.saveSubject.next();
    // this.showNewSlider = false;
  }

  onSaveCompleted() {
    var previousChattingState = false;
    var idx = this.sessionDataProvider.addedMenus.findIndex(menu => menu.menuId === '2100' && menu.isAvailable);
    if (idx > -1) {
      previousChattingState = true;
    }
    this.settingsService.getMenusList(-1, FormMode.None).subscribe(result => {
      this.sessionDataProvider.allMenusAvailable = result.menusList;
      this.sessionDataProvider.addedMenus = result.addedList;

      this.checkChattingSGAvailability(previousChattingState);
      this.navService.setReloadSidebar();
      if (this.sessionDataProvider.allMenusAvailable.length < 1) {
        this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.NoMenusAvailable));
        this.router.navigate(['/' + ConstantURLs.noMenusURL]);
      }
    });
    this.closeSlider();
    this.populateTable();
    this.showSharedTable = true
  }

  checkChattingSGAvailability(previousChattingState: boolean) {
    var newChattingState = false;
    var idx = this.sessionDataProvider.addedMenus.findIndex(menu => menu.menuId === '2100' && menu.isAvailable);
    if (idx > -1) {
      newChattingState = true;
    }

  }

  changeSecurityGroupPrivilegesValue() {

    // this.changeSecurityGroupPrivileges = true;
    // this.showSlider = true;
    // this.sliderDescription = this.translateService.instant("Desc_SecurityGroup_Management")
  }

  onTableFilterChanged(event) {
  }

  populateTable() {
    this.securityGroupManagementService.getAllAvailableSecurityGroups().subscribe(response => {
      if (response.status != null && response.status >= 0) {
        this.dataSource = {
          data: response.data,
          totalItems: response.data.length
        };
      } else {
        this.coreSession.showError(response.message, '');
      }
    },
      error => {
        this.coreSession.showError(ConstantMessages.ErrorHappened, '');
      });
  }
  ngOnDestroy() {
    this.navService.setNavigation([]);
  }
  onChangeSeletedTab(tab) {
    this.setNavigation(tab);
  }
  setNavigation(tab) {
    let navigationList: NavigationData[] = [];
    navigationList.push(
      {
        Name: 'Desc_Settings',
        URL: ConstantURLs.settingsURL
      },
      {
        Name: tab.label,
        URL: undefined
      }
    );
    this.navService.setNavigation(navigationList);
  }

}
