import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { AuthGuard } from '../../core/auth/auth.gurad';
import { ConstantURLs } from '../../shared/models/constants/constant-URL';
import { ChattingComponent } from './chatting/chatting.component';

const chattingRouting: Routes = [
  { path: '',
    canActivate: [AuthGuard],
    component: ChattingComponent,
    children: [
      { path: '', redirectTo: '/' + ConstantURLs.chattingURL , pathMatch: 'full' }
    ]
   }
];

@NgModule({
  imports: [RouterModule.forChild(chattingRouting)],
  exports: [RouterModule]
})
export class ChattingRoutingModule { }
