import { NgModule } from "@angular/core";
import { CommonModule } from "@angular/common";
import { TranslateModule } from "@ngx-translate/core";
import { NgbTooltipModule, NgbModule } from "@ng-bootstrap/ng-bootstrap";
import { ReactiveFormsModule, FormsModule } from "@angular/forms";
import { NgSelectModule } from "@ng-select/ng-select";
import { NgMultiSelectDropDownModule } from "ng-multiselect-dropdown";
import { NgOptionHighlightModule } from "@ng-select/ng-option-highlight";
import { MatListModule } from '@angular/material/list';
import { MatIconModule } from "@angular/material/icon";
import { AvatarModule } from "ngx-avatar";
import { SharedModule } from "../../shared/shared.module";
import { ChattingComponent } from "./chatting/chatting.component";
import { ChattingRoutingModule } from "./chatting-routing.module";


@NgModule({
  declarations: [
    ChattingComponent,
  ],
  imports: [
    CommonModule,
    ReactiveFormsModule,
    FormsModule,
    NgbTooltipModule,
    SharedModule,
    NgbModule,
    NgSelectModule,
    NgMultiSelectDropDownModule,
    TranslateModule.forChild(),
    NgOptionHighlightModule,
    MatListModule,
    MatIconModule,
    AvatarModule,
    ChattingRoutingModule
  ],
})

export class ChattingModule {}