import { HttpErrorResponse } from "@angular/common/http";
import {
  Component,
  ElementRef,
  NgZone,
  OnInit,
  ViewChild,
  AfterViewChecked,
  ViewChildren,
  QueryList,
  OnDestroy,
  EventEmitter,
  AfterViewInit,
  AfterContentInit,
} from "@angular/core";
import { FormControl, FormGroup, Validators } from "@angular/forms";
import { TranslateService } from "@ngx-translate/core";
import { CoreSession } from "../../../core/core.session";
import {
  BroadcastReceiverModel,
  ChattingHistoryMediaModel,
  ChattingHistoryModel,
} from "../../../shared/models/chatting/message.model";
import { ConstantMessages } from "../../../shared/models/constants/constant-message";
import { EmployeeService } from "../../employee/employee.service";
import { Guid } from "guid-typescript";
import {
  ModalDismissReasons,
  NgbModal,
  NgbModalConfig,
  NgbModalRef,
} from "@ng-bootstrap/ng-bootstrap";
import * as cloneDeep from "lodash/cloneDeep";
import { DateTimeModel } from "../../../shared/models/dateTimeModel/date-time.model";
import { forkJoin } from "rxjs";
import { MatOption } from "@angular/material/core";
import { ChattingUser } from "../../../shared/models/chatting/chatting-user.model";
import { ChattingConnectionStatus } from "../../../shared/models/enums/chatting/chatting-connection-status.enum";
import { ChattingService } from "../chatting.service";
import { SessionDataProvider } from "../../../core/session-data-provider.service";
import { ConnectionService } from "ng-connection-service";
import { EmailFileModel } from "../../../shared/models/email/email.model";
import { saveAs } from "file-saver";
import { ChattingMediaTypes } from "../../../shared/models/enums/chatting/chatting-media-types.enum";
import { SharedDialogComponent } from "../../../shared/components/shared-dialog/shared-dialog.component";
import { IDateTimePickerProperties } from "../../../shared/models/dateTimeModel/date-time-properties.interface";

@Component({
  selector: "app-chatting",
  templateUrl: "./chatting.component.html",
  styleUrls: ["./chatting.component.css"],
})
export class ChattingComponent implements OnInit, OnDestroy {
  @ViewChild('mediaExpiryDateDialog', { static: true }) mediaExpiryDateDialog: SharedDialogComponent;
  // @ViewChild("allSelected") private allSelected: MatOption;
  @ViewChild("scrollChatHistory") private msgScrollContainer: ElementRef;
  @ViewChild("customerFilterModal", { static: true })
  customerFilterModal: NgbModal;
  @ViewChild("broadcastModal", { static: true })
  broadcastModal: NgbModal;

  modalRef: NgbModalRef;

  disableScrollDown = false;

  chattingUsersList: any[] = [];
  copyOfChattingUsers: any[] = [];
  AvailablebroadcastList: any[] = [];
  copyOfAvailablebroadcastList: any[] = [];

  selectedUserChattingHistory: any[] = [];

  searchBoxLabel = "Desc_Enter_To_Search";

  searchFilter: string = "";
  broadcastSearchFilter: string = "";

  messageForm: FormGroup;
  customerForm: FormGroup;
  mediaExpiryDateForm: FormGroup;

  imagePath = "";

  currentEmployeeId = this.coreSession.CurrentOperator.employeeId;
  selectedChattingUserId: number = -1;
  selectedChattingUser: any;

  chattingCustomerId: number = -1;
  chattingOutletId: number = -1;
  chattingCustomer: any;
  chattingCustomerOutlet: any;

  chattingUsersPendingMessages: any[] = [];

  showCustomerFilter: boolean = false;

  unreadMessages: any[] = [];

  selectUserByDefault: boolean = false;
  selectedUserByDefault: any = null; // to always select first user from incoming list frm db [not user with unread msgs]

  noAvailableUsers: boolean = false;

  resetValues: EventEmitter<number> = new EventEmitter();

  addedUserBroadcastList: any[] = [];

  customStyleAvatar = {
    backgroundColor: "#ffffff",
    border: "1px solid #7e7e7e",
    borderRadius: "50%",
    color: "#7e7e7e",
    // cursor: "pointer"
  };

  scrollIsAtBottom: boolean = true;
  isSelectAllUsers: boolean = false;

  newMsgsCount: number = 0;

  selectedUserImagePath: string;

  messageSubscription: any;
  messageReadSubscription: any;
  chattingUsersSubscription: any;
  mediaDownloadedSubscription: any;
  messageSetAsReceivedSubscription: any;
  isRTLdirection: any;
  highlightUnreadMsgs: boolean = false;
  isBroadcastOpen: boolean = false;
  receivedWhileOnBC: any[] = [];
  networkConnectionStateSubscription;
  disableSend: boolean = false;
  disableBroadcast: boolean = false;
  connectionSubscribed: boolean = false;
  //#region [attachments]
  maxIndex: number = 0;
  maxBCIndex: number = 0;
  attachedFiles: any[] = [];
  attachedBCFiles: any[] = [];
  fileType: string = '';
  showAttachmentArea: boolean = false;
  showBroadcastAttachmentArea: boolean = false;
  //#endregion
  mediaExpiryDateProperties: IDateTimePickerProperties = {
    label: "Desc_Media_Expiry_Date",
    formControlName: "mediaExpiryDate",
    isCalendarOnly: true,
    min: new Date()
  };

  selectedMediaExpiryDate:any;
  savedMediaExpiryDate:any;
  isBCMsgInOutbox: boolean = false;
  skipScrollOnImageLoad: boolean = false;
  constructor(
    private chattingService: ChattingService,
    private translateService: TranslateService,
    private employeeService: EmployeeService,
    private _ngZone: NgZone,
    public coreSession: CoreSession,
    private config: NgbModalConfig,
    private modalService: NgbModal,
    public sessionData: SessionDataProvider,
    private connectionService: ConnectionService
  ) {
    config.backdrop = true;
  }

  ngOnInit(): void {
    this.subscribeToConnectionState();
    this.chattingService.checkForInternetConnection().subscribe(response => {
      if(response && response.status >=0) {
        if(response.data) {
          this.initCode();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant('Error occured at "fcm.googleapis.com"'));
        }
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant('Error occured at "fcm.googleapis.com"'));
      }
    }, (error:HttpErrorResponse) => {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant('Error occured at "fcm.googleapis.com"'));
    })
  }
  
  initCode() {
    if (this.coreSession.isInternetConnected || navigator.onLine) {
      this.subscribeToEvents();
      this.chattingService.setChattingScreenStatus(true);
      this.getQueryParams();
      this.scrollToBottom();
      this.getEmployeeChattingUsersAndUnreadMessages();
    } else {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgChattingNetworkError));
    }
    this.isRTLdirection = this.coreSession.isRTL;

    // this.subscribeToConnectionState();
    this.initForm();
  }

  ngOnDestroy() {
    this.unsubscribeToEvents(true);
    this.chattingService.setChattingScreenStatus(false);
    this.chattingService.setCurrentChattingUser(null);
    this.chattingService.setSelectedChatUserFromNotifications(-1);
    this.selectedChattingUser = null;
    this.selectedChattingUserId = -1;
  }
  unsubscribeToEvents(includeConnection: boolean) {
    if (this.messageSubscription) this.messageSubscription.unsubscribe();
    if (this.messageReadSubscription) this.messageReadSubscription.unsubscribe();
    if (this.chattingUsersSubscription) this.chattingUsersSubscription.unsubscribe();
    if (this.mediaDownloadedSubscription) this.mediaDownloadedSubscription.unsubscribe();
    if (this.messageSetAsReceivedSubscription) this.messageSetAsReceivedSubscription.unsubscribe();
    if (this.networkConnectionStateSubscription && includeConnection) this.networkConnectionStateSubscription.unsubscribe();
  }
  // ngAfterViewChecked() {
  //   this.scrollToBottom();
  // }

  onScrollToBottomClicked() {
    this.newMsgsCount = 0;
      try {
        this.msgScrollContainer.nativeElement.scrollTop =
          this.msgScrollContainer.nativeElement.scrollHeight;
        this.scrollIsAtBottom = true;
      } catch (err) { }
  }

  private scrollToBottom(): void {
    setTimeout(() => {
      // if (this.disableScrollDown) { // testScroll
      //   return;
      // }
      try {
        this.msgScrollContainer.nativeElement.scrollTop =
          this.msgScrollContainer.nativeElement.scrollHeight;
      } catch (err) { }
    }, 50);
    
  }

  private onScroll() {
    let element = this.msgScrollContainer.nativeElement;
    let atBottom =
      element.scrollHeight - element.scrollTop === element.clientHeight;
    this.scrollIsAtBottom =
      element.scrollHeight - element.scrollTop - element.clientHeight <= 1;
    if (this.scrollIsAtBottom) {
      this.newMsgsCount = 0;
    }
    if (this.disableScrollDown && atBottom) { 
      this.disableScrollDown = false;
    } else {
      this.disableScrollDown = true; 
    }
  }

  subscribeToConnectionState() {
    if(!this.connectionSubscribed) {
      this.connectionSubscribed = true;
      this.networkConnectionStateSubscription =this.connectionService.monitor().subscribe((isConnected) => {  
        // console.log('internet connection - chatting component')
        // this.coreSession.isInternetConnected = isConnected;
         if(isConnected) {  
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgConnectionRestoredRefresh));
          this.unsubscribeToEvents(false);
         }  
         else {  
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgChattingNetworkError));
          this.unsubscribeToEvents(false);
          this.disableScreen();
         }  
       });
    }
    
    // if(!this.connectionSubscribed) {
    //   this.connectionSubscribed = true;
    //   this.networkConnectionStateSubscription =
    //   this.coreSession.connectionState.subscribe((isConnected) => {
    //     if(!isConnected) {
    //       this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgChattingNetworkError));
    //       this.unsubscribeToEvents(false);
    //       this.disableScreen();
    //     } 
    //     else {
    //       this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgConnectionRestoredRefresh));
    //       this.unsubscribeToEvents(false);
    //       // this.enableScreen();
    //     }
    //   });
    // }
  }

  disableScreen() {
    if(this.messageForm) {
      if(this.messageForm.get('message')) this.messageForm.get('message').disable();
      if(this.messageForm.get('broadcastMessage')) this.messageForm.get('broadcastMessage').disable();
    }
   
    this.disableSend = true;
    this.disableBroadcast = true;
  }

  enableScreen() {
    this.messageForm.get('message').enable();
    this.messageForm.get('broadcastMessage').enable();
    this.disableSend = false;
    this.disableBroadcast = false;
    this.initCode();
  }

  initForm() {
    this.messageForm = new FormGroup({
      message: new FormControl(),
      broadcastMessage: new FormControl(),
    });

    this.customerForm = new FormGroup({
      customerId: new FormControl(null, Validators.required),
      outletId: new FormControl(null, Validators.required),
      isTerritoryCustomers: new FormControl(true),
    });

    this.mediaExpiryDateForm = new FormGroup({
      mediaExpiryDate: new FormControl(null)
      //media : new FormControl(null)
    });
  }

  getQueryParams() {
    if (this.chattingService.getSelectedChatUserFromNotifications() > -1) {
      this.selectedChattingUserId =
        this.chattingService.getSelectedChatUserFromNotifications();
      // var idx = this.chattingUsersList.findIndex(x => x.userId === this.selectedChattingUserId);
      // if(idx > -1) {
      //   this.selectedUserImagePath = this.chattingUsersList[idx].imagePath;
      // } else {
      //   this.selectedUserImagePath = "";
      // }
      //   document.getElementsByTagName("base")[0].href +
      //   'wwwroot/Users-Img/' +
      //   this.selectedChattingUserId +
      //   '.jpg' 
        // + '?' 
        // +
        // new Date().getTime();
      var user = this.chattingService.getCurrentChattingUser();
      this.selectedChattingUser = user;
      this.selectedUserImagePath = user.imagePath;
      this.disableScrollDown = false;

      // get chatting history for selected employee:
      var chatInfo = new ChattingHistoryModel();
      chatInfo.senderId = this.coreSession.CurrentOperator.employeeId;
      chatInfo.receiverId = this.selectedChattingUserId;
      chatInfo.customerId = -1;
      chatInfo.outletId = -1;
      this.getChattingHistory(chatInfo, true);
    } else {
      this.selectUserByDefault = true;
    }
  }

  getEmployeeChattingUsersAndUnreadMessages() {
    var chattingUsersResponse =
      this.chattingService.getAvailableUsersForChatting(
        this.coreSession.CurrentOperator.employeeId,
        this.coreSession.selectedLanguageId
      );
    var unreadMessagesResponse = this.chattingService.getEmployeeUnreadMessages(
      this.currentEmployeeId,
      this.coreSession.selectedLanguageId
    );
    forkJoin(chattingUsersResponse, unreadMessagesResponse).subscribe(
      (response) => {
        if (
          response[1].status != null &&
          response[1].status >= 0 &&
          response[0].status != null &&
          response[0].status >= 0
        ) {
          this.unreadMessages = response[1].data;

          this.chattingUsersList = response[0].data.filter(
            (x) =>
              x.isBOUser ||
              (!x.isBOUser &&
                x.deviceToken != null &&
                x.deviceToken != "" &&
                x.deviceToken.trim() != "")
          );
          if (
            this.chattingUsersList !== null &&
            this.chattingUsersList.length > 0
          ) {
            this.copyOfChattingUsers = cloneDeep(this.chattingUsersList);
            this.AvailablebroadcastList = this.copyOfChattingUsers.filter(
              (x) => x.inactive === 0
            );
            this.copyOfAvailablebroadcastList = cloneDeep(
              this.AvailablebroadcastList
            );
          }
          
          if (this.chattingUsersList.length === 0) {
            this.noAvailableUsers = true;
          } else {
            this.noAvailableUsers = false;
          }
          if (this.selectedChattingUserId > -1 && !this.selectedChattingUser) {
            this.selectedChattingUser = this.copyOfChattingUsers.filter(
              (user) => user.userId === this.selectedChattingUserId
            )[0];
          }
          // link users with corresponding unread messages
          this.unreadMessages.forEach((msg) => {
            var idx = this.chattingUsersList.findIndex(
              (user) => user.userId === msg.senderId
            );

            if (idx > -1) {
              if (!this.chattingUsersList[idx].messages) {
                this.chattingUsersList[idx].messages = [];
              }
              this.chattingUsersList[idx].messages.push(msg);
            }
          });
          // Show or hide inactive users depending on chat history.
          // var inactiveUserIds = this.chattingUsersList.filter(u=>u.inactive === 1).map(user => user.userId);
          // if(inactiveUserIds.length > 0) {
          //   this.showInactiveUsersWithChatHistory(inactiveUserIds);
          // }

          this.orderChatByUnreadMessages();
          if (this.selectUserByDefault && this.chattingUsersList.length > 0) {
            // select first user by default
            this.onInboxUserClicked(this.chattingUsersList[0], 0);
          }
        } else {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }

  orderChatByUnreadMessages() {
    this.chattingUsersList.map((chattingUser) => {
      if (chattingUser.messages && chattingUser.messages.length > 0) {
        // User has unread messages, shift to top of chatlist
        var idx = this.chattingUsersList.findIndex(
          (u) => u.userId === chattingUser.userId
        );
        if (idx > -1) {
          this.chattingUsersList.unshift(
            this.chattingUsersList.splice(idx, 1)[0]
          );
        }
      }
    });
  }

  showInactiveUsersWithChatHistory(inactiveUserIds: number[]) {
    this.chattingService
      .checkInactiveEmployeeChattingHistory(
        inactiveUserIds,
        this.currentEmployeeId,
        this.coreSession.selectedLanguageId
      )
      .subscribe((response) => {
        if (response.status != null && response.status >= 0) {
          // remove users with count === 0; (returned data);
          if (response.data && response.data.length > 0) {
            response.data.map((u) => {
              var idx = this.chattingUsersList.findIndex((x) => x.userId === u);
              if (idx > -1) {
                this.chattingUsersList.splice(idx, 1);
              }
            });
          }
        }
      });
  }
  getEmployeeUnreadMessages() {
    this.coreSession.ModalLoading.Show();
    this.chattingService
      .getEmployeeUnreadMessages(
        this.currentEmployeeId,
        this.coreSession.selectedLanguageId
      )
      .subscribe(
        (response) => {
          this.coreSession.ModalLoading.Hide();
          if (response && response.status != null && response.status >= 0) {
            this.unreadMessages = response.data;
          } else {
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              this.translateService.instant(response.message)
            );
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }
      );
  }

  private subscribeToEvents(): void {
    this.subscribeToMessage();
    this.subscribeToMessageRead();
    this.subscribeToUsersUpdate();
    this.subscribeToMediaDownload();
    this.subscribeToSetMessageAsReceived();
  }

  subscribeToMessage() {
    this.messageSubscription = this.chattingService.messageReceived.subscribe(
      (message: any) => {
        this._ngZone.run(() => {
          // ngZone
          setTimeout(() => {
            if (this.scrollIsAtBottom && this.disableScrollDown) {
              this.disableScrollDown = false;
            }
            // message is not a broadcast:
            if (
              message.receiversList === null ||
              message.receiversList.length === 0
            ) {
              if (message.receiverId === this.currentEmployeeId) {
                this.setEmployeeMessagesAsReceivedInDB(message.messageId,message.isBOSender,message.senderDeviceSerial,message.senderId);
                message.isBOReceiver = true;
                message.messageDate = message.messageDateTimeModel ? message.messageDateTimeModel.date : null;
                if (message.senderId === this.selectedChattingUserId) {
                  // chatting area is open with the message sender Id, do not display notification

                  if (this.isBroadcastOpen) {
                    this.receivedWhileOnBC.push(message);
                  }
                  // Translate received customer outlet name to current selected language
                  if (
                    message.customerId !== -1 &&
                    message.outletId !== -1 &&
                    message.customerOutletDescriptions &&
                    message.customerOutletDescriptions.length > 0
                  ) {
                    message.outletCode =
                      message.customerOutletDescriptions[0].outletCode;
                    var i = message.customerOutletDescriptions.findIndex(
                      (desc) =>
                        desc.languageId === this.coreSession.selectedLanguageId
                    );
                    if (i > -1) {
                      message.outletName = message.customerOutletDescriptions[i]
                        .outletDescription
                        ? message.customerOutletDescriptions[i]
                          .outletDescription
                        : "";
                    } else {
                      message.outletName = "";
                    }
                  }

                  // Check if current chat is filtered to a customer,
                  // and if it is, if a message is received for a different customer/or no customer, remove the filter
                  var resetFilter = false;
                  resetFilter = this.resetSelectedFilter(message);

                  if (resetFilter) {
                    this.onAllCustomersClicked();
                    // var unreadMessages = [];
                    // unreadMessages.push(message);
                    // this.setSelectedUserMessagesAsRead(unreadMessages);
                    this.newMsgsCount += 1;
                  } else {
                    this.selectedUserChattingHistory.push(message);
                    var unreadMessages = [];
                    unreadMessages.push(message);
                    this.setSelectedUserMessagesAsRead(unreadMessages);
                    this.newMsgsCount += 1;
                  }
                  if(this.scrollIsAtBottom) {
                    this.scrollToBottom(); // testScroll
                  }
                } else {
                  // chatting area is not open with the message sender Id, display notification
                  var idx = this.chattingUsersList.findIndex(
                    (user) => user.userId === message.senderId
                  );
                  if (idx > -1) {
                    if (!this.chattingUsersList[idx].messages) {
                      this.chattingUsersList[idx].messages = [];
                    }
                    this.chattingUsersList[idx].messages.push(message);
                  }
                  this.orderChatByUnreadMessages();
                }
              }
            } else {
              // message is a broadcast
              // if current user is included in the receivers list
              var i = message.receiversList.findIndex(
                (receiver) => receiver.receiverId === this.currentEmployeeId
              );
              if (i > -1) {
                this.setEmployeeMessagesAsReceivedInDB(message.messageId,message.isBOSender, message.senderDeviceSerial,message.senderId); 

                message.receiverId = message.receiversList[i].receiverId;
                message.receiverName = message.receiversList[i].receiverName;
                message.isBOReceiver = message.receiversList[i].isBOReceiver;
                message.messageId = message.receiversList[i].messageId;
                message.receiverDeviceToken = message.isBOReceiver
                  ? ""
                  : message.receiversList[i].receiverDeviceToken;

                message.messageDate = message.messageDateTimeModel.date;

                if (message.senderId === this.selectedChattingUserId) {
                  if (this.isBroadcastOpen) {
                    this.receivedWhileOnBC.push(message);
                  }
                  // chatting area is open with the message sender Id, do not display notification
                  this.onAllCustomersClicked();

                  this.newMsgsCount += 1;
                } else {
                  // chatting area is not open with the message sender Id, display notification
                  var idx = this.chattingUsersList.findIndex(
                    (user) => user.userId === message.senderId
                  );
                  if (idx > -1) {
                    if (!this.chattingUsersList[idx].messages) {
                      this.chattingUsersList[idx].messages = [];
                    }
                    this.chattingUsersList[idx].messages.push(message);
                  }
                  this.orderChatByUnreadMessages();
                }
              }
            }
          }, 50);
        }); // ngZone
      }
    );
  }

  subscribeToMessageRead() {
    this.messageReadSubscription = this.chattingService.messageRead.subscribe(
      (message: ChattingHistoryModel) => {
        this._ngZone.run(() => {
          // ngZone
          // message sent by current employee is read.
          if (message.senderId === this.currentEmployeeId) {
            // chatting area is open with the message reader.
            if (message.receiverId === this.selectedChattingUserId) {
              this.selectedUserChattingHistory.map(
                (msg) => (msg.isRead = true)
              );
            }
          } else if (message.receiverId === this.currentEmployeeId) {
            // Messages by [message.senderid] are read, set [messages] = [], (reset unread messages for selected chatting user)
            this.chattingUsersList.map((user) => {
              if (user.userId === message.senderId) {
                user.messages = [];
              }
            });
          }
        }); // ngZone
      }
    );
  }

  subscribeToUsersUpdate() {
    this.chattingUsersSubscription =
      this.chattingService.chattingUsersUpdated.subscribe(
        (user: ChattingUser) => {
          this._ngZone.run(() => {
            // ngZone
            // user online / offline changed
            if (!user.addRemoveAssignment) {
              // user went online.
              if (user.status === ChattingConnectionStatus.Online.valueOf()) {
                this.chattingUsersList.map((chattingUser) => {
                  if (chattingUser.userId === user.userId) {
                    chattingUser.isActive = true;
                    chattingUser.status = user.status;
                  }
                });
                if(this.selectedChattingUserId === user.userId) { // chat is open with user who logged in, reflect msgs as received on UI.
                  this.setCurrentUserMessagesAsReceived();
                }
              } // user went offline.
              else {
                this.chattingUsersList.map((chattingUser) => {
                  if (chattingUser.userId === user.userId) {
                    chattingUser.isActive = false;
                    chattingUser.status = user.status;
                  }
                });
              }
            } // user assignment changed
            else {
              setTimeout(() => {
                this.getEmployeeChattingUsersAndUnreadMessages();
              }, 1000);
            }
          }); // ngZone
        }
      );
  }

  subscribeToMediaDownload() {
    this.mediaDownloadedSubscription = 
      this.chattingService.mediaDownloaded.subscribe((message: ChattingHistoryModel) => {
        this._ngZone.run(() => {
          if(message.senderId === this.currentEmployeeId) { // the message media that logged in user sent is downloaded .. else do nothing.
            var receivedMedia = message.mediaList[0];
            var msgObjIdx = this.selectedUserChattingHistory.findIndex(msg => msg.messageId == message.messageId);
            if(msgObjIdx > -1) {
              var mediaObjIdx = this.selectedUserChattingHistory[msgObjIdx].mediaList.findIndex(media => media.fileName === receivedMedia.fileName && media.mediaType === receivedMedia.mediaType);
              if(mediaObjIdx > -1) {
                this.selectedUserChattingHistory[msgObjIdx].mediaList[mediaObjIdx].isDownloaded = true;
                this.selectedUserChattingHistory[msgObjIdx].mediaList[mediaObjIdx].downloadDate = message.mediaList[0].downloadDate;
              } 
            }
          }
        });
      });
  }

  subscribeToSetMessageAsReceived() {
    this.messageSetAsReceivedSubscription = this.chattingService.setMessageAsReceived.subscribe((message: ChattingHistoryModel) => {
      this._ngZone.run(() => {
        
        if(message.senderId === this.currentEmployeeId) { // the message that logged in user sent is received .. else do nothing.
          var i = this.selectedUserChattingHistory.findIndex(msg => msg.messageId == message.messageId);
          if(i > -1) {
            this.selectedUserChattingHistory[i].isMessageReceived = true;
          }
        }
      });
    });
  }
  

  setEmployeeMessagesAsReceivedInDB(messageId:string,isBOSender:boolean, senderDeviceSerial:string, senderId: number) {
    var msg = new ChattingHistoryModel();
    msg.messageId = messageId; 
    msg.isBOSender = isBOSender;
    msg.isBOReceiver = true; // current logged in user is a BO user...
    msg.senderDeviceSerial = senderDeviceSerial;
    msg.receiverId = this.currentEmployeeId;
    msg.senderId = senderId;
    this.chattingService.setEmployeeMessagesAsReceived(msg).subscribe((response) => {}, (error:HttpErrorResponse) => {});
  }

  setCurrentUserMessagesAsReceived() {
    this.selectedUserChattingHistory.filter(m => m.senderId == this.currentEmployeeId).forEach(msg => {
      msg.isMessageReceived = true;
    });
  }

  resetSelectedFilter(message) {
    var result = false;
    if (message.customerId > -1 && message.outletId > -1) {
      if (
        this.chattingCustomer &&
        this.chattingCustomerId > -1 &&
        this.chattingCustomerOutlet &&
        this.chattingOutletId > -1
      ) {
        if (
          this.chattingOutletId !== message.outletId ||
          this.chattingCustomerId !== message.customerId
        ) {
          result = true;
        }
      }
    } else if (
      this.chattingCustomer &&
      this.chattingCustomerId > -1 &&
      this.chattingCustomerOutlet &&
      this.chattingOutletId > -1
    ) {
      result = true;
    }
    return result;
  }

  searchInboxList() {
    var cloneOfChattingUsers = cloneDeep(this.copyOfChattingUsers);
    var test = cloneDeep(this.chattingUsersList);
    this.searchFilter;
    if (!this.searchFilter) {
      this.searchFilter = "";
    }
    if (
      this.searchFilter.trim().length === 0 ||
      this.searchFilter.trim() === "" ||
      this.searchFilter.trim().length === null
    ) {
      this.chattingUsersList = cloneOfChattingUsers.slice();
      return;
    }

    const TempArray = [];
    for (const user of cloneOfChattingUsers) {
      if (
        (user["userName"] + "")
          .toLowerCase()
          .includes(this.searchFilter.toLowerCase().trim())
      ) {
        TempArray.push(user);
      }
    }
    this.chattingUsersList = TempArray;
  }

  searchBroadcastList() {
    var cloneOfChattingUsers = cloneDeep(this.copyOfAvailablebroadcastList);

    this.broadcastSearchFilter;
    if (!this.broadcastSearchFilter) {
      this.broadcastSearchFilter = "";
    }
    if (
      this.broadcastSearchFilter.trim().length === 0 ||
      this.broadcastSearchFilter.trim() === "" ||
      this.broadcastSearchFilter.trim().length === null
    ) {
      this.AvailablebroadcastList = cloneOfChattingUsers.slice();
      this.reflectAddedBeforeUsers(this.AvailablebroadcastList);

      return;
    }

    const TempArray = [];
    for (const user of cloneOfChattingUsers) {
      if (
        (user["userName"] + "")
          .toLowerCase()
          .includes(this.broadcastSearchFilter.toLowerCase().trim())
      ) {
        TempArray.push(user);
      }
    }
    this.AvailablebroadcastList = TempArray;
    this.reflectAddedBeforeUsers(this.AvailablebroadcastList);
  }

  reflectAddedBeforeUsers(viewList: any[]) {
    // If View element exists in added users list, element is checked.
    viewList.forEach((el) => {
      if (
        this.addedUserBroadcastList.findIndex(
          (addedUser) => addedUser.userId === el.userId
        ) > -1
      ) {
        el.isChecked = true;
      }
    });
    // If not items are selected select all is false.
    if (
      this.isSelectAllUsers &&
      this.addedUserBroadcastList.length <
      this.copyOfAvailablebroadcastList.length
    ) {
      this.isSelectAllUsers = false;
    }
    // If view list items are all checked, select all is true.
    if (
      this.AvailablebroadcastList.filter((u) => u.isChecked === true).length ===
      this.AvailablebroadcastList.length &&
      this.AvailablebroadcastList.length > 0
    ) {
      this.isSelectAllUsers = true;
    }
    if (this.AvailablebroadcastList.length === 0) {
      this.isSelectAllUsers = false;
    }
  }

  resetChattingArea() {
    this.messageForm.reset();
    this.attachedFiles = [];
    this.attachedBCFiles = [];
    this.showBroadcastAttachmentArea = false;
    this.showAttachmentArea = false;
  }
  onInboxUserClicked(user, index) {
    this.resetChattingArea();
    //Reset Customer Filter
    this.chattingCustomer = null;
    this.chattingCustomerOutlet = null;
    this.chattingCustomerId = -1;
    this.chattingOutletId = -1;
    this.chattingService.setCurrentChattingUser(user);
    if (user.userId !== this.selectedChattingUserId) {
      this.selectedUserImagePath = ' ';
      this.disableScrollDown = false;
      this.selectedChattingUserId = user.userId;
      this.selectedChattingUser = user;
      this.selectedUserImagePath = user.imagePath;
    
      this.chattingUsersList.map((chattingUser) => {
        if (chattingUser.userId === user.userId) {
          chattingUser.messages = [];
        }
      });

      if (this.selectedChattingUser.inactive === 1) {
        this.messageForm
          .get("message")
          .disable({ onlySelf: true, emitEvent: false });
        this.messageForm.get("message").updateValueAndValidity();
      } else {
        this.messageForm
          .get("message")
          .enable({ onlySelf: true, emitEvent: false });
        this.messageForm.get("message").updateValueAndValidity();
      }
      // get chatting history for selected employee:
      var chatInfo = new ChattingHistoryModel();
      chatInfo.senderId = this.coreSession.CurrentOperator.employeeId;
      chatInfo.receiverId = user.userId;
      chatInfo.customerId = user.customerId ? user.customerId : -1;
      chatInfo.outletId = user.outletId ? user.outletId : -1;
      this.getChattingHistory(chatInfo, true);
    }
  }

  prepareMessageToSend(value) {
    if (
      (value &&
      value.message &&
      value.message != undefined &&
      value.message != "" &&
      value.message.trim() !== "") ||
      (this.attachedFiles && this.attachedFiles.length > 0)
    ) {
      var outgoingMessage = new ChattingHistoryModel();
      outgoingMessage.messageId = Guid.create().toString();

      outgoingMessage.senderId = this.currentEmployeeId;
      outgoingMessage.senderName =
        this.coreSession.CurrentOperator.employeeName;
      outgoingMessage.receiverId = this.selectedChattingUserId;
      outgoingMessage.receiverName = this.selectedChattingUser.userName;

      outgoingMessage.receiverDeviceToken =
        this.selectedChattingUser.deviceToken;
      outgoingMessage.receiverDeviceSerial =
        this.selectedChattingUser.deviceSerial;
      this.selectedChattingUser;

      outgoingMessage.isBOSender = true;
      outgoingMessage.isBOReceiver = this.selectedChattingUser.isBOUser;

      outgoingMessage.customerId = this.chattingCustomerId;
      outgoingMessage.outletId = this.chattingOutletId;
      if (this.chattingCustomerId != -1 && this.chattingOutletId != -1) {
        outgoingMessage.customerId = this.chattingCustomerId;
        outgoingMessage.outletId = this.chattingOutletId;
        outgoingMessage.customerCode = this.chattingCustomer.customerCode;
        outgoingMessage.outletName = this.chattingCustomerOutlet.outletName;
        outgoingMessage.customerName = this.chattingCustomer.customerName;
        outgoingMessage.outletCode = this.chattingCustomerOutlet.outletCode;
      }
      outgoingMessage.messageDateTimeModel = this.getDateTimeModel(new Date());
      outgoingMessage.messageDate = new Date();
      outgoingMessage.messageDateTime = new Date();

      if (value &&
        value.message &&
        value.message != undefined &&
        value.message != "" &&
        value.message.trim() !== "") {
          outgoingMessage.messageBody = value.message;
          outgoingMessage.hasText = true;
      }

      var formData: FormData = new FormData();
      formData.append('messageString', JSON.stringify(outgoingMessage));

      if(this.attachedFiles && this.attachedFiles.length > 0) {
        outgoingMessage.hasMedia = true;
        for (let file of this.attachedFiles) {
          if (file.file)
            formData.append("attachedFiles", file.file, file.name);
        }
      }
   
      this.sendMessage(formData,outgoingMessage, false);
    } else {
      this.messageForm.reset();
    }
  }

  prepareMessageToBroadcast(value) {
    if (
      value &&
      value.broadcastMessage &&
      value.broadcastMessage != "" &&
      value.broadcastMessage.trim() !== "" 
      || (this.attachedBCFiles && this.attachedBCFiles.length > 0)
    ) {
      if (this.addedUserBroadcastList.length === 0) {
        return this.coreSession.showWarrning(
          this.translateService.instant(ConstantMessages.WarningCaption),
          this.translateService.instant(ConstantMessages.Desc_Select_Employee)
        );
      } else {
        // ---------
        var outgoingBroadcastMessage = new ChattingHistoryModel();
        outgoingBroadcastMessage.senderId = this.currentEmployeeId;
        outgoingBroadcastMessage.senderName =
          this.coreSession.CurrentOperator.employeeName;
        outgoingBroadcastMessage.isBOSender = true;
        outgoingBroadcastMessage.customerId = -1;
        outgoingBroadcastMessage.outletId = -1;
        if (value &&
          value.broadcastMessage &&
          value.broadcastMessage != undefined &&
          value.broadcastMessage != "" &&
          value.broadcastMessage.trim() !== "") {
            outgoingBroadcastMessage.hasText = true;
            outgoingBroadcastMessage.messageBody = this.messageForm
            .get("broadcastMessage")
            .value.replace(/(\r\n|\n|\r)/gm, "\n");
          }
        
        outgoingBroadcastMessage.messageDateTimeModel = this.getDateTimeModel(
          new Date()
        );
        outgoingBroadcastMessage.mediaExpiryDateModel = this.savedMediaExpiryDate;
        outgoingBroadcastMessage.messageDate = new Date();
        outgoingBroadcastMessage.messageDateTime = new Date();
        outgoingBroadcastMessage.receiverName = "";
        outgoingBroadcastMessage.receiverDeviceToken = "";
        outgoingBroadcastMessage.receiverDeviceSerial = "";
        outgoingBroadcastMessage.receiversList = [];

        // prepare receivers list:
        this.addedUserBroadcastList.forEach((bcUser) => {
          if (
            (!bcUser.isBOUser &&
              bcUser.deviceToken !== null &&
              bcUser.deviceToken !== "" &&
              bcUser.deviceToken.trim() !== "") ||
            bcUser.isBOUser
          ) {
            var bcReceiverObj = new BroadcastReceiverModel();
            bcReceiverObj.messageId = Guid.create().toString();
            bcReceiverObj.receiverId = bcUser.userId;
            bcReceiverObj.isBOReceiver = bcUser.isBOUser;
            bcReceiverObj.receiverDeviceToken = !bcUser.isBOUser
              ? bcUser.deviceToken
              : "";
            bcReceiverObj.receiverName = bcUser.userName;
            outgoingBroadcastMessage.receiversList.push(bcReceiverObj);
          }
        });

        var formData: FormData = new FormData();
        formData.append('messageString', JSON.stringify(outgoingBroadcastMessage));

        // prepare media files
        if(this.attachedBCFiles && this.attachedBCFiles.length > 0) {
          outgoingBroadcastMessage.hasMedia = true;
          for (let file of this.attachedBCFiles) {
            if (file.file)
              formData.append("attachedFiles", file.file, file.name);
          }
        }

        if (outgoingBroadcastMessage.receiversList.length > 0) {
          this.isBCMsgInOutbox = true;
          this.sendMessage(formData,outgoingBroadcastMessage, true);
        }
      }
    } else {
      this.messageForm.reset();
    }
  }

  afterSendMessage(message: ChattingHistoryModel) {
    this.attachedFiles = [];
    this.showAttachmentArea = false;
    this.selectedUserChattingHistory.push(message);
    this.disableScrollDown = false;
    this.scrollToBottom(); // testscroll
    this.messageForm.reset();
  }

  afterSendBroadcast(message: ChattingHistoryModel) {
    this.isBCMsgInOutbox = false;
    this.attachedBCFiles = [];
    this.chattingCustomer = null;
    this.chattingCustomerOutlet = null;
    this.chattingCustomerId = -1;
    this.chattingOutletId = -1;
    this.coreSession.showSuccess(
      this.translateService.instant(ConstantMessages.SuccessCaption),
      this.translateService.instant(
        ConstantMessages.MsgBroadcastSentSuccessfully
      )
    );
    // is current selected chatting user included in broadcast? if so, show message on chatting history.
    var idx = message.receiversList.findIndex(
      (receiver) =>
        receiver.receiverId === this.selectedChattingUserId
    );
    if (idx > -1) {
      message.receiverId = message.receiversList[idx].receiverId;
      message.messageId = message.receiversList[idx].messageId;
      message.receiverName = message.receiversList[idx].receiverName;
      message.isBOReceiver = message.receiversList[idx].isBOReceiver;
      message.receiverDeviceToken = "";

      this.selectedUserChattingHistory.push(message);
      this.disableScrollDown = false;
      this.scrollToBottom(); // testscroll
      this.messageForm.reset();
    }
    this.closeBroadcastModal();
  }

  sendMessage(formData:FormData ,message: ChattingHistoryModel, isBroadcast: boolean) {
    var messageBody = message.messageBody;
    var msgDate = message.messageDate;
    this.chattingService
      .SendMessage(formData, this.coreSession.selectedLanguageId)
      .subscribe(
        (response) => {
          if (response && response.status != null && response.status >= 0) {
            message = response.data;
            message.messageDate = msgDate;
            if (!isBroadcast) {
              this.afterSendMessage(message);
            } else {
              message.messageBody = messageBody;
              this.afterSendBroadcast(message);
            }
          } else {
            this.isBCMsgInOutbox = false;
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              this.translateService.instant(response.message)
            );
          }
        },
        (error: HttpErrorResponse) => {
          this.isBCMsgInOutbox = false;
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }
      );
  }

  saveBroadcastToDB(broadcastList: ChattingHistoryModel[]) {
    this.chattingService.SendBroadcast(broadcastList).subscribe(
      (response) => {
        if (response && response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(
            this.translateService.instant(ConstantMessages.SuccessCaption),
            this.translateService.instant(
              ConstantMessages.MsgBroadcastSentSuccessfully
            )
          );
          // is current selected chatting user included in broadcast? if so, show message on chatting history.
          var idx = broadcastList.findIndex(
            (message) => message.receiverId === this.selectedChattingUserId
          );
          if (idx > -1) {
            this.selectedUserChattingHistory.push(broadcastList[idx]);
            this.disableScrollDown = false;
            this.scrollToBottom(); // testscroll
            this.messageForm.reset();
          }

          this.closeBroadcastModal();
        } else {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(response.message)
          );
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    );
  }

  getStyle(user) {
    if (user.userId === this.selectedChattingUserId) {
      // return "#d1dbe4";
      return "lightgray";
    }
    //  else if (idx > -1 && this.chattingUsersList[idx].messages && this.chattingUsersList[idx].messages.length > 0) {
    //   // return "#fffaf0";
    //   // return "#fdcb67";
    //   return 'rgb(252, 218, 156)';
    // }
    else {
      return "";
    }
  }

  getUploadedFOUsersInChattingAssignment() {
    this.coreSession.ModalLoading.Show();
    this.chattingService
      .getUploadedFOUsersInChattingAssignment(
        this.coreSession.CurrentOperator.employeeId,
        this.coreSession.selectedLanguageId
      )
      .subscribe(
        (response) => {
          this.coreSession.ModalLoading.Hide();
          if (response && response.status != null && response.status >= 0) {
            this.chattingUsersList = response.data;
            this.copyOfChattingUsers = response.data;
          } else {
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              this.translateService.instant(response.message)
            );
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }
      );
  }

  getAvailableUsersForChatting() {
    this.coreSession.ModalLoading.Show();
    this.chattingService
      .getAvailableUsersForChatting(
        this.coreSession.CurrentOperator.employeeId,
        this.coreSession.selectedLanguageId
      )
      .subscribe(
        (response) => {
          this.coreSession.ModalLoading.Hide();
          if (response && response.status != null && response.status >= 0) {
            this.chattingUsersList = response.data;
            this.copyOfChattingUsers = response.data;
          } else {
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              this.translateService.instant(response.message)
            );
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }
      );
  }

  getChattingHistory(chatInfo, applyHighlightToMsgs?: boolean) {
    this.chattingService
      .getChattingHistory(chatInfo, this.coreSession.selectedLanguageId)
      .subscribe(
        (response) => {
          if (response && response.status != null && response.status >= 0) {
            this.selectedUserChattingHistory = response.data;
            // if (this.scrollIsAtBottom && this.disableScrollDown) {
            //   this.disableScrollDown = false;
            // }
            if(this.scrollIsAtBottom && !applyHighlightToMsgs) {
              this.scrollToBottom(); // testscroll
            }
            var unreadMessages = this.selectedUserChattingHistory.filter(
              (msg) =>
                msg.isRead === false &&
                msg.receiverId === this.currentEmployeeId
            );
            if (unreadMessages && unreadMessages.length > 0) {
              if (applyHighlightToMsgs) {
                this.skipScrollOnImageLoad = true;
                this.highlightUnreadMsgs = true;
              }
              this.setSelectedUserMessagesAsRead(unreadMessages);
            } else {
              this.scrollToBottom();
            }
          } else {
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              this.translateService.instant(response.message)
            );
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }
      );
  }

  setSelectedUserMessagesAsRead(unreadMessages) {
    unreadMessages.map((msg) => {
      msg.isBOSender = this.selectedChattingUser.isBOUser;
      msg.isBOReceiver = true;
    });
    unreadMessages[0].senderDeviceToken = this.selectedChattingUser.deviceToken;
    unreadMessages[0].senderDeviceSerial = this.selectedChattingUser.deviceSerial;

    this.chattingService
      .setMessagesAsRead(unreadMessages[0], this.coreSession.selectedLanguageId)
      .subscribe(
        (response) => {
          if (response && response.status != null && response.status >= 0) {
            this.chattingUsersList.map((chattingUser) => {
              if (chattingUser.userId === unreadMessages.senderId) {
                chattingUser.messages = [];
              }
            });
            //.....
            if (this.highlightUnreadMsgs) {
              this.highlightUnreadMsgs = false;
              this.applyHighlightToUnreadMessages(unreadMessages, !this.scrollIsAtBottom);
            }
            //.....
          } else {
            this.coreSession.showError(
              this.translateService.instant(ConstantMessages.ErrorCaption),
              this.translateService.instant(response.message)
            );
          }
        },
        (error: HttpErrorResponse) => {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }
      );
  }
  applyHighlightToUnreadMessages(unreadMessages, skipDueToScroll?: boolean) {

    this.receivedWhileOnBC = [];
    // If the chat history is scrolled up [not at bottom], do not apply highlight to unread msgs, because an
    // arrow will already indicate unread msgs.
    skipDueToScroll = skipDueToScroll ? skipDueToScroll : false;
    if (!skipDueToScroll) {
      this.disableScrollDown = true;

      var el = document.getElementById('m' + unreadMessages[0].messageId.toLowerCase());
      if (el) {
        // el.scrollIntoView();
        var par = document.createElement("p");
        par.style.cssText = ' margin-bottom: 0;text-align: center;color:#183247;backgroud-color:rgb(235,235,235),border-radius:7px;cursor:default;font-weight:bold';
        var count = unreadMessages.length;
        par.innerText = count.toString() + " " + this.translateService.instant('Desc_Unread_Messages');
        el.before(par);
        // el.classList.add('highlighted');
        setTimeout(() => {

        par.scrollIntoView(true);
        }, 50);

        // if(this.scrollIsAtBottom && this.disableScrollDown) {
        //   this.disableScrollDown = false;
        // }
        setTimeout(() => {
          // el.classList.remove('highlighted');
          el.parentNode.removeChild(par);
          this.skipScrollOnImageLoad = false;
        }, 3000);
      }
    }

  }

  setMessagesAsReadUsingHub(unreadMessages) {
    this.chattingService.setMessageAsRead(
      unreadMessages[unreadMessages.length - 1]
    );
  }

  onCloseCustomerModal() {
    this.modalRef.dismiss();
    this.customerForm.reset();
  }

  onCustomerSelected() {
    if (this.customerForm.invalid) {
      this.coreSession.showWarrning(
        this.translateService.instant(ConstantMessages.WarningCaption),
        this.translateService.instant(ConstantMessages.SelectCustomer)
      );
      return;
    }

    this.chattingCustomerId = this.customerForm.get("customerId").value;
    this.chattingOutletId = this.customerForm.get("outletId").value;

    // get chatting history for selected employee for current customer-outlet :
    var chatInfo = new ChattingHistoryModel();
    chatInfo.senderId = this.coreSession.CurrentOperator.employeeId;
    chatInfo.receiverId = this.selectedChattingUserId;
    chatInfo.customerId = this.chattingCustomerId
      ? this.chattingCustomerId
      : -1;
    chatInfo.outletId = this.chattingOutletId ? this.chattingOutletId : -1;
    this.getChattingHistory(chatInfo);

    this.onCloseCustomerModal();
  }

  onOutletChanged(outlet) {
    this.chattingCustomerOutlet = outlet;
  }

  onCustomerChanged(customer) {
    this.chattingCustomer = customer;
  }

  onAllCustomersClicked(applyHighlightToMsgs?: boolean) {
    applyHighlightToMsgs = applyHighlightToMsgs ? applyHighlightToMsgs : false;
    this.chattingCustomer = null;
    this.chattingCustomerOutlet = null;
    this.chattingCustomerId = -1;
    this.chattingOutletId = -1;

    // get chatting history for selected employee:
    var chatInfo = new ChattingHistoryModel();
    chatInfo.senderId = this.coreSession.CurrentOperator.employeeId;
    chatInfo.receiverId = this.selectedChattingUserId;
    chatInfo.customerId = -1;
    chatInfo.outletId = -1;
    this.getChattingHistory(chatInfo, applyHighlightToMsgs);
  }

  onIsTerritoryCustomersChange() {
    setTimeout(() => {
      this.resetValues.emit(-1);
    }, 10);
  }

  onRowChecked(user) {
    var idx = this.addedUserBroadcastList.findIndex(
      (bcUser) => bcUser.userId === user.userId
    );

    if (idx === -1) {
      user.isChecked = true;
      this.addedUserBroadcastList.push(user);
    } else {
      user.isChecked = false;
      this.addedUserBroadcastList.splice(idx, 1);
    }
    var selectedCount = this.AvailablebroadcastList.filter(
      (u) => u.isChecked === true
    ).length;
    if (selectedCount === this.AvailablebroadcastList.length) {
      this.isSelectAllUsers = true;
    }
    var unselectedCount = this.AvailablebroadcastList.filter(
      (u) => u.isChecked === false
    ).length;
    if (unselectedCount > 0) {
      this.isSelectAllUsers = false;
    }
  }

  onSelectAllUsers() {
    this.isSelectAllUsers = !this.isSelectAllUsers;
    if (this.isSelectAllUsers) {
      // this.addedUserBroadcastList = cloneDeep(this.AvailablebroadcastList);
      this.AvailablebroadcastList.forEach((av) => {
        if (
          this.addedUserBroadcastList.findIndex(
            (addeduser) => av.userId === addeduser.userId
          ) === -1
        ) {
          this.addedUserBroadcastList.push(av);
        }
      });
      this.AvailablebroadcastList.map((user) => {
        user.isChecked = true;
      });
    } else {
      // this.addedUserBroadcastList = [];
      this.AvailablebroadcastList.forEach((av) => {
        var idx = this.addedUserBroadcastList.findIndex(
          (addeduser) => av.userId === addeduser.userId
        );
        if (idx > -1) {
          this.addedUserBroadcastList.splice(idx, 1);
        }
      });
      this.AvailablebroadcastList.map((user) => {
        user.isChecked = false;
      });
    }
  }

  openCustomerModal() {
    this.initializeCustomerControls();
    this.config.backdrop = "static";
    this.modalRef = this.modalService.open(this.customerFilterModal, {
      centered: true,
    });
    this.config.backdrop = true;
  }

  initializeCustomerControls() {
    this.customerForm.get("isTerritoryCustomers").setValue(true);
  }

  openBroadcasrModal() {
    this.isBroadcastOpen = true;
    this.addedUserBroadcastList = [];
    // this.config.backdrop = "static";
    this.modalRef = this.modalService.open(this.broadcastModal, {
      size: "lg",
      centered: true,
    });
    this.config.backdrop = true;

    this.modalRef.result.then(
      () => { },
      () => {
        this.closeBroadcastModal();
      }
    );
  }

  closeBroadcastModal() {
    this.selectedMediaExpiryDate = null;
    this.savedMediaExpiryDate = null;
    this.isBroadcastOpen = false
    if (this.receivedWhileOnBC && this.receivedWhileOnBC.length > 0) {
      this.applyHighlightToUnreadMessages(this.receivedWhileOnBC, !this.scrollIsAtBottom);
    }
    this.messageForm.get("broadcastMessage").reset();
    this.attachedBCFiles = [];
    this.addedUserBroadcastList = [];
    this.showBroadcastAttachmentArea = false;
    this.AvailablebroadcastList.map((u) => (u.isChecked = false));
    this.isSelectAllUsers = false;
    this.modalRef.dismiss();
  }

  getDateTimeModel(selectedDateValue): DateTimeModel {
    let selectedDate = new Date(selectedDateValue);
    const date = new DateTimeModel();
    selectedDate;
    date.year = selectedDate.getFullYear();
    date.month = selectedDate.getMonth() + 1;
    date.day = selectedDate.getDate();
    date.minute = selectedDate.getMinutes();
    date.hour = selectedDate.getHours();
    date.second = selectedDate.getSeconds();
    date.date = selectedDate;
    return date;
  }

  fileIcon(fileName: string, media: ChattingHistoryMediaModel):string {
    var icon = '';
    let extension = fileName.split('.').pop();
    extension = extension.toLowerCase();
    switch(extension) {
      case "xlsx":
      case "xlsm":
      case "xls":
      case "xlsb":
      case "xltx":
        icon = "fa fa-file-excel-o";
        break;
      case "doc":
      case "docx":
        icon = "fa fa-file-word-o";
        break;
      case "pdf":
        icon = "fa fa-file-pdf-o";
        break;
      default:
        icon = "fa fa-file";
      break;
    }
    media.webIcon = icon;
    return icon;
  }



  //#region [handle files]
  onInputFileClick(event) {
    event.target.value = '';
  }

  onUploadFiles(file) {
    if (file) {
      let files = file.srcElement.files;
      if (files.length > 0) {
        for (let index = 0; index < files.length; index++) {
          if (files[index].size > 10000000) //10 MB
          {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorLargeSize));
          }
          else {
            let fileObject = new EmailFileModel();
            let reader = new FileReader();
            fileObject.file = files[index];
            fileObject.name = files[index].name;
            let dotes = files[index].name && (files[index].name.length > 20) ? '..' : '';
            fileObject.shortName = files[index].name.substring(0, 20) + dotes;
            fileObject.index = !this.isBroadcastOpen ? this.maxIndex : this.maxBCIndex;
            fileObject.isImage = files[index].type.includes('image') ? true : false;
            reader.onload = (event: ProgressEvent) => {
              if (fileObject.isImage) {
                fileObject.path = (<FileReader>event.target).result;
              } else {
                fileObject.path = this.coreSession.getDefaultPathAttachments();
              }
              fileObject.pathFile = fileObject.name;
            };
            reader.readAsDataURL(file.target.files[index]);
            if(!this.isBroadcastOpen) {
              if(this.attachedFiles.findIndex(f => f.name === fileObject.name) === -1) {
                this.maxIndex++;
                this.attachedFiles.push(fileObject);
              }
            } else {
              if(this.attachedBCFiles.findIndex(f => f.name === fileObject.name) === -1) {
                this.maxBCIndex ++;
                this.attachedBCFiles.push(fileObject);
              }
            }
          }
        }
      }
    }
    if(!this.isBroadcastOpen) {
      this.checkIfAttachmentAreaIsVisible();
    } else {
      this.checkIfAttachmentAreaIsVisibleInBroadcast();
    }
  }

  onDeleteFile(file) {
    if(!this.isBroadcastOpen) {
      this.attachedFiles.splice(this.attachedFiles.indexOf(file), 1);
      this.checkIfAttachmentAreaIsVisible();
    }
    else {
      this.attachedBCFiles.splice(this.attachedFiles.indexOf(file), 1);
      this.checkIfAttachmentAreaIsVisibleInBroadcast();
    }
  }
  
  checkIfAttachmentAreaIsVisible() {
    if(this.attachedFiles && this.attachedFiles.length > 0 ) {
      this.showAttachmentArea = true;
    } else {
      this.showAttachmentArea = false;
    }
    if(this.scrollIsAtBottom) {
      this.disableScrollDown = false;
      this.scrollToBottom();
    }
  }

  checkIfAttachmentAreaIsVisibleInBroadcast() {
    if(this.attachedBCFiles && this.attachedBCFiles.length > 0 ) {
      this.showBroadcastAttachmentArea = true;
    } else {
      this.showBroadcastAttachmentArea = false;
      this.selectedMediaExpiryDate = null;
      this.savedMediaExpiryDate = null;
    }
  }

  downloadFile(mediaMessage: ChattingHistoryMediaModel,  message: ChattingHistoryModel) {
    //file type extension
    var fileName = mediaMessage.fileName;
    var messageId = mediaMessage.messageId;
    var mediaType = mediaMessage.mediaType;
    var isDownloadedBefore = mediaMessage.isDownloaded;
    let checkFileType = fileName.split('.').pop();
    checkFileType = checkFileType.toLowerCase();
    var fileType;
    if (checkFileType == "txt") {
      fileType = "text/plain";
    }
    if (checkFileType == "pdf") {
      fileType = "application/pdf";
    }
    if (checkFileType == "doc") {
      fileType = "application/vnd.ms-word";
    }
    if (checkFileType == "docx") {
      fileType = "application/vnd.ms-word";
    }
    if (checkFileType == "xls") {
      fileType = "application/vnd.ms-excel";
    }
    if (checkFileType == "png") {
      fileType = "image/png";
    }
    if (checkFileType == "jpg") {
      fileType = "image/jpeg";
    }
    if (checkFileType == "jpeg") {
      fileType = "image/jpeg";
    }
    if (checkFileType == "gif") {
      fileType = "image/gif";
    }
    if (checkFileType == "csv") {
      fileType = "text/csv";
    }
    if(checkFileType == "xlsx") {
      fileType = 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
    }

    if (messageId != undefined && messageId && messageId.trim() != '') {
      this.chattingService
      .downloadFile(messageId, fileName, fileType)
      .subscribe(
        success => {
          saveAs(success, fileName);

          if(message.senderId !== this.currentEmployeeId && !isDownloadedBefore) {
            mediaMessage.isDownloaded = true;
            message = this.prepareMessageWithMediaObj(message,fileName,mediaType);
            this.setAttachmentAsDownloaded(message);
          }
        },
        err => {
          alert("Server error while downloading file.");
        }
      );
    }
  }
  //#endregion

  prepareMessageWithMediaObj(message, fileName:string, fileType: ChattingMediaTypes): ChattingHistoryModel {
    var msgObj = new ChattingHistoryModel();
    // fill main message data:
    msgObj.messageId = message.messageId;
    msgObj.senderId = message.senderId;
    msgObj.receiverId = message.receiverId;
    msgObj.isBOReceiver = true;
    msgObj.isBOSender = this.selectedChattingUser.isBOUser;  /* message.senderDeviceSerial == '' && message.senderDeviceToken == '' ? true : false; */
    msgObj.senderDeviceSerial = message.senderDeviceSerial;

    // fill downloaded file data:
    var mediaObj = new ChattingHistoryMediaModel();
    mediaObj.messageId = message.messageId;
    mediaObj.fileName = fileName;
    mediaObj.mediaType = fileType;


    msgObj.mediaList.push(mediaObj);
    return msgObj;
  }

  setAttachmentAsDownloaded(message) {
    this.chattingService
      .setAttachmentAsDownloaded(message).subscribe(
        (response) => {},
        (error: HttpErrorResponse) => { }
      );
  }

  openMediaExpiryDateDialog() {
    this.mediaExpiryDateForm.get('mediaExpiryDate').setValue(this.savedMediaExpiryDate ? this.savedMediaExpiryDate.date : null);
    this.mediaExpiryDateDialog.Show(true).then((res) => { });
  }

  onMediaExpiryDateSave() {
    this.savedMediaExpiryDate = this.selectedMediaExpiryDate;
    this.mediaExpiryDateDialog.Close();
  }

  onMediaExpiryDateCanceled() {
    this.mediaExpiryDateDialog.Close();
  }

  onMediaExpiryDateSelected(date) {
    
    this.selectedMediaExpiryDate = date;
  }

  onload() {
    // console.log('onload -> skipScrollOnImageLoad: ',this.skipScrollOnImageLoad);
    var skipCondition = 
    this.skipScrollOnImageLoad || 
    (!this.scrollIsAtBottom && this.selectedUserChattingHistory && this.selectedUserChattingHistory.some(msg => !msg.isRead));
    if(!skipCondition) {
      this.scrollToBottom();
    }
  }
}
