import { Component } from '@angular/core';
import { ActivatedRoute, Router } from '@angular/router';
import { TranslateService } from '@ngx-translate/core';
import { Subject } from 'rxjs/Rx';
import { CoreSession } from '../../../core/core.session';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { NavBarService } from '../../../core/sidebar/sidebar.service';
import { ConstantConfigurations } from '../../../shared/models/constants/constant-configuration';
import { ConstantURLs } from '../../../shared/models/constants/constant-URL';
import { MenuModel } from '../../../shared/models/menu/menu.model';
import { NavigationData } from '../../../shared/models/navigation-data/navigation-data.model';


@Component({
  selector: 'customer-app-properties-main',
  templateUrl: './customer-app-properties-main.component.html',
  styleUrls: ['./customer-app-properties-main.css']
})
export class CustomerAppPropertiesMainComponent {
  AllowCustomerAppLogin: boolean = false;
  isCustAppPropertiesMenuVisible: boolean = true;
  isFQAsMenuVisible: boolean = true; //
  moduleId: number;
  customerAppPropertiesComponent = false;
  showSlider = false;
  sliderDescription: String = '';
  customerAppBannersComponent = false;
  customerAppItemsComponent = false;
  isFQAsComponent =false;
  companyDetailsComponent = false;
  organizationDetailsComponent = false;
  isCustAppBannersMenuVisible: boolean = true;
  isCompanyDetailsMenuVisible: boolean = true;
  isOrganizationDetailsMenuVisible: boolean = true;
  isItemDefenitionMenuVisible : boolean = true
  isPriceListMenuVisible : boolean = true;
  isCustomerDefinitionMenuVisible : boolean =true
  notificationManagementComponent = false;
  changeLanguageComponent = false;
  customerAppFirstOrderItemsComponent: boolean = false;
  customerAppSettingsComponent: boolean = false;

  saveSubject: Subject<void> = new Subject<void>();
  navLinks: any[];

  constructor(public coreSession: CoreSession,
              private translateService: TranslateService,
              private router: Router,
              private route: ActivatedRoute,
              private sessionData: SessionDataProvider,
              private sessionDataProvider: SessionDataProvider,
              private navService:NavBarService
              ) { }
  ngOnInit() {
    this.AllowCustomerAppLogin = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowCustomerAppLogin).toLowerCase() === "true";
    this.checkExistedMenus();
  }
  ngOnChanges() {
    this.sessionDataProvider.loadSessionLanguges();
  }

  checkIfCustAppPropertiesMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '1700-001-01').length < 1) {
      this.isCustAppPropertiesMenuVisible = false;
    }
  }
  checkIfItemDefenitionMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '1700-002').length < 1) {
      this.isItemDefenitionMenuVisible = false;
    }
  }
  checkIfPriceListDefenitionMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '1700-003').length < 1) {
      this.isPriceListMenuVisible = false
       }
  }

  checkIfCustomerDefenitionMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '1700-004').length < 1) {
      this.isCustomerDefinitionMenuVisible = false
       }
  }


  checkIfCustAppBannersMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '1700-001-02').length < 1) {
      this.isCustAppBannersMenuVisible = false;
    }
  }
  checkIfCompanyDetailsMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '1700-001-03').length < 1) {
      this.isCompanyDetailsMenuVisible = false;
    }

  }
  checkIfOrganizationDetailsMenuVisible(menu: MenuModel[]) {
    if (menu.filter(x => x.menuId === '1700-001-04').length < 1) {
      this.isOrganizationDetailsMenuVisible = false;
    }
  }

  openCustomerAppPropertiesMenu(moduleId) {
    this.moduleId = moduleId;
    this.customerAppPropertiesComponent = true;
    this.showSlider = true;
    if (moduleId == 1)
      this.sliderDescription = this.translateService.instant('Desc_About_Us');
    else if (moduleId == 2)
      this.sliderDescription = this.translateService.instant('Desc_Privacy_Policy');
  }

  openCustomerAppBannersMenu() {
    this.customerAppBannersComponent = true;
    this.showSlider = true;
    this.sliderDescription = this.translateService.instant('Desc_Banners');
  }

  openSendNotificationMenu() {
    this.coreSession.SetTitle("Notification Management");
    this.showSlider = true;
    this.notificationManagementComponent = true;
    this.sliderDescription = this.translateService.instant('Desc_Send_Notification');
  }


  close() {
    this.showSlider = false;
    this.changeLanguageComponent = false;
    this.customerAppPropertiesComponent = false;
    this.customerAppBannersComponent = false;
    this.notificationManagementComponent = false;
    this.customerAppItemsComponent = false;
    this.isFQAsComponent = false;
    this.customerAppFirstOrderItemsComponent = false;
    this.customerAppSettingsComponent = false;
  }

  onCustomerPropertiesSaved() {
    this.customerAppPropertiesComponent = false;
    this.showSlider = false;
  }

  onSaveDescriptions() {
    this.saveSubject.next();
  }

  onSendCompleted() {
    this.notificationManagementComponent = false;
    this.close();
  }

  onPacksCustomerAppSaved() {
    this.customerAppItemsComponent = false;
    this.showSlider = false;
  }

  onFQAsSaved() {
    this.isFQAsComponent = false;
    this.showSlider = false;
  }

  onFirstOrderPacksCustomerAppSaved() {
    this.customerAppFirstOrderItemsComponent = false;
    this.showSlider = false;
  }
  onCustomerAppSettingsSaved() {
    this.customerAppSettingsComponent = false;
    this.showSlider = false;
  }

  openFeedbackMenu() {
    this.router.navigate([ConstantURLs.custAppPropertiesURL], {
      relativeTo: this.route.parent
    });
    this.prepareNavigation();
    var index = this.navLinks.findIndex(x => x.link == this.navService.searchMenuURL);
    if (index == -1) index = 0;
    this.navLinks[index].isActive = true;
    this.setNavigation(this.navLinks[index]);
  }
  openCompanyDetailsMenu() {
    this.router.navigate([ConstantURLs.companyDetailsURL], {
      relativeTo: this.route.parent
    });
    this.prepareNavigation();
    this.setNavigation(this.navLinks[1]);
  }

  openOrganizationDetailsMenu() {
    this.router.navigate([ConstantURLs.organizationDetailsURL], {
      relativeTo: this.route.parent
    });
    this.prepareNavigation();
    this.setNavigation(this.navLinks[1]);
  }

  openCustomerAppItemsMenu() {
    this.customerAppItemsComponent = true;
    this.showSlider = true;
    this.sliderDescription = this.translateService.instant('Desc_Items');
  }
  openFQAsItemsMenu(){
    this.isFQAsComponent = true;
    this.showSlider = true;
    this.sliderDescription = this.translateService.instant('Desc_FQAs');
  }

  openCustomerAppFirstOrderItemsMenu() {
    this.customerAppFirstOrderItemsComponent = true;
    this.showSlider = true;
    this.sliderDescription = this.translateService.instant('Desc_First_Order_Free_Items');
  }
  openCustomerSettingsMenu() {
    this.customerAppSettingsComponent = true;
    this.showSlider = true;
    this.sliderDescription = this.translateService.instant('Desc_Customer_App_Settings');
  }

  setNavigation(tab) {
    let navigationList: NavigationData[] = [];
    navigationList.push(
      {
        Name: 'Desc_Customer_App_Properties',
        URL: ConstantURLs.customerAppPropertiesURL
      },
      {
        Name: tab.label,
        URL: undefined
      }
    );
    this.navService.setNavigation(navigationList);
  }

  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_Customer_App_Feedback',
        index: 0,
        isActive: true,
      },
      {
        label: 'Desc_Company_Details',
        index: 0,
        isActive: true,
      },
      {
        label: 'Desc_Vendor_Details',
        index: 0,
        isActive: true,
      }
    ];
  }
  checkExistedMenus() {
    this.checkIfCustAppPropertiesMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfCustAppBannersMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfCompanyDetailsMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfOrganizationDetailsMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfItemDefenitionMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfPriceListDefenitionMenuVisible(this.sessionDataProvider.allMenusAvailable);
    this.checkIfCustomerDefenitionMenuVisible(this.sessionDataProvider.allMenusAvailable);
  }

}
