import { NgModule } from "@angular/core";
import { RouterModule, Routes } from "@angular/router";
import { AuthGuard } from "../../core/auth/auth.gurad";
import { CustAppContactUsComponent } from "../../echo/properties/cust-app-contact-us/contact-us-list.component";
import { ConstantURLs } from "../../shared/models/constants/constant-URL";
import { CustomerAppPropertiesMainComponent } from "./customer-app-properties-main/customer-app-properties-main.component";
import { CustAppItemsEntryComponent } from '../../echo/properties/cust-app-items-entry/cust-app-items-entry.component';
import { CustAppFirstOrderItemsEntryComponent } from "../../echo/properties/cust-app-first-order-items-entry/cust-app-first-order-items-entry.component";
import { OrganizationDetailsListComponent } from '../../echo/properties/organization-details/organization-details-list/organization-details-list.component';

const CustomerAppPropertiesRouting: Routes = [
  {
    path: "",
    canActivate: [AuthGuard],
    component: CustomerAppPropertiesMainComponent
  },
  {
    path: ConstantURLs.customerAppPropertiesURL,
    canActivate: [AuthGuard],
    component: CustomerAppPropertiesMainComponent
  }, {
    path: ConstantURLs.custAppPropertiesURL,
    canActivate: [AuthGuard],
    component: CustAppContactUsComponent
  }, {
    path: ConstantURLs.custAppItemsURL,
    canActivate: [AuthGuard],
    component: CustAppItemsEntryComponent
  }, {
    path: ConstantURLs.custAppFirstOrderItems,
    canActivate: [AuthGuard],
    component: CustAppFirstOrderItemsEntryComponent
  }, {
    path: ConstantURLs.organizationDetailsURL,
    canActivate: [AuthGuard],
    component: OrganizationDetailsListComponent
  },

];
@NgModule({
  imports: [RouterModule.forChild(CustomerAppPropertiesRouting)],
  exports: [RouterModule]
})

export class CustomerAppPropertiesRoutingModule { }
