import { NgModule } from "@angular/core";
import { CommonModule, DatePipe } from "@angular/common";
import { ReactiveFormsModule, FormsModule } from "@angular/forms";
import { SharedModule } from "../../shared/shared.module";
import { TranslateModule } from "@ngx-translate/core";
import { NgbModule } from "@ng-bootstrap/ng-bootstrap";
import { NgSelectModule } from "@ng-select/ng-select";
import { MatExpansionModule } from "@angular/material/expansion";
import { NgMultiSelectDropDownModule } from "ng-multiselect-dropdown";
import { QuillModule } from "ngx-quill";
import { CustomerAppPropertiesRoutingModule } from "./customer-app-properties-routing.module";
import { CustAppPropertiesEntryComponent } from "../../echo/properties/cust-app-properties-entry/cust-app-properties-entry.component";
import { CustomerAppPropertiesMainComponent } from "./customer-app-properties-main/customer-app-properties-main.component";
import { HtmlEntryComponent } from "../../echo/shared/components/html-entry/html-entry.component";
import { CustAppContactUsComponent } from "../../echo/properties/cust-app-contact-us/contact-us-list.component";
import { CustAppItemsEntryComponent } from "../../echo/properties/cust-app-items-entry/cust-app-items-entry.component";
import { NgOptionHighlightModule } from '@ng-select/ng-option-highlight';
import { CustAppFirstOrderItemsEntryComponent } from "../../echo/properties/cust-app-first-order-items-entry/cust-app-first-order-items-entry.component";
import { CustAppReplyComponent } from "../../echo/properties/cust-app-contact-us/cust-app-reply/cust-app-reply.component";
import { OrganizationDetailsListComponent } from "../../echo/properties/organization-details/organization-details-list/organization-details-list.component";
import { OrganizationDetailsEntryComponent } from "../../echo/properties/organization-details/organization-details-entry/organization-details-entry.component";
import { FQAsEntryComponent } from '../../echo/properties/fqas-entry/fqas-entry.component';
@NgModule({
  declarations: [
    CustomerAppPropertiesMainComponent,
    CustAppPropertiesEntryComponent,
    HtmlEntryComponent,
    CustAppContactUsComponent,
    CustAppReplyComponent,
    CustAppItemsEntryComponent,
    CustAppFirstOrderItemsEntryComponent,
    OrganizationDetailsListComponent,
    OrganizationDetailsEntryComponent,
    FQAsEntryComponent
  ],
  imports: [
    CustomerAppPropertiesRoutingModule,
    CommonModule,
    ReactiveFormsModule,
    FormsModule,
    SharedModule,
    TranslateModule.forChild(),
    NgbModule,
    NgSelectModule,
    NgMultiSelectDropDownModule,
    MatExpansionModule,
    QuillModule.forRoot(),
    NgOptionHighlightModule,
  ],
  exports: [CustomerAppPropertiesMainComponent,
    CustAppPropertiesEntryComponent,
    HtmlEntryComponent,
    CustAppContactUsComponent,
    CustAppReplyComponent,
    CustAppItemsEntryComponent,
    CustAppFirstOrderItemsEntryComponent,
    OrganizationDetailsListComponent,
    OrganizationDetailsEntryComponent,
    FQAsEntryComponent],
  providers: [DatePipe],
})
export class CustomerAppPropertiesModule { }
