import { NewCustomerListComponent } from './new-customer/new-customer-list/new-customer-list.component';
import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { ConstantURLs } from '../../shared/models/constants/constant-URL';
import { PendingInvoicesComponent } from './payments/pending-invoices/pending-invoices.component';
import { CustomerTransactionListComponent } from './transactions/customer-transaction-list/customer-transaction-list.component';
import { CustomerTransactionEntryComponent } from './transactions/customer-transaction-entry/customer-transaction-entry.component';
import { PaymentsListComponent } from './payments/payments-list/payments-list.component';
import { AuthGuard } from '../../core/auth/auth.gurad';
import { DownPaymentsListComponent } from './payments/down-payments-list/down-payments-list.component';

import { TransactionsEmailsComponent } from './transactions-emails/transactions-emails.component';
import { TransactionListComponent } from './transaction/transaction-list/transaction-list.component';

import { InvoicesComponent } from './transactions/invoices/invoices.component';
import { TestInvoicesComponent } from './transactions/test-invoices/test-invoices.component';

const transactionRouting: Routes = [
  {
    path: '',
    canActivate: [AuthGuard],
    children: [
      {
        path: ConstantURLs.invoiceListURL,
        canActivate: [AuthGuard],
        component: InvoicesComponent,
      },
      {
        path: ConstantURLs.testInvoicesListURL,
        canActivate: [AuthGuard],
        component: TestInvoicesComponent,
      },
      {
        path: ConstantURLs.collectionURL,
        canActivate: [AuthGuard],
        component: PendingInvoicesComponent
      },
      {
        path: ConstantURLs.addInvoiceURL,
        canActivate: [AuthGuard],
        component: CustomerTransactionEntryComponent
      },
      {
        path: ConstantURLs.paymentsListURL,
        canActivate: [AuthGuard],
        component: PaymentsListComponent
      },
      {
        path: ConstantURLs.downPaymentsListURL,
        canActivate: [AuthGuard],
        component: DownPaymentsListComponent
      }

     ,
      {
        path: ConstantURLs.invoicesEmails,
        canActivate: [AuthGuard],
        component: TransactionsEmailsComponent
      },
      {
        path: ConstantURLs.transactionListURL,
        canActivate: [AuthGuard],
        component: TransactionListComponent
      },

      { path: '', redirectTo: '/' + ConstantURLs.customerOperationsURL + '/' + ConstantURLs.invoiceListURL, pathMatch: 'full' },
    ],
  },

];
@NgModule({
  imports: [RouterModule.forChild(transactionRouting)],
  exports: [RouterModule]
})
export class CustomerOperationRoutingModule { }
