import { NgModule } from "@angular/core";
import { CommonModule } from "@angular/common";
import { ReactiveFormsModule, FormsModule } from "@angular/forms";
import { SharedModule } from "../../shared/shared.module";
import { NgbModule } from "@ng-bootstrap/ng-bootstrap";
import { OwlDateTimeModule, OwlNativeDateTimeModule } from "ng-pick-datetime";
import { PendingInvoicesComponent } from "./payments/pending-invoices/pending-invoices.component";
import { CustomerOperationRoutingModule } from "./customer-operation-routing.module";
import { CustomerTransactionListComponent } from "./transactions/customer-transaction-list/customer-transaction-list.component";
import { CustomerTransactionEntryComponent } from "./transactions/customer-transaction-entry/customer-transaction-entry.component";
import { NgSelectModule } from "@ng-select/ng-select";
import { PaymentsListComponent } from "./payments/payments-list/payments-list.component";
import { TranslateModule } from "@ngx-translate/core";
import { PaymentsEntryComponent } from "./payments/payments-entry/payments-entry.component";
import { DownPaymentsListComponent } from "./payments/down-payments-list/down-payments-list.component";
import { NewCustomerListComponent } from "./new-customer/new-customer-list/new-customer-list.component";
import { NewCustomerEntryComponent } from "./new-customer/new-customer-entry/new-customer-entry.component";
import { NgMultiSelectDropDownModule } from "ng-multiselect-dropdown";
import { NgOptionHighlightModule } from "@ng-select/ng-option-highlight";
import { NgxGalleryModule } from "@kolkov/ngx-gallery";
import { TransactionsEmailsComponent } from './transactions-emails/transactions-emails.component';
import { TransactionsEmailsEntryComponent } from './transactions-emails/transactions-emails-entry/transactions-emails-entry.component';
import { TransactionListComponent } from "./transaction/transaction-list/transaction-list.component";
import { CustomerModule } from "../master-data-definition/customers/customer.module";
import { InvoicesComponent } from './transactions/invoices/invoices.component';
import { TestInvoicesComponent } from './transactions/test-invoices/test-invoices.component';

@NgModule({
  declarations: [
    CustomerTransactionListComponent,
    CustomerTransactionEntryComponent,
    PendingInvoicesComponent,
    PaymentsEntryComponent,
    PaymentsListComponent,
    DownPaymentsListComponent,
    NewCustomerListComponent,
    NewCustomerEntryComponent,

    TransactionsEmailsComponent,
    TransactionsEmailsEntryComponent,
    TransactionListComponent,

    InvoicesComponent,
    TestInvoicesComponent,

  ],
  imports: [
    CommonModule,
    ReactiveFormsModule,
    FormsModule,
    CustomerOperationRoutingModule,
    SharedModule,
    OwlDateTimeModule,
    OwlNativeDateTimeModule,
    NgbModule,
    NgSelectModule,
    NgMultiSelectDropDownModule,
    TranslateModule.forChild(),
    NgOptionHighlightModule,
    NgxGalleryModule,
    CustomerModule
  ],
})
export class CustomerOperationModule { }
