import { TranslateService } from '@ngx-translate/core';
import { NewCustomerService } from './../new-customer.service';
import { CoreSession } from './../../../../core/core.session';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { HttpErrorResponse } from '@angular/common/http';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { Observable } from 'rxjs';
import { RowOperation } from '../../../../shared/models/enums/shared-table-operation.enum';
import { saveAs } from "file-saver";
import { CustomerService } from '../../../../shared/services/data-definition/customer/customers.service';
import { EmailFileModel } from '../../../../shared/models/email/email.model';
import { DialogResult } from '../../../../shared/models/enums/dialog-result.enum';
import { DialogMode } from '../../../../shared/models/enums/dialog-mode.enum';

@Component({
  selector: 'app-new-customer-entry',
  templateUrl: './new-customer-entry.component.html',
  styleUrls: ['./new-customer-entry.component.css']
})
export class NewCustomerEntryComponent implements OnInit {
  @Input() newCustomerObj: any;
  @Input() isEditOrg: any;
  @Output() onSaveCompleted = new EventEmitter();
  @Input() events: Observable<void>;
  customerFormGroup: FormGroup;
  editOrgFormGroup: FormGroup;
  saveBtnSubscription: any;
  modal: any;
  navLinks: any[];
  showDefinitionData: boolean = false;
  showImageData: boolean = false;
  showImageTemplate: boolean = false;
  showVisitPattern: boolean = false;
  imagesNames: any[] = [];
  imagesPaths: any[] = [];
  attachedFiles: EmailFileModel[] = [];
  TabelData: ITableProperties = {
    pageSize: 25,
    showPaginator: true,
    isOnline: true,
    showSearch: true,
    showSearchBtn: false,
    showNewBtn: false,
    isMultiSelection: false,
    rowOperations: [
      {
        operation: RowOperation.Select,
        title: 'Desc_Match',
        icon: 'fa-solid fa-check',
        color: '#28a745'
      }],
    multiSelectionOperations: [],
    specificActionWhenCheckRow: true,
    specificActionWhenCheckAll: true,
    showOptionButtonsSeparated: true,
    columns: [
      { title: 'Desc_Customer', key: 'outletCodeName', isSortable: true, width: '30%' },
      { title: 'Desc_Address', key: 'address', isSortable: true, width: '20%' },
      { title: 'Desc_Phone', key: 'phone', isSortable: false, width: '15%' },
      { title: 'Desc_Trade_License_Number', key: 'tradeLicenceNumber', isSortable: false, width: '35%' },

    ]
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  outletsFilter: any = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: 25
    },
  }
  matchingOption: boolean = false;
  customerId: any;
  outletId: any;
  newSelectedOrg: any;
  direction: any;
  templateFields: any[] = [];
  imageList: any[] = [];
  routeVisitPattern: any;
  constructor(private translate: TranslateService,
    private coreSession: CoreSession,
    private newCustomerService: NewCustomerService,
    private customerService: CustomerService) {
    this.matchingOption = false;
  }

  ngOnInit() {
    this.initFormGroup();
    this.subscribeSaveClick();
    this.initialMatchingList();
    this.getCustomerAttachements();
    this.prepareNavigation();
    this.navLinks[0].isActive = true;
    this.getOuletImages();
    if (this.newCustomerObj.newCustomerTemplateId != -1 && !this.isEditOrg) {
      this.getCustomerTemplate();
    }
    this.showDefinitionData = true;
    this.showImageData = false;
    this.showImageTemplate = false;
    this.showVisitPattern = false;
    this.direction = this.coreSession.isRTL;
  }
  ngOnDestroy() {
    this.saveBtnSubscription.unsubscribe();
  }
  initFormGroup() {
    this.customerFormGroup = new FormGroup({
      customer: new FormControl({ value: this.newCustomerObj.outletCodeName, disabled: true }),
      phone: new FormControl({ value: this.newCustomerObj.phone, disabled: true }),
      address: new FormControl({ value: this.newCustomerObj.address, disabled: true }),
      tradeLicenceNumber: new FormControl({ value: this.newCustomerObj.tradeLicenceNumber, disabled: true }),
    });
    this.editOrgFormGroup = new FormGroup({
      customer: new FormControl({ value: this.newCustomerObj.outletCodeName, disabled: true }),
      organizationId: new FormControl(this.newCustomerObj && this.newCustomerObj.organizationId > 0 ? this.newCustomerObj.organizationId : null, Validators.required),
    });
    if (this.newCustomerObj && this.newCustomerObj.organizationId > 0) {
      this.newSelectedOrg = this.newCustomerObj.organizationId;
    }
  }
  onNewCustomerOptionChanged(option: any) {
    if (option.target.value === "1") {
      this.matchingOption = false;
    }
    else {
      this.matchingOption = true;
    }
  }
  onTableFilterChanged(query: any) {
    this.outletsFilter.customListFilter = query;
    this.getCustomerList();
  }
  initialMatchingList() {
    this.outletsFilter = {
      customListFilter: {
        searchFilter: this.newCustomerObj.outletCodeName,
        page: 0,
        pageSize: 25
      }
    }
    this.getCustomerList();
  }
  getCustomerAttachements() {
    this.coreSession.ModalLoading.Show();
    this.newCustomerService.getCustomerAttachements(this.newCustomerObj.customerId).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.attachedFiles = response.data;
      } else {
        this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), this.translate.instant(ConstantMessages.ErrorHappened));
    }
    );
  }
  getCustomerList() {
    this.coreSession.ModalLoading.Show();
    this.newCustomerService.getOutletsListSharedTable(this.outletsFilter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.dataSource = <SharedTableResult>response.data;
      } else {
        this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), this.translate.instant(ConstantMessages.ErrorHappened));
    }
    );
  }
  subscribeSaveClick() {
    this.saveBtnSubscription = this.events.subscribe(() => {
      if (this.newCustomerObj.isVisitPattern && this.newCustomerObj.routesList.length == 0) {
        this.coreSession.ModalDialog.ShowMessage(this.translate.instant(ConstantMessages.MsgNoRouteConfiramtion), DialogMode.YesNo, this.translate.instant(ConstantMessages.WarningCaption)).then(
          (res: DialogResult) => {
            if (res === DialogResult.Yes) {
              this.onSaveClicked();
            }
          });
      } else {
        this.onSaveClicked();
      }
    });
  }
  onSaveClicked() {
    if (!this.isEditOrg) {
      if (this.matchingOption) {
        if (!this.customerId || !this.outletId) {
          this.coreSession.showError(this.translate.instant(ConstantMessages.SelectCustomer), '');
          return;
        }
        this.newCustomerObj.matchCustomerId = this.customerId;
        this.newCustomerObj.matchOutletId = this.outletId;
        // }
        this.coreSession.ModalLoading.Show();
        this.newCustomerService.matchNewCustomer(this.newCustomerObj).subscribe(
          (response) => {
            this.coreSession.ModalLoading.Hide();
            if (response.status != null && response.status >= 0) {
              this.coreSession.showSuccess(this.translate.instant(ConstantMessages.SuccessCaption), this.translate.instant(ConstantMessages.MsgSavedSuccessfuly));
              this.onSaveCompleted.emit(this.matchingOption ? -1 : response.data);
            } else {
              this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), response.message);
            }
          }, (error: HttpErrorResponse) => {
            this.coreSession.ModalLoading.Hide();
            this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), this.translate.instant(ConstantMessages.ErrorCaption));
          }
        );
      } else {
        if (this.newCustomerObj.newCustomerTemplateId != -1 && !this.isEditOrg)
          this.saveCustomerData();
        else
          this.onSaveCompleted.emit(this.newCustomerObj.customerId);
      }
    }
    else {
      this.coreSession.markFormGroupTouched(this.editOrgFormGroup);
      if (!this.editOrgFormGroup.valid) {
        this.coreSession.showWarrning(this.translate.instant(ConstantMessages.WarningCaption), this.translate.instant(ConstantMessages.MsgFillMandatory));
        return;
      }
      this.coreSession.ModalLoading.Show();
      this.newCustomerService.updateCustomerOrg(this.newCustomerObj.customerId, this.newCustomerObj.outletId, this.newSelectedOrg).subscribe(
        (response) => {
          this.coreSession.ModalLoading.Hide();
          if (response.status != null && response.status >= 0) {
            this.coreSession.showSuccess(this.translate.instant(ConstantMessages.SuccessCaption), this.translate.instant(ConstantMessages.MsgSavedSuccessfuly));
            this.onSaveCompleted.emit(-1);
          } else {
            this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), response.message);
          }
        }, (error: HttpErrorResponse) => {
          this.coreSession.ModalLoading.Hide();
          this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), this.translate.instant(ConstantMessages.ErrorCaption));
        }
      );
    }
  }
  saveCustomerData() {
    this.newCustomerService.saveNewCustomerData(this.newCustomerObj).subscribe(
      (response) => {
        if (response.status != null && response.status >= 0) {
          // this.coreSession.showSuccess(this.translate.instant(ConstantMessages.SuccessCaption), this.translate.instant(ConstantMessages.MsgSavedSuccessfuly));
          this.onSaveCompleted.emit(this.newCustomerObj.customerId);
        } else {
          this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), this.translate.instant(ConstantMessages.ErrorCaption));
      }
    );
  }
  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.UnSelect:
        this.customerId = null;
        this.outletId = null;
        break;
      case RowOperation.Select:
        this.customerId = event.object.customerId;
        this.outletId = event.object.outletId;
        break;
    }
  }
  downloadFile(fileName) {
    //file type extension
    let checkFileType = fileName.split('.').pop();
    var fileType;
    if (checkFileType == "txt") {
      fileType = "text/plain";
    }
    if (checkFileType == "pdf") {
      fileType = "application/pdf";
    }
    if (checkFileType == "doc") {
      fileType = "application/vnd.ms-word";
    }
    if (checkFileType == "docx") {
      fileType = "application/vnd.ms-word";
    }
    if (checkFileType == "xls") {
      fileType = "application/vnd.ms-excel";
    }
    if (checkFileType == "png") {
      fileType = "image/png";
    }
    if (checkFileType == "jpg") {
      fileType = "image/jpeg";
    }
    if (checkFileType == "jpeg") {
      fileType = "image/jpeg";
    }
    if (checkFileType == "gif") {
      fileType = "image/gif";
    }
    if (checkFileType == "csv") {
      fileType = "text/csv";
    }


    this.customerService
      .downloadOutletAttachments(this.newCustomerObj.customerId + '\\' + this.newCustomerObj.outletId, fileName, fileType)
      .subscribe(
        success => {
          saveAs(success, fileName);
        },
        err => {
          alert("Server error while downloading file.");
        }
      );
  }
  showEntrySection(selectedIndex: number) {
    this.navLinks.forEach(a => a.isActive = false);
    this.navLinks[selectedIndex].isActive = true;
    if (selectedIndex == 0) {
      this.showDefinitionData = true;
      this.showImageData = false;
      this.showImageTemplate = false;
      this.showVisitPattern = false;
    } else if (selectedIndex == 1 && !this.isEditOrg) {
      this.showDefinitionData = false;
      this.showImageData = true;
      this.showImageTemplate = false;
      this.showVisitPattern = false;
    } else if (selectedIndex == 2 && !this.isEditOrg) {
      this.showDefinitionData = false;
      this.showImageData = false;
      this.showImageTemplate = true;
      this.showVisitPattern = false;
    } else if (selectedIndex == 3 && !this.isEditOrg) {
      this.showDefinitionData = false;
      this.showImageData = false;
      this.showImageTemplate = false;
      this.showVisitPattern = true;
    }
  }

  prepareNavigation() {
    this.navLinks = [
      {
        label: 'Desc_New_Customer',
        index: 0,
        isActive: false,
        hidden: false,
      },
      {
        label: 'Desc_Images',
        index: 1,
        isActive: false,
        hidden: true,
      },
      {
        label: 'Desc_Images_Template',
        index: 2,
        isActive: false,
        hidden: true,
      },
      {
        label: 'Desc_Visits_Pattern',
        index: 3,
        isActive: false,
        hidden: true,
      }
    ];
  }

  closeImage() {
    // When the user click (x), close the modal
    document.getElementById("myModal").style.display = "none";
  }


  openImage(event: any) {

    if (event != null) {
      let target = event.target || event.srcElement || event.currentTarget;
      let modal = document.getElementById("myModal");
      let img = document.getElementById(target.attributes.id.nodeValue).getAttribute('src');
      let modalImg = document.getElementById("img01");
      modal.style.display = "block";
      modalImg.setAttribute('src', img);
      document.getElementById("footer-container").style.zIndex = '-1';
    }
  }


  getOuletImages() {
    let customerOutletId = this.newCustomerObj.customerId + '_' + this.newCustomerObj.outletId;
    this.coreSession.ModalLoading.Show();
    this.customerService.GetOutletImages(customerOutletId).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.imagesNames = response.data;
          this.imagesPaths = Array.from(this.imagesNames)
          if (this.imagesPaths && this.imagesPaths.length > 0) {
            this.imagesPaths.forEach((path, index) => {
              var currentPath = document.getElementsByTagName("base")[0].href + path;
              this.imagesPaths[index] = currentPath;
            });
          }
          this.navLinks[1].hidden = false;
        }
      });

  }
  getCustomerTemplate() {
    this.coreSession.ModalLoading.Show();
    this.newCustomerService.getCustomerTemplate(this.newCustomerObj).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (response.data.templateFields && response.data.templateFields.length > 0) {
            this.templateFields = response.data.templateFields;
            this.templateFields.forEach(field => {
              this.customerFormGroup.addControl(field.name, new FormControl(field.value));
            });
          }
          if (response.data.templateImages && response.data.templateImages.length > 0) {
            this.imageList = response.data.templateImages;
            this.newCustomerObj.templateImages = this.imageList;
            this.newCustomerObj.routeHistoryId = this.imageList[0].routeHistoryId;
            this.newCustomerObj.deviceSerial = this.imageList[0].deviceSerial;
            this.navLinks[2].hidden = false;
          }
          if (response.data.routeVisitPattern && response.data.routeVisitPattern.length > 0) {
            this.routeVisitPattern = response.data.routeVisitPattern;
            this.newCustomerObj.isVisitPattern = true;
            this.navLinks[3].hidden = false;
          }
          if (response.data.routeList && response.data.routeList.length > 0) {
            this.newCustomerObj.routesList = response.data.routeList;
          }
        } else {
          this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translate.instant(ConstantMessages.ErrorCaption), this.translate.instant(ConstantMessages.ErrorHappened));
      });
  }
  onChangeOrganizationId(organization) {
    this.newSelectedOrg = organization.organizationId;
  }
  openNewCustomerTempImage(event: any) {
    if (event != null) {
      let target = event.target || event.srcElement || event.currentTarget;
      let modal = document.getElementById("tempModal");
      let img = target.attributes.src.nodeValue;
      let modalImg = document.getElementById("tempImg");
      modal.style.display = "block";
      modalImg.setAttribute('src', img);
      document.getElementById("footer-container").style.zIndex = '-1';
    }
  }
  closeNewCustomerTempImage() {
    document.getElementById("tempModal").style.display = "none";
  }
}
