import { TranslateService } from '@ngx-translate/core';
import { TransactionService } from './../../transactions/transaction.service';
import { NewCustomerService } from './../new-customer.service';
import { CoreSession } from './../../../../core/core.session';
import { Component, OnInit } from '@angular/core';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { GeneralFilter } from '../../../../shared/models/general/generalFilter.model';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { HttpErrorResponse } from '@angular/common/http';
import { RowOperation } from '../../../../shared/models/enums/shared-table-operation.enum';
import { Subject } from 'rxjs';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { MenuActions } from '../../../../shared/models/enums/menu-actions-enum';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { ConstantConfigurations } from '../../../../shared/models/constants/constant-configuration';
import { DialogResult } from '../../../../shared/models/enums/dialog-result.enum';
import { DialogMode } from '../../../../shared/models/enums/dialog-mode.enum';

@Component({
  selector: 'app-new-customer-list',
  templateUrl: './new-customer-list.component.html',
  styleUrls: ['./new-customer-list.component.css']
})
export class NewCustomerListComponent implements OnInit {

  showSlider: boolean;
  isEditOrg: boolean;
  selectedcustomerObj: any;
  showEntrySlider = false;
  saveSubject: Subject<void> = new Subject<void>();
  editApprovedCustomerSubject: Subject<void> = new Subject<void>();
  selectedCustomerId: any = -1;
  isEditMode = false;

  TabelData: ITableProperties = {
    pageSize: 25,
    showPaginator: true,
    isOnline: true,
    showSearch: true,
    showSearchBtn: true,
    showNewBtn: false,
    showEditButton: false,
    isMultiSelection: false,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Customer', key: 'outletCodeName', isSortable: true, width: '18%' },
      { title: 'Desc_Employee', key: 'employeeCodeName', isSortable: true, width: '18%' },
      { title: 'Desc_Created_Date', key: 'createdDate', isSortable: true, width: '15%', isDate: true },
      { title: 'Desc_Address', key: 'address', isSortable: true, width: '19%' },
      { title: 'Desc_Phone', key: 'phone', isSortable: false, width: '10%' },
      { title: 'Desc_GPSLatitude', key: 'latitude', isSortable: false, width: '10%' },
      { title: 'Desc_GPSLongitude', key: 'longitude', isSortable: false, width: '10%' },
    ]
  };
  customerId: -1;
  isActive: false;
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  generalFilter: GeneralFilter = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: 25
    },
  };
  constructor(private coreSession: CoreSession,
    private newCustomerService: NewCustomerService,
    private translateService: TranslateService,
    private sessionData: SessionDataProvider) { }

  ngOnInit() {
    this.coreSession.SetTitle('New Customer');
    this.populatNewCustomerList();
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.newCustomerURL, MenuActions.Approve)) {
      this.TabelData.rowOperations.push({
        operation: RowOperation.approve,
        title: "Desc_Order_Approve",
        icon: "fa-solid fa-check",
        color: "#02b875"
      });
    }
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.newCustomerURL, MenuActions.Edit)) {
      if (this.sessionData.getConfigurationValue(ConstantConfigurations.ForceCustomerOrganizationSelection).toLowerCase() === "true")
        this.TabelData.rowOperations.push({
          operation: RowOperation.edit,
          title: "Desc_Edit",
          icon: "fa-regular fa-pen-to-square",
          color: "#12344d"
        });
    }
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.newCustomerURL, MenuActions.Reject)) {
      this.TabelData.rowOperations.push({
        operation: RowOperation.reject,
        title: "Desc_Reject",
        icon: "fa-solid fa-trash",
        color: "#f1685e",
        showWhenKeyValueFalse: true,
        showHideOptionPerLine: true,
        controlKeyName: 'inactive'
      });

    }
  }
  onTableFilterChanged(query: any) {
    this.generalFilter.customListFilter = query;
    this.populatNewCustomerList();
  }
  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.approve: {
        this.onApproveCustomer(event.object);
        break;
      }
      case RowOperation.edit: {
        this.onEditCustomerOrganization(event.object);
        break;
      }
      case RowOperation.reject: {
        this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgCustomerInactive), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
          (result: DialogResult) => {
            if (result === DialogResult.Yes) {
              this.UpdateInactiveCustomer(event.object, false);
            }
          }
        );
      }
        break;
    }
  }
  onApproveCustomer(customer: any) {
    this.selectedcustomerObj = customer;
    this.showSlider = true;
    this.isEditOrg = false;
  }
  onEditCustomerOrganization(customer: any) {
    this.selectedcustomerObj = customer;
    this.showSlider = true;
    this.isEditOrg = true;
  }
  closeNewCustomerSlider() {
    this.showSlider = false;
  }
  onSaveClick() {
    this.saveSubject.next();
  }

  onSaveCompleted(customerId) {
    this.showSlider = false;
    if (customerId && customerId != -1) {
      this.coreSession.ModalDialog.ShowMessage(this.translateService.instant(ConstantMessages.MsgEditCustomerConfirmation), DialogMode.YesNo, this.translateService.instant(ConstantMessages.WarningCaption)).then(
        (res: DialogResult) => {
          if (res === DialogResult.Yes) {
            this.selectedCustomerId = customerId;
            this.isEditMode = true;
            this.showEntrySlider = true;
          } else {
            this.ApproveNewCustomer();
          }
        });
    } else {
      this.populatNewCustomerList();
    }
  }



  afterSaveApprovedCustomer() {
    this.closeCustomerEntrySlider();
    this.ApproveNewCustomer();
    this.populatNewCustomerList();
  }

  onSaveCustomerApprovedClick() {
    this.editApprovedCustomerSubject.next();
  }

  closeCustomerEntrySlider() {
    this.selectedCustomerId = -1;
    this.isEditMode = false;
    this.showEntrySlider = false;
  }

  editApprovedCustomerClick() {
    this.editApprovedCustomerSubject.next();
  }

  populatNewCustomerList() {
    this.coreSession.ModalLoading.Show();
    this.newCustomerService.getNewCustomerList(this.generalFilter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.dataSource = <SharedTableResult>response.data;
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
    );
  }
  onFindButtonClicked(result) {
    this.generalFilter.customListFilter.page = 0;
    this.generalFilter.employeeId = result.employeeId;
    this.generalFilter.fromToDate = result.transactionDate;
    this.populatNewCustomerList();
  }
  UpdateInactiveCustomer(customer: any, isActive) {
    this.coreSession.ModalLoading.Show();
    var filter = {
      customerId: customer.customerId,
      isActive: this.isActive
    }
    this.newCustomerService.updateInactiveCustomer(filter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgUpdatedSuccessfuly));
        this.populatNewCustomerList();
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      });
  }
  ApproveNewCustomer() {
    this.coreSession.ModalLoading.Show();
    this.selectedcustomerObj.MatchCustomerId = -1
    this.newCustomerService.matchNewCustomer(this.selectedcustomerObj).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
        this.populatNewCustomerList();
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorCaption));
      }
    );
  }
}
