import { CustomerModel } from './../../../shared/models/customer/customer.model';
import { Injectable, Inject } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { CoreSession } from '../../../core/core.session';
import { ResponseModel } from '../../../shared/models/api-models/api-models';
import { CustomerOutletModel } from '../../../shared/models/customer/outlet.model';
import { GeneralFilter } from '../../../shared/models/general/generalFilter.model';
import { Observable } from 'rxjs';

@Injectable({
  providedIn: 'root'
})
export class NewCustomerService {
  private url = '';
  httpOptions;

  constructor(private http: HttpClient, @Inject('BASE_URL') baseUrl: string, private coreSession: CoreSession) {
    this.url = baseUrl + 'NewCustomer/';
    this.httpOptions = {
      headers: new HttpHeaders({
        'Content-Type': 'application/json'
      })
    };
  }
  getNewCustomerList(filter: any) {
    const urlValue = this.url + 'GetNewCustomerList';
    return this.http.get<ResponseModel>(urlValue + '?' + 'filter=' + JSON.stringify(filter)).map(response => {
      return response;
    });
  }
  getOutletsListSharedTable(outletFilter) {
    const urlValue: string = this.url + 'GetOutletsListSharedTable';
    return this.http.post(urlValue, outletFilter).map(
      (response) => {
        const result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      });
  }
  getCustomerAttachements(customerId: number) {
    const urlValue: string = this.url + 'getCustomerAttachements';
    return this.http.get<ResponseModel>(urlValue + '?' + 'customerId=' + customerId).map(response => {
      return response;
    });
  }
  matchNewCustomer(customer: CustomerOutletModel) {
    const urlValue: string = this.url + 'MatchNewCustomer';
    return this.http.post<ResponseModel>(urlValue, customer).map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      })
  }
  updateCustomerOrg(customerId, outletId, organizationId) {
    const urlValue: string = this.url + 'updateCustomerOrg';
    return this.http.get<ResponseModel>(urlValue + '?customerId=' + customerId + '&outletId=' + outletId + '&organizationId=' + organizationId).map(
      (response) => {
        return response;
      }
    );
  }
  updateInactiveCustomer(filter) {
    const urlValue: string = this.url + 'UpdateInactiveCustomer';
    return this.http.get(urlValue + '?' + this.coreSession.toQueryString(filter)).map(
      (response) => {
        let result = new ResponseModel();
        result.data = response['data'];
        result.message = response['message'];
        result.status = response['status'];
        return result;
      }
    );
  }

  UpdateCustomer(customerObj: CustomerModel) {
    const urlValue: string = this.url + "UpdateCustomer";
    return this.http.post<ResponseModel>(urlValue, customerObj)
      .map((response) => {
        const res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      });
  }

  saveOutletAttachments(formData: FormData) {
    return this.http
      .post(this.url + "InsertOutletAttachments", formData)
      .map((response: Response) => {
        let res = new ResponseModel();
        res.data = response["data"];
        res.message = response["message"];
        res.status = response["status"];
        return res;
      });
  }
  getCustomerTemplate(customerObj) {
    const urlValue: string = this.url + 'GetCustomerTemplate';
    return this.http.post<ResponseModel>(urlValue, customerObj).map((response) => {
      return response;
    });
  }
  saveNewCustomerData(customerObj: CustomerOutletModel) {
    const urlValue: string = this.url + "InsertNewCustomerData";
    return this.http.post<ResponseModel>(urlValue, customerObj)
      .map(response => {
        return response;
      });
  }
}
