import { Injectable, Inject } from '@angular/core';
import { HttpClient, HttpHeaders } from '@angular/common/http';
import { CoreSession } from '../../../core/core.session';
import { ResponseModel } from '../../../shared/models/api-models/api-models';
import { SavePaymentModel } from '../../../shared/models/payment/savePaymentModel';
import { PaymentModel } from '../../../shared/models/payment/payment.model';

@Injectable({
  providedIn: 'root'
})
export class PaymentService {
  private url = '';
  httpOptions;

  constructor(private http: HttpClient, @Inject('BASE_URL') baseUrl: string, private coreSession: CoreSession) {
    this.url = baseUrl + 'Payment/';
    this.httpOptions = {
      headers: new HttpHeaders({
        'Content-Type': 'application/json'
      })
    };
  }
  getALLPaymentTypes() {
    const urlValue: string = this.url + 'GetALLPaymentTypes';
    return this.http.post<ResponseModel>(urlValue, "").map(
      (response) => {
        const res = new ResponseModel();
        res.data = response['data'];
        res.message = response['message'];
        res.status = response['status'];
        return res;
      }
    );
  }
  getPaymentTypes(isDownPayment, customerID: number, outletID: number) {
    const urlValue: string = this.url + 'GetPaymentTypes'
    //?isDownPayment=' + isDownPayment + "&customerID=" + customerID + "&outletID=" + outletID;
    const paymentTypeFilterModel = {
      isDownPayment,
      customerID,
      outletID
    }
    return this.http.post<ResponseModel>(urlValue, JSON.stringify(paymentTypeFilterModel), this.httpOptions).map(response => {
      const result = new ResponseModel();
      result.data = response['data'];
      result.message = response['message'];
      result.status = response['status'];
      return result;
    });
  }
  getBankWithBranches() {
    const urlValue: string = this.url + 'GetBankWithBranches';
    return this.http.post<ResponseModel>(urlValue, {}).map(response => {
      return response.data;
    });
  }

  getPaymentsList(filter: any) {
    const urlValue = this.url + 'GetPaymentList';
    return this.http.post<ResponseModel>(urlValue, JSON.stringify(filter), this.httpOptions).map(response => {
      const result = new ResponseModel();
      result.data = response['data'];
      result.message = response['message'];
      result.status = response['status'];
      return result;
    });
  }
  voidPayments(selectedPayments: PaymentModel[]) {
    (selectedPayments);
    const urlValue = this.url + 'VoidPayments';
    return this.http.post<ResponseModel>(urlValue, selectedPayments).map(response => {
      return response;
    });
  }
  // getDownPaymentsList(filter: any) {
  //   const urlValue = this.url + 'GetDownPaymentList';
  //   return this.http.post<ResponseModel>(urlValue, JSON.stringify(filter), this.httpOptions).map(response => {
  //     const result = new ResponseModel();
  //     result.data = response['data'];
  //     result.message = response['message'];
  //     result.status = response['status'];
  //     return result;
  //   });
  // }
  // saveDownPayments(selectedPayments: PaymentModel[]) {
  //   const urlValue: string = this.url + 'InsertDownPayments';
  //   (urlValue);
  //   return this.http.post(urlValue, selectedPayments).map(
  //     (response) => {
  //       const result = new ResponseModel();
  //       result.data = response['data'];
  //       result.message = response['message'];
  //       result.status = response['status'];
  //       return result;
  //     }
  //   );
  // }
  // voidDownPayments(selectedPayment: PaymentModel) {
  //   const urlValue = this.url + 'VoidDownPayments';
  //   return this.http.post<ResponseModel>(urlValue, selectedPayment).map(response => {
  //     return response;
  //   });
  // }
  bounceCheques(selectedPayments: PaymentModel[]) {
    (selectedPayments);
    const urlValue = this.url + 'BounceCheques';
    return this.http.post<ResponseModel>(urlValue, selectedPayments).map(response => {
      return response;
    });
  }
}
