import { Component, OnInit, ViewChild, OnDestroy } from '@angular/core';
import { HttpErrorResponse } from '@angular/common/http';
import { GeneralFilter } from '../../../../shared/models/general/generalFilter.model';
import { CoreSession } from '../../../../core/core.session';
import { TransactionService } from '../../transactions/transaction.service';
import { DialogMode } from '../../../../shared/models/enums/dialog-mode.enum';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { MultiSelectionOperation, RowOperation } from '../../../../shared/models/enums/shared-table-operation.enum';
import { DocumentTypes } from '../../../../shared/models/enums/document-types.enum';
import { ValidationService } from '../../../../shared/services/validation.service';
import { DialogResult } from '../../../../shared/models/enums/dialog-result.enum';
import { TranslateService } from '@ngx-translate/core';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { NgbModal, NgbModalConfig } from '@ng-bootstrap/ng-bootstrap';
import { Subject } from 'rxjs';
import { SavePaymentModel } from '../../../../shared/models/payment/savePaymentModel';
import { CalculationService } from '../../../../shared/services/calculations.service';
import { MenuActions } from '../../../../shared/models/enums/menu-actions-enum';
import { ConstantConfigurations } from '../../../../shared/models/constants/constant-configuration';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { ResponseModel } from '../../../../shared/models/api-models/api-models';
import { PayInvoiceService } from '../../../../shared/services/customer-operation/pay-invoice/pay-invoice.service';

@Component({
  selector: 'app-pending-invoices',
  templateUrl: './pending-invoices.component.html',
  styleUrls: ['./pending-invoices.component.css']
})
export class PendingInvoicesComponent implements OnInit, OnDestroy {
  @ViewChild("transactionPaymentDialog", { static: true }) transactionPaymentDialog: NgbModal;
  OkResult: DialogResult = DialogResult.Ok;

  // This is an offline table
  sharedTabelData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: false,
    isOnline: false,
    showSearch: true,
    showSearchBtn: true,
    showNewBtn: false,
    openFilterDirectly: true,
    isMultiSelection: false,
    rowOperations: [],
    multiSelectionOperations: [],
    specificActionWhenCheckAll: true,
    specificActionWhenCheckRow: true,
    columns: [
      { title: 'Desc_Customer', key: 'customerCodeName', isSortable: true, width: this.isDivisionLevel() ? '16%' : '18%' },
      { title: 'Desc_Outlet', key: 'outletCodeName', isSortable: true, width: this.isDivisionLevel() ? '17%' : '19%' },
      { title: 'Desc_TransactionID', key: 'transactionId', isSortable: true, width: this.isDivisionLevel() ? '13%' : '12%' },
      { title: 'Desc_Date', key: 'transactionDate', isSortable: true, width: '12%', isDate: true },
      { title: 'Desc_Employee', key: 'employeeName', isSortable: false, width: '9%' },
      { title: 'Desc_Net_Total', key: 'netTotal', isSortable: false, numberOfDigits: true, width: '8%' },
      { title: 'Desc_Remaining', key: 'remainingAmount', isSortable: false, numberOfDigits: true, width: this.isDivisionLevel() ? '9%' : '11%' },
      { title: 'Desc_Applied_Amount', key: 'appliedAmount', isSortable: false, numberOfDigits: true, width: '11%' }
    ]
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  // This is an offline table, but use same method of get transactions so page size is not important
  generalFilter: GeneralFilter = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: this.coreSession.pageSize
    }
  };

  saveSubject: Subject<void> = new Subject<void>();
  showSlider = false;

  requiredAmount = 0;
  appliedAmount = 0;

  savePaymentModel: SavePaymentModel = {
    transactionsList: [],
    paymentsList: [],
    customerId: -1,
    outletId: -1,
    divisionId: -1,
    employeeId: this.coreSession.CurrentOperator.employeeId,
    customerCodeName: '',
    outletCodeName: '',
    creditNoteList: []
  };

  totalRequiredAmount: number = 0;
  allowPayingExtraAtCollection = false;
  isMultiDivision = false;

  constructor(
    private coreSession: CoreSession,
    private transactionService: TransactionService,
    private validationService: ValidationService,
    private translateService: TranslateService,
    private calculationService: CalculationService,
    private config: NgbModalConfig,
    private modalService: NgbModal,
    private payInvoiceService: PayInvoiceService,
    private sessionData: SessionDataProvider) {
  }
  ngOnInit() {

    // customize default values of modals used by this component tree
    this.config.backdrop = true;
    this.config.keyboard = true;
    if (this.isDivisionLevel()) {
      this.sharedTabelData.columns.push(
        { title: 'Desc_Division', key: 'divisionName', isSortable: false, width: '8%' },
      );
    }
    this.coreSession.SetTitle('Collection');
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.collectionURL, MenuActions.Collect)) {
      this.sharedTabelData.isMultiSelection = true;
      this.sharedTabelData.multiSelectionOperations.push({
        operation: MultiSelectionOperation.collect,
        title: 'Desc_Collect',
        icon: 'fa fa-money',
        color: '#f1685e'
      });
      this.sharedTabelData.rowOperations.push({
        operation: RowOperation.collect,
        title: 'Desc_Collect',
        icon: 'fa fa-money',
        color: '#f1685e'
      });
    }
    this.allowPayingExtraAtCollection = this.sessionData.getConfigurationValue(ConstantConfigurations.allowPayingExtraAtCollection).toLowerCase() === "true";
  }
  ngOnDestroy() {
    this.config.backdrop = true;
    this.config.keyboard = true;
  }
  isDivisionLevel() {
    return (this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true")
  }
  applyDivisionsOnDocumentSequence() {
    return (this.isDivisionLevel() && this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyDivisionsOnDocumentSequence).toLowerCase() === "true")
  }
  getUnpdaidTransactions() {
    this.coreSession.ModalLoading.Show();
    this.payInvoiceService.getUnpaidTransactions(this.generalFilter).subscribe(response => {
      this.coreSession.ModalLoading.Hide();
      if (response.status != null && response.status >= 0) {
        this.dataSource = <SharedTableResult>response.data;
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.coreSession.ModalLoading.Hide();
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    }
    );
  }
  //#region [Validations]
  checkDocumentSequenceToPaySelected(event: any) {
    let divisionID = this.applyDivisionsOnDocumentSequence() ? event.object[0].divisionId : -1;
    let documentSequenceFilter = {
      divisionId: divisionID,
      employeeId: this.coreSession.CurrentOperator.employeeId,
      DocumentType: DocumentTypes.Order
    };
    this.coreSession.ModalLoading.Show();
    this.validationService.getMaxDocumentSequence(documentSequenceFilter).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (this.paySelectedInvoices(event.object))
            this.checkIfCustomerHasAvailableCreditNotes(this.savePaymentModel , event.object[0].outletId);
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  paySelectedInvoices(object: any) {
    let result = true;
    if (this.dataSource.data && this.dataSource.data.length > 0) {
      let transactionsToPayList = this.dataSource.data.filter(
        transaction => transaction.appliedAmount > 0 && transaction.isChecked === true);

      // Block pay transactions with different division ids
      if (transactionsToPayList && transactionsToPayList != null && transactionsToPayList.length > 0) {
        var divisionId = transactionsToPayList[0].divisionId;
        if (transactionsToPayList.findIndex(x => x.divisionId != divisionId) >= 0) {
          this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption),
            this.translateService.instant(ConstantMessages.DescCantusecreditnotebecauseselectedmultipledivision));
          this.isMultiDivision = true;
        } else {
          this.isMultiDivision = false;
        }
      }

      this.totalRequiredAmount = 0;
      var customerCodeName = '';
      var outletCodeName = '';
      var index = 0;
      if (transactionsToPayList && transactionsToPayList != null && transactionsToPayList.length > 0) {
        transactionsToPayList.forEach(transaction => {
          this.totalRequiredAmount += transaction.appliedAmount;
          if (index === 0) {
            customerCodeName = transaction.customerCodeName;
            outletCodeName = transaction.outletCodeName;
          }
          else if (index > 0 && outletCodeName != transaction.outletCodeName) {
            outletCodeName = this.translateService.instant(ConstantMessages.CaptionMultiOutlets);
          }
          index += 1;
        });
        this.totalRequiredAmount = this.calculationService.getNumberOnDigitFormat(this.totalRequiredAmount);
        this.savePaymentModel = {
          transactionsList: transactionsToPayList,
          paymentsList: [],
          customerId: this.generalFilter.customerId,
          outletId: this.generalFilter.outletId,
          divisionId: divisionId,
          employeeId: this.coreSession.CurrentOperator.employeeId,
          customerCodeName: customerCodeName,
          outletCodeName: outletCodeName,
          creditNoteList: []
        };

        return result;
      }
      else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.SelectTransactionToPay));
        result = false;
        return result;
      }
    }
    else {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.SelectTransactionToPay));
      result = false;
      return result;
    }
  }
  onRowOperation(event: any) {
    switch (event.operation) {
      case RowOperation.collect:
        if (this.coreSession.checkActivitiesAvailability(ConstantURLs.collectionURL, MenuActions.Collect)) {// check add permession not edit permession, because it will add paid amount for transaction
          this.openTransAppliedDialog(event.object);
        }
        break;
    }
  }
  onMultiSelectionOperation(event: any) {
    switch (event.operation) {
      case MultiSelectionOperation.collect:
        if (this.generalFilter.customerId && this.generalFilter.customerId != -1) {
          this.checkDocumentSequenceToPaySelected(event);
        }
        break;
    }
  }
  onCheckAllOperation(checkAll: boolean) {
    if (checkAll) {
      this.dataSource.data.forEach(invoice => {
        invoice.appliedAmount = invoice.remainingAmount;
      });
    } else {
      this.dataSource.data.forEach(invoice => {
        invoice.appliedAmount = 0;
      });
    }
  }
  onCheckRowOperation(transaction: any) {
    if (transaction.isChecked) {
      transaction.appliedAmount = transaction.remainingAmount;
    }
    else {
      transaction.appliedAmount = 0;
    }
  }
  onTableFilterChanged(query: any) {
    this.generalFilter.customListFilter = query;
    if (this.generalFilter.customerId && this.generalFilter.customerId != -1) {
      this.getUnpdaidTransactions();
    }
  }
  onFindButtonClicked(result) {
    if (result.customerId != null && result.customerId != -1) {
      this.generalFilter.customListFilter.page = 0;
      this.generalFilter.employeeId = result.employeeId;
      this.generalFilter.transactionId = result.transactionId;
      this.generalFilter.customerId = result.customerId;
      this.generalFilter.outletId = result.outletId;
      this.generalFilter.fromToDate = result.transactionDate;
      this.generalFilter.divisionId = result.divisionId;
      this.getUnpdaidTransactions();
    }
    else {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.SelectCustomer));
      return;
    }
  }
  openTransAppliedDialog(transaction: any) {
    this.requiredAmount = transaction.remainingAmount;
    if (transaction.appliedAmount > 0) {
      this.appliedAmount = transaction.appliedAmount;
    } else {
      this.appliedAmount = transaction.remainingAmount;
    }
    this.modalService.open(this.transactionPaymentDialog, {
      centered: true
    }).result.then(
      (result) => {
        if (result == DialogResult.Ok) {
          transaction.appliedAmount = this.appliedAmount;
          if (transaction.appliedAmount > 0) {
            transaction.isChecked = true;
          }
          else {
            transaction.isChecked = false;
          }
          this.appliedAmount = 0;
          this.requiredAmount = 0;
        }
        this.appliedAmount = 0;
        this.requiredAmount = 0;
      }
    );
  }

  checkIfCustomerHasAvailableCreditNotes(objectData: any , firstOutletId: number) {
    if (objectData && !this.isMultiDivision) {
      let customerID = objectData.customerId;
      let outletID = objectData.outletId;
      let divisionID = objectData.divisionId;

      this.transactionService.getCustomerAvailableCreditNotes(customerID, outletID, divisionID , firstOutletId).subscribe(
        (response: ResponseModel) => {
          if (response.status != null && response.status >= 0) {
            this.savePaymentModel.creditNoteList = response.data;
            this.showSliderForAddPayments();
          } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        }, (error: HttpErrorResponse) => {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
        });
    } else {
      if (!this.allowPayingExtraAtCollection)
        this.showSliderForAddPayments();
    }
  }


  showSliderForAddPayments() {
    this.showSlider = true;
  }
  closePaymentSlider() {
    this.showSlider = false;
    this.coreSession.SetTitle('Collection');
  }
  onSavePaymentClick() {
    this.saveSubject.next()
  }
  afterSavePayment() {
    this.closePaymentSlider();
    this.getUnpdaidTransactions();
  }

}
