import { Component, Input, OnInit, ViewChild } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';
import { Router } from '@angular/router';
import { TranslateService } from '@ngx-translate/core';
import { CoreSession } from '../../../../core/core.session';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { DateTimeModel } from '../../../../shared/models/dateTimeModel/date-time.model';
import { ITextInput } from '../../../../shared/models/shared-table/custom-list.interface';
import { ValidationService } from '../../../../shared/services/validation.service';
import { SendEmailService } from '../../../admin-settings/email/send-email.service';
import { TransactionService } from '../../transactions/transaction.service';
import { DatePipe } from '@angular/common';
import { SharedTableResult } from '../../../../shared/models/shared-table/shared-table-result.interface';
import { RowOperation } from '../../../../shared/models/enums/shared-table-operation.enum';
import { ITableProperties } from '../../../../shared/models/shared-table/table-properties.interface';
import { SharedDialogComponent } from '../../../../shared/components/shared-dialog/shared-dialog.component';
import { Subject } from 'rxjs';
import { ReportMode } from '../../../../shared/models/enums/report-mode.enum';
import { title } from 'process';
import { ConstantURLs } from '../../../../shared/models/constants/constant-URL';
import { MenuActions } from '../../../../shared/models/enums/menu-actions-enum';
@Component({
  selector: 'app-transactions-emails-entry',
  templateUrl: './transactions-emails-entry.component.html',
  styleUrls: ['./transactions-emails-entry.component.css']
})
export class TransactionsEmailsEntryComponent implements OnInit {
  title = 'Email'
  @ViewChild('templateEntry', { static: true }) templateEntry: SharedDialogComponent;
  @Input("transactionEmail") transactionEmail = {
    transactionId: '',
    customerDescription: '',
    outletDescription: '',
    divisionId: -1,
    customerId: -1,
    outletId: -1,
    status: -1,
    emailID: -1,
    sendDate: '',
    transactionTypeId: -1,
    voided: -1,
    voidedDescription: '',
    emailSubject: '',
    emailBody: '',
    senderEmail: '',
    statusDescription: '',
    transactionDate: '',
    hasAttachment: true
  }
  @Input("transactionEmailHistory") transactionEmailHistory: any[] = []
  form: FormGroup;
  Subject: ITextInput = {
    formControlName: "Subject",
    placeHolder: "Desc_Email_Subject",
    label: "Desc_Email_Subject",
    isTextArea: false
  };
  SendDate: ITextInput = {
    formControlName: "SendDate",
    placeHolder: "Desc_Send_Date",
    label: "Desc_Send_Date"
  };
  Status: ITextInput = {
    formControlName: "Status",
    placeHolder: "Desc_Status",
    label: "Desc_Status"
  };
  Voided: ITextInput = {
    formControlName: "Voided",
    placeHolder: "Desc_Voided_Caption",
    label: "Desc_Voided_Caption"
  };
  Body: ITextInput = {
    formControlName: "Body",
    placeHolder: "Desc_Body",
    label: "Desc_Body"
  };
  TabelData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: false,
    isOnline: false,
    showSearch: false,
    showSearchBtn: false,
    isMultiSelection: false,
    showExtraBtn: false,
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Sender_Email', key: 'senderEmail', isSortable: true, width: '25%' },
      { title: 'Desc_Send_Date', key: 'sendDate', isSortable: true, width: '25%', isExpiryDate: true },
      { title: 'Desc_Status', key: 'statusDescription', isSortable: true, width: '25%' },
      { title: 'Desc_Voided_Caption', key: 'voidedDescription', isSortable: true, width: '25%' },
    ]
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  constructor(
    private sessionData: SessionDataProvider,
    private validationService: ValidationService,
    private transactionService: TransactionService,
    private coreSession: CoreSession,
    private datePipe: DatePipe,
    private translateService: TranslateService,
    private sendEmailService: SendEmailService) { }
  addActions() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.invoicesEmails, MenuActions.View)) {
      this.TabelData.rowOperations.push(
        {
          operation: RowOperation.View,
          title: "Desc_View",
          icon: "fa-regular fa-eye",
          color: "#12344d"
        });
    }
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.invoicesEmails, MenuActions.Resend)) {
      this.TabelData.rowOperations.push(
        {
          operation: RowOperation.Resend,
          title: "Desc_Show_Report",
          icon: "fa fa-file",
          color: "#12344d",
          showWhenKeyValueTrue: true,
          showHideOptionPerLine: true,
          controlKeyName: "hasAttachment"
        });
    }
  }
  ngOnInit(): void {
    this.initForm();
    this.addActions();
    // this.fillData();
    let data = {
      totalItems: 0,
      data: []
    };
    data.data = this.transactionEmailHistory;
    data.totalItems = this.transactionEmailHistory.length;
    this.dataSource = data;
    this.templateEntry.saveCaption = 'Desc_Show_Report'
    this.templateEntry.saveIconClass = 'fa fa-file'
  }
  initForm() {
    this.form = new FormGroup({
      Subject: new FormControl(null),
      SendDate: new FormControl(null),
      Status: new FormControl(null),
      Voided: new FormControl(null),
      Body: new FormControl(null),
      // LOVOptionName: new FormControl(null, Validators.required),
      // LOVOptionScore: new FormControl(null),
    });
    this.form.disable()
    // this.form.get('isDynamic').setValue(false);
  }
  fillData() {
    this.coreSession.ModalLoading.Show();
    this.sendEmailService.GetTransactionsEmails(this.transactionEmail).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          // this.transactionEmail = response.data.transactionEmail
          this.fillForm(this.transactionEmail);
          let data = {
            totalItems: 0,
            data: []
          };
          data.data = response.data;
          data.totalItems = response.data.length;
          this.dataSource = data;
        } else {
          this.coreSession.showError(response.message, '');
        }
      },
      error => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(ConstantMessages.ErrorHappened, '');
      }
    );
  }
  fillForm(transactionEmail) {
    this.form.get('Subject').setValue(transactionEmail.emailSubject);
    this.form.get('SendDate').setValue(this.datePipe.transform((new Date(transactionEmail.sendDate)), "dd/MM/yyyy"));
    this.form.get('Status').setValue(transactionEmail.statusDescription);
    this.form.get('Voided').setValue(transactionEmail.voidedDescription);
    this.form.get('Body').setValue(transactionEmail.emailBody);
  }
  onRowOperation(transactionEmail) {
    this.transactionEmail = transactionEmail.object;
    this.templateEntry.showSave = this.transactionEmail.hasAttachment;
    switch (transactionEmail.operation) {
      case RowOperation.View:
        //change row background color
        this.fillForm(transactionEmail.object);
        this.showEntryModal()
        break;
      case RowOperation.Resend:
        //View report
        this.showReport();
        break;
    }

  }
  onCloseClicked() {
    this.templateEntry.Close();
  }

  showEntryModal() {
    this.templateEntry.Show(true).then((res) => { });
  }
  onDialogResult(event) {
    if (event && event.saveCLicked) {
      this.onSaveClicked();
    }
  }
  saveSubject: Subject<void> = new Subject<void>();
  onSaveClicked() {
    //send report
    this.showReport();
    this.saveSubject.next();
    this.onCloseClicked()
  }
  showReport() {
    // let trans = {
    //   DivisionId: this.transactionEmail.divisionId ? this.transactionEmail.divisionId : -1,
    //   TransactionId: this.transactionEmail.transactionId,
    //   TransactionTypeId: this.transactionEmail.transactionTypeId,
    //   reportMode: ReportMode.Transaction,
    //   isReprintReport: false,
    //   CustomerId: this.transactionEmail.customerId,
    //   OutletId: this.transactionEmail.outletId
    // }
    // this.pdfCreatorService.ExportReport(trans, true);
    this.sendEmailService.ShowReport(this.transactionEmail, true);
  }
}
