import { HttpErrorResponse } from '@angular/common/http';
import { Component, OnInit, ViewChild } from '@angular/core';
import { FormControl, FormGroup } from '@angular/forms';
import { Router } from '@angular/router';
import { TranslateService } from '@ngx-translate/core';
import { Subject } from 'rxjs';
import { CoreSession } from '../../../core/core.session';
import { SessionDataProvider } from '../../../core/session-data-provider.service';
import { SharedDialogComponent } from '../../../shared/components/shared-dialog/shared-dialog.component';
import { ConstantConfigurations } from '../../../shared/models/constants/constant-configuration';
import { ConstantMessages } from '../../../shared/models/constants/constant-message';
import { ConstantURLs } from '../../../shared/models/constants/constant-URL';
import { DateTimeModel } from '../../../shared/models/dateTimeModel/date-time.model';
import { DynamicTemplateEmailTypes } from '../../../shared/models/enums/dynamic-template-email-types.enum';
import { MenuActions } from '../../../shared/models/enums/menu-actions-enum';
import { ReportMode } from '../../../shared/models/enums/report-mode.enum';
import { MultiSelectionOperation, RowOperation } from '../../../shared/models/enums/shared-table-operation.enum';
import { GeneralFilter } from '../../../shared/models/general/generalFilter.model';
import { ITextInput } from '../../../shared/models/shared-table/custom-list.interface';
import { SharedTableResult } from '../../../shared/models/shared-table/shared-table-result.interface';
import { ITableProperties } from '../../../shared/models/shared-table/table-properties.interface';
import { ValidationService } from '../../../shared/services/validation.service';
import { DynamicTemplateService } from '../../admin-settings/dynamic-templates/dynamic-template.service';
import { SendEmailService } from '../../admin-settings/email/send-email.service';
import { TransactionService } from '../transactions/transaction.service';

@Component({
  selector: 'app-transactions-emails',
  templateUrl: './transactions-emails.component.html',
  styleUrls: ['./transactions-emails.component.css']
})
export class TransactionsEmailsComponent implements OnInit {

  showEntrySlider = false;
  dialogForm: FormGroup;
  saveSubject: Subject<void> = new Subject<void>();
  @ViewChild('templateEntry', { static: true }) templateEntry: SharedDialogComponent;
  transactionEmailHistory: any[] = []
  query: GeneralFilter = {
    customListFilter: {
      searchFilter: '',
      page: 0,
      pageSize: this.coreSession.pageSize
    },
  };
  reportTypes = []
  TabelData: ITableProperties = {
    pageSize: this.coreSession.pageSize,
    showPaginator: true,
    isOnline: true,
    showSearch: true,
    showSearchBtn: true,
    isMultiSelection: true,
    showExtraBtn: false,
    extraBtnCaption: 'Desc_Send_Email',
    // extraBtnIcon: 'fa fa-repeat',
    rowOperations: [],
    multiSelectionOperations: [],
    columns: [
      { title: 'Desc_Transaction_ID', key: 'transactionId', isSortable: true, width: '15%' },
      { title: 'Desc_Customer', key: 'customerDescription', isSortable: true, width: '15%' },
      { title: 'Desc_Outlet', key: 'outletDescription', isSortable: true, width: '15%' },
      { title: 'Desc_Send_Date', key: 'sendDate', isSortable: true, width: '15%', isDate: true },
      { title: 'Desc_Transaction_Date', key: 'transactionDate', isSortable: true, width: '15%', isDate: true },
      { title: 'Desc_Status', key: 'statusDescription', isSortable: false, width: '15%' },
      { title: 'Desc_Voided_Caption', key: 'voidedDescription', isSortable: false, width: '10%' }
    ]
  };
  dataSource: SharedTableResult = {
    totalItems: 0,
    data: []
  };
  transactionEmailHistoryFilter = {
    transactionId: '',
    customerDescription: '',
    outletDescription: '',
    divisionId: -1,
    customerId: -1,
    outletId: -1,
    status: -1,
    emailID: -1,
    sendDate: '',
    transactionTypeId: -1,
    voided: -1,
    voidedDescription: '',
    emailSubject: '',
    emailBody: '',
    senderEmail: '',
    allowView: true,
    transactionDate: '',
    hasAttachment: true
  }
  Subject: ITextInput = {
    formControlName: "Subject",
    placeHolder: "Desc_Email_Subject",
    label: "Desc_Email_Subject",
    isTextArea: false
  };
  title = 'Desc_Email'
  constructor(
    private sessionData: SessionDataProvider,
    private validationService: ValidationService,
    private transactionService: TransactionService,
    private coreSession: CoreSession,
    private dynamicTemplateService: DynamicTemplateService,
    private translateService: TranslateService,
    private sendEmailService: SendEmailService) { }

  ngOnInit(): void {
    let currentDate: DateTimeModel = new DateTimeModel()
    let dateTime = new Date()
    currentDate.date = dateTime
    currentDate.year = dateTime.getFullYear()
    currentDate.month = dateTime.getMonth() + 1
    currentDate.day = dateTime.getDate()
    currentDate.hour = dateTime.getHours();
    currentDate.minute = dateTime.getMinutes();
    this.query.fromToDate = []
    this.query.fromToDate.push(currentDate)
    this.query.fromToDate.push(currentDate)
    this.populateTransactionsEmailsForSharedTable();
    this.initDialogForm();
    this.addActions();
    this.populateEmailTypes();
  }
  populateEmailTypes() {
    this.dynamicTemplateService.getDynamicTemplateEmailTypes(DynamicTemplateEmailTypes.Customer.valueOf()).subscribe(
      (response) => {
        if (response.status !== null && response.status >= 0) {
          this.reportTypes = response.data;
        } else {
          this.coreSession.showError(
            this.translateService.instant(ConstantMessages.ErrorCaption),
            this.translateService.instant(ConstantMessages.ErrorHappened)
          );
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.showError(
          this.translateService.instant(ConstantMessages.ErrorCaption),
          this.translateService.instant(ConstantMessages.ErrorHappened)
        );
      }
    )
  }
  populateTransactionsEmailsForSharedTable() {
    this.coreSession.ModalLoading.Show();
    this.sendEmailService.GetTransactionsEmailsForSharedTable(this.query).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          let data = {
            totalItems: 0,
            data: []
          };
          data.data = response.data.data;
          data.totalItems = response.data.totalItems;
          this.dataSource = data;

        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      error => {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  isDivisionLevel() {
    return (this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true")
  }
  // onFindButtonClicked(result) {
  //   // this.query.customListFilter.page = 0;
  //   // this.query.employeeId = result.employeeId;
  //   this.transactionEmailHistoryFilter.transactionId = result.transactionId;
  //   this.transactionEmailHistoryFilter.customerId = result.customerId;
  //   this.transactionEmailHistoryFilter.outletId = result.outletId;
  //   this.transactionEmailHistoryFilter.sendDate = result.transactionDate;
  //   if (this.isDivisionLevel())
  //     this.transactionEmailHistoryFilter.divisionId = result.divisionId;
  //   else
  //     this.transactionEmailHistoryFilter.divisionId = -1
  //   this.populateTransactionsEmails(this.transactionEmailHistoryFilter);
  // }
  onFindButtonClicked(result) {



    this.query.customListFilter.page = 0;
    this.query.employeeId = result.employeeId;
    this.query.transactionId = result.transactionId;
    this.query.customerId = result.customerId;
    this.query.outletId = result.outletId;
    this.query.fromToDate = result.transactionDate;
    this.query.includeVoided = result.includeVoided;
    // this.query.newCustomerOnly=result.newCustomerOnly;
    if (this.isDivisionLevel())
      this.query.divisionId = result.divisionId;
    else
      this.query.divisionId = -1
    this.query.checkBoxValue = result.checkBoxValue;
    this.query.includeVoided = result.includeVoided;
    this.query.employeeId = result.employeeId;
    this.query.typeValue = result.typeValue;
    this.populateTransactionsEmailsForSharedTable();
  }
  resendEmails(list: any[]) {
    this.coreSession.ModalLoading.Show();
    this.sendEmailService.resendTransactionsEmail(list).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.Desc_Send_Email));
          this.populateTransactionsEmailsForSharedTable();
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      error => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  onResendClick(event) {
    switch (event.operation) {
      case MultiSelectionOperation.resend:
        this.resendEmails(event.object);
        break;
    }
  }

  closeEntrySlider() {
    this.transactionEmailHistoryFilter = {
      transactionId: '',
      customerDescription: '',
      outletDescription: '',
      divisionId: -1,
      customerId: -1,
      outletId: -1,
      status: -1,
      emailID: -1,
      sendDate: '',
      transactionTypeId: -1,
      voided: -1,
      voidedDescription: '',
      emailSubject: '',
      emailBody: '',
      senderEmail: '',
      allowView: true,
      transactionDate: '',
      hasAttachment: true
    };
    this.showEntrySlider = false;
  }
  onRowOperation(event: any) {
    this.templateEntry.showSave = event.object.hasAttachment;
    switch (event.operation) {
      case RowOperation.View:
        this.fillData(event);
        break;
      case RowOperation.Resend:
        let list: any[] = [];
        list.push(event.object)
        this.coreSession.ModalLoading.Show();
        this.resendEmails(list);
        break;
    }
  }
  onDialogResult(event) {
    if (event && event.saveCLicked) {
      this.onSaveClicked();
    }
  }
  onCloseClicked() {
    this.templateEntry.Close();
  }
  onSaveClicked() {
    //send report
    this.showReport();
    this.saveSubject.next();
    this.onCloseClicked()
  }
  showReport() {
    // let trans = {
    //   DivisionId: this.transactionEmailHistoryFilter.divisionId ? this.transactionEmailHistoryFilter.divisionId : -1,
    //   TransactionId: this.transactionEmailHistoryFilter.transactionId,
    //   TransactionTypeId: this.transactionEmailHistoryFilter.transactionTypeId,
    //   reportMode: ReportMode.Transaction,
    //   isReprintReport: false,
    //   CustomerId: this.transactionEmailHistoryFilter.customerId,
    //   OutletId: this.transactionEmailHistoryFilter.outletId
    // }
    // this.pdfCreatorService.ExportReport(trans, true);
    this.sendEmailService.ShowReport(this.transactionEmailHistoryFilter, true);
  }
  showEntryModal() {
    this.templateEntry.Show(true).then((res) => { });
  }
  initDialogForm() {
    this.dialogForm = new FormGroup({
      Subject: new FormControl(null),
      Body: new FormControl(null),
    });
    this.dialogForm.disable()
    this.templateEntry.saveCaption = 'Desc_Show_Report'
    this.templateEntry.saveIconClass = 'fa fa-file'
  }
  fillDialogForm(transactionEmail) {
    this.dialogForm.get('Subject').setValue(transactionEmail.emailSubject);
    this.dialogForm.get('Body').setValue(transactionEmail.emailBody);
  }
  fillData(event) {
    this.coreSession.ModalLoading.Show();
    this.sendEmailService.GetTransactionsEmails(event.object).subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.transactionEmailHistoryFilter = event.object;
          if (response.data.length == 1) {
            //open dialog
            this.fillDialogForm(event.object);
            this.showEntryModal()

          } else {
            this.showEntrySlider = true;
            this.transactionEmailHistory = response.data;
          }

        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      error => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  onTableFilterChanged(query: any) {
    this.query.customListFilter = query;
    this.populateTransactionsEmailsForSharedTable();
  }
  addActions() {
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.invoicesEmails, MenuActions.View)) {
      this.TabelData.rowOperations.push(
        {
          operation: RowOperation.View,
          title: "Desc_View",
          icon: "fa-regular fa-eye",
          color: "#12344d",
          showWhenKeyValueTrue: true,
          showHideOptionPerLine: true,
          controlKeyName: "allowView"
        });
    }
    if (this.coreSession.checkActivitiesAvailability(ConstantURLs.invoicesEmails, MenuActions.Resend)) {
      this.TabelData.rowOperations.push(
        {
          operation: RowOperation.Resend,
          title: "Desc_Send",
          icon: "fa fa-send",
          color: "#12344d",
          showWhenKeyValueFalse: true,
          showHideOptionPerLine: true,
          controlKeyName: "allowView"
        },
        {
          operation: RowOperation.Resend,
          title: "Desc_Resend",
          icon: "fa fa-repeat",
          color: "#12344d",
          showWhenKeyValueTrue: true,
          showHideOptionPerLine: true,
          controlKeyName: "allowView"
        });
      this.TabelData.multiSelectionOperations.push({
        operation: MultiSelectionOperation.resend,
        title: 'Desc_Send_Email',
        icon: 'fa fa-repeat',
        color: '#f1685e'
      });
    }
  }
}
