import { Component, OnInit, EventEmitter, Output, ViewChild, Input } from '@angular/core';
import { FormGroup, FormControl, Validators } from '@angular/forms';
import { HttpErrorResponse } from '@angular/common/http';
import { TransactionService } from '../transaction.service';
import { TransactionModel } from '../../../../shared/models/transaction/transaction.model';
import { DateTimeModel } from '../../../../shared/models/dateTimeModel/date-time.model';
import { TotalsModel } from '../../../../shared/models/Item/totals.model';
import { FormProcessMode } from '../../../../shared/models/enums/form-process-mode.enum';
import { CalculationService } from '../../../../shared/services/calculations.service';
import { ValidationService } from '../../../../shared/services/validation.service';
import { CoreSession } from '../../../../core/core.session';
import { DocumentTypes } from '../../../../shared/models/enums/document-types.enum';
import { ConstantMessages } from '../../../../shared/models/constants/constant-message';
import { IDateTimePickerProperties } from '../../../../shared/models/dateTimeModel/date-time-properties.interface';
import { TransationCommonData } from '../../../../shared/models/transaction/transaction-common-data';
import { TakePromotionComponent } from '../../../../shared/components/promotion/take-promotion/take-promotion.component';
import { TransactionType } from '../../../../shared/models/enums/transaction-type.enum';
import { TransactionMainTypes } from '../../../../shared/models/enums/transaction.main.types.enum';
import { TransactionStatues } from '../../../../shared/models/enums/transaction.statuses.enum';
import { TranslateService } from '@ngx-translate/core';
import { ConstantConfigurations } from '../../../../shared/models/constants/constant-configuration';
import { SessionDataProvider } from '../../../../core/session-data-provider.service';
import { ReportMode } from '../../../../shared/models/enums/report-mode.enum';
import { Observable, Subject, throwError } from 'rxjs';
import { InvoiceService } from '../../../../shared/services/customer-operation/invoice/invoice.service';
import { PdfCreatorService } from '../../../../shared/services/pdf-creator.service';
import { CustomerTypes } from '../../../../shared/models/enums/customer-types.enum';
import { SharedDialogComponent } from '../../../../shared/components/shared-dialog/shared-dialog.component';
import { CustomerService } from '../../../../shared/services/data-definition/customer/customers.service';
import { TestInvoiceService } from '../../../../shared/services/customer-operation/invoice/test-invoice.service';
import { ItemPackModel } from '../../../../shared/models/Item/item.model';


@Component({
  selector: 'app-customer-transaction-entry',
  templateUrl: './customer-transaction-entry.component.html',
  styleUrls: ['./customer-transaction-entry.component.css']
})
export class CustomerTransactionEntryComponent implements OnInit {

  @Output('onSaveComplete') onSaveComplete = new EventEmitter();
  @ViewChild('takePromotions', { static: true }) takePromotions: TakePromotionComponent;
  @ViewChild("salesModeSelection", { static: true }) salesModeSelectionDialog: SharedDialogComponent;

  LimitBOSalesToWarehouseStock = false;
  showBatches = false;
  showSummary: boolean = false;
  showItems: boolean = false;
  showItemsSection: boolean = false;
  showTakePromotions: boolean = false;

  disableHeader = false;
  itemProcessMode = FormProcessMode.Sales;
  totals: TotalsModel;
  showTax = false;
  ShowIncludedTaxAmount = false;
  showRetailTax = false;
  customerPromotions: any[] = [];
  copyCustomerPromotions: any[] = [];
  promotionGroupLevels: any[] = [];
  transactionCommonData: TransationCommonData;
  showTransactionId = true;

  @Input("transactionId") transactionId = '';
  noteWidth: number = 10;
  noteString: string;
  transaction: TransactionModel;
  transactionForm: FormGroup;
  transactionDate: DateTimeModel = new DateTimeModel();
  selectedDivisionId = -1;
  transactionDateProperties: IDateTimePickerProperties = {
    label: 'Desc_Transaction_Date',
    formControlName: 'transactionDate',
    isCalendarOnly: true,
  };
  AllowPromotion = false;
  autoCollectBOInvoices = false;
  submitString = 'col-md-2';
  lastPromotion: boolean = false;
  currentLevelId = 1;
  nextLevelId = 1;
  nextSubject: Subject<void> = new Subject<void>();
  promotionCalculationSequence = 0;
  selectedCustomerTypeId: number = -1;
  allowSalesModeSelection: boolean = false;
  allowSalesModeSelectionForCashCustomersInSales: boolean = false;
  allowSalesModeSelectionForCashCustomersInReturn: boolean = false;
  selectedSalesMode: number = -1;
  selectedCustomerSDCs: any[] = []; // Sales Distribution Channels
  isSDCLoading: boolean = false;
  enableSalesDistributionChannel: boolean = false;
  applyDocumentSequencePerSalesChannel: boolean = false;
  showSDCSelection: boolean = false; // if enableSalesDistributionChannel AND customer is linked to multiple SDCs
  @Input() formProcessMode: FormProcessMode = FormProcessMode.Sales;
  itemsList: ItemPackModel[] = [];


  constructor(
    public coreSession: CoreSession,
    private transactionService: TransactionService,
    private invoiceService: InvoiceService,
    private testInvoiceService: TestInvoiceService,
    private translateService: TranslateService,
    private validationService: ValidationService,
    private calculationService: CalculationService,
    private sessionData: SessionDataProvider,
    private pdfCreatorService: PdfCreatorService,
    private customerService: CustomerService
  ) {
    this.transactionCommonData = new TransationCommonData();
    this.totals = new TotalsModel();
  }
  ngOnInit() {
    this.coreSession.SetTitle('Add New Invoice');
    this.ShowIncludedTaxAmount = this.sessionData.getConfigurationValue(ConstantConfigurations.ShowIncludedTaxAmount).toLowerCase() === "true";
    this.LimitBOSalesToWarehouseStock = this.sessionData.getConfigurationValue(ConstantConfigurations.LimitBOSalesToWarehouseStock).toLowerCase() === "true";
    this.AllowPromotion = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowPromotion).toLowerCase() === "true";
    this.allowSalesModeSelection = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowSalesModeSelection).toLowerCase() === "true";
    this.allowSalesModeSelectionForCashCustomersInSales = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowSalesModeSelectionForCashCustomers).toLowerCase().includes(1 + "");
    this.allowSalesModeSelectionForCashCustomersInReturn = this.sessionData.getConfigurationValue(ConstantConfigurations.AllowSalesModeSelectionForCashCustomers).toLowerCase().includes(2 + "");
    this.transaction = new TransactionModel();
    this.transaction.transactionId = this.transactionId;
    this.transaction.documentType = DocumentTypes.Invoice;
    this.transaction.transactionType = TransactionType.Sales;
    this.transaction.transactionTypeId = TransactionType.Sales.valueOf();
    this.transaction.transactionMainTypes = TransactionMainTypes.CustomerTransaction;
    this.transaction.transactionStatusId = TransactionStatues.None.valueOf();
    this.transaction.divisionId = this.selectedDivisionId;
    this.autoCollectBOInvoices = this.sessionData.getConfigurationValue(ConstantConfigurations.AutoCollectBOInvoices).toLowerCase() === "true";
    this.promotionCalculationSequence = +this.sessionData.getConfigurationValue(ConstantConfigurations.PromotionCalculationSequence);
    this.enableSalesDistributionChannel = this.sessionData.getConfigurationValue(ConstantConfigurations.EnableSalesDistributionChannel).toLowerCase() === "true";
    this.applyDocumentSequencePerSalesChannel = this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyDocumentSequencePerSalesChannel).toLowerCase() === "true";
    this.initForm();
    if (this.enableSalesDistributionChannel && this.applyDocumentSequencePerSalesChannel && this.transaction) {
      var data = {
        customerId: this.transaction.customerId ? this.transaction.customerId : -1,
        outletId: this.transaction.outletId ? this.transaction.outletId : -1
      };
      this.getSelectedCustomerSDCs(data);
    }
    if (this.LimitBOSalesToWarehouseStock) {
      this.noteWidth = this.noteWidth - 6;
    }

    if (this.formProcessMode != FormProcessMode.TestInvoices && this.applyDivisionsOnDocumentSequence()) {
      this.showTransactionId = false;
      if (this.LimitBOSalesToWarehouseStock) {
        this.noteWidth = 6;
      } else {
        this.noteWidth = 9;
      }
      this.submitString = 'col-md-3';
    } else if (this.isDivisionLevel()) {
      this.noteWidth = this.noteWidth - 3;
    }
    if (this.enableSalesDistributionChannel && this.applyDocumentSequencePerSalesChannel) {
      this.showTransactionId = false;
    }
    this.noteString = "col-md-" + this.noteWidth + '';
  }
  initForm() {
    this.transactionForm = new FormGroup({
      transactionId: new FormControl({ value: this.transactionId, disabled: true }),
      customerId: new FormControl(null, Validators.required),
      outletId: new FormControl(null, Validators.required),
      warehouseId: new FormControl(null, this.LimitBOSalesToWarehouseStock ? Validators.required : null),
      divisionId: new FormControl(null, this.isDivisionLevel() ? Validators.required : null),
      transactionDate: new FormControl(this.transactionDate.date, Validators.required),
      notes: new FormControl(null),
      shipTo: new FormControl(null),
      salesMode: new FormControl(),
      sdcId: new FormControl(null, this.enableSalesDistributionChannel && this.applyDocumentSequencePerSalesChannel ? Validators.required : null),
      includeInactive: new FormControl(false)
    });
  }

  //#region [METHODS]
  saveTransactionToDB() {
    this.coreSession.ModalLoading.Show();
    this.invoiceService.SaveTransaction(this.transaction).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (response.data && response.data.invalidZATCATransaction) {
            this.coreSession.showWarrningWithTimeOutDelay(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(response.data.message), 10000);
            this.onSaveComplete.emit();
          } else {
            this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
            this.onSaveComplete.emit();
            let trans = {
              divisionId: this.transaction.divisionId ? this.transaction.divisionId : -1,
              transactionId: response.data.transactionId,
              customerId: this.transaction.customerId,
              outletId: this.transaction.outletId,
              reportMode: ReportMode.Transaction,
              isReprintReport: false
            }
            this.pdfCreatorService.ExportReport(trans);
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  saveTestTransactionToDB() {
    this.coreSession.ModalLoading.Show();
    this.testInvoiceService.SaveTestTransaction(this.transaction).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (response.data && response.data.invalidZATCATransaction) {
            this.coreSession.showWarrningWithTimeOutDelay(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(response.data.message), 10000);
            this.onSaveComplete.emit();
          } else {
            this.coreSession.showSuccess(this.translateService.instant(ConstantMessages.SuccessCaption), this.translateService.instant(ConstantMessages.MsgSavedSuccessfuly));
            this.onSaveComplete.emit();
            let trans = {
              divisionId: this.transaction.divisionId ? this.transaction.divisionId : -1,
              transactionId: response.data.transactionId,
              customerId: this.transaction.customerId,
              outletId: this.transaction.outletId,
              reportMode: ReportMode.TestTransaction,
              isReprintReport: false
            }
            this.pdfCreatorService.ExportReport(trans);
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }
  isDivisionLevel() {
    return this.sessionData.getConfigurationValue(ConstantConfigurations.ControlTransactionOnDivisionLevel).toLowerCase() === "true"
  }
  applyDivisionsOnDocumentSequence() {
    return (this.isDivisionLevel() && this.sessionData.getConfigurationValue(ConstantConfigurations.ApplyDivisionsOnDocumentSequence).toLowerCase() === "true")
  }
  disableHeaderData() {
    this.customerInput.disable({ onlySelf: true, emitEvent: false });
    this.customerInput.updateValueAndValidity();

    this.outletInput.disable({ onlySelf: true, emitEvent: false });
    this.outletInput.updateValueAndValidity();

    this.warehouseInput.disable({ onlySelf: true, emitEvent: false });
    this.warehouseInput.updateValueAndValidity();

    this.divisionInput.disable({ onlySelf: true, emitEvent: false });
    this.divisionInput.updateValueAndValidity();

    this.disableHeader = true;
    this.noteWidth = this.applyDivisionsOnDocumentSequence() ? this.LimitBOSalesToWarehouseStock ? 6 : 9 : this.noteWidth + 2;
    this.noteString = "col-md-" + this.noteWidth + '';
    if (this.enableSalesDistributionChannel && this.applyDocumentSequencePerSalesChannel) {
      this.transactionForm.get("sdcId").disable({ onlySelf: true, emitEvent: false });
      this.transactionForm.get("sdcId").updateValueAndValidity();
    }
  }
  validateInvoiceDataToAdd() {
    this.coreSession.ModalLoading.Show();
    this.transactionCommonData.divisionId = this.selectedDivisionId;
    this.transactionCommonData.salesMode = this.allowSalesModeSelectionForCustomer() ? this.selectedSalesMode : this.selectedCustomerTypeId;
    if (this.formProcessMode == FormProcessMode.TestInvoices)
      this.transactionCommonData.isTest = true;
    this.validationService.checkHeaderData(this.transactionCommonData).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.transaction.outlet = response.data.outlet;
          this.transaction.isTaxeableOutlet = this.transaction.outlet.taxable;
          if (this.transaction.isTaxeableOutlet && this.sessionData.getConfigurationValue(ConstantConfigurations.AllowTax).toLowerCase() === "true") {
            this.showTax = true;
            if (this.sessionData.getConfigurationValue(ConstantConfigurations.AllowRetailTaxOnItems).toLowerCase() === "true") {
              this.showRetailTax = true;
            }
          }
          if (this.formProcessMode == FormProcessMode.TestInvoices || this.isValidInvoice()) {
            this.disableHeaderData();
            this.showItemsSection = true;
            this.showItems = true;
            this.showTransactionId = true;
          }
        } else {
          if (!response.data) {
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), response.message);
          }
          else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgNoDocumentSequence));
      }
    );
  }
  validateInvoiceDataToSave() {

    this.coreSession.ModalLoading.Show();
    this.validationService.checkHeaderData(this.transactionCommonData).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.transaction.outlet = response.data.outlet;
          if (this.transaction.outlet.customerValidations.isExceedsCustomerLimit === true) {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgCustomerExceedsCreditLimit));
            return;
          } else {
            if (this.formProcessMode == FormProcessMode.Sales)
              this.saveTransactionToDB();
            else if (this.formProcessMode == FormProcessMode.TestInvoices)
              this.saveTestTransactionToDB();
          }
        } else {
          if (!response.data) {
            this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), response.message);
          }
          else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
          }
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgNoDocumentSequence));
      }
    );
  }
  isValidInvoice(): boolean {

    if (this.transactionCommonData.noDocumentSequance === true) {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgNoDocumentSequence));
      return false;
    }
    if (this.transaction.outlet.customerValidations.noAccount === true) {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgNoCustomerAccount));
      return false;
    }
    if (this.transaction.outlet.customerValidations.isOnHold === true) {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgOnHoldCustomer));
      return false;
    }
    if (this.transaction.outlet.customerValidations.isViolatePaymentTerms === true) {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgCustomerViolatePaymentTerms));
      return false;
    }
    if (this.transaction.outlet.customerValidations.isExceedsCustomerLimit === true) {
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.MsgCustomerExceedsCreditLimit));
      return false;
    }
    return true;
  }
  showSummaryUI() {
    this.transactionCommonData.soldItems.forEach(i => {
      i.priceString = this.calculationService.getNumberOnDigitFormat(i.price).toString();
    });
    this.transactionCommonData.promotedItems.forEach(i => {
      i.priceString = this.translateService.instant(ConstantMessages.CaptionPromo);
    });

    this.transaction.soldItems = this.transactionCommonData.soldItems;
    this.transaction.promotedItems = this.transactionCommonData.promotedItems;
    // for promotions that not need user selection, set taken promotions in Back end to order promotion
    this.transaction.customerPromotions = this.transactionCommonData.customerPromotions;
    this.transaction.allItems = [];
    this.transaction.allItems = this.transaction.allItems.concat(this.transaction.soldItems);
    this.transaction.allItems = this.transaction.allItems.concat(this.transaction.promotedItems);
    this.calculateTotalAfterPromotions();
    this.transaction.isPromotionTaken = true;
    if ((this.promotionCalculationSequence != 3 && !this.transactionCommonData.isThereAnyProductDiscountDefined) || (this.promotionCalculationSequence == 3 && (this.lastPromotion || this.customerPromotions.length == 0)) || (this.transactionCommonData.isThereAnyProductDiscountDefined && (this.lastPromotion || this.customerPromotions.length == 0))) {
      if (this.transactionCommonData.isThereAnyProductDiscountDefined) {
        this.coreSession.ModalLoading.Show();
        this.validationService.recalculateAfterProductDiscountPromotions(this.transactionCommonData).subscribe(
          (response) => {
            this.coreSession.ModalLoading.Hide();
            if (response.status != null && response.status >= 0) {
              this.transactionCommonData = response.data;
             this.modifyTransactionItemsFromTransactionCommonData();
              this.calculateTotalAfterPromotions();
                  this.showSummary = true;
                  this.showItemsSection = false;
                  this.showTakePromotions = false;
            }
          }, (error: HttpErrorResponse) => {
            this.coreSession.ModalLoading.Hide();
            this.coreSession.showError('', this.translateService.instant(ConstantMessages.ErrorHappened));
          }
        );
      }
      else{
        this.calculateTotalAfterPromotions();
      this.showSummary = true;
      this.showItemsSection = false;
      this.showTakePromotions = false;
      }
    }
    else {
      this.fillTransactionCommonData();
      this.checkPromotions(false);

    }
  }
  modifyTransactionItemsFromTransactionCommonData() {
    this.transactionCommonData.soldItems.forEach(i => {
      i.priceString = this.calculationService.getNumberOnDigitFormat(i.price).toString();
    });
    this.transactionCommonData.promotedItems.forEach(i => {
      i.priceString = this.translateService.instant(ConstantMessages.CaptionPromo);
    });

    this.transaction.soldItems = this.transactionCommonData.soldItems;
    this.transaction.promotedItems = this.transactionCommonData.promotedItems;
    this.transaction.customerPromotions = this.transactionCommonData.customerPromotions;
    // this.transaction.promotionsForAllLevels = this.transactionCommonData.promotionsForAllLevels;
    this.transaction.allItems = [];
    this.transaction.allItems = this.transaction.allItems.concat(this.transaction.soldItems);
    this.transaction.allItems = this.transaction.allItems.concat(this.transaction.promotedItems);
  }
  calculateTotalAfterPromotions() {
    // reset totals
    this.totals = new TotalsModel;

    // calculate items totals after take benefits
    this.calculationService.calculateTotalAfterPromotions(this.totals, this.transaction.allItems);

    // set transaction Totals
    this.transaction.netTotal = this.totals.netTotal;
    this.transaction.roundingDifference = this.totals.roundingDifference;
    this.transaction.includedTaxAmount = this.totals.includedTaxAmount;
    this.transaction.grossTotal = this.totals.grossTotal;
    this.transaction.tax = this.totals.taxTotal;
    this.transaction.calculatedRetailTax = this.totals.retailTaxTotal;
    this.transaction.discount = this.totals.discountTotal;
    this.transaction.promotedDiscount = this.totals.promotedDiscountTotal;
  }
  fillTransactionCommonData() {
    this.transactionCommonData.draftTransactionId = this.transaction.transactionId;
    this.transactionCommonData.customerId = this.transaction.customerId;
    this.transactionCommonData.outletId = this.transaction.outletId;
    this.transactionCommonData.divisionId = this.selectedDivisionId;
    this.transactionCommonData.employeeId = this.transaction.employeeId;
    this.transactionCommonData.itemFormProcessMode = FormProcessMode.Sales;
    this.transactionCommonData.soldItems = this.transaction.soldItems;
    this.transactionCommonData.promotedItems = this.transaction.promotedItems;
    this.transactionCommonData.netTotal = this.transaction.netTotal;
    this.transactionCommonData.roundingDifference = this.transaction.roundingDifference;
    this.transactionCommonData.includedTaxAmount = this.transaction.includedTaxAmount;
    this.transactionCommonData.grossTotal = this.transaction.grossTotal;
    this.transactionCommonData.calculatedRetailTax = this.transaction.calculatedRetailTax;
    this.transactionCommonData.tax = this.transaction.tax;
    this.transactionCommonData.outlet = this.transaction.outlet;
    this.transactionCommonData.shipTo = this.transaction.shipTo;
    this.transactionCommonData.salesMode = this.allowSalesModeSelectionForCustomer() ? this.selectedSalesMode : this.selectedCustomerTypeId;
    this.transactionCommonData.includeInActive = this.transactionForm.get('includeInactive').value == null ? false : this.transactionForm.get('includeInactive').value;
    if (this.formProcessMode == FormProcessMode.TestInvoices)
      this.transactionCommonData.isTest = true;
  }
  cancelPromotions() {
    this.coreSession.ModalLoading.Show();
    this.showItemsSection = true;
    this.showSummary = false;
    this.showTakePromotions = false;

    this.transaction.isPromotionTaken = false;

    this.customerPromotions = [];
    this.copyCustomerPromotions = [];
    this.promotionGroupLevels = [];
    this.currentLevelId = 1;
    this.nextLevelId = 1;
    this.lastPromotion = false;
    if (this.transactionCommonData != null) {
      this.transactionCommonData.promotionLevelId = 1;
      this.transactionCommonData.productPromotionLevelId = 1;
      this.transactionCommonData.onlyProductDiscount = true;
      this.transactionCommonData.isThereAnyProductDiscountDefined = false;
      this.transactionCommonData.isSecondLevelProductDiscountTaken = false;
      this.transactionCommonData.quanityProductDiscountCount = 0;
      this.transactionCommonData.discountOrFreeItemsProductDiscountCount = 0;
      this.transactionCommonData.promotionsForAllLevels = [];
      this.transactionCommonData.notSelectedFirstLevelLastInvoice = [];
      this.transactionCommonData.areAllItemDiscountsAdded = false;
    }
    this.transaction.soldItems.forEach(i => {
      i.promotedDiscount = 0;
      i.calculatedPromotedDiscount = 0;
      i.itemPromotedDiscount = 0;
      i.price = i.originalPrice;
    });

    // reset totals
    this.totals = new TotalsModel();
    this.calculationService.calculateTotalAfterCancelPromotions(this.totals, this.transaction.soldItems);
    this.coreSession.ModalLoading.Hide();
  }
  checkPromotions(onCheckout) {
    this.coreSession.ModalLoading.Show();
    this.customerPromotions = [];
    this.copyCustomerPromotions = [];
    this.transactionCommonData.promotionsForAllLevels = [];
    if (onCheckout){
      this.promotionGroupLevels = [];
      this.transactionCommonData.promotionsForAllLevels = [];
      this.transactionCommonData.promotionLevelId = 1;
      this.transactionCommonData.onlyProductDiscount = true;
      this.transactionCommonData.isThereAnyProductDiscountDefined = false;
      this.transactionCommonData.isSecondLevelProductDiscountTaken = false;
      this.transactionCommonData.quanityProductDiscountCount = 0;
      this.transactionCommonData.discountOrFreeItemsProductDiscountCount = 0;
      this.transactionCommonData.notSelectedFirstLevelLastInvoice = [];
      this.transactionCommonData.productPromotionLevelId = 1;
      this.transactionCommonData.productDiscountFirstLevelList = [];
      this.transactionCommonData.productDiscountSecondLevelList = [];
      this.transactionCommonData.lastInvoicePromotionsList = [];
    }
    this.validationService.checkOutPromotions(this.transactionCommonData).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          if (response.data.customerPromotions.length > 0) {
            this.customerPromotions = response.data.customerPromotions;
            this.transactionCommonData.isThereAnyProductDiscountDefined = response.data.transCommonData.isThereAnyProductDiscountDefined;
            this.transactionCommonData.productPromotionLevelId = response.data.transCommonData.productPromotionLevelId;
            this.transactionCommonData.quanityProductDiscountCount = response.data.transCommonData.quanityProductDiscountCount;
            this.transactionCommonData.discountOrFreeItemsProductDiscountCount = response.data.transCommonData.discountOrFreeItemsProductDiscountCount;
            this.transactionCommonData.isSecondLevelProductDiscountTaken = response.data.transCommonData.isSecondLevelProductDiscountTaken;
            this.transactionCommonData.onlyProductDiscount = response.data.transCommonData.onlyProductDiscount;
            this.copyCustomerPromotions = this.customerPromotions.slice();
            if (onCheckout) {
              this.promotionGroupLevels = response.data.promotionGroupLevels;
              this.transactionCommonData.promotionGroupLevels = this.promotionGroupLevels;
            }
            this.openTakePromotions();
          } else {
            //Go to Summary
            this.showSummaryUI();
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(response.message));
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), error.message);
      }
    );
  }
  openTakePromotions() {
    this.showTakePromotions = true;
    this.showSummary = false;
    this.showItemsSection = false;
    if (this.promotionCalculationSequence == 3 && !(this.lastPromotion || this.customerPromotions.length == 0))
      this.onNextClick();
  }
  takeSelectedPromotions() {
    this.coreSession.ModalLoading.Show();

    this.validationService.takePromotions(this.transactionCommonData).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.transactionCommonData = response.data;
          this.showSummaryUI();
        } else {
          this.coreSession.showError('', this.translateService.instant(response.message));
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError('', this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  //#endregion

  //#region [EVENTS]

  onSaveClicked() {
    if (!this.transaction.soldItems || this.transaction.soldItems.length <= 0) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgSelectItem));
      return;
    }

    this.transaction.transactionDateModel = this.transactionDate;
    this.transaction.notes = this.transactionForm.get('notes').value;
    this.fillTransactionCommonData();
    this.validateInvoiceDataToSave();
  }
  onBackClicked() {
    this.cancelPromotions();
    if (this.formProcessMode == FormProcessMode.TestInvoices) {
      this.includeInactive.enable();
      this.transactionDateControl.enable();
      this.transactionDateControl.updateValueAndValidity();
    }
  }
  onTransactionDateDateSelected(date) {
    this.transactionDate = date;
  }
  onChangeDivision(division: any) {
    this.selectedDivisionId = division.divisionId;
  }
  onCheckOutClicked(itemsData) {
    this.transaction.soldItems = itemsData.itemsList;
    this.totals = itemsData.totals;
    this.showBatches = itemsData.showBatches; // this will used in show batches in summary screen
    this.transaction.soldItems.forEach((i) => {
      i.originalPrice = i.price;//last edited one
    });
    this.transaction.promotedItems = [];
    this.transaction.netTotal = this.totals.netTotal;
    this.transaction.roundingDifference = this.totals.roundingDifference;
    this.transaction.includedTaxAmount = this.totals.includedTaxAmount;
    this.transaction.grossTotal = this.totals.grossTotal;
    this.transaction.tax = this.totals.taxTotal;
    this.transaction.calculatedRetailTax = this.totals.retailTaxTotal;
    this.transaction.discount = this.totals.discountTotal;
    this.transaction.promotedDiscount = this.totals.promotedDiscountTotal;
    this.fillTransactionCommonData();
    if (this.AllowPromotion) {
      this.checkPromotions(true);
    } else {
      this.showSummaryUI();
    }
    if (this.formProcessMode == FormProcessMode.TestInvoices) {
      this.includeInactive.disable();
      this.transactionDateControl.disable();
      this.transactionDateControl.updateValueAndValidity();
    }
  }
  onSubmitHeaderDataClicked() {
    this.coreSession.markFormGroupTouched(this.transactionForm);
    if (this.transactionForm.invalid) {
      this.coreSession.showWarrning(this.translateService.instant(ConstantMessages.WarningCaption), this.translateService.instant(ConstantMessages.MsgFillMandatory));
      return false;
    }
    this.transaction.customerId = this.customerInput.value;
    this.transaction.outletId = this.outletInput.value;
    this.transaction.employeeId = this.coreSession.CurrentOperator.employeeId;
    this.transaction.warehouseId = this.warehouseInput.value ? this.warehouseInput.value : -1;

    this.transaction.shipTo = this.shipToInput.value;
    this.transaction.sdcId = this.enableSalesDistributionChannel && this.applyDocumentSequencePerSalesChannel && this.transactionForm.get('sdcId').value ? this.transactionForm.get('sdcId').value : -1;

    if (this.allowSalesModeSelectionForCustomer()) {
      this.showSalesModeSelectionDialog();
    } else {
      this.afterSubmitHeaderDataClicked();
    }
  }

  afterSubmitHeaderDataClicked() {
    var checkDocSequenceForSDC = false;
    if (this.applyDivisionsOnDocumentSequence()) {
      this.transaction.divisionId = this.selectedDivisionId;
      if (this.formProcessMode != FormProcessMode.TestInvoices)
        this.getMaxDocumentSequence();
    } else if (this.formProcessMode != FormProcessMode.TestInvoices && this.enableSalesDistributionChannel && this.applyDocumentSequencePerSalesChannel) {
      checkDocSequenceForSDC = true;
      this.transaction.sdcId = this.transactionForm.get('sdcId').value;
      this.getMaxDocumentSequence();
    }
    else if (this.isDivisionLevel()) {
      this.transaction.divisionId = this.selectedDivisionId;
    } else {
      this.transaction.divisionId = -1;
    }

    this.transactionCommonData = new TransationCommonData();
    this.fillTransactionCommonData();
    if (!this.applyDivisionsOnDocumentSequence() && !checkDocSequenceForSDC)
      this.validateInvoiceDataToAdd();
  }

  allowSalesModeSelectionForCustomer(): boolean {
    // TODO -> check for sales and return.
    let result = false;
    if ((this.allowSalesModeSelection && this.selectedCustomerTypeId === CustomerTypes.CreditCustomer.valueOf()) ||
      (this.allowSalesModeSelectionForCashCustomersInSales && this.selectedCustomerTypeId === CustomerTypes.CashCustomer.valueOf())) {
      result = true;
    }
    return result;
  }
  allowSalesModeSelectionForCustomerInSales(): boolean {
    // only in sales.
    var customerTypeId = this.transactionCommonData.outlet.customerTypeId;
    return (this.allowSalesModeSelection && customerTypeId == CustomerTypes.CreditCustomer.valueOf()) ||
      (this.allowSalesModeSelectionForCashCustomersInSales && customerTypeId == CustomerTypes.CashCustomer.valueOf());
  }

  showSalesModeSelectionDialog() {
    this.transactionForm.get('salesMode').setValue(
      this.selectedCustomerTypeId !== CustomerTypes.BillToBillCustomer.valueOf() ? this.selectedCustomerTypeId : 1);
    this.salesModeSelectionDialog.Show(true).then((res) => { });
  }

  onPromotionTaken(selectedBenefits) {
    if (this.promotionCalculationSequence == 3) {
      this.lastPromotion = selectedBenefits.lastPromotion;
      this.currentLevelId = selectedBenefits.currentLevelId;
      this.nextLevelId = selectedBenefits.nextLevelId;
    }
    else if (this.transactionCommonData.isThereAnyProductDiscountDefined) {
      this.lastPromotion = selectedBenefits.lastPromotion;
      this.currentLevelId = 1;
      this.nextLevelId = 1;
    }
    else {
      this.lastPromotion = true;
      this.currentLevelId = 1;
      this.nextLevelId = 1;
    }

    if (selectedBenefits.promotions) {
      this.transactionCommonData.customerPromotions = selectedBenefits.promotions;
      this.transactionCommonData.promotionLevelId = this.promotionCalculationSequence == 3 ? this.nextLevelId : 1;
      this.takeSelectedPromotions();
    }
  }

  onPromtionCanceled() {
    this.showTakePromotions = false;
    this.showSummary = false;
    this.showItemsSection = true;
    this.customerPromotions = [];
    this.copyCustomerPromotions = [];
    this.currentLevelId = 1;
    this.nextLevelId = 1;
    this.lastPromotion = false;
    if (this.transactionCommonData != null) {
      this.transactionCommonData.promotionLevelId = 1;
      this.transactionCommonData.productPromotionLevelId = 1;
      this.transactionCommonData.onlyProductDiscount = true;
      this.transactionCommonData.isThereAnyProductDiscountDefined = false;
      this.transactionCommonData.isSecondLevelProductDiscountTaken = false;
      this.transactionCommonData.quanityProductDiscountCount = 0;
      this.transactionCommonData.discountOrFreeItemsProductDiscountCount = 0;
      this.transactionCommonData.promotionsForAllLevels = [];
      this.transactionCommonData.notSelectedFirstLevelLastInvoice = [];
      if ((this.transactionCommonData.productDiscountFirstLevelList != null && this.transactionCommonData.productDiscountFirstLevelList.length > 0)
        || (this.transactionCommonData.productDiscountSecondLevelList != null && this.transactionCommonData.productDiscountSecondLevelList.length > 0)) {
        this.transactionCommonData.soldItems.forEach((pack, index) => {
          if (pack.totalProductDiscountQuantity > 0) {
            if (pack.totalProductDiscountQuantity == pack.requiredQty)
              this.transactionCommonData.soldItems.splice(index, 1);
            else if (pack.requiredQty > pack.totalProductDiscountQuantity)
              this.transactionCommonData.soldItems[index].requiredQty = this.transactionCommonData.soldItems[index].requiredQty - pack.totalProductDiscountQuantity;
          }
          pack.totalProductDiscountQuantity = 0;
        });
        this.transactionCommonData.productDiscountFirstLevelList = [];
        this.transactionCommonData.productDiscountSecondLevelList = [];
      }
    }
  }

  getMaxDocumentSequence() {

    let resut = false;
    let documentSequenceFilter = {
      divisionId: this.selectedDivisionId,
      employeeId: this.coreSession.CurrentOperator.employeeId,
      documentType: DocumentTypes.Invoice,
      sdcId: this.transaction.sdcId
    };
    this.coreSession.ModalLoading.Show();
    // check for document sequence and account

    this.validationService.checkAccountAndDocumentSequence(documentSequenceFilter).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.transactionForm.get('transactionId').setValue(response.data);
          this.transactionId = response.data;
          this.transaction.transactionId = this.transactionId;
          this.transactionCommonData.draftTransactionId = this.transaction.transactionId;
          // check document sequence of payment on division only if:
          // 1. autoCollectBOInvoices is TRUE OR AllowSalesModeSelection is FALSE for customer. [this means that the tx will be treated as cash by default(previous system behavior)]
          // 2. AllowSalesModeSelection is TRUE for customer && Selected sales mode === CASH. [selected --> cash]
          if (this.autoCollectBOInvoicesInSales()) {
            this.validateInvoiceDataToAdd();
            resut = this.checkDocumentSequenceToPayment();
          } else {
            this.validateInvoiceDataToAdd();
            resut = true;
          }
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  autoCollectBOInvoicesInSales() {
    return (this.autoCollectBOInvoices && !this.allowSalesModeSelectionForCustomerInSales()) ||
      (this.allowSalesModeSelectionForCustomerInSales() && this.selectedSalesMode == CustomerTypes.CashCustomer.valueOf());
  }


  checkDocumentSequenceToPayment() {

    let result = false;
    let documentSequenceFilter = {
      divisionId: this.selectedDivisionId,
      employeeId: this.coreSession.CurrentOperator.employeeId,
      DocumentType: DocumentTypes.Collection
    };
    this.coreSession.ModalLoading.Show();
    this.validationService.getMaxDocumentSequence(documentSequenceFilter).subscribe(
      (response) => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          result = true;
        } else {
          this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      }, (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
    return result;
  }
  onNextClick() {
    this.nextSubject.next()
  }

  onChangeOutlet(data) {
    this.resetSDCData();
    this.selectedCustomerTypeId = -1;
    if (data && data != undefined) {
      this.selectedCustomerTypeId = data.customerTypeId;
    }
    if (this.enableSalesDistributionChannel && this.applyDocumentSequencePerSalesChannel && data && data != undefined) {
      this.getSelectedCustomerSDCs(data);
    }
  }

  //#endregion

  //#region [Sales Mode Selection dialog]
  onSalesModeSelected(result) {
    this.salesModeSelectionDialog.Close();
    this.selectedSalesMode = this.transactionForm.get('salesMode').value;
    this.afterSubmitHeaderDataClicked();
  }
  onSalesModeCanceled() {
    this.salesModeSelectionDialog.Close();
    // this.selectedSalesMode = this.selectedCustomerTypeId;
    // this.afterSubmitHeaderDataClicked();
  }
  getSelectedCustomerSDCs(data) { // Sales Distribution Channels
    this.isSDCLoading = true;
    var filter = {
      organizationIds: null,
      customerId: data.customerId,
      outletId: data.outletId
    }
    this.customerService.getAllSalesDistributionChannels(filter).subscribe(response => {
      this.isSDCLoading = false;
      if (response.status != null && response.status >= 0) {
        this.selectedCustomerSDCs = response.data;
        this.showSDCSelection = true;
      } else {
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
      }
    }, (error: HttpErrorResponse) => {
      this.isSDCLoading = false;
      this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
    });

  }
  resetSDCData() {
    this.showSDCSelection = false;
    this.selectedCustomerSDCs = [];
    this.transactionForm.get('sdcId').setValue(null);
  }
  onItemListFilled(items: any) {
    this.itemsList = items;
  }
  //#endregion
  //#region [PROPERTIES]

  get customerInput() {
    return this.transactionForm.get('customerId');
  }
  get outletInput() {
    return this.transactionForm.get('outletId');
  }
  get warehouseInput() {
    return this.transactionForm.get('warehouseId');
  }
  get divisionInput() {
    return this.transactionForm.get('divisionId');
  }
  get transactionDateControl() {
    return this.transactionForm.get('transactionDate');
  }
  get transactionIdInput() {
    return this.transactionForm.get('transactionId');
  }
  get shipToInput() {
    return this.transactionForm.get('shipTo');
  }
  get includeInactive() {
    return this.transactionForm.get('includeInactive');
  }

  //#endregion
}
