import { Injectable, Inject } from '@angular/core';
import { HttpClient } from '@angular/common/http';
import { ResponseModel } from '../../../shared/models/api-models/api-models';
import { CoreSession } from '../../../core/core.session';
import { TransactionModel } from '../../../shared/models/transaction/transaction.model';

@Injectable({
  providedIn: 'root'
})
export class TransactionService {
  private url = '';
  constructor(private http: HttpClient, @Inject('BASE_URL') baseUrl: string, private coreSession: CoreSession) {
    this.url = baseUrl + 'Transaction/';
  }

  // getCustomerTransactions(filter: any) {
  //   const urlValue = this.url + 'GetTransactions';
  //   return this.http.post<ResponseModel>(urlValue, filter).map(response => {
  //     return response;
  //   });
  // }
  // getICashTransactions(filter: any) {
  //   const urlValue = this.url + 'GetICashTransactions';
  //   return this.http.post<ResponseModel>(urlValue, filter).map(response => {
  //     return response;
  //   });
  // }
  // getICashTransactionData(customerId: number, outletId: number, transactionId: string) {
  //   const urlValue = this.url + 'GetICashTransactionData';
  //   let icashData = {
  //     customerId: customerId,
  //     outletId: outletId,
  //     transactionId: transactionId
  //   }
  //   return this.http.post<ResponseModel>(urlValue, icashData).map(response => {
  //     return response;
  //   });
  // }
  // getICashReversalNeededData(customerId: number, outletId: number, transactionId: string) {
  //   const urlValue = this.url + 'GetICashReversalNeededData';
  //   let icashReversal = {
  //     customerId: customerId,
  //     outletId: outletId,
  //     transactionId: transactionId
  //   }
  //   return this.http.post<ResponseModel>(urlValue, icashReversal).map(response => {
  //     return response;
  //   });
  // }
  // getUnpaidTransactions(filter: any) {
  //   const urlValue = this.url + 'GetUnpaidTransactions';
  //   return this.http.post<ResponseModel>(urlValue, filter)
  //     .map(response => {
  //       return response;
  //     });
  // }

  getTransactionData(signature: string) {
    const urlValue = this.url + 'GetTransactionData';
    let transaction = {
      signature: signature
    }
    return this.http
      .post<ResponseModel>(urlValue, transaction)
      .map(response => { return response; });
  }

  voidTransaction(transaction: TransactionModel) {
    (transaction);
    const urlValue = this.url + 'VoidTransaction';
    return this.http.post<ResponseModel>(urlValue, transaction).map(response => {
      return response;
    });
  }

  // SaveTransaction(transaction: TransactionModel) {
  //   const urlValue: string = this.url + 'InsertTransaction';
  //   return this.http.post<ResponseModel>(urlValue, transaction).map(
  //     (response) => {
  //       const res = new ResponseModel();
  //       res.data = response['data'];
  //       res.message = response['message'];
  //       res.status = response['status'];
  //       return res;
  //     })
  // }
  // saveICashReversal(transaction: any) {
  //   const urlValue: string = this.url + 'InsertICashReversal';
  //   return this.http.post<ResponseModel>(urlValue, transaction).map(
  //     (response) => {
  //       const res = new ResponseModel();
  //       res.data = response['data'];
  //       res.message = response['message'];
  //       res.status = response['status'];
  //       return res;
  //     })
  // }
  // getSourceTransactionData(sourceTransactionId: any) {
  //   const urlValue = this.url + 'getSourceTransactionData';
  //   let sourceTransaction = {
  //     sourceTransactionId: sourceTransactionId
  //   }
  //   return this.http.post<ResponseModel>(urlValue, sourceTransaction).map(response => {
  //     return response;
  //   });
  // }

  getCustomerAvailableCreditNotes(customerID: number, outletID: number, divisionID: number , firstOutletId: number) {
    const urlValue = this.url + 'GetCustomerAvailableCreditNotes';
    let customerCreditNotes = {
      customerId: customerID,
      outletId: outletID,
      divisionId: divisionID,
      firstOutletId: firstOutletId
    }
    return this.http.post<ResponseModel>(urlValue, customerCreditNotes).map(response => {
      return response;
    });
  }

  getDocumentReasonDataSource(documentTypeId: number) {
    const urlValue = this.url + 'GetDocumentReasonDataSource';
    return this.http.post<ResponseModel>(urlValue, documentTypeId).map(response => {
      return response;
    });

  }
  GetAllTaxesForGeneralPrice(employeeId:number){
    const urlValue = this.url + 'GetAllTaxesForGeneralPrice';
    return this.http.post<ResponseModel>(urlValue,employeeId).map(response => {
      return response;})
  }





}
