import { Component, OnInit } from "@angular/core";
import { CoreSession } from "../../../core/core.session";
import { DashboardService } from "../dashboard.service";
import { DialogMode } from "../../../shared/models/enums/dialog-mode.enum";
import { HttpErrorResponse } from "@angular/common/http";
import { ConstantMessages } from "../../../shared/models/constants/constant-message";
import { SafeResourceUrl, DomSanitizer } from "@angular/platform-browser";
import { TranslateService } from "@ngx-translate/core";

@Component({
  selector: "app-dashboard-main",
  templateUrl: "./dashboard-main.component.html",
  styleUrls: ["./dashboard-main.component.css"]
})
export class DashboardMainComponent implements OnInit {

  dashboards: any[] = [];
  // showSlider = false;
  // dashboardURL: string;
  // safeURL: SafeResourceUrl;
  showNoDataFound = false;

  constructor(
    public coreSession: CoreSession,
    private dashboardService: DashboardService,
    private sanitizer: DomSanitizer,
    private translateService: TranslateService
  ) { }

  ngOnInit() {
    this.coreSession.SetTitle('Dashboards');
    this.getAvailableDashboard();
  }

  getAvailableDashboard() {
    this.coreSession.ModalLoading.Show();
    this.dashboardService.getAvailableDashboard().subscribe(
      response => {
        this.coreSession.ModalLoading.Hide();
        if (response.status != null && response.status >= 0) {
          this.dashboards = response.data;
          if (this.dashboards && this.dashboards.length > 0) {
            this.showNoDataFound = false;
          }
          else {
            this.showNoDataFound = true;
          }
        } else {
            this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), response.message);
        }
      },
      (error: HttpErrorResponse) => {
        this.coreSession.ModalLoading.Hide();
        this.coreSession.showError(this.translateService.instant(ConstantMessages.ErrorCaption), this.translateService.instant(ConstantMessages.ErrorHappened));
      }
    );
  }

  // closeSlider() {
  //   this.showSlider = false;
  //   this.dashboardURL = '';
  // }

  // openDashboard(url) {
  //   this.dashboardURL = url;
  //   this.getURL();
  //   this.showSlider = true;
  // }

  // getURL() {
  //   this.safeURL = this.sanitizer.bypassSecurityTrustResourceUrl(this.dashboardURL);
  //   return this.safeURL;

  // }
  getSafeURL(dashboardURL) {
    return this.sanitizer.bypassSecurityTrustResourceUrl(dashboardURL);
  }
}
