import { Component, OnInit } from "@angular/core";
import { CoreSession } from "../../../core/core.session";
import { SessionDataProvider } from "../../../core/session-data-provider.service";
@Component({
  selector: "app-employee-operation-main",
  templateUrl: "./employee-operation-main.component.html",
  styleUrls: ["./employee-operation-main.component.css"]
})
export class EmployeeOperationMainComponent implements OnInit {

  navLinks: any[];
  indexCounter: number = -1;
  constructor(
    private coreSession: CoreSession,
    private sessionDataProvider: SessionDataProvider
  ) {}

  ngOnInit() {
    this.coreSession.SetTitle("Employee-Operations");
    this.prepareNavigation();
  }

  prepareNavigation() {
    this.navLinks = [];
    for (let menu of this.sessionDataProvider.allMenusAvailable) {
      if (menu.menuId.startsWith("600-")) {
        this.indexCounter = this.indexCounter + 1;
        let navLink = {
          label: menu.menuName,
          link: menu.url,
          index: this.indexCounter
        };
        this.navLinks.push(navLink);
      }
    }
  }
}
